/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.migrate.transfer;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.protocol.BrocWrapper;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.Alias;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.EndPortInfo;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ReadOtherSwitch;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.StoreConfigurationInMDS;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.Zone;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ZoneMember;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ZoneSet;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ZonesetList;
import com.cisco.dcbu.sm.client.zm.migrate.transfer.ZonesetZone;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;

public class ReadBrocadeSwitch
extends ReadOtherSwitch {
    public static final String _EFFECTIVE_CONFIGURATION = "Effective configuration:";
    public static final String _DEFINED_CONFIGURATION = "Defined configuration:";
    private ZonesetList zsList = new ZonesetList();
    private ZonesetList brocadeDomainIdList = new ZonesetList();
    private ZonesetList brocadeWWNList = new ZonesetList();
    private ZonesetList parsedList = new ZonesetList();
    private ArrayList aliasList = new ArrayList();
    private int vsanId = 1;

    public ReadBrocadeSwitch() {
        this._brocadeSwitch = this;
    }

    @Override
    protected StringBuffer getCLI() {
        StoreConfigurationInMDS storeConfiguration = new StoreConfigurationInMDS();
        ZonesetList aliasList = this.getZonesetListFromZonesetZone(this.parsedList._aliasList);
        ZonesetList inList = this.getZonesetListFromZonesetZone(this.parsedList._zonesetList);
        inList._aliasList = aliasList._aliasList;
        StringBuffer buffer = storeConfiguration.generateZonesetCLIForMDS(inList, this.vsanId);
        if (SnmpSession.isTrace()) {
            DefaultLogger._DefLogger.debug((Object)("CLI is " + buffer));
        }
        return buffer;
    }

    protected ZonesetList getZoneSets(String switchIp, String userName, String password, int vsan, boolean fullConfiguration) throws ConnectException, Exception {
        this.vsanId = vsan;
        this.vsanId = vsan;
        String infoFromSwitch = this.getFromBrocade(switchIp, userName, password);
        this.zsList = this.returnZoneTable(infoFromSwitch, fullConfiguration ? "defined configuration" : "effective configuration");
        return this.zsList;
    }

    @Override
    protected ZonesetList getZoneSets(String switchIp, String userName, String password, int vsan) throws ConnectException, Exception {
        return this.getZoneSets(switchIp, userName, password, vsan, false);
    }

    @Override
    protected ZonesetList getDomanIdsUnDecoded() {
        ZonesetList returnList = new ZonesetList();
        if (this.zsList._zonesetList.size() == 0 && this.zsList._aliasList.size() == 0) {
            return returnList;
        }
        if (this.brocadeDomainIdList._zonesetList.size() > 0) {
            returnList = this.brocadeDomainIdList;
        } else {
            ZonesetZone zonesetZone;
            int i;
            ArrayList zonesetZoneList = this.getZonesetZoneFormat(this.zsList._zonesetList);
            for (i = 0; i < zonesetZoneList.size(); ++i) {
                zonesetZone = (ZonesetZone)zonesetZoneList.get(i);
                if (!ReadBrocadeSwitch.isDomain(zonesetZone._zoneMemberOrig)) continue;
                returnList._zonesetList.add(zonesetZone.cloneThis());
                this.brocadeDomainIdList._zonesetList.add(zonesetZone.cloneThis());
            }
            zonesetZoneList = this.getZonesetZoneFormat(this.zsList._aliasList);
            for (i = 0; i < zonesetZoneList.size(); ++i) {
                zonesetZone = (ZonesetZone)zonesetZoneList.get(i);
                if (!ReadBrocadeSwitch.isDomain(zonesetZone._zoneMemberOrig)) continue;
                returnList._aliasList.add(zonesetZone.cloneThis());
                this.brocadeDomainIdList._aliasList.add(zonesetZone.cloneThis());
            }
        }
        ZonesetList zList = this.getZonesetListFromZonesetZone(returnList._zonesetList);
        ZonesetList aliasList = this.getZonesetListFromZonesetZone(returnList._aliasList);
        returnList._zonesetList = zList._zonesetList;
        returnList._aliasList = aliasList._aliasList;
        if (returnList._zonesetList.size() == 0 && returnList._aliasList.size() == 0) {
            return null;
        }
        return returnList;
    }

    @Override
    protected ZonesetList getWWNUnDecoded() {
        ZonesetList returnList = new ZonesetList();
        if (this.brocadeWWNList._zonesetList.size() > 0) {
            returnList = this.brocadeWWNList;
        } else {
            EndPortInfo eportInfo = new EndPortInfo();
            if (this.zsList._zonesetList.size() == 0 && this.zsList._aliasList.size() == 0) {
                return returnList;
            }
            ArrayList zonesetZoneList = this.getZonesetZoneFormat(this.zsList._zonesetList);
            zonesetZoneList.addAll(this.getZonesetZoneFormat(this.zsList._aliasList));
            for (int i = 0; i < zonesetZoneList.size(); ++i) {
                ZonesetZone zonesetZone = (ZonesetZone)zonesetZoneList.get(i);
                zonesetZone._zoneMemberNew = zonesetZone._zoneMemberOrig;
                if (zonesetZone == null || zonesetZone._zoneType != 0) continue;
                if (ReadBrocadeSwitch.isPort(zonesetZone._zoneMemberOrig)) {
                    String zoneMemberValue = zonesetZone._zoneMemberOrig;
                    if (eportInfo.isNWWN(zoneMemberValue)) {
                        ArrayList pwwnList = eportInfo.getPWWNs(zoneMemberValue);
                        for (int l = 0; l < pwwnList.size(); ++l) {
                            ZonesetZone zszone = new ZonesetZone();
                            zszone._zonesetName = zonesetZone._zonesetName;
                            zszone._aliasName = zonesetZone._aliasName;
                            zszone._zoneName = zonesetZone._zoneName;
                            zszone._zoneMemberOrig = (String)pwwnList.get(l);
                            zszone._zoneMemberNew = (String)pwwnList.get(l);
                            zszone._zoneType = 2;
                            this.parsedList._zonesetList.add(zszone);
                        }
                        continue;
                    }
                    if (eportInfo.isPWWN(zoneMemberValue)) {
                        ZonesetZone zszone = new ZonesetZone();
                        zszone._zonesetName = zonesetZone._zonesetName;
                        zszone._aliasName = zonesetZone._aliasName;
                        zszone._zoneName = zonesetZone._zoneName;
                        zszone._zoneMemberOrig = zoneMemberValue;
                        zszone._zoneMemberNew = zoneMemberValue;
                        zszone._zoneType = 2;
                        this.parsedList._zonesetList.add(zszone);
                        continue;
                    }
                    returnList._zonesetList.add(zonesetZone);
                    this.brocadeWWNList._zonesetList.add(zonesetZone.cloneThis());
                    continue;
                }
                zonesetZone._zoneType = 4;
                returnList._zonesetList.add(zonesetZone);
            }
            returnList = this.brocadeWWNList;
        }
        returnList = this.getZonesetListFromZonesetZone(returnList._zonesetList);
        return returnList;
    }

    @Override
    protected void putDecodedInfo(ZonesetList zonesetList) {
        ArrayList decodedWWNs = this.getZonesetZoneFormat(zonesetList._zonesetList);
        decodedWWNs.addAll(this.getZonesetZoneFormat(zonesetList._aliasList));
        for (int i = 0; i < decodedWWNs.size(); ++i) {
            boolean isAlias = false;
            ZonesetZone zonesetZone = (ZonesetZone)decodedWWNs.get(i);
            if (zonesetZone._zoneType == 0) continue;
            isAlias = zonesetZone._aliasName.length() > 0;
            int presentValue = -1;
            presentValue = isAlias ? ReadBrocadeSwitch.isPresent(this.parsedList._aliasList, zonesetZone) : ReadBrocadeSwitch.isPresent(this.parsedList._zonesetList, zonesetZone);
            if (presentValue != -1) {
                if (isAlias) {
                    this.parsedList._aliasList.remove(presentValue);
                    this.parsedList._aliasList.add(zonesetZone);
                    continue;
                }
                this.parsedList._zonesetList.remove(presentValue);
                this.parsedList._zonesetList.add(zonesetZone);
                continue;
            }
            if (isAlias) {
                this.parsedList._aliasList.add(zonesetZone);
                continue;
            }
            this.parsedList._zonesetList.add(zonesetZone);
        }
    }

    private String getFromBrocade(String switchIP, String userName, String password) throws ConnectException, Exception {
        BrocWrapper brocWrapper = null;
        try {
            String returnValue;
            brocWrapper = new BrocWrapper(switchIP, userName, password, "TELNET");
            String string = returnValue = brocWrapper.sendCommand("zoneShow");
            return string;
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (brocWrapper != null) {
                brocWrapper.disconnect();
            }
        }
    }

    private ZonesetList returnZoneTable(String infoFromSwitch, String configuration) {
        if (configuration == null || "".equalsIgnoreCase(configuration.trim())) {
            configuration = "effective configuration";
        }
        boolean isEffectiveConfiguration = false;
        if (configuration.equalsIgnoreCase("effective configuration")) {
            isEffectiveConfiguration = true;
        }
        ArrayList<ZoneSet> table = new ArrayList<ZoneSet>();
        String[] temp = new String[]{};
        temp = isEffectiveConfiguration ? infoFromSwitch.split("\n") : infoFromSwitch.split("[\n;]");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < temp.length; ++i) {
            if (temp[i].trim().length() <= 0) continue;
            list.add(temp[i]);
        }
        String[] individualStrings = new String[list.size()];
        individualStrings = list.toArray(individualStrings);
        boolean configStarted = false;
        boolean configEnded = false;
        String[] endString = null;
        ZoneSet zoneSet = new ZoneSet();
        Zone zone = new Zone();
        if (configuration.equalsIgnoreCase("defined configuration") || configuration.equalsIgnoreCase("alias")) {
            endString = new String[]{"effective configuration", "no defined configuration"};
        } else if (configuration.equalsIgnoreCase("effective configuration")) {
            endString = new String[]{"admin>", "no effective configuration"};
        }
        boolean aliasConfig = false;
        for (int i = 0; i < individualStrings.length; ++i) {
            String individualString = individualStrings[i].trim();
            if (endString != null && !"".equalsIgnoreCase(endString[0])) {
                for (int j = 0; j < endString.length; ++j) {
                    String thisEndString = endString[j];
                    if (thisEndString == null || "".equalsIgnoreCase(thisEndString.trim()) || !individualString.toLowerCase().startsWith(thisEndString)) continue;
                    configEnded = true;
                    break;
                }
                if (configEnded) break;
            }
            if (individualString == null) continue;
            if ((individualString = individualString.trim()).indexOf(">") > -1) {
                aliasConfig = false;
                continue;
            }
            if (individualString.toLowerCase().indexOf(configuration) > -1) {
                configStarted = true;
                aliasConfig = false;
            }
            if (!configStarted) continue;
            if (individualString.startsWith("cfg:") && !configuration.equalsIgnoreCase("alias")) {
                aliasConfig = false;
                String zoneSetName = individualString.substring("cfg:".length()).trim();
                if (zoneSet._zoneSetName != null) {
                    if (zone != null) {
                        Zone[] myArr = new Zone[zoneSet._zones.length + 1];
                        System.arraycopy(zoneSet._zones, 0, myArr, 0, zoneSet._zones.length);
                        myArr[zoneSet._zones.length] = zone;
                        zoneSet._zones = myArr;
                        zone = new Zone();
                    }
                    table.add(zoneSet);
                    zoneSet = new ZoneSet();
                }
                zoneSet._zoneSetName = zoneSetName;
                continue;
            }
            if (individualString.startsWith("zone:") && !configuration.equalsIgnoreCase("alias")) {
                aliasConfig = false;
                individualString = individualString.substring("zone:".length() + 1).trim();
                StringTokenizer tokenizer = new StringTokenizer(individualString);
                String zoneName = null;
                String zoneMember = null;
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (null == token || "".equalsIgnoreCase(token.trim())) continue;
                    if (zoneName == null) {
                        zoneName = token;
                        continue;
                    }
                    zoneMember = token;
                }
                if (zone._zoneName != null) {
                    if (zoneSet == null) continue;
                    Zone[] zoneArr = new Zone[zoneSet._zones.length + 1];
                    System.arraycopy(zoneSet._zones, 0, zoneArr, 0, zoneSet._zones.length);
                    zoneArr[zoneSet._zones.length] = zone;
                    zoneSet._zones = zoneArr;
                    zone = new Zone();
                }
                zone._zoneName = zoneName;
                if (zoneMember == null) continue;
                zone._zoneMembers = new ZoneMember[1];
                ZoneMember zm = new ZoneMember();
                zm._zoneMemberOrig = zoneMember;
                zm._zoneMemberType = 0;
                zone._zoneMembers[0] = zm;
                continue;
            }
            if (individualString.startsWith("alias:")) {
                int index = individualString.indexOf("alias");
                individualString = individualString.substring(index + 7);
                aliasConfig = true;
                Alias newAlias = new Alias();
                StringTokenizer tokenizer = new StringTokenizer(individualString);
                newAlias._aliasName = tokenizer.nextToken();
                while (tokenizer.hasMoreTokens()) {
                    ZoneMember member = new ZoneMember();
                    member._zoneMemberOrig = tokenizer.nextToken();
                    member._zoneMemberType = 0;
                    newAlias._aliasMembers.add(member);
                }
                this.aliasList.add(newAlias);
                continue;
            }
            if (aliasConfig) {
                Alias lastAlias = (Alias)this.aliasList.get(this.aliasList.size() - 1);
                ZoneMember member = new ZoneMember();
                member._zoneMemberOrig = individualString;
                member._zoneMemberType = 0;
                lastAlias._aliasMembers.add(member);
                continue;
            }
            if (zone._zoneName == null) continue;
            ZoneMember[] memberArr = new ZoneMember[zone._zoneMembers.length + 1];
            System.arraycopy(zone._zoneMembers, 0, memberArr, 0, zone._zoneMembers.length);
            ZoneMember zm = new ZoneMember();
            zm._zoneMemberOrig = individualString;
            zm._zoneMemberType = 0;
            memberArr[zone._zoneMembers.length] = zm;
            zone._zoneMembers = memberArr;
        }
        if (zoneSet._zoneSetName != null) {
            if (zone != null) {
                Zone[] zoneArr = new Zone[zoneSet._zones.length + 1];
                System.arraycopy(zoneSet._zones, 0, zoneArr, 0, zoneSet._zones.length);
                zoneArr[zoneSet._zones.length] = zone;
                zoneSet._zones = zoneArr;
                zone = new Zone();
            }
            table.add(zoneSet);
            zoneSet = new ZoneSet();
        }
        ZonesetList zonesetList = new ZonesetList();
        zonesetList._zonesetList = table;
        if (this.aliasList.size() > 0) {
            HashSet set = new HashSet(this.aliasList);
            this.aliasList.clear();
            this.aliasList.addAll(set);
        }
        zonesetList._aliasList = this.aliasList;
        return zonesetList;
    }
}

