/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zoneconfig;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneControls;
import com.cisco.dcbu.sm.client.zm.zoneconfig.ZoneDialogAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class CommitDialog
extends JDialog
implements ActionListener {
    int action = 0;
    static final int COMMIT_ACT = 1;
    static final int VIEW_ACT = 2;
    int vsanId;
    ZoneControls znControls;
    ZoneDialogAction znDlgAction;

    public CommitDialog(JDialog parent, int vId, VersionPeer swVesionrPeer, ZoneControls controls, ZoneDialogAction dlgAction) {
        super(parent);
        this.setTitle("Commit Full Zone Database" + ClientController.getInstance().getDialogFabricTitlePostfix());
        this.vsanId = vId;
        this.znControls = controls;
        this.znDlgAction = dlgAction;
        JTextArea details = new JTextArea();
        details.setWrapStyleWord(true);
        details.setEditable(false);
        details.setLineWrap(true);
        details.setOpaque(false);
        details.setFont((Font)UIManager.getDefaults().get("Table.font"));
        details.setText("Commit operation will distribute zone configuration across fabric. This will overwrite current full zone configuration on all " + (this.vsanId == -1 ? "IVR CFS enabled switches " : "Enhanced zoning enabled switches in VSAN " + this.vsanId) + "with zone configuration of " + swVesionrPeer + ".");
        AbstractButton[] btns = DialogUtil.buildButtons(new String[]{"Continue Commit", "Proposed Changes...", "Cancel"}, (ActionListener)this);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)details, btns);
        this.setDefaultCloseOperation(2);
        this.setSize(new Dimension(450, 120));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.action = 0;
        char ch = evt.getActionCommand().charAt(0);
        try {
            switch (ch) {
                case 'C': {
                    if (evt.getActionCommand().charAt(1) == 'o') {
                        this.action = 1;
                        this.znDlgAction.commitAction(this.vsanId);
                        this.znControls.setCommitControls(true);
                    }
                    this.dispose();
                    break;
                }
                case 'P': {
                    this.action = 2;
                    this.znDlgAction.showPendingChanges();
                    break;
                }
                default: {
                    this.action = 0;
                    break;
                }
            }
        }
        catch (SnmpException ex) {
            if (SnmpSession.isTrace()) {
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            Util.errorMessage((Component)Util.getFrameAncestor(this), ex.getMessage());
        }
    }

    public int getAction() {
        return this.action;
    }
}

