/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zoneconfig;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.FeatureEnabler;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EnableIVRDlg
extends JDialog
implements ActionListener,
StatusIf {
    protected JLabel _status;
    private FeatureEnabler _featureEnabler;
    protected boolean _isSuccess;
    protected JComboBox _switchCb;
    protected SnmpPeer _selectedPeer;
    private JButton[] _buttons;

    public EnableIVRDlg(JFrame parent) throws SnmpException {
        super(parent);
        this.buildUI(parent);
    }

    void buildUI(JFrame parent) throws SnmpException {
        this.setDefaultCloseOperation(2);
        this._status = new JLabel(" ");
        String[] btnLbl = new String[]{"OK", "Cancel"};
        this._buttons = DialogUtil.buildButtons(btnLbl, (ActionListener)this);
        JPanel lowerPnl = DialogUtil.buildStatusPanel(this._buttons, this._status);
        JPanel mainPnl = new JPanel(new BorderLayout());
        this._switchCb = new JComboBox();
        Fabric f = ClientController.getInstance().getFabric();
        this._switchCb.setModel(new DefaultComboBoxModel<Object>(SmZoneUtil.getIvrCapableSwitches(f).toArray()));
        JLabel[] labels1 = DialogUtil.buildLabels(new String[]{"IVR enabled switches in Fabric."});
        JComponent[] labels2 = DialogUtil.buildLabels(new String[]{"There are no ", "Enable IVR on:"});
        labels1[0].setHorizontalAlignment(2);
        labels2[0].setHorizontalAlignment(2);
        labels2[1].setHorizontalAlignment(2);
        mainPnl.add("Center", DialogUtil.buildPanel(labels2, new JComponent[]{labels1[0], this._switchCb}));
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)mainPnl, lowerPnl);
        this.setResizable(true);
        this.pack();
        this.setTitle("Enable IVR " + ClientController.getInstance().getDialogFabricTitlePostfix());
        this.setModal(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            char cmd = e.getActionCommand().charAt(0);
            if (cmd == 'O') {
                this._selectedPeer = null;
                this._status.setText(" ");
                Switch sww = (Switch)this._switchCb.getSelectedItem();
                ArrayList<Object[]> enableFeatureList = new ArrayList<Object[]>();
                enableFeatureList.add(new Object[]{sww.getPeer(), new int[]{1}});
                this._featureEnabler = new FeatureEnabler(enableFeatureList, true, this);
                this._featureEnabler.startAction();
                this._buttons[0].setEnabled(false);
            } else if (cmd == 'C') {
                this._isSuccess = false;
                this.dispose();
            }
        }
        catch (SnmpException ex) {
            this._status.setText("Failed");
            if (SnmpSession.isTrace()) {
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            Util.errorMessage((Component)this, ex);
        }
    }

    @Override
    public void dispose() {
        if (this._featureEnabler != null) {
            this._featureEnabler.stopPolling();
        }
        super.dispose();
    }

    @Override
    public void setStatus(String status) {
        this._status.setText(status);
    }

    @Override
    public void actionFinished() {
        this._isSuccess = true;
        this._selectedPeer = ((Switch)this._switchCb.getSelectedItem()).getPeer();
        this.setStatus("IVR Enabled");
        this.dispose();
    }

    @Override
    public void handleError(Exception[] ex) {
        this._isSuccess = false;
        Util.errorMessage((Component)this, SmZoneUtil.buildErrorMessage(ex).toString());
        this.actionFinished();
        this._status.setText("Failed");
    }

    public SnmpPeer getSelectedPeer() {
        return this._isSuccess ? this._selectedPeer : null;
    }
}

