/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zoneconfig;

import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.zm.common.IscsiProxy;
import com.cisco.dcbu.sm.client.zm.common.ZoneDragTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class IscsiProxyPortSelector
extends JDialog
implements ActionListener {
    private static String[] HEADER_PROXY = new String[]{"WWN", "Interface"};
    private IscsiProxy[] _selectedProxy;
    private ZoneDragTable _eTable;
    private IfIndexIf _ifIndexIf;

    IscsiProxyPortSelector(JDialog parent, ArrayList data, IfIndexIf ifIndexIf) {
        super(parent);
        this._ifIndexIf = ifIndexIf;
        this.setDefaultCloseOperation(2);
        this.setIscsiProxyData(data);
        JScrollPane scp = new JScrollPane(this._eTable);
        scp.setPreferredSize(this._eTable.calcPreferredSize());
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)scp, "Center");
        DialogUtil.buildDialog(this, parent, pnl);
        if (this.getHeight() > 600) {
            this.setSize(this.getWidth() + scp.getVerticalScrollBar().getWidth() + 5, 600);
        }
        if (this.getHeight() < 150) {
            this.setSize(this.getWidth() + 5, 150);
        }
        this.setLocationRelativeTo(parent);
        this.setResizable(true);
        this.setTitle("Select iSCSI Proxy" + ClientController.getInstance().getDialogFabricTitlePostfix());
        this.setModal(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char cmd = e.getActionCommand().charAt(0);
        switch (cmd) {
            case 'O': {
                int[] selRows = this._eTable.getSelectedRows();
                if (selRows == null || selRows.length == 0) {
                    Util.errorMessage((Component)this, "Please select a row");
                    return;
                }
                this._selectedProxy = new IscsiProxy[selRows.length];
                KTableModel theModel = (KTableModel)this._eTable.getModel();
                for (int k = 0; k < selRows.length; ++k) {
                    this._selectedProxy[k] = (IscsiProxy)theModel.getValueAt(selRows[k], 0);
                }
            }
            case 'C': {
                this.dispose();
            }
        }
    }

    public IscsiProxy[] getSelectedIscsiProxy() {
        return this._selectedProxy;
    }

    private void setIscsiProxyData(ArrayList data) {
        Array<Object[]> theData = new Array<Object[]>();
        if (data != null && data.size() > 0) {
            for (int i = 0; i < data.size(); ++i) {
                IscsiProxy init = (IscsiProxy)data.get(i);
                if (init._pWWN == null || init._pWWN.length != 8) continue;
                Object[] ob = new Object[2];
                ob[0] = init;
                StringBuilder stringBuilder = new StringBuilder();
                ClientController.getInstance();
                ob[1] = stringBuilder.append(ClientController.findFabricSwitchByIpAddress(init._switchAdd)).append(" ").append(this._ifIndexIf.ifIndexToName(init._ifIndex)).toString();
                theData.addElement(ob);
            }
        }
        KTableModel model = new KTableModel();
        model.setHeaders(HEADER_PROXY);
        model.setData(theData);
        this._eTable = new ZoneDragTable(model, null);
        this._eTable.setAutoResizeMode(0);
    }
}

