/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zoneconfig;

import com.cisco.dcbu.lib.mds.zm.ZoneSet;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.zm.common.DragTableModel;
import java.util.ArrayList;

class ZoneSetTableModel
extends DragTableModel {
    static final String[] LABELS = new String[]{"Name", "Members", "Creation/Mod Time"};
    static final int NAME = 0;
    static final int MEMBERS = 1;
    static final int ZONESET_TIMESTAMP = 2;

    ZoneSetTableModel(boolean editable) {
        this.setHeaders(LABELS);
        this.setEditMode(editable);
    }

    @Override
    public void updateData(ArrayList memberList) {
        Array<Object[]> responseData = new Array<Object[]>();
        if (memberList != null) {
            for (int i = 0; i < memberList.size(); ++i) {
                ZoneSet zs = (ZoneSet)memberList.get(i);
                if (this.filterStr != null && this.filterStr.length() > 0 && !zs.getZoneName().matches(this.filterStr)) continue;
                responseData.addElement(this.addRow(zs));
            }
        }
        this.setData(responseData);
        this.sort(0, true);
    }

    void setEditMode(boolean editable) {
        this.setEditable(new boolean[]{editable, false, false});
    }

    Object[] addRow(Object listNode) {
        ZoneSet zs = (ZoneSet)listNode;
        Object[] row = new Object[LABELS.length + 3];
        row[1] = this._defaultDetailsList;
        row[0] = zs.toString();
        row[2] = zs.getLastModifiedAsLong();
        row[4] = zs;
        return row;
    }

    @Override
    public int getTimeStampColumn() {
        return 2;
    }

    @Override
    public Object getDragObject(int row) {
        return ((Object[])this.getData().elementAt(row))[4];
    }

    @Override
    public ArrayList getChangedZoneProperties() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.isChanged(i, 0)) continue;
            Object[] row = (Object[])this.getData().elementAt(i);
            list.add(new Object[]{row[4], row[0]});
        }
        return list;
    }

    @Override
    public boolean isInfoColumn(int clmn) {
        return clmn == 1;
    }
}

