/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zonewizard;

import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.FeatureEnabler;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.mds.zm.ZoneSet;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.FabricBindingActivator;
import com.cisco.dcbu.sm.client.zm.common.IvrEndPort;
import com.cisco.dcbu.sm.client.zm.common.OutputTextArea;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import com.cisco.dcbu.sm.client.zm.zonewizard.FabricBinding;
import com.cisco.dcbu.sm.client.zm.zonewizard.IvrResultsPanel;
import com.cisco.dcbu.sm.client.zm.zonewizard.IvrResultsPanelActionsTable;
import com.cisco.dcbu.sm.client.zm.zonewizard.WizardCopyTopologyAction;
import com.cisco.dcbu.sm.client.zm.zonewizard.WizardZoneAction;
import com.cisco.dcbu.sm.client.zm.zonewizard.ZoneMemWizard;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class Ivr1Results
extends IvrResultsPanelActionsTable {
    private ArrayList _reservedDomains;
    private ArrayList _taskList;
    private int _action;
    private FeatureEnabler _featureEnabler;
    private FabricBindingActivator _fbActivator;
    private ArrayList _vsanListForFBActivation = new ArrayList();
    private int _vsanIndexForFBActivation = 0;
    HashMap _swVblMap = new HashMap();
    static final String WWN_EXISTS = "WWN already exists";
    static final int ENBLE_IVR_ACT = 0;
    static final int CREATE_VSAN_ACT = 1;
    static final int RESERVED_DOMAIN_ACT = 2;
    static final int CREATE_AND_ACTIVATE_FABRIC_BINDING = 3;
    static final int CREATE_ZONE_ACT = 4;
    static final int CREATE_TOPO_ACT = 5;
    static final int COPY_ZONES_ACT = 6;
    static final int ACTIVATE_ZONES_ACT = 7;
    static final int SAVE_RUNNING_ACT = 8;
    static final int ZONE_CONFIGFILE_ACT = 9;
    static final Object[][] IVR1_STEPS = new Object[][]{{"1", "Enable IVR ", new Integer(0)}, {"2", "Create new VSAN ", new Integer(0)}, {"3", "Set static domains on transition switches", new Integer(0)}, {"4", "Create and Activate Fabric Binding", new Integer(0)}, {"5", "Create new zone", new Integer(0)}, {"6", "Copy and activate vsan topology on all switches", new Integer(0)}, {"7", "Copy full IVR zones to all switches", new Integer(0)}, {"8", "Force create VSAN zones & activate IVR zones on all switches", new Integer(0)}, {"9", "Save running configuration to startup on all switches (Optional)", new Integer(0)}, {"10", "Save current zone configuration from master to file (Optional)", new Integer(0)}};

    Ivr1Results(IvrResultsPanel panel, OutputTextArea output) {
        super(panel, output, IVR1_STEPS);
    }

    private void updateProgressTable(ArrayList enableIvrSws) {
        if (enableIvrSws != null && enableIvrSws.size() > 0) {
            this._progressTableModel.setValueAt("Enable IVR on " + enableIvrSws + ".", this._rowIndex[0], 1);
        }
    }

    private void updateProgressTable(Switch ivrSeed, int newVsan, String newZone, ArrayList reservedDomains, String zoneset, boolean saveConfig, String file, ArrayList transitSw, boolean enableFabricBinding) {
        if (this._rowStatus[1] && newVsan != -1) {
            this._progressTableModel.setValueAt("Create new VSAN " + newVsan + ".", this._rowIndex[1], 1);
            String resDid = "";
            for (int i = 0; i < transitSw.size(); ++i) {
                if (reservedDomains.size() <= i) continue;
                resDid = resDid + "0x" + Integer.toHexString((Integer)reservedDomains.get(i)) + " ";
            }
            this._progressTableModel.setValueAt("Set static domain(s) on " + transitSw + " to " + resDid, this._rowIndex[2], 1);
        }
        if (this._rowStatus[4]) {
            this._progressTableModel.setValueAt("Create new zone " + newZone + " and add to zoneset " + zoneset, this._rowIndex[4], 1);
        }
        if (this._rowStatus[6]) {
            this._progressTableModel.setValueAt("Copy full IVR zones from " + ivrSeed + " to all IVR enabled switches", this._rowIndex[6], 1);
        }
        if (this._rowStatus[8] && saveConfig) {
            this._progressTableModel.setValueAt("Save running configuration to startup on all switches", this._rowIndex[8], 1);
        }
        if (this._rowStatus[9] && file != null) {
            this._progressTableModel.setValueAt("Save current zone configuration from " + ivrSeed + " to file " + file, this._rowIndex[9], 1);
        }
        if (this._rowStatus[3] && enableFabricBinding) {
            this._progressTableModel.setValueAt("Create and Activate Fabric Binding", this._rowIndex[8], 1);
        }
        this._progressTableModel.fireTableDataChanged();
    }

    private void updateProgressTable(int action, int value) {
        if (this._rowStatus[action]) {
            this._progressTableModel.setValueAt(new Integer(value), this._rowIndex[action], 2);
            this._progressTableModel.fireTableCellUpdated(this._rowIndex[action], 2);
        }
    }

    @Override
    void insertSaveConfigActions(boolean saveConfig, String configFile) {
        Object[] el;
        int currentActions = this._progressTableModel.getRowCount();
        Array data = this._progressTableModel.getData();
        if (saveConfig) {
            this._rowStatus[8] = true;
            el = new Object[4];
            this._rowIndex[8] = currentActions;
            el[0] = Integer.toString(currentActions + 1);
            el[1] = IVR1_STEPS[8][1];
            el[2] = IVR1_STEPS[8][2];
            data.addElement(el);
            ++currentActions;
        }
        if (configFile != null && configFile.length() > 0) {
            this._rowStatus[9] = true;
            el = new Object[4];
            this._rowIndex[9] = currentActions;
            el[0] = Integer.toString(currentActions + 1);
            el[1] = IVR1_STEPS[9][1];
            el[2] = IVR1_STEPS[9][2];
            data.addElement(el);
        }
        this._progressTableModel.fireTableDataChanged();
    }

    private void updateProgressTableData(ArrayList enableIvrSws, boolean newVsan, boolean saveConfig, boolean saveConfigToFile, boolean fbinding) {
        for (int i = 0; i < IVR1_STEPS.length; ++i) {
            this._rowStatus[i] = true;
        }
        if (!newVsan) {
            this._rowStatus[1] = false;
            this._rowStatus[2] = false;
        }
        if (!saveConfig) {
            this._rowStatus[8] = false;
        }
        if (!saveConfigToFile) {
            this._rowStatus[9] = false;
        }
        if (!fbinding) {
            this._rowStatus[3] = false;
        }
        if (enableIvrSws == null || enableIvrSws.size() == 0) {
            this._rowStatus[0] = false;
        }
        Array<Object[]> data = new Array<Object[]>();
        int j = 0;
        for (int i = 0; i < IVR1_STEPS.length; ++i) {
            if (!this._rowStatus[i]) continue;
            Object[] el = new Object[4];
            this._rowIndex[i] = j;
            el[0] = Integer.toString(j + 1);
            el[1] = IVR1_STEPS[i][1];
            el[2] = IVR1_STEPS[i][2];
            data.addElement(el);
            ++j;
        }
        this._progressTableModel.setData(data);
        this._progressTableModel.fireTableDataChanged();
    }

    @Override
    void setProgressBar() {
        WizardZoneAction zoneAction = (WizardZoneAction)this._panel.getModelValue("ZONE_DATA");
        int length = zoneAction.getActionsSize();
        if (length > 0) {
            for (int k = 5; k <= 9; ++k) {
                int completed = 0;
                switch (k) {
                    case 5: {
                        completed = zoneAction.getCompletedActions(WizardZoneAction.ZONE_CREATE_TOPOLOGY_ACTION);
                        break;
                    }
                    case 6: {
                        completed = zoneAction.getCompletedActions(WizardZoneAction.ZONE_COPY_FULL_ZONES_ACTION);
                        ++completed;
                        break;
                    }
                    case 7: {
                        completed = zoneAction.getCompletedActions(WizardZoneAction.ZONE_ACTIVATION_ACTION);
                        break;
                    }
                    case 3: {
                        completed = zoneAction.getCompletedActions(WizardZoneAction.FABRIC_ACTIVATION_ACTION);
                        break;
                    }
                    case 8: {
                        completed = zoneAction.getCompletedActions(WizardZoneAction.ZONE_SAVE_RUNNING_ACTION);
                        break;
                    }
                    case 9: {
                        completed = zoneAction.getCompletedActions(WizardZoneAction.ZONE_COPY_RUNNING_FILE_ACTION);
                    }
                }
                if (completed <= 0) continue;
                this._progressTableModel.setValueAt(new Integer(completed * 100 / length), this._rowIndex[k], 2);
                this._progressTableModel.fireTableDataChanged();
            }
        }
    }

    @Override
    boolean refreshForIVR() {
        Integer cachedVsanId = (Integer)this._panel.getModelValue("TRANSITION_VSAN_ID");
        Switch ivrSwitch = (Switch)this._panel.getModelValue("IVR_ZONE_SWITCH");
        String zonesetName = (String)this._panel.getModelValue("ZONESET");
        String zone = (String)this._panel.getModelValue("ZONE");
        ArrayList transitSw = (ArrayList)this._panel.getModelValue("TRANSITION_SWITCH_LIST");
        VarBindList vbTopo = (VarBindList)this._panel.getModelValue("TOPOLOGY_VARBIND");
        int newVsan = ivrSwitch.getFabric().findVsanById(cachedVsanId) == null ? cachedVsanId : -1;
        boolean fb = (Boolean)this._panel.getModelValue("ENABLE_FABRIC_BINDING");
        this.updateProgressTableData((ArrayList)this._panel.getModelValue("IVR_TO_ENABLE_SWITCHES"), newVsan != -1, false, false, fb);
        this._reservedDomains = Ivr1Results.buildAllowedDomainList(WizardCopyTopologyAction.buildVsanList(vbTopo, ivrSwitch.getFabric()));
        this.setActionsText();
        this.buildTopologyText();
        this.updateProgressTable(ivrSwitch, newVsan, zone, this._reservedDomains, zonesetName, false, null, transitSw, fb);
        ArrayList enableIvrSws = (ArrayList)this._panel.getModelValue("IVR_TO_ENABLE_SWITCHES");
        this.updateProgressTable(enableIvrSws);
        if (fb) {
            try {
                Array selected = (Array)this._panel.getModelValue("NXPORTS");
                this._vsanListForFBActivation.clear();
                StringBuffer buf = new StringBuffer();
                this._swVblMap.clear();
                this._swVblMap = FabricBinding.buildFabricBindingActVsanListAndCreateConfigEntries(cachedVsanId, selected, transitSw, this._vsanListForFBActivation, buf);
                this._output.getTextArea().setText(buf.toString());
            }
            catch (SnmpException exx) {
                Util.errorMessage((Component)this._panel.getWizard(), exx.getMessage());
            }
        }
        return true;
    }

    private void createVsanDomainList() throws SnmpException {
        Integer cachedVsanId = (Integer)this._panel.getModelValue("TRANSITION_VSAN_ID");
        Switch ivrSwitch = (Switch)this._panel.getModelValue("IVR_ZONE_SWITCH");
        ArrayList transitionSwitches = (ArrayList)this._panel.getModelValue("TRANSITION_SWITCH_LIST");
        if (ivrSwitch.getFabric().findVsanById(cachedVsanId) == null) {
            if (this._reservedDomains.size() < transitionSwitches.size()) {
                throw new SnmpException("Only " + this._reservedDomains.size() + " domains can be statically \n" + "configured on " + transitionSwitches.size() + " transition switches. \n" + "The IVR zone configuration cannot succeed.");
            }
            for (int i = 0; i < transitionSwitches.size(); ++i) {
                Switch sw = (Switch)transitionSwitches.get(i);
                Ivr1Results.createVsan(SmZoneUtil.getSwitchPeer(sw), cachedVsanId);
                this.updateProgressTable(1, 100 * (i + 1) / transitionSwitches.size());
                this._output.getTextArea().append("Created VSAN " + cachedVsanId + " on " + sw + ".");
                if (this._reservedDomains != null && i < this._reservedDomains.size()) {
                    Integer did = (Integer)this._reservedDomains.get(i);
                    Ivr1Results.setDomainStaticId(SmZoneUtil.getSwitchPeer(sw), did, cachedVsanId);
                    this._output.getTextArea().append("Set static domains for " + sw + " to 0x" + Integer.toHexString(did) + ".\n");
                }
                this.updateProgressTable(2, 100 * (i + 1) / transitionSwitches.size());
            }
        }
    }

    @Override
    protected void setActionsText() {
        Integer cachedVsanId = (Integer)this._panel.getModelValue("TRANSITION_VSAN_ID");
        Switch ivrSwitch = (Switch)this._panel.getModelValue("IVR_ZONE_SWITCH");
        StringBuffer description = new StringBuffer();
        ArrayList transitionSwitches = (ArrayList)this._panel.getModelValue("TRANSITION_SWITCH_LIST");
        description.append("Transition switches:" + transitionSwitches + ", Transit VsanID:" + cachedVsanId + ".\n");
        WizardZoneAction zoneAction = (WizardZoneAction)this._panel.getModelValue("ZONE_DATA");
        description.append("IVR seed switch:" + zoneAction.getSwitch() + ".\n");
        ArrayList enableIvrSws = (ArrayList)this._panel.getModelValue("IVR_TO_ENABLE_SWITCHES");
        if (enableIvrSws != null && enableIvrSws.size() > 0) {
            description.append("Enable IVR on " + enableIvrSws + ".\n");
        }
        if (ivrSwitch.getFabric().findVsanById(cachedVsanId) == null) {
            description.append("Create new VSAN " + cachedVsanId + " on transition switches.\n");
            StringBuffer didDesc = new StringBuffer();
            for (int i = 0; i < transitionSwitches.size(); ++i) {
                Switch sw = (Switch)transitionSwitches.get(i);
                if (this._reservedDomains == null || i >= this._reservedDomains.size()) continue;
                Integer did = (Integer)this._reservedDomains.get(i);
                didDesc.append("Set static domains for " + sw + " to Ox" + Integer.toHexString(did) + ".\n");
            }
            didDesc.append("\n");
            description.append(didDesc);
        }
        this._output.getTextArea().append(description.toString());
        String zonesetName = (String)this._panel.getModelValue("ZONESET");
        String zone = (String)this._panel.getModelValue("ZONE");
        this._output.getTextArea().append("Add selected port members to a new zone " + zone + "\nand add zone to a zoneset " + zonesetName + ".\n");
        this._output.getTextArea().append("Configure VSAN topology on " + zoneAction.getSwitch() + ".\n");
        this._output.getTextArea().append("Copy and activate VSAN topology on all IVR enabled switches in fabric.\n");
        this._output.getTextArea().append("Copy zoneset " + zonesetName + " configuration to all IVR enabled switches.\n");
        this._output.getTextArea().append("Activate " + zonesetName + " on all IVR enabled switches in fabric.\n");
        this._output.getTextArea().append("\nNote:The existing zoneset configuration on all IVR enabled \nswitches will be replaced with new configuration. \nAttempting to stop the operation may leave zone configuration in unknown state\n");
    }

    private void buildTopologyText() {
        Array selected = (Array)this._panel.getModelValue("NXPORTS");
        EndPort portOne = ((IvrEndPort)selected.elementAt(0)).getEndPort();
        this._output.getTextArea().append("Topology:\n");
        VarBindList vbTopo = (VarBindList)this._panel.getModelValue("TOPOLOGY_VARBIND");
        for (int i = 0; i < vbTopo.size(); i += 3) {
            SnmpVarBind vb = vbTopo.get(i + 1);
            int[] oid = vb.getOid().getValue();
            int[] wwn = new int[8];
            System.arraycopy(oid, oid.length - 8, wwn, 0, 8);
            byte[] wwnByte = new byte[8];
            for (int k = 0; k < 8; ++k) {
                wwnByte[k] = (byte)wwn[k];
            }
            Switch sw = portOne.getFabric().findSwitchByWwn(new Wwn(wwnByte));
            if (sw != null) {
                this._output.getTextArea().append(sw + ":VSANs  ");
            } else {
                this._output.getTextArea().append(SnmpString.toHexString(wwnByte) + ":VSANs  ");
            }
            byte[] vsan1 = ((SnmpString)vb.getVar()).getValue();
            byte[] vsan2 = ((SnmpString)vbTopo.get(i + 2).getVar()).getValue();
            byte[] vsan2k4k = new byte[512];
            System.arraycopy(vsan1, 0, vsan2k4k, 0, vsan1.length);
            System.arraycopy(vsan2, 0, vsan2k4k, 256, vsan2.length);
            this._output.getTextArea().append(SnmpBitmap.toString(vsan2k4k, false) + "\n");
        }
    }

    @Override
    void doFinish(boolean saveConfig, String configFile) throws SnmpException {
        this._saveConfig = saveConfig;
        this._configFile = configFile;
        ArrayList enableIvrSws = (ArrayList)this._panel.getModelValue("IVR_TO_ENABLE_SWITCHES");
        if (enableIvrSws != null && enableIvrSws.size() > 0) {
            this._taskList = new ArrayList();
            for (int i = 0; i < enableIvrSws.size(); ++i) {
                this._taskList.add(new Object[]{((Switch)enableIvrSws.get(i)).getPeer(), new int[]{1}});
            }
            this._featureEnabler = new FeatureEnabler(this._taskList, true, this);
            this._action = 0;
            this._featureEnabler.startAction();
        } else {
            this.beginFabricBindingActions();
        }
    }

    private void beginPostIvrActions(boolean saveConfig, String configFile) {
        block2: {
            try {
                WizardZoneAction zoneAction = (WizardZoneAction)this._panel.getModelValue("ZONE_DATA");
                String zonesetName = (String)this._panel.getModelValue("ZONESET");
                String zone = (String)this._panel.getModelValue("ZONE");
                Boolean zoneMode = (Boolean)this._panel.getModelValue("ZONE_MODE");
                VarBindList vbTopo = (VarBindList)this._panel.getModelValue("TOPOLOGY_VARBIND");
                zoneAction.setTopology(vbTopo);
                ZoneSet zs = zoneAction.getActiveZoneSet();
                Array memberPorts = (Array)this._panel.getModelValue("NXPORTS");
                ArrayList transitionSwitches = (ArrayList)this._panel.getModelValue("TRANSITION_SWITCH_LIST");
                zoneAction.setTransitSwitches(transitionSwitches);
                zs = zoneAction.createZoneSet(zonesetName, zone, zoneMode, memberPorts, false, -1, false, null, zoneAction.getSwitch().getSwitchUpTime());
                this._output.getTextArea().append("Created new zone " + zone + " and added to zoneset " + zonesetName + "\non IVR Master switch " + zoneAction.getSwitch() + ".");
                this.updateProgressTable(4, 100);
                zoneAction.activateAction(zs, true, saveConfig, configFile, true);
            }
            catch (Exception ex) {
                this._output.getTextArea().append(ex.getMessage() + "\n");
                Util.errorMessage((Component)this._panel.getWizard(), ex);
                if (!SnmpSession.isTrace()) break block2;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void beginFabricBindingActions() {
        block4: {
            try {
                WizardZoneAction zoneAction = (WizardZoneAction)this._panel.getModelValue("ZONE_DATA");
                this.createVsanDomainList();
                this._action = 3;
                boolean fb = (Boolean)this._panel.getModelValue("ENABLE_FABRIC_BINDING");
                if (fb) {
                    this.createAndActivateFabricBinding();
                } else {
                    this._vsanIndexForFBActivation = 0;
                    this._vsanListForFBActivation.clear();
                    this.actionFinished();
                }
            }
            catch (Exception ex) {
                this._output.getTextArea().append(ex.getMessage() + "\n");
                Util.errorMessage((Component)this._panel.getWizard(), ex);
                if (!SnmpSession.isTrace()) break block4;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Override
    public void setStatus(String str) {
        try {
            if (this._output != null) {
                this._output.write(str.getBytes());
            } else {
                SmZoneUtil.trace(str);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this._panel != null && this._panel.getWizard() != null) {
            this._panel.getWizard().setStatus(str);
        }
        if (this._action == 0) {
            this.updateProgressTable(0, (this._taskList.size() - this._featureEnabler.getFailedList().size()) * 100 / this._taskList.size());
        }
    }

    @Override
    public void handleError(Exception[] ex) {
        ((ZoneMemWizard)this._panel.getWizard()).handleError(ex);
    }

    @Override
    public void dispose() {
        if (this._featureEnabler != null) {
            this._featureEnabler.stopPolling();
        }
        if (this._fbActivator != null) {
            this._fbActivator.stopPolling();
        }
    }

    @Override
    public void actionFinished() {
        if (!this._panel.getWizard().isVisible()) {
            return;
        }
        boolean fb = (Boolean)this._panel.getModelValue("ENABLE_FABRIC_BINDING");
        if (this._action == 0) {
            this.beginFabricBindingActions();
        } else if (!fb) {
            this.beginPostIvrActions(this._saveConfig, this._configFile);
        } else if (this._action == 3) {
            this.updateProgressTable(3, (this._vsanIndexForFBActivation + 1) * 100 / this._vsanListForFBActivation.size());
            if (this._vsanIndexForFBActivation < this._vsanListForFBActivation.size() - 1) {
                this.activateFabricBinding(++this._vsanIndexForFBActivation);
            } else {
                this.beginPostIvrActions(this._saveConfig, this._configFile);
            }
        }
    }

    static void createVsan(SnmpPeer destinationPeer, int newVsanId) throws SnmpException {
        VarBindList vbLst = new VarBindList();
        vbLst = new VarBindList();
        vbLst.add(MibNode.get("vsanRowStatus").getOid(), newVsanId, (SnmpVar)new SnmpInt(4));
        vbLst.add(MibNode.get("vsanName").getOid(), newVsanId, (SnmpVar)new SnmpString("IVR_TRANSIT" + newVsanId));
        destinationPeer.set(new SnmpPDU(-93, vbLst));
    }

    static void setDomainStaticId(SnmpPeer destinationPeer, int id, int vsan) throws SnmpException {
        VarBindList vbLst = new VarBindList();
        vbLst.add(MibNode.get("dmConfigDomainId").getOid(), vsan, (SnmpVar)new SnmpInt(id));
        vbLst.add(MibNode.get("dmRestart").getOid(), vsan, (SnmpVar)new SnmpInt(2));
        destinationPeer.set(new SnmpPDU(-93, vbLst));
    }

    private static void buildVsanList(ArrayList vsanids, SnmpVarBind vb2K, SnmpVarBind vb4K) throws SnmpException {
        String vsanbits = "";
        Collections.sort(vsanids);
        for (int i = 0; i < vsanids.size(); ++i) {
            vsanbits = i == 0 ? vsanbits + vsanids.get(i).toString() : vsanbits + "," + vsanids.get(i).toString();
        }
        byte[] bitmap = SnmpBitmap.parse(vsanbits, false);
        if (vb2K.getVar() != null) {
            SnmpString refVsans = (SnmpString)vb2K.getVar();
            SnmpString refVsan4k = (SnmpString)vb4K.getVar();
            PortInterfaceUtil.getInstance(7).getVsan(refVsans, refVsan4k, true);
            int length = refVsans.getValue().length > bitmap.length ? refVsans.getValue().length : bitmap.length;
            byte[] newVsanBits = refVsans.getValue().length > bitmap.length ? refVsans.getValue() : bitmap;
            byte[] smallerBitMap = refVsans.getValue().length <= bitmap.length ? refVsans.getValue() : bitmap;
            for (int i = 0; i < smallerBitMap.length; ++i) {
                newVsanBits[i] = (byte)(newVsanBits[i] | smallerBitMap[i]);
            }
            bitmap = newVsanBits;
        }
        SnmpString vsan2Kmap = new SnmpString(bitmap);
        PortInterfaceUtil.getInstance(7);
        byte[] vsan4Kmap = PortInterfaceUtil.getVsan4k2(vb2K.getOid(), vsan2Kmap);
        if (vsan4Kmap == null) {
            vsan4Kmap = new byte[]{};
        }
        vsan4Kmap = SnmpBitmap.trimTrailingZero(vsan4Kmap);
        vb2K.setVar(new SnmpString(SnmpBitmap.trimTrailingZero(vsan2Kmap.getValue())));
        vb4K.setVar(new SnmpString(vsan4Kmap));
    }

    public static VarBindList buildTopologyVarBind(SnmpPeer peer, HashMap topology, VarBindList topoVbL) throws SnmpException {
        VarBindList vbL = new VarBindList();
        vbL.copy(topoVbL, 0, topoVbL.size());
        int avlTopLength = vbL.size();
        ArrayList<Switch> mismatchedSw = new ArrayList<Switch>();
        for (Map.Entry obEntry : topology.entrySet()) {
            Switch sw = (Switch)obEntry.getKey();
            byte[] refSwwn = sw.getWwn().getValue();
            int[] refWwn = new int[refSwwn.length];
            for (int k = 0; k < refSwwn.length; ++k) {
                refWwn[k] = refSwwn[k] & 0xFF;
            }
            boolean matchingSwitchWwn = false;
            ArrayList vsanList = (ArrayList)obEntry.getValue();
            for (int i = 0; i < avlTopLength; i += 3) {
                int[] oid = vbL.getVb(i).getOid().getValue();
                int[] wwn = new int[8];
                System.arraycopy(oid, oid.length - 8, wwn, 0, 8);
                if (MibNode.equals(refWwn, wwn) != 0) continue;
                matchingSwitchWwn = true;
                Ivr1Results.buildVsanList(vsanList, vbL.getVb(i + 1), vbL.getVb(i + 2));
                break;
            }
            if (matchingSwitchWwn) continue;
            if (vsanList == null || vsanList.size() == 0) {
                mismatchedSw.add(sw);
                continue;
            }
            int[] index = new int[9];
            index[0] = 1;
            System.arraycopy(refWwn, 0, index, 1, 8);
            vbL.add(MibNode.get("civrTopologyConfigRowStatus").getOid(), index, (SnmpVar)new SnmpInt(4));
            SnmpVarBind vb2K = new SnmpVarBind(new SnmpOID(_VSAN2KOID, index));
            SnmpVarBind vb4K = new SnmpVarBind(new SnmpOID(_VSAN4KOID, index));
            Ivr1Results.buildVsanList(vsanList, vb2K, vb4K);
            vbL.add(vb2K);
            vbL.add(vb4K);
        }
        if (mismatchedSw.size() > 0) {
            throw new SnmpException("The following switches don't participate in the\nActive IVR Topology:\n" + mismatchedSw + "\n" + "Either:\n" + "(1) Disable IVR on these switches, or\n" + "(2) Manually configure IVR Topology for these switches.\n\n" + "Please restart the wizard after making changes.");
        }
        return vbL;
    }

    static HashMap getConflictingDids(ArrayList vsanList) {
        HashMap map = new HashMap();
        for (int i = 0; i < vsanList.size(); ++i) {
            Vsan v = (Vsan)vsanList.get(i);
            Switch[] switches = v.getSwitches();
            if (switches == null || switches.length <= 0) continue;
            for (int j = 0; j < switches.length; ++j) {
                Integer did = new Integer(switches[j].getDomainId(v.getId()));
                ArrayList<Vsan> list = (ArrayList<Vsan>)map.get(did);
                if (list == null) {
                    list = new ArrayList<Vsan>();
                }
                if (!list.contains(v)) {
                    list.add(v);
                }
                map.put(did, list);
            }
        }
        Iterator itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry obEntry = itr.next();
            ArrayList vsans = (ArrayList)obEntry.getValue();
            if (vsans.size() > 1) continue;
            itr.remove();
        }
        return map;
    }

    public void createAndActivateFabricBinding() throws SnmpException {
        Integer transitVsan = (Integer)this._panel.getModelValue("TRANSITION_VSAN_ID");
        Array selected = (Array)this._panel.getModelValue("NXPORTS");
        ArrayList tSwitches = (ArrayList)this._panel.getModelValue("TRANSITION_SWITCH_LIST");
        for (Map.Entry obEntry : this._swVblMap.entrySet()) {
            Switch swM = (Switch)obEntry.getKey();
            VarBindList vbl = (VarBindList)obEntry.getValue();
            VarBindList modB = new VarBindList();
            for (int n = 0; n < vbl.size(); n += 3) {
                modB.clear();
                modB.add(vbl.get(n));
                modB.add(vbl.get(n + 1));
                modB.add(vbl.get(n + 2));
                try {
                    SmZoneUtil.getSwitchPeer(swM).set(new SnmpPDU(-93, modB));
                    continue;
                }
                catch (SnmpException ex) {
                    if (ex.getMessage().indexOf(WWN_EXISTS) == -1) {
                        throw ex;
                    }
                    DefaultLogger._DefLogger.error((Object)("Switch:" + swM + "  " + ex.getMessage() + "\n"));
                }
            }
        }
        this._vsanIndexForFBActivation = 0;
        this.activateFabricBinding(this._vsanIndexForFBActivation);
    }

    private void activateFabricBinding(int index) {
        short vsanId = (Short)this._vsanListForFBActivation.get(index);
        this._action = 3;
        WizardZoneAction zoneAction = (WizardZoneAction)this._panel.getModelValue("ZONE_DATA");
        ArrayList tSwitches = (ArrayList)this._panel.getModelValue("TRANSITION_SWITCH_LIST");
        this._taskList = new ArrayList();
        for (int i = 0; i < tSwitches.size(); ++i) {
            Switch sww = (Switch)tSwitches.get(i);
            if (sww.getVsan(vsanId) == null) continue;
            this._taskList.add(new Object[]{((Switch)tSwitches.get(i)).getPeer()});
        }
        try {
            Object[] params = new Object[]{zoneAction.getCmdHandler(), new Integer(vsanId), Boolean.TRUE};
            this._fbActivator = new FabricBindingActivator(this._taskList, params, this);
            this._fbActivator.startAction();
        }
        catch (Exception ex) {
            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

