/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.zm.zonewizard;

import com.cisco.dcbu.lib.mds.zm.IvrZoneSwitch;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.DialogSeparator;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.MenuButton;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.model.Vsan;
import com.cisco.dcbu.sm.client.zm.common.IvrEndPort;
import com.cisco.dcbu.sm.client.zm.common.SmIvrZoneSwitch;
import com.cisco.dcbu.sm.client.zm.common.SmZoneUtil;
import com.cisco.dcbu.sm.client.zm.zonewizard.Ivr1Results;
import com.cisco.dcbu.sm.client.zm.zonewizard.IvrZoneWizardController;
import com.cisco.dcbu.sm.client.zm.zonewizard.TVsan;
import com.cisco.dcbu.sm.client.zm.zonewizard.WizardCopyTopologyAction;
import com.cisco.dcbu.sm.client.zm.zonewizard.ZoneMemWizard;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class TopologyPanel
extends WizardPanel
implements ActionListener {
    static final String[] LABELS = new String[]{"Hop", "Switch", "VSANs"};
    private VsanMenuButton _vsanMenuBtn;
    private FieldPanel _vsanField;
    private KTable _vsanTopoTbl;
    private KTableModel _vsanTopoTblMdl;
    private Vsan[] _transitionVsans = null;
    private ArrayList _transitionSwitches = new ArrayList();
    private HashMap _map = new HashMap();
    private JButton _validateBtn;
    protected JCheckBox _fabricBindingChkBox;
    static final int MIN_ALLOWED_FICON_HOPS = 2;

    TopologyPanel(JWizard wiz) {
        super("", "", wiz, IvrZoneWizardController.IMAGE_ZONE);
        this.setTitle(((ZoneMemWizard)this.getWizard()).getStepTitle(4) + "Select Transition VSAN");
        this.buildControls();
    }

    private void buildControls() {
        JComponent[] labels = new JLabel[]{new JLabel("Transition VSAN:"), null, null};
        JComponent[] values = new JComponent[labels.length];
        this._fabricBindingChkBox = new JCheckBox("Enable Fabric Binding");
        this._vsanMenuBtn = new VsanMenuButton(null, this);
        this._validateBtn = new JButton("Recompute Transit Switches");
        this._validateBtn.addActionListener(this);
        this._vsanMenuBtn.addActionListener(this);
        JPanel btnPnl = new JPanel(new FlowLayout());
        btnPnl.add(this._vsanMenuBtn);
        btnPnl.add(this._validateBtn);
        this._vsanField = new FieldPanel(10, (JComponent)btnPnl);
        values[0] = this._vsanField;
        values[2] = new DialogSeparator("Transit Switches");
        values[1] = this._fabricBindingChkBox;
        this._fabricBindingChkBox.setSelected(true);
        JPanel pnl = DialogUtil.buildPanel(labels, values);
        this._vsanTopoTblMdl = new KTableModel();
        this._vsanTopoTblMdl.setHeaders(LABELS);
        this._vsanTopoTbl = new KTable(this._vsanTopoTblMdl);
        JScrollPane sp = new JScrollPane(this._vsanTopoTbl);
        this._vsanTopoTbl.getColumnModel().getColumn(0).setMaxWidth(30);
        this._vsanTopoTbl.getColumnModel().getColumn(1).setWidth(160);
        JPanel pnlFinal = new JPanel(new BorderLayout());
        pnlFinal.add((Component)pnl, "North");
        pnlFinal.add((Component)sp, "Center");
        this.add((Component)pnlFinal, "Center");
    }

    private int filterTVsansbyPathLengthAndType(TVsan[] theTvsan, ArrayList tvsanFicon) {
        int minHops = Integer.MAX_VALUE;
        for (int i = 0; i < theTvsan.length; ++i) {
            if (!theTvsan[i].getVsan().isFicon()) continue;
            tvsanFicon.add(theTvsan[i]);
            int hops = theTvsan[i].getPath().size();
            minHops = minHops < hops ? minHops : hops;
        }
        return minHops;
    }

    @Override
    public boolean refresh() {
        TVsan[] tvsan;
        Array selected = (Array)this.getModelValue("NXPORTS");
        TVsan[] theTvsan = TVsan.getTVsans(selected);
        boolean ficonPorts = (Integer)this.getModelValue("PORT_TYPE") == 2;
        this._fabricBindingChkBox.setSelected(ficonPorts);
        this._fabricBindingChkBox.setVisible(ficonPorts);
        this._vsanField.getField().setEnabled(!ficonPorts);
        if (ficonPorts && theTvsan.length > 0) {
            ArrayList tvsanFicon = new ArrayList();
            int minHops = this.filterTVsansbyPathLengthAndType(theTvsan, tvsanFicon);
            if (tvsanFicon == null || tvsanFicon.size() == 0) {
                this.doPrevious();
                Util.errorMessage((Component)this.getWizard(), "There are no FICON Transit VSANs available between selected end devices.\nPlease create a transit FICON VSAN between end devices and restart the wizard.");
                return false;
            }
            if (minHops > 2) {
                this.doPrevious();
                Util.errorMessage((Component)this.getWizard(), "IVR with FICON is supported only if FICON devices are 2 switches apart.");
                return false;
            }
            tvsan = tvsanFicon.toArray(new TVsan[tvsanFicon.size()]);
        } else {
            tvsan = theTvsan;
        }
        this.setModelValue("IVR_T_VSAN_MAP", theTvsan);
        if (tvsan.length > 0) {
            this._transitionVsans = new Vsan[tvsan.length];
            short selVsanId = tvsan[0].getVsanId();
            IvrEndPort selIvrEp = (IvrEndPort)selected.elementAt(0);
            ArrayList<Switch> epSwitches = new ArrayList<Switch>();
            ArrayList<Vsan> epVsans = new ArrayList<Vsan>();
            for (int k = 0; k < selected.size(); ++k) {
                IvrEndPort ivrEp = (IvrEndPort)selected.elementAt(k);
                EndPort epp = ivrEp.getEndPort();
                Switch epSw = epp.getSwitch();
                Vsan epVsan = ivrEp.getVsan();
                if (!epSwitches.contains(epSw)) {
                    epSwitches.add(epSw);
                }
                if (epVsans.contains(epVsan)) continue;
                epVsans.add(epVsan);
            }
            if (epSwitches.size() == 1) {
                this._transitionVsans = epVsans.toArray(new Vsan[epVsans.size()]);
                selVsanId = selIvrEp.getVsan().getId();
            } else {
                ArrayList tvsanFicon = new ArrayList();
                for (int i = 0; i < tvsan.length; ++i) {
                    this._transitionVsans[i] = tvsan[i].getVsan();
                    if (selIvrEp.getVsan().getId() != tvsan[i].getVsanId()) continue;
                    selVsanId = selIvrEp.getVsan().getId();
                }
            }
            this.handleVsanIdChange(selVsanId);
            this._vsanField.setText(Integer.toString(selVsanId));
        } else {
            this._transitionVsans = null;
            this._vsanField.setText("");
            this.handleVsanIdChange(-1);
        }
        this.getWizard().getNavigator().getNextBtn().setEnabled(this._transitionSwitches.size() != 0);
        if (this._transitionVsans != null) {
            this._vsanMenuBtn.buildMenu(this._transitionVsans);
        }
        this.setModelValue("TRANSITION_VSAN_LIST", this._transitionVsans);
        this.buildInformation(this._transitionSwitches);
        return true;
    }

    private void handleVsanIdChange(int vsanIndex) {
        Array modelData = new Array();
        TVsan[] tvsan = (TVsan[])this.getModelValue("IVR_T_VSAN_MAP");
        if (tvsan != null && tvsan.length > 0) {
            int index = -1;
            for (int i = 0; i < tvsan.length; ++i) {
                if (tvsan[i].getVsanId() != vsanIndex) continue;
                index = i;
                break;
            }
            if (index >= 0 && index < tvsan.length) {
                modelData = this.updateForNewTVsan(tvsan[index]);
            }
        }
        this._vsanTopoTblMdl.setData(modelData);
        this._vsanTopoTblMdl.fireTableDataChanged();
    }

    private Array updateForNewTVsan(TVsan tvsan) {
        Array<Object[]> modelData = new Array<Object[]>();
        int transitionPoints = tvsan.getNumTPoints();
        this._map.clear();
        this._transitionSwitches.clear();
        for (int j = 0; j < transitionPoints; ++j) {
            ArrayList<Integer> vsanIds;
            Switch swT = tvsan.getTPointSwitch(j);
            if (!this._transitionSwitches.contains(swT)) {
                this._transitionSwitches.add(swT);
            }
            if ((vsanIds = (ArrayList<Integer>)this._map.get(swT)) == null) {
                vsanIds = new ArrayList<Integer>();
            }
            Integer inVsan = new Integer(tvsan.getTPointInVsanId(j));
            Integer outVsan = new Integer(tvsan.getTPointOutVsanId(j));
            if (!vsanIds.contains(inVsan)) {
                vsanIds.add(inVsan);
            }
            if (!vsanIds.contains(outVsan)) {
                vsanIds.add(outVsan);
            }
            this._map.put(swT, vsanIds);
            Vsan inV = tvsan.getTPointInVsan(j);
            Vsan outV = tvsan.getTPointOutVsan(j);
            String vsanText = (inV == null ? Integer.toString(tvsan.getTPointInVsanId(j)) : inV.toString()) + ", " + (outV == null ? Integer.toString(tvsan.getTPointOutVsanId(j)) : outV.toString());
            modelData.addElement(new Object[]{Integer.toString(j + 1), swT, vsanText});
        }
        this.setModelValue("TRANSITION_SWITCH_LIST", this._transitionSwitches);
        ArrayList swLst = (ArrayList)this.getModelValue("IVR_ZONE_SWITCH_OBJECT_LIST");
        ArrayList ivrEnabledSw = SmZoneUtil.buildSwitchLFromVerPeerList(IvrZoneSwitch.getIvrSwitches(swLst, true));
        for (int i = 0; i < ivrEnabledSw.size(); ++i) {
            if (this._transitionSwitches.contains(ivrEnabledSw.get(i))) continue;
            this._map.put(ivrEnabledSw.get(i), new ArrayList());
        }
        this.setModelValue("IVR_ZONE_SWITCH_VSAN", this._map);
        return modelData;
    }

    private void validateVsan(short vsanId) throws SnmpException {
        boolean newVsan = true;
        if (this._transitionVsans != null) {
            for (int i = 0; i < this._transitionVsans.length; ++i) {
                if (this._transitionVsans[i].getId() != vsanId) continue;
                newVsan = false;
                break;
            }
        }
        if (newVsan) {
            boolean ficonPorts;
            TVsan tvsan = new TVsan(vsanId);
            Array selected = (Array)this.getModelValue("NXPORTS");
            String message = tvsan.check(selected, (ficonPorts = (Integer)this.getModelValue("PORT_TYPE") == 2) ? 2 : Integer.MAX_VALUE);
            if (message != null) {
                throw new SnmpException(message);
            }
            Array modelData = this.updateForNewTVsan(tvsan);
            this._vsanTopoTblMdl.setData(modelData);
            this._vsanTopoTblMdl.fireTableDataChanged();
        } else {
            this.handleVsanIdChange(vsanId);
        }
    }

    private Array getSelectedEndPorts(Array selIvrEndPorts) {
        Array<EndPort> newAr = new Array<EndPort>();
        if (selIvrEndPorts != null) {
            for (int i = 0; i < selIvrEndPorts.size(); ++i) {
                newAr.addElement(((IvrEndPort)selIvrEndPorts.elementAt(i)).getEndPort());
            }
        }
        return newAr;
    }

    private boolean buildInformation(ArrayList transitionSwitches) {
        boolean ficonPorts;
        StringBuffer sb = new StringBuffer();
        if (transitionSwitches.size() == 0) {
            sb.append("Transition VSAN is used to bridge the source and destination VSAN. We were unable to find an existing transition VSAN. Please create a new transition VSAN.");
        } else {
            sb.append("Transition VSAN is used to bridge the source and destination VSAN. Please select one of the VSANs in the list or type in an id for new VSAN which will be used as transition VSAN.");
        }
        sb.append(" (Please ensure the allowed VSAN list for trunk ISL between selected ports includes the new VSAN.)\n");
        boolean bl = ficonPorts = (Integer)this.getModelValue("PORT_TYPE") == 2;
        if (ficonPorts) {
            sb.append("(For FICON ports, please create a transit FICON Vsan between transit switches)");
        }
        this.setDescription(sb.toString());
        return true;
    }

    @Override
    public void doNext() {
        try {
            if (this._transitionSwitches.size() == 0) {
                Util.errorMessage((Component)this.getWizard(), "We could not find a trunk path or IVR capable switches.\nYou can modify the ISL trunk properties by selecting the attribute of ISL's from map.");
                return;
            }
            ArrayList enableIvrSws = new ArrayList();
            ArrayList zoneSwitches = (ArrayList)this.getModelValue("IVR_ZONE_SWITCH_OBJECT_LIST");
            ArrayList ivrEnabledSw = SmZoneUtil.buildSwitchLFromVerPeerList(IvrZoneSwitch.getIvrSwitches(zoneSwitches, true));
            for (int i = 0; i < this._transitionSwitches.size(); ++i) {
                if (ivrEnabledSw.contains(this._transitionSwitches.get(i))) continue;
                enableIvrSws.add(this._transitionSwitches.get(i));
            }
            this.setModelValue("IVR_TO_ENABLE_SWITCHES", enableIvrSws);
            Switch sw = (Switch)this.getModelValue("IVR_ZONE_SWITCH");
            if (sw == null) {
                sw = ((Fabric)this.getModelValue("IVR_SELECTED_FABRIC")).getFirstIvrSeedSwitch();
                if (sw == null || !sw.isManageable() || !sw.isMDS()) {
                    sw = (Switch)this._transitionSwitches.get(0);
                }
                this.setModelValue("IVR_ZONE_SWITCH", sw);
            }
            this.setModelValue("ENABLE_FABRIC_BINDING", this._fabricBindingChkBox.isSelected());
            Integer vsanId = Integer.valueOf(this._vsanField.getText());
            this.validateVsan(this.getVsanId());
            Integer cachedVsanId = (Integer)this.getModelValue("TRANSITION_VSAN_ID");
            if (cachedVsanId == null || cachedVsanId.intValue() != vsanId.intValue()) {
                this.setDataValid(false);
                HashMap topoMap = (HashMap)this.getModelValue("IVR_ZONE_SWITCH_VSAN");
                if (topoMap == null) {
                    throw new SnmpException("No VSAN topology information is available.");
                }
                VarBindList vbTopo = null;
                VarBindList activeTopo = (VarBindList)this.getModelValue("IVR_ACTIVE_TOPOLOGY_VBL");
                vbTopo = Ivr1Results.buildTopologyVarBind(SmZoneUtil.getSwitchPeer(sw), topoMap, activeTopo);
                if (!this.validateTopVsansForDids(vbTopo)) {
                    return;
                }
                this.setModelValue("TRANSITION_VSAN_ID", vsanId);
                this.setModelValue("TOPOLOGY_VARBIND", vbTopo);
            }
            super.doNext();
        }
        catch (NumberFormatException ex) {
            boolean ficonPorts;
            boolean bl = ficonPorts = (Integer)this.getModelValue("PORT_TYPE") == 2;
            if (ficonPorts) {
                Util.errorMessage((Component)this.getWizard(), "Please create a transit FICON Vsan between transit switches for FICON ports\nand restart the wizard.");
            }
            Util.errorMessage((Component)this.getWizard(), "Please enter a valid VSAN Id.");
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this.getWizard(), ex.getMessage());
        }
    }

    private short getVsanId() throws NumberFormatException {
        short tfVsanId = Short.parseShort(this._vsanField.getText());
        if (tfVsanId > 0 && tfVsanId < 4094) {
            return tfVsanId;
        }
        throw new NumberFormatException("VSAN Id out of range");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._validateBtn) {
            try {
                this.validateVsan(this.getVsanId());
                this.getWizard().getNavigator().getNextBtn().setEnabled(this._transitionSwitches.size() != 0);
            }
            catch (NumberFormatException ex) {
                Util.errorMessage((Component)this.getWizard(), "Please enter a valid VSAN Id.");
            }
            catch (SnmpException ex) {
                Util.errorMessage((Component)this.getWizard(), ex);
            }
            return;
        }
    }

    boolean validateTopVsansForDids(VarBindList topology) {
        Array selected = (Array)this.getModelValue("NXPORTS");
        EndPort portOne = ((IvrEndPort)selected.elementAt(0)).getEndPort();
        HashMap map = Ivr1Results.getConflictingDids(WizardCopyTopologyAction.buildVsanList(topology, (Fabric)this.getModelValue("IVR_SELECTED_FABRIC")));
        if (map.size() > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("The following switches do not have unique Domain Ids in active topology VSANs.\n");
            for (Map.Entry obEntry : map.entrySet()) {
                Integer did = (Integer)obEntry.getKey();
                ArrayList vsanList = (ArrayList)obEntry.getValue();
                for (int k = 0; k < vsanList.size(); ++k) {
                    Vsan v = (Vsan)vsanList.get(k);
                    Switch sw = portOne.getFabric().findSwitchByVsanDomainId(v.getId(), did);
                    buf.append((sw != null ? sw.toString() : "Unknown Switch") + ": Domain Id 0x" + Integer.toHexString(did) + " in " + v + "\n");
                }
            }
            buf.append("IVR may not work correctly. Continue?");
            return JOptionPane.showConfirmDialog(this.getWizard(), buf.toString(), this.getWizard().getTitle(), 0, 2) == 0;
        }
        return true;
    }

    private ArrayList buildIvrSwitches() {
        ArrayList swLst = (ArrayList)this.getModelValue("IVR_ZONE_SWITCH_OBJECT_LIST");
        ArrayList sws = SmZoneUtil.buildSwitchLFromVerPeerList(SmIvrZoneSwitch.getIvrSwitches(swLst, true));
        if (this._transitionSwitches != null) {
            for (int i = 0; i < this._transitionSwitches.size(); ++i) {
                if (sws.contains(this._transitionSwitches.get(i))) continue;
                sws.add(this._transitionSwitches.get(i));
            }
        }
        return sws;
    }

    public class VsanMenuButton
    extends MenuButton {
        private TopologyPanel _pnl;

        public VsanMenuButton(JMenu menu, TopologyPanel pnl) {
            super(menu);
            this._pnl = pnl;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JMenuItem) {
                String source = ((JMenuItem)e.getSource()).getText();
                int index = source.indexOf("ID:");
                TopologyPanel.this._vsanField.setText(source.substring(index + 3));
                try {
                    int vsanId = Integer.parseInt(TopologyPanel.this._vsanField.getText());
                    this._pnl.handleVsanIdChange(vsanId);
                }
                catch (NumberFormatException ex) {
                    Util.errorMessage((Component)this._pnl.getWizard(), "Please enter a valid VSAN Id.");
                }
                return;
            }
            super.actionPerformed(e);
        }

        @Override
        public JMenu buildMenu(Object[] items) {
            Arrays.sort(items);
            return super.buildMenu(items);
        }

        @Override
        protected JMenuItem buildMenuItem(Object item) {
            Vsan v = (Vsan)item;
            JMenuItem mi = new JMenuItem(v + ", ID:" + v.getId());
            mi.addActionListener(this);
            return mi;
        }
    }
}

