/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.cfgdiffEngine;

import com.cisco.dcbu.sm.common.cfgdiffEngine.KeywordEnumKind;

public enum ConfigFile implements KeywordEnumKind
{
    LEFT("Left", "Left"),
    RIGHT("Right", "Right");

    private static final long serialVersionUID = 1L;
    private final transient String keyValue;
    private final transient String keyWord;

    private ConfigFile(String aName, String aKeyword) {
        this.keyValue = aName;
        this.keyWord = aKeyword;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal();
    }

    public static int minOrdinal() {
        return 0;
    }

    public static int maxOrdinal() {
        return ConfigFile.values().length - 1;
    }

    public static ConfigFile minEnum() {
        return ConfigFile.values()[0];
    }

    public static ConfigFile maxEnum() {
        return ConfigFile.values()[ConfigFile.values().length - 1];
    }

    public static ConfigFile getInstance(int aOrdinal) {
        if (aOrdinal >= ConfigFile.minOrdinal() && aOrdinal <= ConfigFile.maxOrdinal()) {
            return ConfigFile.values()[aOrdinal];
        }
        throw new IllegalArgumentException("ConfigFile ordinal must be between [" + ConfigFile.minOrdinal() + "," + ConfigFile.maxOrdinal() + "], but was " + aOrdinal);
    }

    public static ConfigFile getInstance(String aKeyword) {
        for (ConfigFile a : ConfigFile.values()) {
            if (!a.getKeyword().equals(aKeyword)) continue;
            return a;
        }
        throw new IllegalArgumentException("ConfigFile keyword name [" + aKeyword + "] does not exist");
    }

    @Override
    public final String getKeyword() {
        return this.keyWord;
    }

    public final String toString() {
        return this.getName() + "(" + this.getOrdinal() + ", " + this.getKeyword() + ")";
    }

    @Override
    public final String getName() {
        return this.keyValue;
    }
}

