/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.dto;

import java.io.Serializable;
import java.util.Comparator;

public class CliData
implements Serializable,
Comparator,
Comparable {
    private String[] cliCmds;
    private String refSwitch = "";
    private String vsanName = "";
    private int vsanId = -2;
    private boolean isCommented = false;
    private String cliExplanation;
    private int cmdIndex = -1;
    private boolean isEnhancedOrCfs;
    private String zoneset;
    private boolean activateZs = true;
    public static int sortMode = -1;
    public static final int REF_SWITCH_SORT = 1;
    public static final int VSAN_SORT = 2;
    public static final int CMD_INDEX_SORT = 3;

    public String getCommitString() {
        if (this.isEnhancedOrCfs) {
            if (this.cmdIndex == 0) {
                return "device-alias commit";
            }
        } else if (this.cmdIndex == 2 || this.cmdIndex == 3) {
            if (this.vsanId > 0) {
                return "!zone commit vsan " + this.vsanId;
            }
            return "!ivr commit";
        }
        return null;
    }

    public String getActivateDeActivateString() {
        if ((this.cmdIndex == 2 || this.cmdIndex == 3) && this.zoneset != null && this.zoneset.trim().length() > 0) {
            if (this.vsanId > 0) {
                return this.activateZs ? "!Uncomment zoneset activate name " + this.zoneset + " vsan " + this.vsanId : "!Uncomment no zoneset activate name " + this.zoneset + " vsan " + this.vsanId;
            }
            return this.activateZs ? "!ivr zoneset activate name " + this.zoneset : "!no ivr zoneset activate name " + this.zoneset;
        }
        return null;
    }

    public int getCmdIndex() {
        return this.cmdIndex;
    }

    public void setCmdIndex(int cmdIndex) {
        this.cmdIndex = cmdIndex;
    }

    public String getCliExplanation() {
        return this.cliExplanation.trim().length() > 0 ? (this.vsanName.trim().length() > 0 ? this.vsanName + ", " : "") + (this.refSwitch.trim().length() > 0 ? this.refSwitch + ", " : "") + this.cliExplanation : "";
    }

    public void setCliExplanation(String cliExplanation) {
        this.cliExplanation = cliExplanation;
    }

    public CliData(int index, String[] cliCmd, String refSw, String vsan, int vid, boolean isCmt, String expl) {
        this.cliCmds = cliCmd;
        this.refSwitch = refSw;
        this.vsanName = vsan;
        this.vsanId = vid;
        this.isCommented = isCmt;
        this.cliExplanation = expl;
        this.cmdIndex = index;
    }

    public String getCliAsString() {
        String theCli = "";
        if (this.cliCmds != null && this.cliCmds.length > 0) {
            for (int i = 0; i < this.cliCmds.length; ++i) {
                theCli = theCli + this.cliCmds[i] + "<BR>";
            }
        }
        return (this.isCommented ? "!UNCOMMENT  " : "") + theCli;
    }

    public boolean isCommented() {
        return this.isCommented;
    }

    public void setCommented(boolean isCommented) {
        this.isCommented = isCommented;
    }

    public String getRefSwitch() {
        return this.refSwitch;
    }

    public void setRefSwitch(String refSwitch) {
        this.refSwitch = refSwitch;
    }

    public String getVsanName() {
        return this.vsanName;
    }

    public void setVsanName(String vsanName) {
        this.vsanName = vsanName;
    }

    public int getVsanId() {
        return this.vsanId;
    }

    public void setVsanId(int vsanId) {
        this.vsanId = vsanId;
    }

    public String[] getCliCmds() {
        return this.cliCmds;
    }

    public void setCliCmds(String[] cliCmds) {
        this.cliCmds = cliCmds;
    }

    public boolean isEnhancedOrCfs() {
        return this.isEnhancedOrCfs;
    }

    public void setEnhancedOrCfs(boolean isEnhancedOrCfs) {
        this.isEnhancedOrCfs = isEnhancedOrCfs;
    }

    public String getZoneset() {
        return this.zoneset;
    }

    public void setZoneset(String zoneset) {
        this.zoneset = zoneset;
    }

    public boolean isActivateZs() {
        return this.activateZs;
    }

    public void setActivateZs(boolean activateZs) {
        this.activateZs = activateZs;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        CliData z1 = (CliData)o1;
        CliData z2 = (CliData)o2;
        switch (sortMode) {
            case 1: {
                return z1.refSwitch.compareTo(z2.refSwitch);
            }
            case 2: {
                return z1.vsanName.compareTo(z2.vsanName);
            }
            case 3: {
                return z1.cmdIndex - z2.cmdIndex;
            }
        }
        return z1.getCliAsString().compareTo(z2.getCliAsString());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CliData z = (CliData)obj;
        switch (sortMode) {
            case 1: {
                return z.refSwitch.equals(this.refSwitch);
            }
            case 2: {
                return z.vsanName.equals(this.vsanName);
            }
            case 3: {
                return z.cmdIndex == this.cmdIndex;
            }
        }
        return z.getCliAsString().equals(this.getCliAsString());
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }
}

