/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.event;

import java.util.Comparator;

public enum LogEventType implements Comparator
{
    SYSLOG("All Syslog", -1),
    ALL("All Events", 0),
    OTHER("Other", 1),
    FABRIC("Fabric", 2),
    FICON("Ficon", 3),
    IVR("IVR", 4),
    LICENSE("License", 5),
    PORT_ALARM("Port Alarm", 6),
    PORT_DOWN("Port Down", 7),
    PORT_UP("Port Up", 8),
    SECURITY("Security", 9),
    SWITCH_HARDWARE("Switch Hardware", 10),
    SWITCH_MANAGEABILITY("Switch Manageability", 11),
    THRESHOLD("Threshold", 12),
    VSAN("VSAN", 13),
    ZONE("Zone", 14),
    LAN("LAN", 15),
    VC("Virtual Center", 16);

    private String _type;
    private int _intVal;
    private static LogEventType[] _eventTypes;

    private LogEventType(String type, int val) {
        this._type = type;
        this._intVal = val;
    }

    public String toString() {
        return this._type;
    }

    public int value() {
        return this._intVal;
    }

    public static String toString(int value) {
        if (value >= -1 && value < _eventTypes.length - 1) {
            return _eventTypes[value + 1].toString();
        }
        return "Unknown";
    }

    public static LogEventType valueOf(int value) {
        if (value >= -1 && value < _eventTypes.length - 1) {
            return _eventTypes[value + 1];
        }
        throw new IllegalArgumentException("invalid type: " + value);
    }

    public static LogEventType valueOfByString(String typeString) {
        for (int i = 0; i < _eventTypes.length; ++i) {
            if (!_eventTypes[i].toString().equals(typeString)) continue;
            return _eventTypes[i];
        }
        return null;
    }

    public static String[] getStringTable() {
        String[] st = new String[_eventTypes.length];
        for (int i = 0; i < _eventTypes.length; ++i) {
            st[i] = _eventTypes[i].toString();
        }
        return st;
    }

    public int compare(Object o1, Object o2) {
        return o1.toString().compareTo(o2.toString());
    }

    public static void main(String[] strArgs) {
        System.out.println(LogEventType.valueOf(-1));
        System.out.println(LogEventType.valueOfByString("Fabric").value());
    }

    static {
        _eventTypes = LogEventType.values();
    }
}

