/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.event;

import java.util.Comparator;

public enum PortLogEventType implements Comparator
{
    ALL("All", -1),
    OTHER("Other", 0),
    STORAGE("Storage", 1),
    HOST("Host", 2),
    ISL("ISL", 3),
    NPLINK("NPV link", 4);

    private String _type;
    private int _intVal;
    private static PortLogEventType[] _eventTypes;

    private PortLogEventType(String type, int val) {
        this._type = type;
        this._intVal = val;
    }

    public String toString() {
        return this._type;
    }

    public int value() {
        return this._intVal;
    }

    public static String toString(int value) {
        if (value >= -1 && value < _eventTypes.length - 1) {
            return _eventTypes[value + 1].toString();
        }
        return "Unknown";
    }

    public static PortLogEventType valueOf(int value) {
        if (value >= -1 && value < _eventTypes.length - 1) {
            return _eventTypes[value + 1];
        }
        throw new IllegalArgumentException("invalid type: " + value);
    }

    public static PortLogEventType valueOfByString(String typeString) {
        for (int i = 0; i < _eventTypes.length; ++i) {
            if (!_eventTypes[i].toString().equals(typeString)) continue;
            return _eventTypes[i];
        }
        return null;
    }

    public static String[] getStringTable() {
        String[] st = new String[_eventTypes.length];
        for (int i = 0; i < _eventTypes.length; ++i) {
            st[i] = _eventTypes[i].toString();
        }
        return st;
    }

    public int compare(Object o1, Object o2) {
        return o1.toString().compareTo(o2.toString());
    }

    public static void main(String[] strArgs) {
        System.out.println(PortLogEventType.valueOf(-1));
        System.out.println(PortLogEventType.valueOfByString("NPV link").value());
    }

    static {
        _eventTypes = PortLogEventType.values();
    }
}

