/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.event;

import com.cisco.dcbu.sm.common.event.AbstractEventHandler;
import com.cisco.dcbu.sm.common.event.MessageSelector;
import com.cisco.dcbu.sm.common.event.smis.LinkStateChange;
import com.cisco.dcbu.sm.common.event.smis.ZoneChange;
import com.cisco.dcbu.sm.common.event.smis.ZoneSetChange;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;

public class SMISNotifHandler
extends AbstractEventHandler {
    private static SMISNotifHandler _eventHandler;
    private static final String TOPIC_SMIS = "topic/smisTopic";

    public SMISNotifHandler(String host, int port) throws RemoteException {
        super(host, port);
    }

    public static SMISNotifHandler getInstance(String host, int port) throws RemoteException {
        if (_eventHandler == null) {
            _eventHandler = new SMISNotifHandler(host, port);
        }
        return _eventHandler;
    }

    @Override
    public void onMessage(Message msg) {
        ObjectMessage om = (ObjectMessage)msg;
        Serializable event = null;
        try {
            event = om.getObject();
            if (event instanceof LinkStateChange) {
                LinkStateChange eventObj = (LinkStateChange)event;
                String fabric = eventObj.getFabricName();
                int operValue = eventObj.getIfOperStatus().value();
                int adminStatus = eventObj.getIfAdminStatus().value();
            } else if (event instanceof ZoneChange) {
                ZoneChange zcevent = (ZoneChange)event;
                String zoneName = zcevent.getZoneName();
                int state = zcevent.getState();
            } else if (event instanceof ZoneSetChange) {
                ZoneSetChange zsevent = (ZoneSetChange)event;
                int state = zsevent.getState();
            }
        }
        catch (Exception ex) {
            this._logger.error((Object)("error process event:" + om.toString()));
            return;
        }
    }

    @Override
    protected void setMessageSelector() throws JMSException {
        this.setMessageSelector(MessageSelector.NON_MSG_SELECTOR);
    }

    @Override
    public void remove() {
        _eventHandler = null;
    }

    @Override
    protected String getTopic() {
        return TOPIC_SMIS;
    }
}

