/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.event;

public enum Severity {
    EMERGENCY(0),
    ALERT(1),
    CRITICAL(2),
    ERROR(3),
    WARNING(4),
    NOTICE(5),
    INFO(6),
    DEBUG(7);

    static final long serialVersionUID = 1L;
    static final String[] _StringTable;
    static final Severity[] _EnumValueTable;
    private int _value;

    private Severity(int value) {
        this._value = value;
    }

    public int getValue() {
        return this._value;
    }

    public String toString() {
        return _StringTable[this._value];
    }

    public static String[] stringValues() {
        return _StringTable;
    }

    public static Severity valueOf(int value) {
        if (value >= Severity.EMERGENCY._value && value <= Severity.DEBUG._value) {
            return _EnumValueTable[value];
        }
        throw new IllegalArgumentException("invalid severity value: " + value);
    }

    public static Severity stringOf(String name) {
        for (int i = Severity.EMERGENCY._value; i <= Severity.DEBUG._value; ++i) {
            if (!_StringTable[i].equals(name)) continue;
            return _EnumValueTable[i];
        }
        throw new IllegalArgumentException("invalid severity string: " + name);
    }

    static {
        _StringTable = new String[]{"Emergency", "Alert", "Critical", "Error", "Warning", "Notice", "Info", "Debug"};
        _EnumValueTable = new Severity[]{EMERGENCY, ALERT, CRITICAL, ERROR, WARNING, NOTICE, INFO, DEBUG};
    }
}

