/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.PortIf;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SwitchIntKeyIf;

public abstract class AbstractPortBase<E extends SwitchIntKeyIf, T extends PKIf>
extends BaseModelObject
implements PortIf<E, T> {
    static final long serialVersionUID = 1L;
    public static final int Up_Mode = 1;
    public static final int Down_Mode = 2;
    public static final int Unknown_Mode = 4;
    public static final int NotPresent_Mode = 6;
    public static final short STATUS_UP = 1;
    public static final short STATUS_DOWN = 2;
    public static final short STATUS_TESTING = 3;
    public static final short STATUS_UNKNOWN = 4;
    public static final short STATUS_DORMANT = 5;
    public static final short STATUS_NOTPRESENT = 6;
    public static final short STATUS_LOWERLAYERDOWN = 7;
    public static final String Unknown_Name = "unknown";
    protected final E _pkey;
    protected String _ifname;
    protected int _ifType = -1;
    protected long _ifSpeed = -1L;
    protected int _ifOperMode = -1;
    protected short _ifAdminStatus = (short)-1;
    protected short _ifOperStatus;
    protected byte _trunkMode;
    protected String _displayName = null;

    public AbstractPortBase(E pkey) {
        if (pkey == null) {
            throw new IllegalArgumentException("Invaild switch port key:" + pkey);
        }
        this._pkey = pkey;
    }

    public void sync(AbstractPortBase<E, T> port) {
        super.sync(port);
        this._ifname = port._ifname;
        this._ifType = port._ifType;
        this._ifSpeed = port._ifSpeed;
        this._ifOperMode = port._ifOperMode;
        this._trunkMode = port._trunkMode;
    }

    @Override
    public PKIf getPK() {
        return this._pkey;
    }

    @Override
    public E getSwitchPortPK() {
        return this._pkey;
    }

    @Override
    public abstract T getSwitchPK();

    @Override
    public int getIfIndex() {
        return this._pkey.getIfindex();
    }

    @Override
    public String getIfname() {
        return this._ifname;
    }

    public void setIfname(String ifname) {
        boolean changed;
        boolean bl = changed = !GenUtil.equals(this._ifname, ifname);
        if (changed) {
            this.setModified(true);
            this._ifname = ifname;
        }
    }

    public long getIfSpeed() {
        return this._ifSpeed;
    }

    public void setIfSpeed(long ifSpeed) {
        if (this._ifSpeed != ifSpeed) {
            this._ifSpeed = ifSpeed;
            this.setModified(true);
        }
    }

    public int getIfType() {
        return this._ifType;
    }

    public void setIfType(int ifType) {
        if (this._ifType != ifType) {
            this.setModified(true);
            this._ifType = ifType;
        }
    }

    @Override
    public int getIfOperMode() {
        return this._ifOperMode;
    }

    public void setIfOperMode(int operMode) {
        if (this._ifOperMode != operMode) {
            this.setModified(true);
            this._ifOperMode = operMode;
        }
    }

    public void setIfAdminStatus(short ifAdminStatus) {
        if (this._ifAdminStatus != ifAdminStatus) {
            this.setModified(true);
            this._ifAdminStatus = ifAdminStatus;
        }
    }

    public short getIfAdminStatus() {
        return this._ifAdminStatus;
    }

    public void setIfOperStatus(short ifOperStatus) {
        if (this._ifOperStatus != ifOperStatus) {
            this.setModified(true);
            this._ifOperStatus = ifOperStatus;
        }
    }

    public short getIfOPerStatus() {
        return this._ifOperStatus;
    }

    public byte getTrunkMode() {
        return this._trunkMode;
    }

    public void setTrunkMode(byte mode) {
        if (this._trunkMode != mode) {
            this.setModified(true);
            this._trunkMode = mode;
        }
    }

    public void setDisplayName(String name) {
        boolean changed;
        boolean bl = changed = !GenUtil.equals(this._displayName, name);
        if (changed) {
            this._displayName = name;
            this._isModified = true;
        }
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public short getOperStatusCause() {
        return -1;
    }

    public short getIfOperStatusCause() {
        if (this.getIfType() == 56) {
            return this.getOperStatusCause();
        }
        if (this.getIfAdminStatus() == 2) {
            return 12;
        }
        if (this.getIfAdminStatus() == 1 && this.getIfOPerStatus() == 1) {
            return 2;
        }
        if (this.getIfAdminStatus() == 1 && this.getIfOPerStatus() != 1) {
            return 7;
        }
        return 2;
    }
}

