/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

public class BaseModelConstants {
    public static final short FABRIC_BASE_ATTR = 512;
    public static final short VSAN_BASE_ATTR = 768;
    public static final short SW_BASE_ATTR = 1024;
    public static final short ISL_BASE_ATTR = 1280;
    public static final short NXPORT_BASE_ATTR = 1536;
    public static final short ENCL_BASE_ATTR = 1792;
    public static final short PORT_BASE_ATTR = 2048;
    public static final short GROUP_BASE_ATTR = 2304;
    public static final short CLUSTER_BASE_ATTR = 2560;
    public static final short VLAN_BASE_ATTR = 2816;
    public static final short NPVLINK_BASE_ATTR = 3072;
    public static final short CDPSEED_BASE_ATTR = 3328;
    public static final short LAN_BASE_ATTR = 3584;
    public static final short HOST_SYSTEM_ATTR = 3840;
    public static final short CFS_REGION_ATTR = 4096;
    public static final short FEX_BASE_ATTR = 4352;
    public static final int CISCO_VENDOR_OID = 9;
    public static final int MCDATA_VENDOR_OID = 289;
    public static final int BROCADE_VENDOR_OID = 1588;
    public static final int INRANGE_VENDOR_OID = 5808;
    public static final int QLOGIC1_VENDOR_OID = 1663;
    public static final int QLOGIC2_VENDOR_OID = 3873;
    public static final int FWSM_OID = 522;
    public static final String Cisco_Str = "Cisco";
    public static final String McData_Str = "McData";
    public static final String Brocade_Str = "Brocade";
    public static final String InRange_Str = "InRange";
    public static final String QLogic_Str = "QLogic";

    public static String getVendorFromSysOid(int vendorOid) {
        switch (vendorOid) {
            case 9: {
                return Cisco_Str;
            }
            case 289: {
                return McData_Str;
            }
            case 1588: {
                return Brocade_Str;
            }
            case 5808: {
                return InRange_Str;
            }
            case 1663: 
            case 3873: {
                return QLogic_Str;
            }
        }
        return null;
    }

    public static boolean isFWSM(int[] sysObjectID) {
        if (sysObjectID == null || sysObjectID.length < 8) {
            return false;
        }
        return sysObjectID[6] == 9 && sysObjectID[7] == 1 && sysObjectID[8] == 522;
    }
}

