/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.common.dto.FcPortAlias;
import com.cisco.dcbu.sm.common.model.CfsRegion;
import com.cisco.dcbu.sm.common.model.ClusterBase;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.GroupBase;
import com.cisco.dcbu.sm.common.model.IslBase;
import com.cisco.dcbu.sm.common.model.NpvLinkBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.vi.model.DataStore;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class FabricBase
implements Serializable {
    static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<String, ConcurrentHashMap<Integer, FcPortAlias>> _deviceAliasByName = new ConcurrentHashMap();
    protected ConcurrentHashMap<Wwn, FcPortAlias> _deviceAliasByWwn = new ConcurrentHashMap();
    public static final short FABRIC_ATTR = 512;
    public static final short ATTR_NAME = 513;
    public static final short ATTR_SEEDPK = 514;
    public static final short ATTR_IVRSEEDPK = 515;
    public static final short ATTR_IVRENFZONESETNAME = 516;
    public static final short ATTR_IVRENFZONESETTIME = 517;
    public static final short ATTR_IVRENFZONES = 518;
    public static final short ATTR_PERSISTENCE = 519;
    public static final short ATTR_ALIASSEEDPK = 520;
    public static final short ATTR_DEVICEALIAS = 521;
    public static final short ATTR_USEFCALIAS = 522;
    public static final short ATTR_GROUPS = 523;
    public static final short ATTR_CLUSTER = 524;
    public static final short ATTR_COEXISTMAP = 525;
    public static final String[] _Attrs = new String[]{"fabricName", "fabricSeed", "ivrSeedSwitch", "ivrEnforcedZonesetName", "ivrEnforcedZonesetActivateTime", "ivrActiveZones", "persistent", "aliasSeedSwitch", "deviceAlias", "useFcAlias", "groups", "cluster", "coexistmap"};
    protected final FabricPK _pkey;
    protected WwnKey _seedSwPK;
    protected String _seedSwName;
    protected InetAddress _seedIP;
    protected boolean _licensed;
    protected long _lastUpdateTime = 0L;
    protected Collection<VsanBase> _vsans;
    protected Collection<CfsRegion> _cfsRegions;
    protected Collection<SwitchBase> _switches;
    protected Collection<IslBase> _isls;
    protected Collection<EndPortBase> _endports;
    protected Collection<FcPortBase> _fcports;
    protected Collection<NpvLinkBase> _npvLinks;
    protected Collection<FcPortAlias> _deviceAliases;
    protected Collection<ClusterBase> _clusters;
    protected Collection<DataStore> _dataStores;
    protected HashMap<PKIf, PKIf> _coexistSwPKs;
    protected WwnKey _ivrSeedSwPK;
    protected ConcurrentHashMap<Integer, String> _ivrEnfZoneSetName;
    protected ConcurrentHashMap<Integer, Long> _ivrEnfZoneSetActivateTime;
    protected ConcurrentHashMap<Integer, ZoneBase[]> _ivrEnfZones;
    protected ConcurrentHashMap<Integer, WwnKey> _ivrSeedByCfsRegion;
    protected ConcurrentHashMap<Integer, WwnKey> _aliasSeedByCfsRegion;
    protected boolean _useFcAlias;
    protected WwnKey _aliasSeedSwPK;
    protected boolean _isPersistent;
    protected String _includedVsanList;
    protected String _excludedVsanList;

    public FabricBase(FabricPK pkey) {
        this._pkey = pkey;
    }

    public FabricBase(FabricBase fabric) {
        this._pkey = fabric._pkey;
        this._seedSwPK = fabric._seedSwPK;
        this._seedSwName = fabric.getSeedSwitchName();
        this._seedIP = fabric.getSeedSwitchIP();
        this._lastUpdateTime = fabric._lastUpdateTime;
        this._licensed = fabric.isLicensed();
        this._lastUpdateTime = fabric._lastUpdateTime;
        this._ivrSeedSwPK = fabric._ivrSeedSwPK;
        this._ivrEnfZoneSetName = fabric._ivrEnfZoneSetName;
        this._ivrEnfZoneSetActivateTime = fabric._ivrEnfZoneSetActivateTime;
        this._ivrEnfZones = fabric._ivrEnfZones;
        this._ivrSeedByCfsRegion = fabric._ivrSeedByCfsRegion;
        this._aliasSeedByCfsRegion = fabric._aliasSeedByCfsRegion;
        this._useFcAlias = fabric._useFcAlias;
        this._aliasSeedSwPK = fabric._aliasSeedSwPK;
        this._isPersistent = fabric._isPersistent;
        this._vsans = fabric._vsans;
        this._cfsRegions = fabric._cfsRegions;
        this._switches = fabric._switches;
        this._isls = fabric._isls;
        this._npvLinks = fabric._npvLinks;
        this._endports = fabric._endports;
        this._fcports = fabric._fcports;
        this._deviceAliases = fabric._deviceAliases;
        this._clusters = fabric._clusters;
        this._deviceAliasByName = fabric._deviceAliasByName;
        this._deviceAliasByWwn = fabric._deviceAliasByWwn;
    }

    public void setDeviceAliasMap(FabricBase fabric) {
        this._deviceAliasByName = fabric._deviceAliasByName;
        this._deviceAliasByWwn = fabric._deviceAliasByWwn;
    }

    public FabricPK getPK() {
        return this._pkey;
    }

    public String toString() {
        return this._pkey.toString();
    }

    public boolean equals(FabricBase fabric) {
        return fabric.getPK().equals(this._pkey);
    }

    public String getFabricName() {
        return this._pkey.getName();
    }

    public void setFabricName(String name) {
        this._pkey.setName(name);
    }

    public WwnKey getSeedSwitchPK() {
        return this._seedSwPK;
    }

    public void setSeedSwitchPK(WwnKey swPK) {
        this._seedSwPK = swPK;
    }

    public String getSeedSwitchName() {
        return this._seedSwName;
    }

    public void setSeedSwitchName(String name) {
        this._seedSwName = name;
    }

    public InetAddress getSeedSwitchIP() {
        return this._seedIP;
    }

    public boolean isLicensed() {
        return this._licensed;
    }

    public Long getLastUpdateTime() {
        return this._lastUpdateTime;
    }

    public boolean isPersistent() {
        return this._isPersistent;
    }

    public void setPersistent(boolean isPersistent) {
        this._isPersistent = isPersistent;
    }

    public WwnKey getIvrSeedSwitchPK() {
        return this._ivrSeedSwPK;
    }

    public WwnKey getFirstIvrSeedSwitchPK() {
        return this._ivrSeedByCfsRegion != null && this._ivrSeedByCfsRegion.elements() != null && this._ivrSeedByCfsRegion.elements().hasMoreElements() ? this._ivrSeedByCfsRegion.elements().nextElement() : null;
    }

    public void setIvrSeedSwitchPK(WwnKey swPK) {
        this._ivrSeedSwPK = swPK;
    }

    public WwnKey getRegionIvrSeed(int cfsRegionId) {
        return this._ivrSeedByCfsRegion != null ? this._ivrSeedByCfsRegion.get(new Integer(cfsRegionId)) : null;
    }

    public void setRegionIvrSeed(int cfsRegionId, WwnKey swPK) {
        if (this._ivrSeedByCfsRegion == null) {
            this._ivrSeedByCfsRegion = new ConcurrentHashMap();
        }
        if (swPK == null && this._ivrSeedByCfsRegion.get(new Integer(cfsRegionId)) != null) {
            this._ivrSeedByCfsRegion.remove(new Integer(cfsRegionId));
        } else if (swPK != null) {
            this._ivrSeedByCfsRegion.put(new Integer(cfsRegionId), swPK);
        }
    }

    public WwnKey getRegionAliasSeed(int cfsRegionId) {
        return this._aliasSeedByCfsRegion.get(new Integer(cfsRegionId));
    }

    public void setRegionAliasSeed(int cfsRegionId, WwnKey swPK) {
        if (this._aliasSeedByCfsRegion == null) {
            this._aliasSeedByCfsRegion = new ConcurrentHashMap();
        }
        if (swPK == null && this._aliasSeedByCfsRegion.get(new Integer(cfsRegionId)) != null) {
            this._aliasSeedByCfsRegion.remove(new Integer(cfsRegionId));
        } else if (swPK != null) {
            this._aliasSeedByCfsRegion.put(new Integer(cfsRegionId), swPK);
        }
    }

    public String getIvrEnforcedZoneSetName() {
        return this._ivrEnfZoneSetName.get(new Integer(-1));
    }

    public String getIvrEnforcedZoneSetName(int cfsRegionId) {
        return this._ivrEnfZoneSetName.get(new Integer(cfsRegionId));
    }

    public ConcurrentHashMap<Integer, String> getAllIvrEnforcedZoneSetName() {
        return this._ivrEnfZoneSetName;
    }

    public ConcurrentHashMap<Integer, ZoneBase[]> getAllIvrEnforcedZones() {
        return this._ivrEnfZones;
    }

    public void setIvrEnforcedZoneSetName(String newName) {
        this.setIvrEnforcedZoneSetName(-1, newName);
    }

    public void setIvrEnforcedZoneSetName(int cfsRegionId, String newName) {
        if (newName == null) {
            this._ivrEnfZoneSetName.remove(new Integer(cfsRegionId));
        } else {
            this._ivrEnfZoneSetName.put(new Integer(cfsRegionId), newName);
        }
    }

    public long getIvrEnforcedZoneSetActivateTime() {
        return this.getIvrEnforcedZoneSetActivateTime(-1);
    }

    public long getIvrEnforcedZoneSetActivateTime(int cfsRegionId) {
        Long val = this._ivrEnfZoneSetActivateTime.get(new Integer(cfsRegionId));
        return val == null ? -1L : val;
    }

    public void setIvrEnforcedZoneSetActivateTime(long time) {
        this._ivrEnfZoneSetActivateTime.put(-1, time);
    }

    public void setIvrEnforcedZoneSetActivateTime(int cfsRegionId, long time) {
        if (time == -1L) {
            this._ivrEnfZoneSetActivateTime.remove(new Integer(cfsRegionId));
        } else {
            this._ivrEnfZoneSetActivateTime.put(new Integer(cfsRegionId), new Long(time));
        }
    }

    public ZoneBase[] getIvrEnforcedZones() {
        return this.getIvrEnforcedZones(-1);
    }

    public ZoneBase[] getIvrEnforcedZones(int cfsRegionId) {
        return this._ivrEnfZones.get(new Integer(cfsRegionId));
    }

    public void setIvrEnforcedZones(ZoneBase[] zones) {
        this.setIvrEnforcedZones(-1, zones);
    }

    public void setIvrEnforcedZones(int cfsRegionId, ZoneBase[] zones) {
        if (zones == null) {
            this._ivrEnfZones.remove(new Integer(cfsRegionId));
        } else {
            this._ivrEnfZones.put(new Integer(cfsRegionId), zones);
        }
    }

    public boolean useFcAlias() {
        return this._useFcAlias;
    }

    public void useFcAlias(boolean b) {
        this._useFcAlias = b;
    }

    public WwnKey getAliasSeedSwitchPK() {
        return this._aliasSeedSwPK;
    }

    public void setAliasSeedSwitchPK(WwnKey swPK) {
        this._aliasSeedSwPK = swPK;
    }

    public int getNumVsans() {
        return this._vsans != null ? this._vsans.size() : 0;
    }

    public Collection<VsanBase> getVsans() {
        return this._vsans;
    }

    public int getNumCfsRegions() {
        return this._cfsRegions != null ? this._cfsRegions.size() : 0;
    }

    public Collection<CfsRegion> getCfsRegions() {
        return this._cfsRegions;
    }

    public int getNumSwitches() {
        return this._switches != null ? this._switches.size() : 0;
    }

    public Collection<SwitchBase> getSwitches() {
        return this._switches;
    }

    public int getNumDeviceAliases() {
        return this._deviceAliases != null ? this._deviceAliases.size() : 0;
    }

    public Collection<FcPortAlias> getDeviceAliases() {
        if (this._deviceAliases == null || this._deviceAliases.size() == 0) {
            this._deviceAliases = new ArrayList<FcPortAlias>(this._deviceAliasByWwn.values());
            for (FcPortAlias da : this._deviceAliasByWwn.values()) {
                this._deviceAliases.add(da);
            }
        }
        return this._deviceAliases;
    }

    public int getNumClusters() {
        return this._clusters != null ? this._clusters.size() : 0;
    }

    public Collection<ClusterBase> getClusters() {
        return this._clusters;
    }

    public int getNumIsls() {
        return this._isls != null ? this._isls.size() : 0;
    }

    public Collection<IslBase> getIsls() {
        return this._isls;
    }

    public int getNumNpvLinks() {
        return this._npvLinks != null ? this._npvLinks.size() : 0;
    }

    public Collection<NpvLinkBase> getNpvLinks() {
        return this._npvLinks;
    }

    public int getNumEndPorts() {
        return this._endports != null ? this._endports.size() : 0;
    }

    public Collection<EndPortBase> getEndPorts() {
        return this._endports;
    }

    public Collection<FcPortBase> getFcPorts() {
        return this._fcports;
    }

    public FabricBase getScopedFabric(short[] vsanScope) {
        if (vsanScope == null) {
            return this;
        }
        FabricBase scopedFabric = new FabricBase(this);
        scopedFabric._vsans = new ArrayList<VsanBase>(this._vsans.size());
        for (VsanBase v : this._vsans) {
            if (!FabricBase.inScope(vsanScope, v)) continue;
            scopedFabric._vsans.add(v);
        }
        scopedFabric._switches = new ArrayList<SwitchBase>(this._switches.size());
        for (SwitchBase sw : this._switches) {
            if (!FabricBase.inScope(vsanScope, sw)) continue;
            scopedFabric._switches.add(sw);
        }
        scopedFabric._cfsRegions = new ArrayList<CfsRegion>(this._cfsRegions.size());
        for (SwitchBase sw : this._switches) {
            if (!FabricBase.inScope(vsanScope, sw)) continue;
            ArrayList<Integer> regionIds = sw.getCfsRegionIds();
            for (Integer regionId : regionIds) {
                int rId = regionId;
                scopedFabric._cfsRegions.add(new CfsRegion(this.getPK(), rId));
            }
        }
        scopedFabric._isls = new ArrayList<IslBase>(this._isls.size() / 2);
        for (IslBase isl : this._isls) {
            if (!FabricBase.inScope(vsanScope, isl)) continue;
            scopedFabric._isls.add(isl);
        }
        scopedFabric._endports = new ArrayList<EndPortBase>(this._endports.size());
        for (EndPortBase ep : this._endports) {
            if (!FabricBase.inScope(vsanScope, ep)) continue;
            scopedFabric._endports.add(ep);
        }
        scopedFabric._fcports = new ArrayList<FcPortBase>(this._fcports.size());
        for (FcPortBase fcp : this._fcports) {
            if (!FabricBase.inScope(vsanScope, fcp)) continue;
            scopedFabric._fcports.add(fcp);
        }
        scopedFabric._npvLinks = new ArrayList<NpvLinkBase>(this._npvLinks.size());
        for (NpvLinkBase npl : this._npvLinks) {
            if (!FabricBase.inScope(vsanScope, npl)) continue;
            scopedFabric._npvLinks.add(npl);
        }
        return scopedFabric;
    }

    public FabricBase getScopedFabric(GroupBase group) {
        if (group == null) {
            return this;
        }
        return this;
    }

    public static boolean inScope(short[] vsanScope, VsanBase v) {
        return FabricBase.inScope(vsanScope, v.getVsanPK());
    }

    public static boolean inScope(short[] vsanScope, VsanPK vkey) {
        return vsanScope == null ? true : Arrays.binarySearch(vsanScope, vkey._id) >= 0;
    }

    public static boolean inScope(short[] vsanScope, SwitchBase sw) {
        return vsanScope == null ? true : FabricBase.inScope(vsanScope, sw.getVsanIds());
    }

    public static boolean inScope(short[] vsanScope, IslBase isl) {
        return vsanScope == null ? true : FabricBase.inScope(vsanScope, isl.getVsanIds());
    }

    public static boolean inScope(short[] vsanScope, short[] vids) {
        if (vids == null) {
            return false;
        }
        for (int i = 0; i < vids.length; ++i) {
            if (Arrays.binarySearch(vsanScope, vids[i]) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean inScope(short[] vsanScope, EndPortBase ep) {
        return vsanScope == null ? true : FabricBase.inScope(vsanScope, ep.getVsanMembership());
    }

    public static boolean inScope(short[] vsanScope, FcPortBase fcp) {
        return vsanScope == null ? true : FabricBase.inScope(vsanScope, fcp.getVsanMembership());
    }

    public static boolean inScope(short[] vsanScope, NpvLinkBase npl) {
        return vsanScope == null ? true : FabricBase.inScope(vsanScope, npl.getVsanIds());
    }

    public int getDeviceAlliasCount() {
        return this._deviceAliasByWwn != null ? this._deviceAliasByWwn.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FcPortAlias[] getDeviceAliasesByName() {
        ConcurrentHashMap<String, ConcurrentHashMap<Integer, FcPortAlias>> concurrentHashMap = this._deviceAliasByName;
        synchronized (concurrentHashMap) {
            return this._deviceAliasByName.values().toArray(new FcPortAlias[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FcPortAlias[] getDeviceAliasesByWwn() {
        ConcurrentHashMap<Wwn, FcPortAlias> concurrentHashMap = this._deviceAliasByWwn;
        synchronized (concurrentHashMap) {
            return this._deviceAliasByWwn.values().toArray(new FcPortAlias[0]);
        }
    }

    public ArrayList<String> getDeviceAliasNames() {
        return this.getDeviceAliasNames(-1);
    }

    public ArrayList<String> getDeviceAliasNames(int regionId) {
        ArrayList<String> aliasList = new ArrayList<String>();
        for (FcPortAlias da : this._deviceAliasByWwn.values()) {
            if (da.getCfsRegionId() != regionId) continue;
            aliasList.add(da.getAlias());
        }
        return aliasList;
    }

    public ArrayList<FcPortAlias> getDeviceAliases(int regionId) {
        ArrayList<FcPortAlias> aliasList = new ArrayList<FcPortAlias>();
        for (FcPortAlias da : this._deviceAliasByWwn.values()) {
            if (da.getCfsRegionId() != regionId) continue;
            aliasList.add(da);
        }
        return aliasList;
    }

    public void removeDeviceAlias(String alias) {
        this._deviceAliasByName.remove(alias);
    }

    public void removeDeviceAlias(String alias, int regionId) {
        if (alias == null) {
            return;
        }
        ConcurrentHashMap<Integer, FcPortAlias> aliasByCfsId = this._deviceAliasByName.get(alias);
        if (aliasByCfsId != null) {
            aliasByCfsId.remove(regionId);
        }
    }

    public FcPortAlias getDeviceAlias(String alias) {
        return this.getDeviceAlias(alias, -1);
    }

    public FcPortAlias getDeviceAlias(String alias, int cfsRegionId) {
        if (alias == null) {
            return null;
        }
        ConcurrentHashMap<Integer, FcPortAlias> aliasByCfsId = this._deviceAliasByName.get(alias);
        if (aliasByCfsId != null) {
            return aliasByCfsId.get(cfsRegionId);
        }
        return null;
    }

    public void removeDeviceAliasWwn(Wwn alias) {
        this._deviceAliasByWwn.remove(alias);
    }

    public FcPortAlias getDeviceAliasWwn(Wwn alias) {
        return this._deviceAliasByWwn.get(alias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FcPortAlias createDeviceAlias(Wwn pwwn, String alias, int cfsRegionId) {
        FcPortAlias da;
        ConcurrentHashMap<String, ConcurrentHashMap<Integer, FcPortAlias>> concurrentHashMap = this._deviceAliasByName;
        synchronized (concurrentHashMap) {
            ConcurrentHashMap<Integer, FcPortAlias> aliasByCfsId = this._deviceAliasByName.get(alias);
            if (aliasByCfsId == null) {
                aliasByCfsId = new ConcurrentHashMap();
                da = new FcPortAlias(alias, pwwn, cfsRegionId);
                aliasByCfsId.put(cfsRegionId, da);
                this._deviceAliasByName.put(alias, aliasByCfsId);
                this._deviceAliasByWwn.put(pwwn, da);
            } else {
                da = aliasByCfsId.get(cfsRegionId);
                if (da == null) {
                    da = new FcPortAlias(alias, pwwn, cfsRegionId);
                    aliasByCfsId.put(cfsRegionId, da);
                    this._deviceAliasByName.put(alias, aliasByCfsId);
                    this._deviceAliasByWwn.put(pwwn, da);
                } else if (!da.getWwn().equals(pwwn)) {
                    this._deviceAliasByWwn.remove(da.getWwn());
                    da.setWwn(pwwn);
                    this._deviceAliasByWwn.put(pwwn, da);
                }
            }
        }
        return da;
    }

    public HashMap<PKIf, PKIf> getCoexistSwitchPKs() {
        return this._coexistSwPKs;
    }

    public void setCoexistSwitchPKs(HashMap<PKIf, PKIf> coexistSwPKs) {
        this._coexistSwPKs = coexistSwPKs;
    }

    public String getIncludedVsanList() {
        return this._includedVsanList;
    }

    public void setIncludedVsanList(String includedVsanList) {
        this._includedVsanList = includedVsanList;
    }

    public String getExcludedVsanList() {
        return this._excludedVsanList;
    }

    public void setExcludedVsanList(String excludedVsanList) {
        this._excludedVsanList = excludedVsanList;
    }

    public boolean isVsanScoped() {
        return this._includedVsanList != null && !this._includedVsanList.equals("") || this._excludedVsanList != null && !this._excludedVsanList.equals("");
    }
}

