/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.common.model.InventoryComponent;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.WwnKey;

public class Hba
extends InventoryComponent {
    static final long serialVersionUID = 1L;
    private WwnKey _pkey;
    private Wwn _nwwn;
    private String _manufacturer;
    private String _sn;
    private String _model;
    private String _modelDescr;
    private String _hwVer;
    private String _drVer;
    private String _optRomVer;
    private String _fmVer;

    public Hba(Wwn hwwn, Wwn nwwn, String vendor, String sn, String model, String modelDescr, String hwVer, String drVer, String romVer, String fmVer) {
        this._pkey = new WwnKey(hwwn);
        this._nwwn = nwwn;
        this._manufacturer = vendor;
        this._sn = sn;
        this._model = model;
        this._modelDescr = modelDescr;
        this._hwVer = hwVer;
        this._drVer = drVer;
        this._optRomVer = romVer;
        this._fmVer = fmVer;
        this._changeFlags = (byte)(this._changeFlags | 2);
        this.updateLastScanTime();
    }

    public boolean update(Wwn nwwn, String vendor, String sn, String model, String modelDescr, String hwVer, String drVer, String romVer, String fmVer) {
        this.updateLastScanTime();
        if (!this._nwwn.equals(nwwn)) {
            this._nwwn = nwwn;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (vendor != null && !vendor.equals(this._manufacturer)) {
            this._manufacturer = vendor;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (sn != null && !sn.equals(this._sn)) {
            this._sn = sn;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (model != null && !model.equals(this._model)) {
            this._model = model;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (modelDescr != null && !modelDescr.equals(this._modelDescr)) {
            this._modelDescr = modelDescr;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (hwVer != null && !hwVer.equals(this._hwVer)) {
            this._hwVer = hwVer;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (drVer != null && !drVer.equals(this._drVer)) {
            this._drVer = drVer;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (romVer != null && !romVer.equals(this._optRomVer)) {
            this._optRomVer = romVer;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        if (fmVer != null && !fmVer.equals(this._fmVer)) {
            this._fmVer = fmVer;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
        return (this._changeFlags & 1) != 0;
    }

    @Override
    public PKIf getPK() {
        return this._pkey;
    }

    public Wwn getHbaWwn() {
        return this._pkey._wwn;
    }

    public Wwn getNodeWwn() {
        return this._nwwn;
    }

    public String getManufacturer() {
        return this._manufacturer;
    }

    public String getSerialNumber() {
        return this._sn;
    }

    public String getModel() {
        return this._model;
    }

    public String getModelDescription() {
        return this._modelDescr;
    }

    public String getHardwareVersion() {
        return this._hwVer;
    }

    public String getDriverVersion() {
        return this._drVer;
    }

    public String getRomVersion() {
        return this._optRomVer;
    }

    public String getFirmwareVersion() {
        return this._fmVer;
    }

    @Override
    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (x == null || !(x instanceof Hba)) {
            return false;
        }
        return ((Hba)x)._pkey.equals(this._pkey);
    }

    @Override
    public int compare(Object o1, Object o2) {
        return ((Hba)o1).compareTo(o2);
    }

    @Override
    public int compareTo(Object x) {
        return this._pkey.compareTo(((Hba)x)._pkey);
    }

    public String toString() {
        return new StringBuffer("HBA WWN: ").append(this._pkey._wwn).append("\nNode WWN: ").append(this._nwwn).append("\nManufacturer: ").append(this._manufacturer).append("\nSerial number: ").append(this._sn).append("\nModel: ").append(this._model).append("\nModel description: ").append(this._modelDescr).append("\nHardware version: ").append(this._hwVer).append("\nDriver version: ").append(this._drVer).append("\nOption ROM version: ").append(this._optRomVer).append("\nFirmware version: ").append(this._fmVer).toString();
    }
}

