/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.util.IntPair;
import com.cisco.dcbu.sm.common.dto.PCMemberTrustSec;
import com.cisco.dcbu.sm.common.model.AbstractFcLinkBase;
import com.cisco.dcbu.sm.common.model.IslIf;
import com.cisco.dcbu.sm.common.type.IslPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IslBase
extends AbstractFcLinkBase<IslPK>
implements IslIf<IslPK> {
    static final long serialVersionUID = 1L;
    public static final short ISL_ATTR = 1280;
    public static final short ATTR_ISPRESENT = 1281;
    public static final short ATTR_OPERMODE = 1282;
    public static final short ATTR_OPERSTATUSCAUSE = 1283;
    public static final short ATTR_VSANMEMBERSHIP = 1284;
    public static final short ATTR_AUTOCREATED = 1285;
    public static final short ATTR_CONFCHILDCOUNT = 1286;
    public static final short ATTR_CHILDREN = 1287;
    public static final short ATTR_SPEED = 1288;
    public static final short ATTR_FICONADDRS = 1289;
    public static final short ATTR_CONNTYPE = 1290;
    public static final short ATTR_VLANMEMBERSHIP = 1291;
    public static final short ATTR_FCSPAUTHEN = 1292;
    public static final short ATTR_ESPSECURE = 1293;
    public static final short ATTR_ESPREADY = 1294;
    public static final short ATTR_PCMTRUSTSEC = 1295;
    public static final short ATTR_NATIVEVLAN = 1296;
    public static final short ATTR_FABRIC = 1297;
    public static final short ATTR_CHANNEL = 1298;
    public static final short ATTR_ACCESSVLAN = 1299;
    public static final short ATTR_VLANTRUNK = 1300;
    public static final String[] _Attrs = new String[]{"isPresent", "operMode", "operStatusCause", "vsans", "autoCreated", "configChildCount", "members", "speed", "FICONAddrs", "connectorType", "vlans", "fcspAuthenticated", "espSecured", "espReady", "pcmtrustsec", "nativeVlan", "fabric", "channel", "accessVlan", "vlanTrunk"};
    protected int _ficonAddrs = -1;
    protected boolean _autoCreated;
    protected short _configChildCount;
    protected Set<IntPair> _children = new HashSet<IntPair>();
    protected Map<IntPair, PCMemberTrustSec> _trustSecByIfIndex;
    protected boolean _fcspAuthenticated;
    protected boolean _espSecured;
    protected boolean _espReady;

    public IslBase(WwnKey sw1, WwnKey sw2, int ifindex1, int ifindex2) {
        super(new IslPK(sw1, sw2, ifindex1, ifindex2));
        this._vsanIds = Collections.synchronizedList(new ArrayList(4));
        this._trustSecByIfIndex = Collections.synchronizedMap(new HashMap());
    }

    public IslBase(IslPK pkey) {
        super(pkey);
        this._vsanIds = Collections.synchronizedList(new ArrayList(4));
        this._trustSecByIfIndex = Collections.synchronizedMap(new HashMap());
    }

    public void sync(IslBase isl) {
        if (isl == null) {
            throw new IllegalArgumentException("Invalid Isl:" + isl);
        }
        super.sync(isl);
        this._operMode = isl._operMode;
        this._autoCreated = isl._autoCreated;
        this._configChildCount = isl._configChildCount;
        this._children.clear();
        this._children.addAll(isl.getPcMembers());
        this._trustSecByIfIndex = isl._trustSecByIfIndex;
    }

    @Override
    public IslPK getIslPK() {
        return (IslPK)this._pkey;
    }

    @Override
    public WwnKey getSwitch1PK() {
        return ((IslPK)this._pkey)._p1.getSwitchKey();
    }

    @Override
    public WwnKey getSwitch2PK() {
        return ((IslPK)this._pkey)._p2._swPK;
    }

    @Override
    public int getIfIndex1() {
        return ((IslPK)this._pkey)._p1._index;
    }

    @Override
    public int getIfIndex2() {
        return ((IslPK)this._pkey)._p2._index;
    }

    public int getFiconAddress1() {
        return this._ficonAddrs >> 16 & 0xFFFF;
    }

    public int getFiconAddress2() {
        return this._ficonAddrs & 0xFFFF;
    }

    public void setFiconAddress(int ifIndex, int ficonAddr) {
        if (((IslPK)this._pkey)._p1._index == ifIndex) {
            this._ficonAddrs = (ficonAddr << 16) + (this._ficonAddrs & 0xFFFF);
        } else if (((IslPK)this._pkey)._p2._index == ifIndex) {
            this._ficonAddrs = (this._ficonAddrs & 0xFFFF0000) + ficonAddr;
        }
    }

    public int getFiconAddresses() {
        return this._ficonAddrs;
    }

    public void setFiconAddresses(int ficonAddrs) {
        this._ficonAddrs = ficonAddrs;
    }

    public WwnKey getNbrSwitchPK(WwnKey swPK) {
        if (swPK.equals(this.getSwitch1PK())) {
            return this.getSwitch2PK();
        }
        if (swPK.equals(this.getSwitch2PK())) {
            return this.getSwitch1PK();
        }
        return null;
    }

    public boolean isAutoCreated() {
        return this._autoCreated;
    }

    public void setAutoCreated(boolean autoCreated) {
        this._autoCreated = autoCreated;
    }

    public List<IntPair> getPcMembers() {
        ArrayList<IntPair> ret = new ArrayList<IntPair>(this._children.size());
        ret.addAll(this._children);
        Collections.sort(ret);
        return ret;
    }

    public void setPcMembers(Collection<IntPair> children) {
        if (children == null) {
            return;
        }
        this._children.clear();
        this._children.addAll(children);
    }

    public boolean containPcMember(IntPair child) {
        if (child == null) {
            return false;
        }
        return this._children.contains(child);
    }

    @Override
    public List<int[]> getChildren() {
        ArrayList<int[]> ret = new ArrayList<int[]>(this._children.size());
        for (IntPair p : this._children) {
            ret.add(p._pair);
        }
        return ret;
    }

    public void setChildren(List<int[]> children) {
        if (children == null) {
            return;
        }
        this._children.clear();
        for (int[] p : children) {
            if (p.length != 2) continue;
            this._children.add(new IntPair(p));
        }
    }

    public boolean containChild(int[] childPair) {
        if (childPair == null) {
            return false;
        }
        return this._children.contains(new IntPair(childPair));
    }

    @Override
    public int getChildCount() {
        return this._children == null ? 0 : this._children.size();
    }

    public short getConfigChildCount() {
        return this._configChildCount;
    }

    public void setConfigChildCount(short count) {
        this._configChildCount = count;
    }

    public PCMemberTrustSec findTrustSecs(int[] ifIndexpair) {
        IntPair pair = new IntPair(ifIndexpair);
        return this._trustSecByIfIndex.get(pair);
    }

    public void addTrustSec(int[] ifIndexpair, PCMemberTrustSec trustSec) {
        IntPair pair = new IntPair(ifIndexpair);
        this._trustSecByIfIndex.put(pair, trustSec);
    }

    public void updateTrustSec(PCMemberTrustSec fa, boolean[] trustSec) {
        fa.setTrustSec(trustSec);
        IntPair pair = new IntPair(fa.getIfIndexPair());
        this._trustSecByIfIndex.put(pair, fa);
    }

    public PCMemberTrustSec removeTrustSecs(int[] ifIndexpair) {
        PCMemberTrustSec trustSecs = this._trustSecByIfIndex.remove(ifIndexpair);
        return trustSecs;
    }

    public int getNumPCMembers() {
        if (this._children != null) {
            return this._children.size() * 2;
        }
        return 0;
    }

    public boolean isDWDM() {
        return this.getFcConnectorType() == 18 || this.getFcConnectorType() == 20;
    }

    public String getName() {
        return this.getSwitch1PK().toString() + ',' + this.getIfIndex1() + " <-> " + this.getSwitch2PK().toString() + ',' + this.getIfIndex2();
    }

    @Override
    public boolean isMinorAlarm() {
        return this._isPresent && (this._operStatusCause == 108 || this.hasPCdegraded());
    }

    public boolean hasPCdegraded() {
        return this._configChildCount > 0 && this._configChildCount != this.getChildCount();
    }

    public boolean getEspReady() {
        return this._espReady;
    }

    public void setEspReady(boolean espReady) {
        this._espReady = espReady;
    }

    public boolean getEspSecure() {
        return this._espSecured;
    }

    public void setEspSecure(boolean espSecured) {
        this._espSecured = espSecured;
    }

    public boolean getFcspAuthenticated() {
        return this._fcspAuthenticated;
    }

    public void setFcspAuthenticated(boolean fspAuthenticated) {
        this._fcspAuthenticated = fspAuthenticated;
    }

    @Override
    public boolean isIsl() {
        return true;
    }

    @Override
    public boolean isEdgeLink() {
        return false;
    }

    @Override
    public boolean isNpvLink() {
        return false;
    }

    @Override
    public boolean isTrunk() {
        return this._operMode == 12 || this.getNumVsans() > 1;
    }

    @Override
    public boolean isPortChannel() {
        return WwnDictionary.isCiscoWwn(this.getSwitch1PK()._wwn.getValue()) && WwnDictionary.isCiscoWwn(this.getSwitch2PK()._wwn.getValue()) && IfIndexUtil.getType(this.getIfIndex1()) == 4 && IfIndexUtil.getType(this.getIfIndex2()) == 4;
    }
}

