/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.sm.common.model.InventoryComponent;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.PortPK;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.WwnKey;

public class PhysPort
extends InventoryComponent {
    static final long serialVersionUID = 1L;
    public final PortPK _pkey;
    private int _type;

    public PhysPort(SwitchIntKey cardPK, int portId, int type) {
        this(new PortPK(cardPK, portId), type);
    }

    public PhysPort(PortPK portPK, int type) {
        this._pkey = portPK;
        this.update(type);
    }

    public void update(int type) {
        this.updateLastScanTime();
        if (this._type != type) {
            this._type = type;
            this._changeFlags = (byte)(this._changeFlags | 3);
        }
    }

    @Override
    public PKIf getPK() {
        return this._pkey;
    }

    public PortPK getPortPK() {
        return this._pkey;
    }

    public WwnKey getSwitchPK() {
        return this._pkey._cardPK._swPK;
    }

    public int getSlotId() {
        return this._pkey._cardPK._index + 1;
    }

    public int getPortId() {
        return this._pkey._portId;
    }

    public int getType() {
        return this._type;
    }

    public String getName() {
        return "Linecard-" + this.getSlotId() + " Port-" + this._pkey._portId;
    }

    @Override
    public boolean equals(Object x) {
        return true;
    }

    @Override
    public int compare(Object o1, Object o2) {
        return this._pkey.compare(((PhysPort)o1)._pkey, ((PhysPort)o2)._pkey);
    }
}

