/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SysUpTimeIf;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.DumpIf;
import com.cisco.dcbu.sm.common.model.EthSwitchBase;
import com.cisco.dcbu.sm.common.type.MacAddress;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.VdcPK;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import java.net.InetAddress;

public class VdcBase
extends EthSwitchBase<VdcPK>
implements SysUpTimeIf,
DumpIf {
    private static final long serialVersionUID = 1L;
    public static final short VDC_FCOE_DISALLOWED = 1;
    public static final short VDC_FCOE_ALLOWED = 2;
    public static final short VDC_FCOE_INSTALLED = 3;
    public static final String[] VDC_FCOE_Names = new String[]{"disallowed", "allowed", "installed"};
    protected MacAddress _parentMacAddr;

    public VdcBase(SerialNumKey chassisKey, MacAddress macAddr, int vdcId, InetAddress vdcIP) {
        this(new VdcPK(chassisKey, macAddr, vdcId), vdcIP);
    }

    public VdcBase(VdcPK vdcPK, InetAddress vdcIP) {
        super(vdcPK, vdcIP);
        this._isVdc = true;
    }

    public void sync(VdcBase vdc) {
        super.sync(vdc);
        this._parentMacAddr = vdc._parentMacAddr;
        this._fcoeCapability = vdc._fcoeCapability;
    }

    @Override
    public boolean isVdcObject() {
        return true;
    }

    @Override
    public boolean allowDiscoverMoreOnFC() {
        return this.isFcoeEnabled();
    }

    @Override
    public boolean allowDiscoverMoreOnCDP() {
        return false;
    }

    @Override
    public void setChassisKey(SerialNumKey snKey) {
        if (snKey != null) {
            super.setChassisKey(snKey);
            ((VdcPK)this._pkey)._chassisKey = snKey;
        }
    }

    @Override
    public SerialNumKey getChassisKey() {
        return ((VdcPK)this._pkey)._chassisKey;
    }

    @Override
    public int ifIndex2Card(int ifIndex) {
        return IfIndexUtil.ifIndex2Card(ifIndex);
    }

    @Override
    public int ifIndex2Port(int ifIndex) {
        return IfIndexUtil.ifIndex2Port(ifIndex);
    }

    @Override
    public String ifTypeToifName(int ifType) {
        return IfIndexUtil.ifTypeToifName(ifType);
    }

    @Override
    public int getType(int ifIndex) {
        return IfIndexUtil.getType(ifIndex);
    }

    @Override
    public int getActualType(int type) {
        return type;
    }

    @Override
    public boolean isN5KVerLT503() {
        return false;
    }

    @Override
    public boolean isPortRangeSupport() {
        return true;
    }

    @Override
    public int nameToIfIndex(int card, int port, int type) {
        return IfIndexUtil.nameToIfIndex(card, port, type);
    }

    @Override
    public int nameToIfIndex(String ifName) {
        try {
            if (this.isN7K()) {
                String tmpifName = ifName.toLowerCase();
                if (tmpifName.startsWith("eth") && !tmpifName.startsWith("eth-")) {
                    int tmpIfIndex = IfIndexUtil.nameToIfIndex(ifName);
                    int slot = IfIndexUtil.getIfIndexCard(tmpIfIndex);
                    Card card = InventoryManager.getInstance().findCard((PKIf)this.getSwitchPK(), slot);
                    if (card != null && card.isAutodromoCard()) {
                        if (card.isAuto100()) {
                            return IfIndexUtil.nameToIfIndexForAutodromo(ifName, 10);
                        }
                        return IfIndexUtil.nameToIfIndexForAutodromo(ifName, 4);
                    }
                    return IfIndexUtil.nameToIfIndex(ifName);
                }
                if (tmpifName.startsWith("vlan")) {
                    int vdcId = this.getVdcPK()._id;
                    return IfIndexUtil.nameToIfIndex(ifName, false, vdcId);
                }
                return IfIndexUtil.nameToIfIndex(ifName);
            }
            return IfIndexUtil.nameToIfIndex(ifName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public VdcPK getVdcPK() {
        return (VdcPK)this._pkey;
    }

    @Override
    public boolean isVdc() {
        return true;
    }

    public MacAddress getParentMacAddress() {
        return this._parentMacAddr;
    }

    public void setParentKey(MacAddress parentMac) {
        this._parentMacAddr = parentMac;
    }

    @Override
    public boolean isDefaultVdc() {
        return ((VdcPK)this._pkey)._id == 1;
    }

    public boolean isFCoEAllowed() {
        return this._fcoeCapability == 2;
    }

    @Override
    public String indent(int level) {
        if (level < 0) {
            return LIL[0];
        }
        if (level >= LIL.length) {
            return LIL[LIL.length - 1];
        }
        return LIL[level];
    }

    @Override
    public String dump(boolean inDetail, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.dump(inDetail, level));
        StringBuilder vdcSb = new StringBuilder();
        vdcSb.append("VdcPK=").append(this.getVdcPK().getFullString()).append(", DefaultVdc: ").append(this.isDefaultVdc()).append(", ChassisMac:").append(this._parentMacAddr);
        if (this._fcoeCapability >= 1 && this._fcoeCapability <= 3) {
            vdcSb.append(", VdcFCoECapability: ").append(VDC_FCOE_Names[this._fcoeCapability - 1]);
        }
        vdcSb.append(this.indent(level + 1));
        int pos = sb.indexOf("SysUpTime");
        if (pos > 0) {
            sb.insert(pos, vdcSb.toString());
        } else {
            sb.append(vdcSb.toString());
        }
        return sb.toString();
    }

    @Override
    public String print(boolean inDetail, boolean withDecor) {
        StringBuilder sb = new StringBuilder();
        if (withDecor) {
            sb.append("VDC").append("@").append(this.getIpAddress());
        } else {
            sb.append(this.getIpAddress());
        }
        if (inDetail && inDetail) {
            sb.append("[PK=" + this.getVdcPK().getFullString()).append(", defaultVdc=").append(this.isDefaultVdc()).append(", chassisMac=").append(this._parentMacAddr);
            if (this._fcoeCapability >= 1 && this._fcoeCapability <= 3) {
                sb.append(", vdcFCoECapability=").append(VDC_FCOE_Names[this._fcoeCapability - 1]);
            }
            this.printDetails(sb);
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

