/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.model.ioa;

import com.cisco.dcbu.sm.common.model.LicenseInfo;
import com.cisco.dcbu.sm.common.model.ioa.IOALicense;
import java.io.Serializable;
import java.util.ArrayList;

public class Switch
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long fabricId;
    private String name;
    private String wwn;
    private String ipAddress;
    private String siteName;
    private IOALicense license;
    private boolean switchCommUseIp = true;
    private boolean isMaster = false;
    private String version;
    private ArrayList<LicenseInfo> licenseList;

    public Switch() {
    }

    public Switch(long fabricId, String name, String wwn) {
        this.fabricId = fabricId;
        this.wwn = wwn;
        this.name = name;
    }

    public String getWwn() {
        if (this.wwn == null) {
            return "";
        }
        return this.wwn;
    }

    public void setWwn(String wwn) {
        this.wwn = wwn;
    }

    public long getFabricId() {
        return this.fabricId;
    }

    public void setFabricId(long fabricId) {
        this.fabricId = fabricId;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void setName(String switchName) {
        this.name = switchName;
    }

    public String getIpAddress() {
        if (this.ipAddress == null) {
            return "";
        }
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getSiteName() {
        if (this.siteName == null) {
            return "";
        }
        return this.siteName;
    }

    public String toString() {
        return this.name;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public boolean equals(Object o) {
        if (o instanceof Switch) {
            Switch s = (Switch)o;
            if (this.getIpAddress().equals(s.getIpAddress()) && this.getName().equals(s.getName())) {
                return true;
            }
        }
        return false;
    }

    public boolean isSwitchCommUseIp() {
        return this.switchCommUseIp;
    }

    public void setSwitchCommUseIp(boolean switchCommUseIp) {
        this.switchCommUseIp = switchCommUseIp;
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public void setMaster(boolean isMaster) {
        this.isMaster = isMaster;
    }

    public IOALicense getLicense() {
        if (this.license == null) {
            return new IOALicense(0);
        }
        return this.license;
    }

    public void setLicense(IOALicense license) {
        this.license = license;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean versionSupportsIOA() {
        if (this.version == null) {
            return false;
        }
        if (this.version.length() < 3) {
            return false;
        }
        try {
            String primaryCh = this.version.substring(0, 1);
            String secondaryCh = this.version.substring(2, 3);
            int primary = Integer.valueOf(primaryCh);
            if (primary < 4) {
                return false;
            }
            int secondary = Integer.valueOf(secondaryCh);
            return primary != 4 || secondary >= 2;
        }
        catch (StringIndexOutOfBoundsException e) {
            return false;
        }
    }

    public void setLicenseList(ArrayList<LicenseInfo> licenses) {
        this.licenseList = licenses;
    }

    public ArrayList<LicenseInfo> getLicenseList() {
        return this.licenseList;
    }

    public String getLicenseDisplay() {
        if (this.licenseList == null) {
            return "None";
        }
        LicenseInfo disp = null;
        for (LicenseInfo l : this.licenseList) {
            if (l.isPermanent()) {
                if (disp != null) continue;
                disp = l;
                continue;
            }
            if (!l.isCheckedout()) continue;
            if (disp == null) {
                disp = l;
                continue;
            }
            if (disp.timeLeft() <= l.timeLeft()) continue;
            disp = l;
        }
        if (disp == null) {
            return "None";
        }
        return disp.toString();
    }

    public LicenseInfo getDiplayLicense() {
        if (this.licenseList == null) {
            return null;
        }
        LicenseInfo ret = null;
        for (LicenseInfo l : this.licenseList) {
            if (l.isPermanent()) {
                if (ret != null) continue;
                ret = l;
                continue;
            }
            if (!l.isCheckedout()) continue;
            if (ret == null) {
                ret = l;
                continue;
            }
            if (ret.timeLeft() <= l.timeLeft()) continue;
            ret = l;
        }
        return ret;
    }

    public LicenseInfo getBestAvailableLicense() {
        if (this.licenseList == null) {
            return null;
        }
        LicenseInfo ret = null;
        for (LicenseInfo l : this.licenseList) {
            if (l.isPermanent()) {
                return l;
            }
            if (!l.canCheckout()) continue;
            if (ret == null) {
                ret = l;
                continue;
            }
            if (ret.timeLeft() >= l.timeLeft()) continue;
            ret = l;
        }
        return ret;
    }

    public static String getLicenseString(LicenseInfo l) {
        StringBuffer sb = new StringBuffer();
        if (l == null) {
            return "None";
        }
        if (l.isDemo() || l.isTemp()) {
            sb.append("Demo License ");
            if (l.getExpDate() != null) {
                sb.append("Expires on ").append(l.getExpDate().getTime());
            } else {
                sb.append("Expired");
            }
        }
        if (l.isTemp()) {
            sb.append("Eval License ");
            if (l.getExpDate() != null) {
                sb.append("Expires on ").append(l.getExpDate().getTime());
            } else {
                sb.append("Expired");
            }
        }
        if (l.isPermanent()) {
            sb.append("Permanent License ");
        }
        if (l.isEval()) {
            sb.append("Eval License ");
        }
        if ((l.getFlags() & 8) != 0) {
            int left = l.getGracePeriod();
            if (left <= 0) {
                sb.append("Grace Period Expired");
            } else {
                sb.append("Grace Period: ");
                int secs = left % 60;
                int mins = left / 60;
                int hours = mins / 60;
                int days = hours / 24;
                sb.append(days > 0 ? days + " days " : "").append(hours > 0 ? (hours %= 24) + " hours " : "").append(mins > 0 ? (mins %= 60) + " mins " : "").append(secs > 0 ? secs + " seconds " : "");
            }
        }
        return sb.toString();
    }
}

