/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.pm;

import com.cisco.dcbu.sm.common.model.PmPolicyBase;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.EthIslImpl;
import com.cisco.dcbu.sm.server.model.EthPortImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.pm.PmCollect;
import com.cisco.dcbu.sm.server.pm.PmMetaDataUtil;
import java.io.Serializable;

public class PmEventDef
implements Serializable {
    static final long serialVersionUID = 1L;
    public PmPolicyBase[] _pps;
    public static final int ISL_ADDED = 1;
    public static final int ISL_UP = 2;
    public static final int ISL_DOWN = 3;
    public static final int HOST_ADDED = 4;
    public static final int HOST_UP = 5;
    public static final int HOST_DOWN = 6;
    public static final int STORAGE_ADDED = 7;
    public static final int STORAGE_UP = 8;
    public static final int STORAGE_DOWN = 9;
    public static final int ETHISL_ADDED = 10;
    public static final int ETHISL_UP = 11;
    public static final int ETHISL_DOWN = 12;
    public static final int ETHINTF_ADDED = 13;
    public static final int ETHINTF_UP = 14;
    public static final int ETHINTF_DOWN = 15;

    public PmEventDef(PmPolicyBase[] pps) {
        this._pps = pps;
    }

    public boolean isMonitoring(LanImpl fImpl, EthIslImpl isl) {
        boolean ret = false;
        if (PmCollect.getMetaData()._collectLanISL) {
            EthSwitchImpl sw1 = isl.getSwitch1();
            long dbId1 = sw1.getDBID();
            ret = PmMetaDataUtil.isEthSwitchInCollection(dbId1);
            if (ret) {
                return ret;
            }
            EthSwitchImpl sw2 = isl.getSwitch2();
            long dbId2 = sw2.getDBID();
            ret = PmMetaDataUtil.isEthSwitchInCollection(dbId2);
        }
        return ret;
    }

    public boolean isMonitoring(LanImpl fImpl, EthPortImpl ep) {
        boolean ret = false;
        if (PmCollect.getMetaData()._collectLanFex) {
            EthSwitchImpl sw = ep.getSwitch();
            long dbId = sw.getDBID();
            ret = PmMetaDataUtil.isEthSwitchInCollection(dbId);
        }
        return ret;
    }

    public boolean isMonitoring(FabricImpl fImpl, IslImpl isl) {
        if (this._pps == null) {
            return false;
        }
        for (int i = this._pps.length - 1; i >= 0; --i) {
            if (this._pps[i].getFabricId() != fImpl.getDBID() || !this._pps[i].isMonitoringISL()) continue;
            return true;
        }
        return false;
    }

    public boolean isMonitoring(FabricImpl fImpl, EndPortImpl ep) {
        if (this._pps == null) {
            return false;
        }
        for (int i = this._pps.length - 1; i >= 0; --i) {
            boolean target = ep.isTarget();
            if (this._pps[i].getFabricId() != fImpl.getDBID()) continue;
            if (target && this._pps[i].isMonitoringStorage()) {
                return true;
            }
            if (!this._pps[i].isMonitoringHost()) continue;
            return true;
        }
        return false;
    }
}

