/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.pm;

import java.io.Serializable;

public class PmLinearRegression
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double startFact;
    private double slopeFact;
    private double endValue;

    public PmLinearRegression(double startFact, double slopeFact, long steps) {
        this.startFact = startFact;
        this.slopeFact = slopeFact;
        this.endValue = startFact + this.slopeFact * (double)steps;
    }

    public double getStartFact() {
        return this.startFact;
    }

    public void setStartFact(double startFact) {
        this.startFact = startFact;
    }

    public double getSlopeFact() {
        return this.slopeFact;
    }

    public void setSlopeFact(double slopeFact) {
        this.slopeFact = slopeFact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PmLinearRegression)) {
            return false;
        }
        PmLinearRegression pmLinearRegression = (PmLinearRegression)o;
        if (this.slopeFact != pmLinearRegression.slopeFact) {
            return false;
        }
        return this.startFact == pmLinearRegression.startFact;
    }

    public double getFutureAverage(long secondsFromNow) {
        double futureEndValue = this.endValue + this.slopeFact * (double)secondsFromNow;
        return (this.endValue + Math.max(0.0, futureEndValue)) / 2.0;
    }

    public long getFutureThresholdBreakingPoint(double threshold) {
        if (this.slopeFact == 0.0) {
            if (threshold <= this.endValue) {
                return 0L;
            }
            return Long.MAX_VALUE;
        }
        double x = (threshold - this.endValue) / this.slopeFact;
        return (long)x;
    }

    public double getEndValue() {
        return this.endValue;
    }
}

