/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.topology.dto;

import com.cisco.dcbu.lib.util.ShortArray;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.type.PKIf;
import java.io.Serializable;

public abstract class TopoAbstractDto
implements Serializable {
    public static final int TOOLTIP_LINE_LENGTH = 60;
    protected PKIf pk = null;
    protected String name = null;
    protected boolean majorAlarm = false;
    protected boolean minorAlarm = false;
    protected boolean isPresent = true;
    protected ShortArray vsanIds = null;

    protected TopoAbstractDto(BaseModelObject baseModelObject) {
        if (baseModelObject != null) {
            this.setPK(baseModelObject.getPK());
            this.setPresent(baseModelObject.isPresent());
        }
    }

    public PKIf getPK() {
        return this.pk;
    }

    public void setPK(PKIf pk) {
        this.pk = pk;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMajorAlarm(boolean majorAlarm) {
        this.majorAlarm = majorAlarm;
    }

    public boolean isMajorAlarm() {
        return this.majorAlarm;
    }

    public boolean isMinorAlarm() {
        return this.minorAlarm;
    }

    public void setMinorAlarm(boolean minorAlarm) {
        this.minorAlarm = minorAlarm;
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public void setPresent(boolean isPresent) {
        this.isPresent = isPresent;
    }

    public short[] getVsanIds() {
        if (this.vsanIds == null) {
            return null;
        }
        return this.vsanIds.toArray();
    }

    public void setVsanIds(short[] vsanIds) {
        this.vsanIds = new ShortArray(vsanIds);
        this.vsanIds.sort();
    }

    public void addVsanIds(short[] vsanIds) {
        if (this.vsanIds == null) {
            this.setVsanIds(vsanIds);
            return;
        }
        if (vsanIds != null) {
            this.vsanIds.add(vsanIds);
            this.vsanIds.sort();
        }
    }

    public boolean isMemberOfVsan(short vsanId) {
        return this.vsanIds != null && this.vsanIds.binarySearch(vsanId) >= 0;
    }

    public boolean isMemberOfVsans(short[] vsanIds) {
        if (vsanIds != null) {
            for (int i = 0; i < vsanIds.length; ++i) {
                if (!this.isMemberOfVsan(vsanIds[i])) continue;
                return true;
            }
        }
        return false;
    }
}

