/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.topology.layout;

import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.common.topology.layout.GraphModelIf;
import com.cisco.dcbu.sm.common.topology.layout.GraphNodeIf;
import com.cisco.dcbu.sm.common.topology.layout.ILogGraphIf;
import com.cisco.dcbu.sm.common.topology.layout.ILogLinkIf;
import com.cisco.dcbu.sm.common.topology.layout.ILogNodeIf;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ILogGraph
implements ILogGraphIf,
GraphModelIf {
    private Set<ILogLinkIf> edgeSet = new HashSet<ILogLinkIf>();
    private Set<ILogNodeIf> nodeSet = new HashSet<ILogNodeIf>();
    private List<ILogLinkIf> edgeList = new HashedArrayList<ILogLinkIf>();
    private List<ILogNodeIf> nodeList = new HashedArrayList<ILogNodeIf>();
    private Map<String, String> neighborMap = new HashMap<String, String>();

    @Override
    public Set<ILogLinkIf> edges() {
        return this.edgeSet;
    }

    public ILogLinkIf addLink(ILogLinkIf link) {
        this.edgeSet.add(link);
        this.edgeList.add(link);
        String linkName = link.getSourceNode().getNodeLabel() + "<->" + link.getTargetNode().getNodeLabel();
        this.neighborMap.put(linkName, linkName);
        return link;
    }

    @Override
    public Set<ILogNodeIf> nodes() {
        return this.nodeSet;
    }

    public ILogNodeIf addNode(ILogNodeIf node) {
        this.nodeSet.add(node);
        this.nodeList.add(node);
        return node;
    }

    @Override
    public int getNodeCount() {
        return this.nodeSet.size();
    }

    @Override
    public GraphNodeIf getNodeAt(int index) {
        return (GraphNodeIf)((Object)this.nodeList.get(index));
    }

    @Override
    public int getLinkCount() {
        return this.edgeSet.size();
    }

    @Override
    public boolean isNeighbor(GraphNodeIf n1, GraphNodeIf n2) {
        String linkName = ((ILogNodeIf)((Object)n1)).getNodeLabel() + "<->" + ((ILogNodeIf)((Object)n2)).getNodeLabel();
        if (this.neighborMap.get(linkName) != null) {
            return true;
        }
        linkName = ((ILogNodeIf)((Object)n2)).getNodeLabel() + "<->" + ((ILogNodeIf)((Object)n1)).getNodeLabel();
        return this.neighborMap.get(linkName) != null;
    }
}

