/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.topology.layout;

import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.sm.common.topology.layout.GraphModelIf;
import com.cisco.dcbu.sm.common.topology.layout.ILogGraphIf;
import com.cisco.dcbu.sm.common.topology.layout.ILogNode;
import com.cisco.dcbu.sm.common.topology.layout.ILogNodeIf;
import com.cisco.dcbu.sm.common.topology.layout.LayoutServerIf;
import com.cisco.dcbu.sm.common.topology.layout.Spring;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class SpringHierarchicalLayoutServer
implements LayoutServerIf {
    private int width = 100;
    private int height = 100;
    double switchMinX = 0.0;
    double switchMaxX = 0.0;
    double switchMinY = 0.0;
    double switchMaxY = 0.0;

    @Override
    public void layout(ILogGraphIf topologyGraph, int divideDegree, boolean zero) throws Exception {
        Spring.compute((GraphModelIf)((Object)topologyGraph), this.width, this.height);
    }

    @Override
    public void interrupt() {
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void fitNodesToBounds(ILogGraphIf topologyGraph, int width, int height) {
        height -= 25;
        if ((width -= 150) <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (ILogNodeIf node : topologyGraph.nodes()) {
            if (node == null) continue;
            double x = node.getIconCenterX();
            double y = node.getIconCenterY();
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        double xWidth = maxX - minX;
        double scaleX = 1.0;
        if (xWidth != 0.0) {
            scaleX = (double)width / xWidth;
        }
        double scaleY = 1.0;
        double yHeight = this.switchMaxY - this.switchMinY;
        if (yHeight != 0.0) {
            scaleY = (double)height / yHeight;
        }
        double translateX = minX + xWidth / 2.0;
        double translateY = this.switchMinY + yHeight / 2.0;
        for (ILogNodeIf node : topologyGraph.nodes()) {
            if (node == null) continue;
            if (node.isHost() || node.isStorage()) {
                node.setIconCenter((node.getIconCenterX() - translateX) * scaleX, node.getIconCenterY());
                continue;
            }
            node.setIconCenter((node.getIconCenterX() - translateX) * scaleX, (node.getIconCenterY() - translateY) * scaleY);
        }
    }

    public void fitHostEnclosures(ILogGraphIf topologyGraph, int width, int height, HashedArrayList<ILogNode> srcSwitchList, HashedArrayList<ILogNode> hostEnclosureList) {
        if (hostEnclosureList == null || hostEnclosureList.size() == 0) {
            return;
        }
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        ArrayList<Object> enclosures = new ArrayList();
        int numEnclosure = 0;
        for (ILogNode node : hostEnclosureList) {
            if (node == null || !node.isHost()) continue;
            ++numEnclosure;
            double x = node.getIconCenterX();
            double y = node.getIconCenterY();
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        enclosures = this.reorderListPosition(srcSwitchList, hostEnclosureList);
        double xWidth = maxX - minX;
        double idealX = minX + xWidth / 2.0;
        idealX = this.switchMinX - 50.0;
        double yHeight = maxY - minY;
        double idealY = minY + yHeight / 2.0;
        double yIncrement = height / numEnclosure;
        double minIncrementY = 12.0;
        double maxIncrementY = 48.0;
        if (yIncrement < minIncrementY) {
            yIncrement = minIncrementY;
        } else if (yIncrement > maxIncrementY) {
            yIncrement = maxIncrementY;
        }
        for (int i = 0; i < enclosures.size(); ++i) {
            ILogNodeIf node = (ILogNodeIf)enclosures.get(i);
            node.setIconCenter(idealX, (double)((int)(yIncrement * (double)i)) - yIncrement * (double)(enclosures.size() - 1) / 2.0);
        }
    }

    public void fitStorageEnclosures(ILogGraphIf topologyGraph, int width, int height, HashedArrayList<ILogNode> dstSwitchList, HashedArrayList<ILogNode> storageEnclosureList) {
        if (storageEnclosureList == null || storageEnclosureList.size() == 0) {
            return;
        }
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        ArrayList<Object> enclosures = new ArrayList();
        int numEnclosure = 0;
        for (ILogNode node : storageEnclosureList) {
            if (node == null || !node.isStorage()) continue;
            ++numEnclosure;
            double x = node.getIconCenterX();
            double y = node.getIconCenterY();
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        enclosures = this.reorderListPosition(dstSwitchList, storageEnclosureList);
        double xWidth = maxX - minX;
        double idealX = minX + xWidth / 2.0;
        idealX = this.switchMaxX + 50.0;
        double yHeight = maxY - minY;
        double idealY = minY + yHeight / 2.0;
        double yIncrement = height / numEnclosure;
        double minIncrementY = 12.0;
        double maxIncrementY = 48.0;
        if (yIncrement < minIncrementY) {
            yIncrement = minIncrementY;
        } else if (yIncrement > maxIncrementY) {
            yIncrement = maxIncrementY;
        }
        for (int i = 0; i < enclosures.size(); ++i) {
            ILogNodeIf node = (ILogNodeIf)enclosures.get(i);
            node.setIconCenter(idealX, (double)((int)(yIncrement * (double)i)) - yIncrement * (double)(enclosures.size() - 1) / 2.0);
        }
    }

    private ArrayList<ILogNode> reorderListPosition(List<ILogNode> switchList, List<ILogNode> enclList) {
        int i;
        HashedArrayList hashedEnclList;
        ILogNode enclNode;
        if (switchList.size() > 2) {
            Collections.sort(switchList, new Comparator<ILogNode>(){

                @Override
                public int compare(ILogNode arg0, ILogNode arg1) {
                    if (arg0.getY_cord() == arg1.getY_cord()) {
                        return 0;
                    }
                    if (arg0.getY_cord() > arg1.getY_cord()) {
                        return 1;
                    }
                    return -1;
                }
            });
        }
        HashMap<String, HashedArrayList> enclosureBySwitch = new HashMap<String, HashedArrayList>();
        for (int i2 = 0; i2 < enclList.size(); ++i2) {
            enclNode = enclList.get(i2);
            String swWWn = enclNode.getWwn();
            hashedEnclList = (HashedArrayList)enclosureBySwitch.get(swWWn);
            if (hashedEnclList == null) {
                hashedEnclList = new HashedArrayList();
                enclosureBySwitch.put(swWWn, hashedEnclList);
            }
            hashedEnclList.add(enclNode);
        }
        HashedArrayList<ILogNode> sortedEnclList = new HashedArrayList<ILogNode>();
        for (i = 0; i < switchList.size(); ++i) {
            hashedEnclList = (HashedArrayList)enclosureBySwitch.get(switchList.get(i).getWwn());
            if (hashedEnclList == null) continue;
            if (hashedEnclList.size() >= 2) {
                Collections.sort(hashedEnclList, new Comparator<ILogNode>(){

                    @Override
                    public int compare(ILogNode arg0, ILogNode arg1) {
                        return arg0.getNodeLabel().compareTo(arg1.getNodeLabel());
                    }
                });
            }
            for (int j = 0; j < hashedEnclList.size(); ++j) {
                enclNode = (ILogNode)hashedEnclList.get(j);
                if (sortedEnclList.contains(enclNode)) continue;
                sortedEnclList.add(enclNode);
            }
        }
        for (i = 0; i < enclList.size(); ++i) {
            enclNode = enclList.get(i);
            if (sortedEnclList.contains(enclNode)) continue;
            sortedEnclList.add(enclNode);
        }
        return sortedEnclList;
    }

    public void findSwitchBounds(ILogGraphIf topologyGraph) {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (ILogNodeIf node : topologyGraph.nodes()) {
            if (node == null || node.isHost() || node.isStorage()) continue;
            double x = node.getIconCenterX();
            double y = node.getIconCenterY();
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (!(y > maxY)) continue;
            maxY = y;
        }
        this.switchMinX = minX;
        this.switchMaxX = maxX;
        this.switchMinY = minY;
        this.switchMaxY = maxY;
    }
}

