/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.util;

import java.util.Collection;

public class Filter {
    public static String SELECTED = "selected";
    public static String CREDENTIAL = "credential";
    public static String INTERVAL = "interval";
    public static String STATUS = "status";
    public static String TOFILE = "toFile";
    private String filterName;
    private String filterKey;
    private Object filterValue;
    private boolean displayable;

    public Filter(String filterName, Object filterValue) {
        this(filterName, filterValue, true);
    }

    public Filter(String filterName, Object filterValue, boolean displayable) {
        this.filterKey = filterName;
        this.filterName = filterName;
        this.filterValue = filterValue;
        this.displayable = displayable;
    }

    public Filter(String filterKey, String filterName, Object filterValue) {
        this.filterName = filterName;
        this.filterKey = filterKey;
        this.filterValue = filterValue;
        this.displayable = true;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public Object getFilterValue() {
        return this.filterValue;
    }

    public String getDisplayValue() {
        if (this.filterValue != null) {
            return this.filterValue.toString();
        }
        return "";
    }

    public void setFilterValue(String filterValue) {
        this.filterValue = filterValue;
    }

    public int hashCode() {
        return this.filterKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Filter)) {
            return false;
        }
        Filter f = (Filter)obj;
        return this.filterKey.equals(f.getFilterKey());
    }

    public boolean isDisplayable() {
        return this.displayable;
    }

    public void setDisplayable(boolean displayable) {
        this.displayable = displayable;
    }

    public static Filter getFilter(String key, Collection<Filter> filters) {
        for (Filter filter : filters) {
            if (!key.equals(filter.getFilterKey())) continue;
            return filter;
        }
        return null;
    }

    public String getFilterKey() {
        return this.filterKey;
    }
}

