/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.visio;

import com.cisco.dcbu.sm.common.visio.VisioGraphIntf;
import com.cisco.dcbu.sm.common.visio.VisioLinkIntf;
import com.cisco.dcbu.sm.common.visio.VisioNodeIntf;
import com.cisco.nm.esper.model.Transform;
import com.loox.jloox.LxAbstractGraph;
import com.loox.jloox.LxComponent;
import com.loox.jloox.LxGraph;
import com.loox.jloox.LxLayoutManager;
import com.loox.jloox.LxLink;
import com.loox.jloox.LxRectangle;
import com.loox.jloox.layout.LxCircularLayout;
import com.loox.jloox.layout.LxSpringLayout;
import com.loox.jloox.layout.LxSpringNodeConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;

public class VisioLayoutServer2 {
    public static final String LAYOUT_STYLE_DEFAULT = "Default";
    public static final String LAYOUT_STYLE_CIRCULAR = "Circular";
    public static final String LAYOUT_STYLE_SPRING = "Spring";
    public static final String LAYOUT_STYLE_TIER = "Tier";
    private boolean _inited = false;
    private LxLayoutManager _Circular = null;
    private LxLayoutManager _Spring = null;
    private static String _layoutStyle = "Spring";
    private static LxSpringNodeConstraints _SpringNodeConstraints;
    private static boolean _staticInited;
    private static int _layoutWidth;
    private static int _layoutHeight;

    public VisioLayoutServer2() {
        if (!_staticInited) {
            _staticInited = true;
            _SpringNodeConstraints = new LxSpringNodeConstraints();
            _SpringNodeConstraints.setFixed(true);
        }
    }

    public static void setLayoutStyle(String style) {
        if (style == null || _layoutStyle.equals(style)) {
            return;
        }
        _layoutStyle = style;
    }

    public static String getLayoutStyle() {
        return _layoutStyle;
    }

    public void setSize(int width, int height) {
        if (width > 1) {
            _layoutWidth = width;
        }
        if (height > 1) {
            _layoutHeight = height;
        }
    }

    public void interrupt() {
    }

    public void layout(VisioGraphIntf graph) throws Exception {
        this.layout(graph, true);
    }

    public void layout(VisioGraphIntf graph, boolean useSizeParams) throws Exception {
        this.layout(graph, useSizeParams, 0, 0);
    }

    public void layout(VisioGraphIntf graph, boolean useSizeParams, int offX, int offY) throws Exception {
        block28: {
            LxAbstractGraph lxgraph;
            if (LAYOUT_STYLE_TIER.equals(_layoutStyle)) {
                return;
            }
            try {
                if (graph == null || (graph.graphs() == null || graph.graphs().size() < 1) && (graph.nodes() == null || graph.nodes().size() < 1)) {
                    return;
                }
            }
            catch (Exception ex) {
                System.err.println("VisioLayoutServer2.layout() " + ex.getMessage());
            }
            this.init();
            if (graph.graphs() != null && graph.graphs().size() > 0) {
                boolean subGraphSizeParams = useSizeParams;
                if (graph.graphs().size() != 1) {
                    subGraphSizeParams = false;
                }
                ((LxSpringLayout)this._Spring).setSpecifyLayoutSize(false);
                for (VisioGraphIntf g : graph.graphs()) {
                    if (!g.isVisible() || !g.isExpanded()) continue;
                    this.layout(g, subGraphSizeParams);
                }
            }
            if (useSizeParams) {
                ((LxSpringLayout)this._Spring).setEdgeLength(100.0);
                ((LxSpringLayout)this._Spring).setAutoEdgeLength(true);
                ((LxSpringLayout)this._Spring).setEpsilon(0.02);
                ((LxSpringLayout)this._Spring).setUseObjectsSizes(true);
                ((LxSpringLayout)this._Spring).setSpecifyLayoutSize(true);
                this._Spring.setSize((double)_layoutWidth, (double)_layoutHeight);
            }
            if ((lxgraph = this.getServerGraph(graph, useSizeParams)).getComponents() != null && lxgraph.getComponents().length > 600) {
                if (lxgraph.getComponents().length > 1500) {
                    ((LxSpringLayout)this._Spring).setEpsilon(150000.0);
                } else if (lxgraph.getComponents().length > 1000) {
                    ((LxSpringLayout)this._Spring).setEpsilon(20000.0);
                } else {
                    ((LxSpringLayout)this._Spring).setEpsilon(10000.0);
                }
            } else {
                ((LxSpringLayout)this._Spring).setEpsilon(0.02);
            }
            if (lxgraph == null) {
                graph.compactBounds();
                return;
            }
            try {
                if (LAYOUT_STYLE_SPRING.equals(_layoutStyle)) {
                    try {
                        this._Spring.run();
                    }
                    catch (Exception e) {
                        System.err.println("cancel..." + e.getMessage());
                    }
                    this.copyGeometry(graph, this._Spring, offX, offY, useSizeParams);
                    break block28;
                }
                if (LAYOUT_STYLE_CIRCULAR.equals(_layoutStyle)) {
                    try {
                        this._Circular.run();
                    }
                    catch (Exception e) {
                        System.err.println("cancel..." + e.getMessage());
                    }
                    this.copyGeometry(graph, this._Circular, offX, offY, useSizeParams);
                    break block28;
                }
                try {
                    this._Spring.run();
                }
                catch (Exception e) {
                    System.err.println("cancel..." + e.getMessage());
                }
                this.copyGeometry(graph, this._Spring, offX, offY, useSizeParams);
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                this.freeResources(lxgraph);
            }
        }
    }

    public LxAbstractGraph getServerGraph(VisioGraphIntf graph, boolean useSizeParams) throws Exception {
        if (this._Circular.getComponents() != null) {
            this._Circular.removeAll();
        }
        if (this._Spring.getComponents() != null) {
            this._Spring.removeAll();
        }
        LxGraph lxgraph = null;
        try {
            lxgraph = new LxGraph();
        }
        catch (Exception ex) {
            System.err.println("VisioLayoutServer2.getServerGraph() " + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
        HashMap nodeMap = new HashMap();
        LxComponent source = null;
        LxComponent target = null;
        LxLink lxedge = null;
        int sizex = _layoutWidth;
        int sizey = _layoutHeight;
        if (!useSizeParams) {
            sizex = ((graph.nodes() != null ? graph.nodes().size() : 0) + (graph.graphs() != null ? graph.graphs().size() : 0) * 5) * 25;
            if (sizex < 50) {
                sizex = 50;
            }
            if (sizex > 500) {
                sizex = 500;
            }
            sizey = sizex;
        }
        if (graph.graphs() != null && graph.graphs().size() > 0) {
            for (VisioGraphIntf g : graph.graphs()) {
                if (g == null || !g.isVisible()) continue;
                LxRectangle lxnode = new LxRectangle();
                lxnode.setUserData((Object)g);
                lxnode.setLocation(0.0, 0.0);
                int width = (int)g.getWidth();
                int height = (int)g.getHeight();
                if (width < 0) {
                    width = 50;
                }
                if (width > sizex) {
                    width = sizex;
                }
                if (height < 0) {
                    height = 50;
                }
                if (height > sizey) {
                    height = sizey;
                }
                lxnode.setSize((double)width, (double)height);
                g.setUserObject(lxnode);
                lxgraph.add((LxComponent)lxnode);
                this._Circular.add((LxComponent)lxnode);
                this._Spring.add((LxComponent)lxnode);
            }
        }
        if (graph.nodes() != null && graph.nodes().size() > 0) {
            Iterator nodeIter = graph.nodes().iterator();
            boolean fixed = false;
            int n = 16;
            if (useSizeParams) {
                n = (graph.nodes() != null ? graph.nodes().size() : 0) + (graph.graphs() != null ? graph.graphs().size() : 0) * 5;
                if ((n = sizex * sizey / 100 / n) > 32) {
                    n = 32;
                } else if (n < 8) {
                    n = 8;
                }
            }
            if (this._Circular.getComponentCount() == 0 && graph.nodes().size() == 1) {
                VisioNodeIntf node = (VisioNodeIntf)nodeIter.next();
                if (node != null) {
                    if (!node.isLocationFixed()) {
                        node.setIconCenter(0, 0);
                    }
                    node.setIconSize(n, n);
                }
                return null;
            }
            while (nodeIter.hasNext()) {
                VisioNodeIntf node = (VisioNodeIntf)nodeIter.next();
                if (node == null) continue;
                if (!node.isVisible()) {
                    if (node.isLocationFixed()) continue;
                    node.setIconCenter(0, 0);
                    continue;
                }
                LxRectangle lxnode = new LxRectangle();
                lxnode.setUserData((Object)node);
                Point p = new Point((int)node.getIconCenterX(), (int)node.getIconCenterY());
                if (p.x == 0 && p.y == 0) {
                    fixed = false;
                    p.x = (int)(Math.random() * 1000.0) % sizex;
                    p.y = (int)(Math.random() * 1000.0) % sizey;
                } else {
                    fixed = true;
                }
                lxnode.setLocation((double)p.x, (double)p.y);
                lxnode.setSize((double)n, (double)n);
                node.setUserObject(lxnode);
                lxgraph.add((LxComponent)lxnode);
                this._Circular.add((LxComponent)lxnode);
                this._Spring.add((LxComponent)lxnode);
                if (!fixed) continue;
                ((LxSpringLayout)this._Spring).setNodeConstraints((LxComponent)lxnode, _SpringNodeConstraints);
            }
        }
        if (graph.edges() != null && graph.edges().size() > 0) {
            for (VisioLinkIntf edge : graph.edges()) {
                if (edge.hasDummyLink() ? !edge.isDummyLink() : !edge.isVisible()) continue;
                source = (LxComponent)edge.getSourceNode().getUserObject();
                target = (LxComponent)edge.getTargetNode().getUserObject();
                if (source == null || target == null) continue;
                lxedge = new LxLink(source.getHandle(0), target.getHandle(0));
                edge.setUserObject(lxedge);
                lxgraph.add((LxComponent)lxedge);
            }
        }
        nodeMap.clear();
        nodeMap = null;
        return lxgraph;
    }

    protected void copyGeometry(LxLayoutManager from, LxLayoutManager to) {
        to.removeAll();
        LxComponent[] comps = from.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            LxComponent lxnode = comps[i];
            to.add(lxnode);
        }
    }

    protected void copyGeometry(VisioGraphIntf graph, LxLayoutManager layout, int offX, int offY, boolean useSizeParams) {
        Object node;
        LxComponent lxnode;
        int i;
        LxComponent[] comps = layout.getComponents();
        int n = 0;
        if (useSizeParams) {
            n = (comps != null ? comps.length : (graph.nodes() != null ? graph.nodes().size() : 0)) + (graph.graphs() != null ? graph.graphs().size() : 0) * 5;
            if ((n = _layoutWidth * _layoutHeight / 130 / n) > 32) {
                n = 32;
            } else if (n < 8) {
                n = 8;
            }
        } else {
            n = 16;
        }
        double x = 0.0;
        double y = 0.0;
        double sx = 1.0;
        double sy = 1.0;
        double l = 10000.0;
        double r = -10000.0;
        double b = -10000.0;
        double t = 10000.0;
        Transform ident = new Transform();
        Rectangle rect = null;
        int lw = 0;
        int rw = 0;
        int th = 0;
        int bh = 0;
        int maxW = 8;
        if (useSizeParams) {
            for (i = 0; i < comps.length; ++i) {
                lxnode = comps[i];
                if (lxnode.getUserData() == null || !(lxnode.getUserData() instanceof VisioNodeIntf)) continue;
                node = (VisioNodeIntf)lxnode.getUserData();
                rect = null;
                x = lxnode.getX();
                y = lxnode.getY();
                if (x < l) {
                    l = x;
                }
                if (x > r) {
                    r = x;
                }
                if (y < t) {
                    t = y;
                }
                if (!(y > b)) continue;
                b = y;
            }
            x = r - l;
            y = b - t;
            sx = (double)(_layoutWidth - lw / 2 - rw / 2) / x;
            sx = (double)((int)(1000.0 * sx)) / 1000.0;
            sy = (double)(_layoutHeight - th / 2 - bh / 2) / y;
            sy = (double)((int)(1000.0 * sy)) / 1000.0;
        } else {
            for (i = 0; i < comps.length; ++i) {
                lxnode = comps[i];
                if (lxnode.getUserData() == null || !(lxnode.getUserData() instanceof VisioNodeIntf)) continue;
                node = (VisioNodeIntf)lxnode.getUserData();
            }
        }
        if (rect == null) {
            rect = new Rectangle(0, 0, 0, 0);
        } else {
            rect.setRect(0.0, 0.0, 0.0, 0.0);
        }
        for (i = 0; i < comps.length; ++i) {
            lxnode = comps[i];
            if (lxnode.getUserData() instanceof VisioNodeIntf) {
                node = (VisioNodeIntf)lxnode.getUserData();
                if (node == null) continue;
                x = (double)(lw / 2) + (lxnode.getX() - l) * sx;
                y = (double)(th / 2) + (lxnode.getY() - t) * sy;
                node.setIconCenter((double)((int)x + offX) + rect.getWidth() / 2.0, (double)((int)y + offY) + rect.getHeight() / 2.0);
                continue;
            }
            if (!(lxnode.getUserData() instanceof VisioGraphIntf) || (node = (VisioGraphIntf)lxnode.getUserData()) == null) continue;
            node.setCenter(lxnode.getX() + lxnode.getWidth() / 2.0 + (double)offX, lxnode.getY() + lxnode.getHeight() / 2.0 + (double)offY);
        }
        if (graph.edges() != null) {
            for (VisioLinkIntf edge : graph.edges()) {
            }
        }
        graph.compactBounds();
    }

    protected void freeResources(LxAbstractGraph lxgraph) {
        if (lxgraph != null) {
            if (this._Spring.getComponents() != null) {
                this._Spring.removeAll();
            }
            if (this._Circular.getComponents() != null) {
                this._Circular.removeAll();
            }
            lxgraph.cleanUp();
        }
    }

    private void init() {
        if (!this._inited) {
            this._inited = true;
            this._Spring = new LxSpringLayout((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, _layoutWidth, _layoutHeight));
            ((LxSpringLayout)this._Spring).setEdgeLength(100.0);
            ((LxSpringLayout)this._Spring).setAutoEdgeLength(true);
            ((LxSpringLayout)this._Spring).setEpsilon(0.02);
            ((LxSpringLayout)this._Spring).setUseObjectsSizes(true);
            this._Circular = new LxCircularLayout((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, _layoutWidth, _layoutHeight));
        }
    }

    static {
        _staticInited = false;
        _layoutWidth = 500;
        _layoutHeight = 500;
    }
}

