/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.common.visio;

import com.cisco.dcbu.sm.common.topology.dto.TopoEdgeLinkDto;
import com.cisco.dcbu.sm.common.topology.dto.TopoEthIslDto;
import com.cisco.dcbu.sm.common.topology.dto.TopoEthSwitchDto;
import com.cisco.dcbu.sm.common.topology.dto.TopoHubDto;
import com.cisco.dcbu.sm.common.topology.dto.TopoIslDto;
import com.cisco.dcbu.sm.common.topology.dto.TopoNpvLinkDto;
import com.cisco.dcbu.sm.common.topology.dto.TopoNxPortDto;
import com.cisco.dcbu.sm.common.topology.dto.TopoSwitchDto;
import com.cisco.dcbu.sm.common.visio.VisioDeviceNode;
import com.cisco.dcbu.sm.common.visio.VisioEdgeLink;
import com.cisco.dcbu.sm.common.visio.VisioEdgeLinkIntf;
import com.cisco.dcbu.sm.common.visio.VisioEthSwitchNode;
import com.cisco.dcbu.sm.common.visio.VisioFCoEEdgeLink;
import com.cisco.dcbu.sm.common.visio.VisioFCoEVdcSwitchNode;
import com.cisco.dcbu.sm.common.visio.VisioFiconCUPNode;
import com.cisco.dcbu.sm.common.visio.VisioHostNode;
import com.cisco.dcbu.sm.common.visio.VisioISCIHostNode;
import com.cisco.dcbu.sm.common.visio.VisioIslLink;
import com.cisco.dcbu.sm.common.visio.VisioIslLinkIntf;
import com.cisco.dcbu.sm.common.visio.VisioLoopNode;
import com.cisco.dcbu.sm.common.visio.VisioLoopNodeIntf;
import com.cisco.dcbu.sm.common.visio.VisioMDS9216SwitchNode;
import com.cisco.dcbu.sm.common.visio.VisioMDS95xxSwitchNode;
import com.cisco.dcbu.sm.common.visio.VisioMDSSwitchNode;
import com.cisco.dcbu.sm.common.visio.VisioMainFrameNode;
import com.cisco.dcbu.sm.common.visio.VisioN5KSwitchNode;
import com.cisco.dcbu.sm.common.visio.VisioNodeIntf;
import com.cisco.dcbu.sm.common.visio.VisioNpvLink;
import com.cisco.dcbu.sm.common.visio.VisioSN5428SwitchNode;
import com.cisco.dcbu.sm.common.visio.VisioStorageNode;
import com.cisco.dcbu.sm.common.visio.VisioSwitchNode;
import com.cisco.dcbu.sm.common.visio.VisioSwitchNodeIntf;
import com.cisco.dcbu.sm.common.visio.VisioUCSSwitchNode;

public class VisioMapFactory {
    public static VisioSwitchNodeIntf createSwitchNode(TopoSwitchDto fcSwitch) {
        VisioSwitchNode visioSwitchNode = null;
        visioSwitchNode = fcSwitch.isVdc() && fcSwitch.isN7K() ? new VisioFCoEVdcSwitchNode() : (fcSwitch.isMDS() || fcSwitch.isQuail() ? (fcSwitch.isMdsDirector() ? new VisioMDS95xxSwitchNode() : (fcSwitch.getModelType() == 380 ? new VisioMDS9216SwitchNode() : (fcSwitch.isUCS() ? new VisioUCSSwitchNode() : (fcSwitch.isN5K() ? new VisioN5KSwitchNode() : new VisioMDSSwitchNode())))) : (fcSwitch.isSN5428() ? new VisioSN5428SwitchNode() : new VisioSwitchNode()));
        visioSwitchNode.setModel(fcSwitch);
        visioSwitchNode.setName(fcSwitch.toString());
        visioSwitchNode.setName(fcSwitch.getName());
        visioSwitchNode.setHashCode(fcSwitch.getPK().hashCode());
        return visioSwitchNode;
    }

    public static VisioLoopNodeIntf createLoopNode(TopoHubDto hubDto) {
        VisioLoopNode visioNode = null;
        visioNode = hubDto.isCloud() ? new VisioLoopNode() : new VisioLoopNode();
        visioNode.setModel(hubDto);
        visioNode.setName(hubDto.toString());
        visioNode.setName(hubDto.getName());
        visioNode.setHashCode(hubDto.getPK().hashCode());
        return visioNode;
    }

    public static VisioNodeIntf createEndNode(TopoNxPortDto nxPort) {
        VisioDeviceNode visioNode = null;
        if (nxPort.getEnclosure() != null) {
            if (!nxPort.isTarget() && nxPort.isFiconCH()) {
                visioNode = new VisioMainFrameNode();
            } else if (nxPort.isTarget()) {
                visioNode = new VisioStorageNode();
            }
        } else if (nxPort.isTarget()) {
            visioNode = new VisioStorageNode();
        }
        if (visioNode == null) {
            visioNode = nxPort.isFiconCH() ? new VisioMainFrameNode() : (nxPort.isISCSI() ? new VisioISCIHostNode() : (nxPort.isFiconCup() ? new VisioFiconCUPNode() : new VisioHostNode()));
        }
        visioNode.setModel(nxPort);
        visioNode.setName(nxPort.toString());
        visioNode.setName(nxPort.getName());
        visioNode.setHashCode(nxPort.getPK().hashCode());
        return visioNode;
    }

    public static VisioIslLinkIntf createIslLink(TopoIslDto isl) {
        VisioIslLink visioIslLink = null;
        visioIslLink = new VisioIslLink();
        visioIslLink.setModel(isl);
        visioIslLink.setPortChannel(isl.isPortChannel());
        visioIslLink.setSwitch1PK(isl.getSwitch1PK());
        visioIslLink.setIfIndex1Name(isl.getIfIndex1Name());
        visioIslLink.setIfIndex2Name(isl.getIfIndex2Name());
        visioIslLink.setTunnel(isl.isFCIP());
        visioIslLink.setDWDM(isl.isDWDM());
        return visioIslLink;
    }

    public static VisioIslLinkIntf createNpvLink(TopoNpvLinkDto npvLink) {
        VisioNpvLink visioIslLink = null;
        visioIslLink = new VisioNpvLink();
        visioIslLink.setModel(npvLink);
        visioIslLink.setPortChannel(npvLink.isPortChannel());
        visioIslLink.setSwitch1PK(npvLink.getSwitch1PK());
        visioIslLink.setIfIndex1Name(npvLink.getIfIndex1Name());
        visioIslLink.setIfIndex2Name(npvLink.getIfIndex2Name());
        visioIslLink.setTunnel(npvLink.isFCIP());
        return visioIslLink;
    }

    public static VisioEdgeLinkIntf createEdgeLink(TopoEdgeLinkDto edgeLink) {
        VisioEdgeLink visioEdgeLink = null;
        visioEdgeLink = edgeLink.isFCoE() ? new VisioFCoEEdgeLink() : new VisioEdgeLink();
        visioEdgeLink.setModel(edgeLink);
        visioEdgeLink.setIfIndexName(VisioMapFactory.getIfIndexName(edgeLink));
        visioEdgeLink.setDashed(edgeLink.isISCSI());
        return visioEdgeLink;
    }

    private static String getIfIndexName(TopoEdgeLinkDto edgeLink) {
        String name = edgeLink.getIfName();
        if (name != null && name.length() != 0) {
            return name;
        }
        if (edgeLink.isSwitchIsMDS() || edgeLink.isSwitchIsQuail()) {
            return edgeLink.isFiconCup() ? "" : edgeLink.getSwitchIfIndexToName();
        }
        return edgeLink.isFiconCup() ? "" : Integer.toString(edgeLink.getIfIndex());
    }

    public static VisioSwitchNodeIntf createEthSwitchNode(TopoEthSwitchDto ethSwitch) {
        VisioEthSwitchNode visioSwitchNode = null;
        visioSwitchNode = new VisioEthSwitchNode();
        visioSwitchNode.setModel(ethSwitch);
        visioSwitchNode.setName(ethSwitch.toString());
        visioSwitchNode.setName(ethSwitch.getName());
        visioSwitchNode.setHashCode(ethSwitch.getPK().hashCode());
        return visioSwitchNode;
    }

    public static VisioIslLinkIntf createEthIslLink(TopoEthIslDto ethIsl) {
        VisioIslLink visioIslLink = null;
        visioIslLink = new VisioIslLink();
        visioIslLink.setModel(ethIsl);
        visioIslLink.setSwitch1PK(ethIsl.getSwitch1PK());
        visioIslLink.setIfIndex1Name(ethIsl.getIfIndex1Name());
        visioIslLink.setIfIndex2Name(ethIsl.getIfIndex2Name());
        return visioIslLink;
    }
}

