/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CreateClientPackage {
    static final String separator = System.getProperty("file.separator");
    static TreeSet<String> fmjarList = new TreeSet();
    static TreeSet<String> dmjarList = new TreeSet();
    public static ArrayList listFil = new ArrayList();

    private static void zippingFiles(File f1) throws IOException {
        File directoryToZip = f1;
        ArrayList<File> fileList = new ArrayList<File>();
        System.out.println("---Getting references to all files in: " + directoryToZip.getCanonicalPath());
        CreateClientPackage.getAllFiles(directoryToZip, fileList);
        System.out.println("---Creating zip file");
        CreateClientPackage.writeZipFile(directoryToZip, fileList, new File(f1.getParent()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createLinuxPackage(File f1, File fmjars, File dmjars, String installdir) {
        File fmlib = new File(installdir + separator + "dcm" + separator + "fm" + separator + "lib" + separator + "fm");
        File dmlib = new File(installdir + separator + "dcm" + separator + "fm" + separator + "lib" + separator + "dm");
        BufferedWriter writer = null;
        try {
            System.out.println("Coping jars.. \nFrom : " + fmlib.getAbsolutePath() + "\nTo : " + fmjars.getAbsolutePath());
            CreateClientPackage.copyDirectory(fmlib, fmjars, fmjarList);
            System.out.println("Jars copied to folder: " + fmjars.getPath());
            File fabricManager = new File(f1, "FabricManager.sh");
            File deviceManager = new File(f1, "DeviceManager.sh");
            if (System.getProperty("os.name").toLowerCase().contains("linux") || System.getProperty("os.name").toLowerCase().contains("unix")) {
                Runtime.getRuntime().exec("chmod 777 " + fabricManager.getAbsolutePath());
                Runtime.getRuntime().exec("chmod 777 " + deviceManager.getAbsolutePath());
            }
            writer = new BufferedWriter(new FileWriter(fabricManager));
            writer.write("#!/bin/sh");
            writer.write("\n");
            writer.write("# Run Fabric Manager client.");
            writer.write("\n");
            writer.write("INSTALLDIR=$(dirname $(readlink -f ${BASH_SOURCE[0]}))");
            writer.write("\n");
            writer.write("LIB=$(dirname $(readlink -f ${BASH_SOURCE[0]}))/fmjars");
            writer.write("\n");
            writer.write("JVMARGS=\"-Xmx512m -Dsun.rmi.dgc.client.gcInterval=3600000 -Dsun.rmi.dgc.server.gcInterval=3600000\"");
            writer.write("\n");
            writer.write("CP=$LIB/patch.jar:$LIB/fmclient.jar:$LIB/portland.jar:$LIB/fm_jcommon-0.7.2.jar:$LIB/fm_log4j.jar:$LIB/fm_layout.jar:$LIB/jviews-diagrammer.jar:$LIB/jviews-framework-all.jar:$LIB/fm_jfree.jar:$LIB/jboss-aop-jdk50-client.jar:$LIB/jboss-aspect-jdk50-client.jar:$LIB/jboss-ejb3-client.jar:$LIB/jbossall-client.jar:$LIB/jboss-ejb3x.jar:$LIB/commons-net-1.4.1.jar:$LIB/jakarta-oro-2.0.8.jar:$LIB/commons-codec-1.3.jar:$LIB/jchart.jar:$LIB/httpcore-4.0.1.jar:$LIB/httpclient-4.0-beta1.jar");
            writer.write("\n");
            writer.write("CP=$CP:$LIB/com.noelios.restlet.jar:$LIB/org.restlet.jar");
            writer.write("\n");
            writer.write("CP=$CP:$LIB/hssf.jar:$LIB/jide-action.jar:$LIB/jide-common.jar:$LIB/jide-components.jar:$LIB/jide-dialogs.jar:$LIB/jide-dock.jar:$LIB/jide-grids.jar:$LIB/jide-pivot.jar:$LIB/jide-shortcut.jar");
            writer.write("\n");
            writer.write("cd $INSTALLDIR");
            writer.write("\n");
            writer.write("java -cp $CP $JVMARGS com.cisco.dcbu.sm.client.Launcher $*&");
            writer.write("\n");
            writer.close();
            System.out.println("FabricManager.sh created\n");
            System.out.println("Coping jars.. \nFrom : " + dmlib.getAbsolutePath() + "\nTo : " + dmjars.getAbsolutePath());
            CreateClientPackage.copyDirectory(dmlib, dmjars, dmjarList);
            System.out.println("Jars copied to folder: " + dmjars.getPath());
            writer = new BufferedWriter(new FileWriter(deviceManager));
            writer.write("#!/bin/sh");
            writer.write("\n");
            writer.write("# Run the Device Manager client.");
            writer.write("\n");
            writer.write("INSTALLDIR=$(dirname $(readlink -f ${BASH_SOURCE[0]}))");
            writer.write("\n");
            writer.write("LIB=$(dirname $(readlink -f ${BASH_SOURCE[0]}))/dmjars");
            writer.write("\n");
            writer.write("JVMARGS=\"-Xmx512m -Dsun.rmi.dgc.client.gcInterval=3600000 -Dsun.rmi.dgc.server.gcInterval=3600000\"");
            writer.write("\n");
            writer.write("CP=$LIB/patch.jar:$LIB/bitmaps.jar:$LIB/dm.jar:$LIB/dmdb.jar:$LIB/dmhelp.jar:$LIB/portland.jar:$LIB/jchart.jar:$LIB/jnm.jar:$LIB/snmp.jar:$LIB/jcommon-0.7.2.jar:$LIB/fmserver.jar:$LIB/log4j.jar:$LIB/commons-codec-1.3.jar");
            writer.write("\n");
            writer.write("CP=$CP:$LIB/jboss-jaxrpc.jar:$LIB/jboss-jaxws.jar:$LIB/jboss-saaj.jar:$LIB/jbossws-client.jar:$LIB/jboss-xml-binding.jar:$LIB/mail.jar:$LIB/concurrent.jar:$LIB/jboss-common-client.jar:$LIB/jboss-remoting.jar:$LIB/xercesImpl.jar:$LIB/activation.jar");
            writer.write("\n");
            writer.write("CP=$CP:$LIB/jide-action.jar:$LIB/jide-common.jar:$LIB/jide-grids.jar");
            writer.write("\n");
            writer.write("cd $INSTALLDIR");
            writer.write("\n");
            writer.write("java -cp $CP $JVMARGS com.cisco.dcbu.dm.DM $*&");
            writer.write("\n");
            writer.close();
            System.out.println("DeviceManager.sh created");
        }
        catch (IOException io) {
            System.out.println("I/O Exception occured" + io.toString());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                System.out.println("I/O Exception occured" + e.toString());
            }
        }
    }

    private static String checkInstallDir(String installdir) {
        File temp = new File(installdir);
        if (!temp.exists() || !temp.isDirectory()) {
            System.out.println("Error: Path " + installdir + " does not exist or is not a directory!!");
            installdir = null;
            return installdir;
        }
        if (temp.exists()) {
            File f3 = new File(installdir + separator + "dcm" + separator + "fm" + separator + "lib" + separator + "fm");
            File f4 = new File(installdir + separator + "dcm" + separator + "fm" + separator + "lib" + separator + "dm");
            if (!(f3.exists() && f3.isDirectory() && f4.exists() && f4.isDirectory())) {
                System.out.println("Error: FM Server not found under " + installdir + ". Inavlid path!");
                installdir = null;
            }
        }
        return installdir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createWindowsPackage(File f1, File fmjars, File dmjars, String installdir) {
        File fmlib = new File(installdir + separator + "dcm" + separator + "fm" + separator + "lib" + separator + "fm");
        File dmlib = new File(installdir + separator + "dcm" + separator + "fm" + separator + "lib" + separator + "dm");
        BufferedWriter writer = null;
        try {
            System.out.println("Coping jars.. \nFrom : " + fmlib.getAbsolutePath() + "\nTo : " + fmjars.getAbsolutePath());
            CreateClientPackage.copyDirectory(fmlib, fmjars, fmjarList);
            System.out.println("Jars copied to folder: " + fmjars.getPath());
            writer = new BufferedWriter(new FileWriter(new File(f1, "FabricManager.bat")));
            writer.write("rem Run Fabric Manager client.");
            writer.write("\r\n");
            writer.write("set INSTALLDIR=%~dp0");
            writer.write("\r\n");
            writer.write("set LIB=%~dp0fmjars");
            writer.write("\r\n");
            writer.write("set JVMARGS=\"-Xmx512m -Dsun.rmi.dgc.client.gcInterval=3600000 -Dsun.rmi.dgc.server.gcInterval=3600000\"");
            writer.write("\r\n");
            writer.write("set CP=%LIB%\\patch.jar;%LIB%\\fmclient.jar;%LIB%\\portland.jar;%LIB%\\fm_jcommon-0.7.2.jar;%LIB%\\fm_log4j.jar;%LIB%\\fm_layout.jar;%LIB%\\jviews-diagrammer.jar;%LIB%\\jviews-framework-all.jar;%LIB%\\fm_jfree.jar;%LIB%\\jboss-aop-jdk50-client.jar;%LIB%\\jboss-aspect-jdk50-client.jar;%LIB%\\jboss-ejb3-client.jar;%LIB%\\jbossall-client.jar;%LIB%\\jboss-ejb3x.jar;%LIB%\\commons-net-1.4.1.jar;%LIB%\\jakarta-oro-2.0.8.jar;%LIB%\\commons-codec-1.3.jar;%LIB%\\jchart.jar;%LIB%\\httpcore-4.0.1.jar;%LIB%\\httpclient-4.0-beta1.jar;");
            writer.write("\r\n");
            writer.write("set CP=%CP%;%LIB%\\com.noelios.restlet.jar;%LIB%\\org.restlet.jar");
            writer.write("\r\n");
            writer.write("set CP=%CP%;%LIB%\\hssf.jar;%LIB%\\jide-action.jar;%LIB%\\jide-common.jar;%LIB%\\jide-components.jar;%LIB%\\jide-dialogs.jar;%LIB%\\jide-dock.jar;%LIB%\\jide-grids.jar;%LIB%\\jide-pivot.jar;%LIB%\\jide-shortcut.jar");
            writer.write("\r\n");
            writer.write("cd %INSTALLDIR%");
            writer.write("\r\n");
            writer.write("cmd /c start \"\" javaw  -cp \"%CP%\" \"%JVMARGS%\" com.cisco.dcbu.sm.client.Launcher %1 %2 %3 %4 %5 %6 %7 %8");
            writer.write("\r\n");
            writer.write("exit");
            writer.write("\r\n");
            System.out.println("FabricManager.bat created");
            writer.close();
            System.out.println("Coping jars.. \nFrom : " + dmlib.getAbsolutePath() + "\nTo : " + dmjars.getAbsolutePath());
            CreateClientPackage.copyDirectory(dmlib, dmjars, dmjarList);
            System.out.println("Jars copied to folder: " + dmjars.getPath());
            writer = new BufferedWriter(new FileWriter(new File(f1, "DeviceManager.bat")));
            writer.write("rem Run Device Manager client.");
            writer.write("\r\n");
            writer.write("set INSTALLDIR=%~dp0");
            writer.write("\r\n");
            writer.write("set LIB=%~dp0dmjars");
            writer.write("\r\n");
            writer.write("set JVMARGS=\"-Xmx512m -Dsun.rmi.dgc.client.gcInterval=3600000 -Dsun.rmi.dgc.server.gcInterval=3600000\"");
            writer.write("\r\n");
            writer.write("set CP=%LIB%\\patch.jar;%LIB%\\bitmaps.jar;%LIB%\\dm.jar;%LIB%\\dmdb.jar;%LIB%\\dmhelp.jar;%LIB%\\portland.jar;%LIB%\\jchart.jar;%LIB%\\jcommon-0.7.2.jar;%LIB%\\jnm.jar;%LIB%\\log4j.jar;%LIB%\\snmp.jar;%LIB%\\commons-codec-1.3.jar;%LIB%\\fmserver.jar;");
            writer.write("\r\n");
            writer.write("set CP=%CP%;%LIB%\\jboss-jaxrpc.jar;%LIB%\\jboss-jaxws.jar;%LIB%\\jboss-saaj.jar;%LIB%\\jbossws-client.jar;%LIB%\\jboss-xml-binding.jar;%LIB%\\mail.jar;%LIB%\\concurrent.jar;%LIB%\\jboss-common-client.jar;%LIB%\\jboss-remoting.jar;%LIB%\\xercesImpl.jar;%LIB%\\activation.jar;");
            writer.write("\r\n");
            writer.write("set CP=%CP%;%LIB%\\jide-action.jar;%LIB%\\jide-common.jar;%LIB%\\jide-grids.jar;");
            writer.write("\r\n");
            writer.write("cd %INSTALLDIR%");
            writer.write("\r\n");
            writer.write("cmd /c start \"\" javaw  -cp \"%CP%\" \"%JVMARGS%\" com.cisco.dcbu.dm.DM %1");
            writer.write("\r\n");
            writer.write("exit");
            writer.write("\r\n");
            writer.close();
            System.out.println("DeviceManager.bat created");
        }
        catch (IOException io) {
            System.out.println("I/O Exception occured" + io.toString());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                System.out.println("I/O Exception occured" + e.toString());
            }
        }
    }

    public static void copyDirectory(File sourceDir, File destDir, TreeSet<String> fmjarList2) throws IOException {
        File[] children;
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        for (File sourceChild : children = sourceDir.listFiles()) {
            String name = sourceChild.getName();
            File destChild = new File(destDir, name);
            if (sourceChild.isDirectory() || !fmjarList2.contains(sourceChild.getName())) continue;
            CreateClientPackage.copyFile(sourceChild, destChild);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest) throws IOException {
        if (!dest.exists()) {
            dest.createNewFile();
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new FileInputStream(source);
            out = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    private static void getAllFiles(File dir, List<File> fileList) {
        try {
            File[] files;
            for (File file : files = dir.listFiles()) {
                fileList.add(file);
                if (file.isDirectory()) {
                    System.out.println("directory:" + file.getCanonicalPath());
                    CreateClientPackage.getAllFiles(file, fileList);
                    continue;
                }
                System.out.println("     file:" + file.getCanonicalPath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] agrs) throws Exception {
        String installdir = null;
        Scanner scanner = new Scanner(System.in);
        String packageType = null;
        do {
            if (packageType != null) {
                System.out.println("Invalid choice entered, Please enter again");
            }
            System.out.println("Please choose the package :\n 1. Windows Package \n 2. Linux Package");
        } while (!(packageType = scanner.nextLine()).equals("1") && !packageType.equals("2"));
        String path = null;
        while (installdir == null) {
            System.out.println("\nPlease specify the DCNM sever install directory.");
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                installdir = "C:\\Program Files\\Cisco Systems";
                System.out.println("Press 'y'if DCNM server is installed under " + installdir);
            } else if (System.getProperty("os.name").toLowerCase().contains("linux") || System.getProperty("os.name").toLowerCase().contains("unix")) {
                installdir = "/usr/local/cisco";
                System.out.println("Press 'y'if DCNM server is installed under " + installdir);
            } else {
                installdir = null;
            }
            if (installdir != null) {
                System.out.println("Press 'n'to specify the DCNM server install directory");
                System.out.println("Enter your choice (y/n)");
                path = scanner.nextLine();
                while (!path.equalsIgnoreCase("y") && !path.equalsIgnoreCase("n")) {
                    System.out.println("Invalid input, Enter (y/n)");
                    path = scanner.nextLine();
                }
                if (path.equalsIgnoreCase("y")) {
                    installdir = CreateClientPackage.checkInstallDir(installdir);
                    continue;
                }
                if (!path.equalsIgnoreCase("n")) continue;
                System.out.println("Please specify the install directory path");
                installdir = scanner.nextLine();
                installdir = CreateClientPackage.checkInstallDir(installdir);
                continue;
            }
            System.out.println("Please enter the DCNM server install directory path");
            installdir = scanner.nextLine();
            installdir = CreateClientPackage.checkInstallDir(installdir);
        }
        System.out.println("DCNM Server found under :" + installdir);
        File f1 = new File(new File(installdir, "dcm"), "package");
        File fmjars = new File(f1.getPath(), "fmjars");
        File dmjars = new File(f1.getPath(), "dmjars");
        CreateClientPackage.cleaupDirectory(f1);
        System.out.println("Creating directories :\n" + f1.getAbsolutePath() + "\n" + fmjars.getAbsolutePath() + "\n" + dmjars.getAbsolutePath());
        f1.mkdir();
        fmjars.mkdir();
        dmjars.mkdir();
        if (packageType.equals("1")) {
            CreateClientPackage.createWindowsPackage(f1, fmjars, dmjars, installdir);
            System.out.println("\nPackaging files...");
            CreateClientPackage.zippingFiles(f1);
        } else {
            CreateClientPackage.createLinuxPackage(f1, fmjars, dmjars, installdir);
            System.out.println("\nPackaging files...");
            CreateClientPackage.zippingFiles(f1);
        }
        CreateClientPackage.cleaupDirectory(f1);
        System.out.println("---Done");
    }

    private static void cleaupDirectory(File path) {
        if (path.exists()) {
            if (path.isDirectory()) {
                for (File child : path.listFiles()) {
                    CreateClientPackage.cleaupDirectory(child);
                }
            }
            if (!path.delete()) {
                System.out.println("Could not delete " + path.getAbsolutePath());
            }
        }
    }

    private static void writeZipFile(File directoryToZip, List<File> fileList, File destdir) {
        try {
            File zipfile = new File(destdir, directoryToZip.getName() + ".zip");
            FileOutputStream fos = new FileOutputStream(zipfile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (File file : fileList) {
                if (file.isDirectory()) continue;
                CreateClientPackage.addToZip(directoryToZip, file, zos);
            }
            System.out.println("\nClient Package created under: " + zipfile.getAbsolutePath());
            zos.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void addToZip(File directoryToZip, File file, ZipOutputStream zos) throws FileNotFoundException, IOException {
        int length;
        FileInputStream fis = new FileInputStream(file);
        String zipFilePath = file.getCanonicalPath().substring(directoryToZip.getCanonicalPath().length() + 1, file.getCanonicalPath().length());
        System.out.println("Writing '" + zipFilePath + "' to zip file");
        ZipEntry zipEntry = new ZipEntry(zipFilePath);
        zos.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zos.write(bytes, 0, length);
        }
        zos.closeEntry();
        fis.close();
    }

    static {
        fmjarList.add("com.noelios.restlet.jar");
        fmjarList.add("commons-codec-1.3.jar");
        fmjarList.add("commons-net-1.4.1.jar");
        fmjarList.add("fm_jcommon-0.7.2.jar");
        fmjarList.add("fm_layout.jar");
        fmjarList.add("fmclient.jar");
        fmjarList.add("hssf.jar");
        fmjarList.add("jakarta-oro-2.0.8.jar");
        fmjarList.add("jboss-aop-jdk50-client.jar");
        fmjarList.add("jboss-aspect-jdk50-client.jar");
        fmjarList.add("jboss-ejb3-client.jar");
        fmjarList.add("jboss-ejb3x.jar");
        fmjarList.add("jchart.jar");
        fmjarList.add("jide-action.jar");
        fmjarList.add("jide-common.jar");
        fmjarList.add("jide-components.jar");
        fmjarList.add("jide-dialogs.jar");
        fmjarList.add("jide-dock.jar");
        fmjarList.add("jide-grids.jar");
        fmjarList.add("jide-pivot.jar");
        fmjarList.add("jide-shortcut.jar");
        fmjarList.add("jviews-diagrammer.jar");
        fmjarList.add("jviews-framework-all.jar");
        fmjarList.add("log4j.jar");
        fmjarList.add("org.restlet.jar");
        fmjarList.add("portland.jar");
        fmjarList.add("fm_log4j.jar");
        fmjarList.add("jbossall-client.jar");
        dmjarList.add("activation.jar");
        dmjarList.add("bitmaps.jar");
        dmjarList.add("commons-codec-1.3.jar");
        dmjarList.add("concurrent.jar");
        dmjarList.add("dmdb.jar");
        dmjarList.add("jboss-common-client.jar");
        dmjarList.add("jboss-jaxrpc.jar");
        dmjarList.add("jboss-jaxws.jar");
        dmjarList.add("jboss-remoting.jar");
        dmjarList.add("jboss-saaj.jar");
        dmjarList.add("jboss-xml-binding.jar");
        dmjarList.add("jbossws-client.jar");
        dmjarList.add("jchart.jar");
        dmjarList.add("jcommon-0.7.2.jar");
        dmjarList.add("jide-action.jar");
        dmjarList.add("jide-common.jar");
        dmjarList.add("jide-grids.jar");
        dmjarList.add("jnm.jar");
        dmjarList.add("log4j.jar");
        dmjarList.add("mail.jar");
        dmjarList.add("portland.jar");
        dmjarList.add("snmp.jar");
        dmjarList.add("xercesImpl.jar");
        dmjarList.add("dm.jar");
    }
}

