/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server;

import com.cisco.dcbu.lib.snmp.security.CommunityUser;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UsmUser;
import com.cisco.dcbu.sm.common.registry.EjbRegistry;
import com.cisco.dcbu.sm.common.rif.FMServerRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.db.ClusterSequence;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.GlobalDCManager;
import com.cisco.dcbu.sm.server.model.GlobalFabricManager;
import com.cisco.dcbu.sm.server.security.SecurityManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import sun.security.validator.ValidatorException;

public class ServerMonitor
extends Thread {
    private static volatile ServerMonitor _Instance;
    private int _serverId;
    private Timer _timer;
    static final long _MonitorInterval = 120000L;
    static final long _TimerInterval = 90000L;
    static final long _ServerLatency = 60000L;
    static boolean _NoMonitor;
    static int _FailureDetectRetries;
    static long _RetryInterval;
    static String _Value;
    static String _RetryIntervalStr;
    static AtomicBoolean _dirty;
    private static AtomicInteger _failCount;
    static final String _serverports_f = "select tmp.ports, PHYSICAL_LOGICSVR.lsvr_id, PHYSICAL_LOGICSVR.location from PHYSICAL_LOGICSVR left outer join  (select count(*) as ports, logicsvr_fabric.lsvr_id from switch_port, switch, logicsvr_fabric, fabric  where switch_port.switch_id = switch.id and switch.fabric_id = fabric.id and logicsvr_fabric.f_id = fabric.fid group by logicsvr_fabric.lsvr_id) tmp on tmp.lsvr_id = PHYSICAL_LOGICSVR.lsvr_id where PHYSICAL_LOGICSVR.status=0";
    static final String _serverports_l = "select tmp.ports, PHYSICAL_LOGICSVR.lsvr_id from PHYSICAL_LOGICSVR left outer join  (select count(*)  as ports, logicsvr_fabric.lsvr_id from ethswitch_port, ethswitch, lanswitch_map, lan, logicsvr_fabric where ethswitch_port.switch_id = ethswitch.id and ethswitch.id = lanswitch_map.id and lanswitch_map.lan_id = lan.id and lan.lan_id = logicsvr_fabric.f_id group by logicsvr_fabric.lsvr_id) tmp on tmp.lsvr_id = PHYSICAL_LOGICSVR.lsvr_id where PHYSICAL_LOGICSVR.status=0";
    Logger _log = LogManager.getLogger((String)"ServerMonitor");
    public static final int RUNNING = 0;
    public static final int FAILOVER_START = 1;
    public static final int FAILOVER_COMPLETE = 2;
    public static final int SERVER_UNREACH = 3;

    public ServerMonitor() {
        super("ServerMonitorThread");
        _Value = System.getProperty("server.ping.retries", "1");
        _RetryIntervalStr = System.getProperty("server.ping.retryInterval", "180");
        _RetryInterval = (long)Integer.parseInt(_RetryIntervalStr) * 1000L;
        _FailureDetectRetries = Integer.parseInt(_Value);
        this._serverId = ClusterSequence.getSequence().getServerId();
        this._timer = new Timer();
        this._timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                block2: {
                    try {
                        ClusterMapping.getInstance().updateScanTime(ServerMonitor.this._serverId);
                        ClusterMapping.getInstance().updateStatus(ServerMonitor.this._serverId, 0);
                        _failCount.set(0);
                    }
                    catch (SQLException e) {
                        ServerMonitor.this._log.warn((Object)("ServerMonitorThread: " + e.getMessage()));
                        if (_failCount.incrementAndGet() != 3) break block2;
                        System.exit(1);
                    }
                }
            }
        }, 0L, 90000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerMonitor getInstance() {
        if (_Instance != null) return _Instance;
        Class<ServerMonitor> clazz = ServerMonitor.class;
        synchronized (ServerMonitor.class) {
            if (_Instance != null) return _Instance;
            _Instance = new ServerMonitor();
            _Instance.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _Instance;
        }
    }

    @Override
    public void run() {
        while (!_NoMonitor) {
            block13: {
                try {
                    boolean status;
                    final InetAddress inaddr = this.getNextAddress(this._serverId, true);
                    if (inaddr == null || ClusterMapping.getInstance().getStatus(inaddr) != 0 || (status = this.pingHttpServer(inaddr))) break block13;
                    this._log.info((Object)("ServerMonitor: Ping server " + inaddr.getHostAddress() + " and detected the server is not responding..."));
                    String value = System.getProperty("server.ping.retries", "1");
                    if (!_Value.equals(value)) {
                        _FailureDetectRetries = Integer.parseInt(value);
                    }
                    int retries = _FailureDetectRetries;
                    String retryIntervalStr = System.getProperty("server.ping.retryInterval", "180");
                    if (!_RetryIntervalStr.equals(retryIntervalStr)) {
                        _RetryInterval = (long)Integer.parseInt(retryIntervalStr) * 1000L;
                    }
                    int result = ClusterMapping.getInstance().updateStatus(inaddr, 3);
                    while (!status && retries > 0) {
                        try {
                            Thread.sleep(_RetryInterval);
                        }
                        catch (InterruptedException e1) {
                            if (_NoMonitor) break;
                            this._log.warn((Object)("ServerMonitorThread: " + e1.getMessage()));
                        }
                        result = ClusterMapping.getInstance().getStatus(inaddr);
                        if (result != 3) break;
                        status = this.pingHttpServer(inaddr);
                        --retries;
                    }
                    if (!status && result == 3) {
                        this._log.info((Object)("ServerMonitor: Retry ..  and detected the server " + inaddr.getHostAddress() + " is down"));
                        result = ClusterMapping.getInstance().updateStatus(inaddr, 1);
                        if (result == 1 && Boolean.getBoolean("server.autofailover")) {
                            new Thread(){

                                @Override
                                public void run() {
                                    ServerMonitor.this._log.info((Object)"ServerMonitor: starting failover ...");
                                    ServerMonitor.this.failover(inaddr);
                                    ServerMonitor.this.maintenance();
                                }
                            }.start();
                        }
                    }
                }
                catch (SQLException e) {
                    this._log.warn((Object)e.getMessage(), (Throwable)e);
                }
                catch (RemoteException e) {
                    this._log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            try {
                Thread.sleep(120000L);
            }
            catch (InterruptedException e) {
                if (_NoMonitor) break;
                this._log.warn((Object)("ServerMonitorThread: " + e.getMessage()));
            }
        }
    }

    public List<String> getAllServerNodes() throws RemoteException {
        try {
            return ClusterMapping.getInstance().qALlIPStrings();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public int getNumofActiveServers() throws RemoteException {
        return this.getActiveServerNodes().size();
    }

    public boolean isServerActive(int sid) throws RemoteException {
        try {
            return ClusterMapping.getInstance().qActiveSID(180000L, sid);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public boolean isServerActive(InetAddress ip) throws RemoteException {
        try {
            return ClusterMapping.getInstance().qActiveIP(180000L, ip);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public List<String> getActiveServerNodes() throws RemoteException {
        try {
            return ClusterMapping.getInstance().qActiveIPs();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public HashSet<Integer> getActiveServerIDs() throws RemoteException {
        try {
            return ClusterMapping.getInstance().qActiveSIDs();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    protected void stopService() {
        _NoMonitor = true;
        this._timer.cancel();
        this.interrupt();
    }

    private InetAddress getNextAddress(int serverId, boolean up) {
        InetAddress inaddr = null;
        try {
            inaddr = ClusterMapping.getInstance().qNextIPFromSId(serverId, up ? 2 : 0);
        }
        catch (UnknownHostException e) {
            this._log.warn((Object)e.getMessage());
        }
        catch (SQLException e) {
            this._log.warn((Object)e.getMessage());
        }
        return inaddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pingHttpServer(InetAddress ipAddr) throws RemoteException {
        boolean _isHttps = Boolean.getBoolean("mds.web.http");
        String method = _isHttps ? "https://" : "http://";
        String port = System.getProperty("web.port");
        if (port == null) {
            port = _isHttps ? "443" : "80";
        }
        HttpURLConnection connection = null;
        boolean status = false;
        try {
            String inputLine;
            URL serverAddress = new URL(method + ipAddr.getHostAddress() + ":" + port);
            connection = null;
            connection = (HttpURLConnection)serverAddress.openConnection();
            connection.setReadTimeout(10000);
            connection.connect();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                if (!inputLine.contains("DCNM") && !inputLine.contains("Data Center Network Manager")) continue;
                status = true;
                break;
            }
            in.close();
        }
        catch (MalformedURLException e) {
            this._log.error((Object)("Server " + ipAddr.getHostAddress() + " is not responding: " + e.getLocalizedMessage()));
        }
        catch (IOException e) {
            if (e != null && e.getCause() instanceof ValidatorException) {
                status = true;
            }
            this._log.error((Object)("Server " + ipAddr.getHostAddress() + " is not responding: " + e.getLocalizedMessage()));
        }
        finally {
            connection.disconnect();
            connection = null;
        }
        return status;
    }

    public void setDirty() {
        _dirty.compareAndSet(false, true);
    }

    private FMServerRif getFMServerBean(String ipAddr) {
        String port = System.getProperty("server.port", "4447");
        try {
            return (FMServerRif)EjbRegistry.getInstance().getRemoteService(ipAddr, port, "FMServerBean", FMServerRif.class.getName());
        }
        catch (Exception e) {
            this._log.error((Object)("Error looking up Key Manager implementation connecting to " + ipAddr), (Throwable)e);
            return null;
        }
    }

    public void failover(InetAddress ip) {
        try {
            Set<Integer> pkset = GlobalFabricManager.getInstance().getAllFabricPKSet();
            List<Integer> sFids = ClusterMapping.getInstance().qFIdsFromIP(ip);
            String location = ClusterMapping.getInstance().getLocation(ip);
            for (Integer sFid : sFids) {
                InetAddress target = this.minLoadServer(location);
                if (target != null) {
                    FMServerRif fmtarget = this.getFMServerBean(target.getHostAddress());
                    int serverId = ClusterMapping.getInstance().qSIdFromIP(ip);
                    ClusterMapping.getInstance().deleteLOGIC(serverId, sFid);
                    if (pkset.contains(sFid)) {
                        FabricPK fpk = new FabricPK(sFid);
                        SnmpUser snmpUser = FabricImpl.getSnmpUser(fpk);
                        String userName = null;
                        if (snmpUser == null) {
                            this._log.error((Object)"No Snmp User available for fail over");
                        }
                        userName = snmpUser.getSecurityModel() == 3 ? ((UsmUser)snmpUser).getUserName() : ((CommunityUser)snmpUser).getCommunity();
                        fmtarget.moveFabric(fpk, false, SecurityManager.getSSOToken(userName, fmtarget.getServerTime()), true);
                        fmtarget.restart(4);
                        continue;
                    }
                    LanPK lanPK = new LanPK(sFid);
                    GlobalDCManager.getInstance().updateLanManageableByLanPK(false, lanPK);
                    this._log.info((Object)"ServerMonitor: calling FMServerRif moveLan ... ");
                    fmtarget.moveLan(lanPK, false, SecurityManager.getSSOToken("failover", fmtarget.getServerTime()));
                    this._log.info((Object)"ServerMonitor: after calling FMServerRif moveLan");
                    continue;
                }
                this._log.error((Object)"Can not find the target server for failover");
                break;
            }
            ClusterMapping.getInstance().updateStatus(ip, 2);
        }
        catch (Exception e) {
            this._log.error((Object)"Can not find the target server for failover", (Throwable)e);
        }
    }

    public void maintenance() {
        try {
            List<InetAddress> ips = ClusterMapping.getInstance().qUncompletedIPs(this._serverId);
            for (InetAddress ip : ips) {
                this.failover(ip);
            }
        }
        catch (Exception e) {
            this._log.error((Object)"Error maintenanceCheck ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InetAddress minLoadServer(String location) throws Exception {
        block13: {
            block12: {
                con = null;
                statf = null;
                statl = null;
                hmap = new HashMap<Integer, Long>();
                locations = new HashMap<Integer, String>();
                rsf = null;
                rsl = null;
                minSvr = 0;
                ip = null;
                tset = new TreeSet<Long>();
                allnone = location == null;
                try {
                    con = ConnectionManager.getConnection();
                    statf = con.prepareStatement("select tmp.ports, PHYSICAL_LOGICSVR.lsvr_id, PHYSICAL_LOGICSVR.location from PHYSICAL_LOGICSVR left outer join  (select count(*) as ports, logicsvr_fabric.lsvr_id from switch_port, switch, logicsvr_fabric, fabric  where switch_port.switch_id = switch.id and switch.fabric_id = fabric.id and logicsvr_fabric.f_id = fabric.fid group by logicsvr_fabric.lsvr_id) tmp on tmp.lsvr_id = PHYSICAL_LOGICSVR.lsvr_id where PHYSICAL_LOGICSVR.status=0");
                    rsf = statf.executeQuery();
lbl16:
                    // 4 sources

                    while (rsf.next()) {
                        ports = rsf.getLong(1);
                        sid = rsf.getInt(2);
                        hmap.put(sid, ports == null ? 0L : ports);
                        sloc = rsf.getString(3);
                        if (sloc == null) ** GOTO lbl48
                        if (location == null) {
                            var16_19 = null;
                            break block12;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl54
                }
                catch (SQLException ex) {
                    try {
                        this._log.warn((Object)ex.getMessage());
                        throw ex;
                    }
                    catch (Throwable var17_20) {
                        DbUtil.close(rsf);
                        DbUtil.close(rsl);
                        DbUtil.close(statf);
                        DbUtil.close(statl);
                        DbUtil.close(con);
                        throw var17_20;
                    }
                }
            }
            DbUtil.close(rsf);
            DbUtil.close(rsl);
            DbUtil.close(statf);
            DbUtil.close(statl);
            DbUtil.close(con);
            return var16_19;
lbl-1000:
            // 1 sources

            {
                block14: {
                    if (location.equalsIgnoreCase(sloc)) break block14;
                    ** GOTO lbl16
lbl48:
                    // 1 sources

                    if (location != null) ** GOTO lbl16
                    sloc = "None";
                }
                locations.put(sid, sloc);
                ** GOTO lbl16
lbl54:
                // 1 sources

                if (locations.size() != 0) ** GOTO lbl-1000
                ports = null;
            }
            DbUtil.close(rsf);
            DbUtil.close(rsl);
            DbUtil.close(statf);
            DbUtil.close(statl);
            DbUtil.close(con);
            return ports;
lbl-1000:
            // 1 sources

            {
                statl = con.prepareStatement("select tmp.ports, PHYSICAL_LOGICSVR.lsvr_id from PHYSICAL_LOGICSVR left outer join  (select count(*)  as ports, logicsvr_fabric.lsvr_id from ethswitch_port, ethswitch, lanswitch_map, lan, logicsvr_fabric where ethswitch_port.switch_id = ethswitch.id and ethswitch.id = lanswitch_map.id and lanswitch_map.lan_id = lan.id and lan.lan_id = logicsvr_fabric.f_id group by logicsvr_fabric.lsvr_id) tmp on tmp.lsvr_id = PHYSICAL_LOGICSVR.lsvr_id where PHYSICAL_LOGICSVR.status=0");
                rsl = statl.executeQuery();
                while (rsl.next()) {
                    svr = rsl.getInt(2);
                    if (locations.containsKey(svr)) {
                        count = (Long)hmap.get(svr);
                        ports = rsl.getLong(1);
                        ports = ports == null ? 0L : ports + count;
                        hmap.put(svr, ports);
                        continue;
                    }
                    hmap.remove(svr);
                }
                if (!hmap.isEmpty()) {
                    for (Map.Entry<K, V> me : hmap.entrySet()) {
                        key = (Integer)me.getKey();
                        tset.add((Long)me.getValue() * 10L + (long)key.intValue());
                    }
                }
                if (tset == null) break block13;
                minSvr = (int)((Long)tset.first() % 10L);
                ip = ClusterMapping.getInstance().qIPFromSId(minSvr);
            }
        }
        DbUtil.close(rsf);
        DbUtil.close(rsl);
        DbUtil.close(statf);
        DbUtil.close(statl);
        DbUtil.close(con);
        return ip;
    }

    public static void main(String[] strArgs) {
        try {
            boolean result = ServerMonitor.getInstance().pingHttpServer(InetAddress.getByName("dcnm-san-007"));
            System.out.println("dcnm-san-007: " + result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        _NoMonitor = false;
        _FailureDetectRetries = 0;
        _RetryInterval = 180000L;
        _Value = "1";
        _RetryIntervalStr = "180";
        _dirty = new AtomicBoolean();
        _failCount = new AtomicInteger();
    }

    public static class ServerConf
    implements Comparable<ServerConf> {
        long _portNum;
        boolean _sameLoc;

        ServerConf(long portNum, boolean sameLoc) {
            this._portNum = portNum;
            this._sameLoc = sameLoc;
        }

        @Override
        public int compareTo(ServerConf o) {
            int result = 0;
            if (this._sameLoc != o._sameLoc) {
                if (this._sameLoc) {
                    result = -1;
                } else if (o._sameLoc) {
                    result = 1;
                }
            } else {
                result = this._portNum < o._portNum ? -1 : (this._portNum == o._portNum ? 0 : 1);
            }
            return result;
        }
    }
}

