/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.analysis;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.server.analysis.BaseAnalysisReport;
import com.cisco.dcbu.sm.server.analysis.ReportProgressTracker;
import com.cisco.dcbu.sm.server.analysis.ServerObjectCache;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class ReportAnalysis {
    BaseAnalysisReport reportData;
    private boolean reportRunning;
    protected int percentCompleted;
    protected String status = "";
    protected String baseStatus = "";
    protected boolean errorInProcessing;
    protected Exception errorException;
    protected ArrayList warnings = new ArrayList();
    private boolean isStopped;
    private boolean cleanUpOnFinish = false;
    protected long startTime = System.currentTimeMillis();
    protected int reptId = -1;
    protected long maxRunTimeInMin = Long.MAX_VALUE;

    protected ReportAnalysis() {
        String exTime = System.getProperty("web.analysisReportTimeoutInterval", Long.toString(Long.MAX_VALUE));
        try {
            this.maxRunTimeInMin = Integer.parseInt(exTime);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ArrayList getReportData(int reptType) {
        return this.reportData != null ? this.reportData.getReportData() : null;
    }

    public ArrayList buildReportSynchronously(String vPKString, int fId, Object[] params, boolean ignoreVsan, long fdbId, long vsanDbId) throws Exception {
        ArrayList reportList = new ArrayList();
        ReportProgressTracker prTracker = new ReportProgressTracker(this);
        if (vPKString == null || vPKString.trim().length() == 0) {
            if (fId == -1) {
                FabricPK[] fPK = SanManager.getInstance().getFabricPKs();
                if (fPK != null) {
                    for (int k = 0; k < fPK.length; ++k) {
                        if (this.isStopped) {
                            return reportList;
                        }
                        prTracker.setCurTaskWeight((k + 1) * 100 / fPK.length);
                        this.buildReportSynchronously(fPK[k], reportList, params, ignoreVsan, prTracker, fdbId, vsanDbId);
                    }
                }
            } else {
                prTracker.setCurTaskWeight(95);
                this.buildReportSynchronously(new FabricPK(fId), reportList, params, ignoreVsan, prTracker, fdbId, vsanDbId);
            }
        } else {
            VsanPK[] vPk = ReportAnalysis.getVsanPK(vPKString);
            prTracker.setCurTaskWeight(95);
            if (this.isStopped) {
                return reportList;
            }
            this.buildReportSynchronously(vPk[0], new FabricPK(fId), reportList, params, prTracker, fdbId, vsanDbId);
        }
        return this.buildTextReport(reportList, params);
    }

    protected ArrayList buildTextReport(ArrayList encPairList) {
        return encPairList;
    }

    protected ArrayList buildTextReport(ArrayList encPairList, Object[] param) {
        return this.buildTextReport(encPairList);
    }

    protected boolean logUnlicensedFabric(FabricImpl fImpl) {
        boolean allowUnLicensedFabrics;
        String allow = System.getProperty("web.allowUnLicensedFabrics");
        boolean bl = allowUnLicensedFabrics = allow != null && Boolean.getBoolean(allow.trim()) == Boolean.TRUE;
        if (!allowUnLicensedFabrics && !fImpl.isLicensed()) {
            if (this.getLogger() != null) {
                this.getLogger().info((Object)("Skipping Unlicensed Fabric " + fImpl));
            } else {
                System.out.println("Skipping Unlicensed Fabric " + fImpl);
            }
            this.warnings.add("Skipping Unlicensed Fabric " + fImpl);
            return true;
        }
        return false;
    }

    public boolean logUnopenedFabric(FabricImpl fImpl) {
        if (fImpl.getFarbicStatus() != 2 && fImpl.getFarbicStatus() != 4) {
            if (this.getLogger() != null) {
                this.getLogger().info((Object)("Skipping Unopend Fabric " + fImpl));
            } else {
                System.out.println("Skipping Unopend Fabric " + fImpl);
            }
            this.warnings.add("Skipping Unopend Fabric " + fImpl);
            return false;
        }
        return true;
    }

    public void buildReportSynchronously(FabricPK fPk, ArrayList reportList, Object[] params, boolean ignoreVsan, ReportProgressTracker prTracker, long fdbId, long vsanDbId) throws Exception {
        FabricImpl fImpl = SanManager.getInstance().findFabric(fPk);
        if (fImpl != null) {
            if (this.logUnlicensedFabric(fImpl) && this.logUnopenedFabric(fImpl)) {
                return;
            }
            prTracker.setBaseStatus(fImpl.toString());
            int taskWt = prTracker.getCurTaskWeight();
            VsanImpl[] vImpl = fImpl.getVsans();
            if (vImpl != null && !ignoreVsan) {
                if (vImpl.length == 0) {
                    this.warnings.add("Fabric Id:" + fPk + " is not monitored.");
                    if (this.getLogger() != null) {
                        this.getLogger().info((Object)("Skipping Unmonitored Fabric ID:" + fPk));
                    }
                    return;
                }
                for (int k = 0; k < vImpl.length; ++k) {
                    if (this.isStopped) {
                        return;
                    }
                    prTracker.setCurTaskWeight(taskWt * (k + 1) / vImpl.length);
                    prTracker.setBaseStatus(fImpl.toString() + " " + vImpl[k].getName());
                    this.buildReportSynchronously(((VsanBase)vImpl[k].getBaseObject()).getVsanPK(), fPk, reportList, params, prTracker, fdbId, vsanDbId);
                }
            } else {
                prTracker.setCurTaskWeight(taskWt);
                if (this.isStopped) {
                    return;
                }
                this.buildReportSynchronously(null, fPk, reportList, params, prTracker, fdbId, vsanDbId);
            }
        } else {
            this.warnings.add("Fabric Id:" + fPk + " is not monitored.");
            if (this.getLogger() != null) {
                this.getLogger().info((Object)("Skipping Unmonitored Fabric ID:" + fPk));
            }
        }
    }

    public void buildReportSynchronously(VsanPK vPk, FabricPK fPk, ArrayList reportList, Object[] params, ReportProgressTracker prTracker, long fdbId, long vsanDbId) throws Exception {
        System.out.println("Override this function buildReportSynchronously(VsanPK vPk, FabricPK fPk, ArrayList reportList, Object[] params) ");
    }

    public void clearReport() {
        this.reportData = null;
    }

    public void cleanUpExistingReport() {
        this.reportData = null;
        this.warnings.clear();
    }

    public synchronized void setReportData(BaseAnalysisReport reportData) {
        this.reportData = reportData;
    }

    public boolean isReportRunning() {
        return this.reportRunning;
    }

    public synchronized void setReportRunning(boolean reportRunning) {
        this.reportRunning = reportRunning;
    }

    public synchronized int getPercentCompleted() {
        return this.percentCompleted;
    }

    public synchronized void setPercentCompleted(int percentCompleted) {
        this.percentCompleted = percentCompleted;
    }

    public synchronized String getStatus() {
        return this.status;
    }

    public synchronized void setStatus(String status) {
        this.status = status;
        if (this.getLogger() != null) {
            this.getLogger().debug((Object)("Report Status:" + status));
        }
    }

    public synchronized void setBaseStatus(String status) {
        this.baseStatus = status;
    }

    public synchronized void appendStatus(String status) {
        this.status = this.baseStatus + " " + status;
        if (this.getLogger() != null) {
            this.getLogger().debug((Object)("Report Status:" + status));
        }
    }

    protected Logger getLogger() {
        return null;
    }

    protected void initNewReport() {
        this.cleanUpExistingReport();
        this.setPercentCompleted(0);
    }

    public static char[] replaceDashWithColon(String vsanPKString) {
        char[] ch = vsanPKString.toCharArray();
        if (ch != null) {
            for (int i = 0; i < ch.length; ++i) {
                if (ch[i] != '-') continue;
                ch[i] = 58;
            }
        }
        return ch;
    }

    public static VsanPK[] getVsanPK(String vsanAndPKString) {
        VsanPK[] vPK = null;
        if (vsanAndPKString == null) {
            return vPK;
        }
        char[] chV = ReportAnalysis.replaceDashWithColon(vsanAndPKString);
        String vsanPKString = chV != null ? new String(chV) : "";
        int firstColon = vsanPKString.trim().indexOf(":");
        if (firstColon != -1 && vsanPKString.length() > firstColon) {
            try {
                String vsanIdString = vsanPKString.substring(0, firstColon);
                int v = Integer.parseInt(vsanIdString);
                Wwn swWwn = new Wwn(vsanPKString.substring(firstColon + 1), true);
                vPK = new VsanPK[]{new VsanPK(v, swWwn)};
            }
            catch (Exception ex) {
                System.out.println("Data error:" + ex.getMessage());
            }
        }
        return vPK;
    }

    public Exception getErrorException() {
        return this.errorException;
    }

    public boolean isErrorInProcessing() {
        return this.errorInProcessing;
    }

    public abstract ArrayList generateReportSynchronously(int var1, String var2, Object[] var3, int var4, long var5, long var7) throws Exception;

    public abstract void generateReportAsynchronously(int var1, String var2, Object[] var3, int var4, int var5, long var6, long var8);

    public void stopReport() {
        this.isStopped = true;
    }

    public ArrayList getWarnings() {
        return this.warnings;
    }

    public void setStopped(boolean isStopped) {
        if (isStopped) {
            this.warnings.add("Report is being stopped");
        }
        this.isStopped = isStopped;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public long getMaxRunTimeInMin() {
        return this.maxRunTimeInMin;
    }

    public void setMaxRunTimeInMin(long maxRunTimeInMin) {
        this.maxRunTimeInMin = maxRunTimeInMin;
    }

    protected boolean exceedsAllowedRunTime() {
        long curTime = System.currentTimeMillis();
        return (curTime - this.startTime) / 1000L / 60L > this.maxRunTimeInMin;
    }

    public String getReportStartTime() {
        return new Date(this.startTime).toString();
    }

    public long getReportRunTime() {
        long curTime = System.currentTimeMillis();
        return (curTime - this.startTime) / 1000L / 60L;
    }

    public boolean isCleanUpOnFinish() {
        return this.cleanUpOnFinish;
    }

    public void setCleanUpOnFinish(boolean cleanUpOnFinish) {
        this.cleanUpOnFinish = cleanUpOnFinish;
    }

    protected void buildIvrRegionWarning(int regionId) {
        this.warnings.add("Multiple IVR CFS regions configured in fabric.  IVR zones from region" + regionId + " are considered in this analysis.\n" + "IVR CFS regions can be modified by going to logical tree/IVR/CFS tab.");
        if (this.getLogger() != null) {
            this.getLogger().info((Object)("Multiple IVR CFS regions configured in fabric.  IVR zones from region" + regionId + " are considered in this analysis.\n" + "IVR CFS regions can be modified by going to logical tree/IVR/CFS tab."));
        }
    }

    protected Object[] getFirstIVREnfocedZoneAndRegionID(FabricImpl fImpl) {
        ArrayList regionIds = fImpl.getAllIvrEnforcedZoneSetRegionIds();
        if (regionIds != null && regionIds.size() > 0) {
            Integer regionId = (Integer)regionIds.get(0);
            return new Object[]{regionId, fImpl.getIvrEnforcedZones(regionId)};
        }
        return null;
    }

    protected class RunReportThread
    implements Runnable {
        BaseAnalysisReport thReport;
        boolean asynchronous;

        public RunReportThread(boolean asynchronous) {
            this.asynchronous = asynchronous;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ReportAnalysis.this.startTime = System.currentTimeMillis();
            ReportAnalysis.this.setReportRunning(true);
            ReportAnalysis.this.errorException = null;
            ReportAnalysis.this.errorInProcessing = false;
            ReportAnalysis.this.warnings.clear();
            try {
                this.thReport = this.doAction();
            }
            catch (Exception ex) {
                ReportAnalysis.this.errorException = ex;
                ex.printStackTrace();
                Logger.getLogger((String)"FM.WebReport").debug((Object)ex.getStackTrace());
                ReportAnalysis.this.errorInProcessing = true;
            }
            finally {
                ReportAnalysis.this.setReportRunning(false);
                if (this.thReport != null) {
                    this.thReport.setReportTime(new Date());
                }
                if (ReportAnalysis.this.cleanUpOnFinish) {
                    ServerObjectCache.modifyCachedObjectMap(false, -1, ReportAnalysis.this.reptId, null);
                }
                ReportAnalysis.this.setReportData(this.thReport);
            }
        }

        protected BaseAnalysisReport doAction() throws Exception {
            return new BaseAnalysisReport(-1, null, -1);
        }

        public BaseAnalysisReport getThReport() {
            return this.thReport;
        }
    }
}

