/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.bean;

import com.cisco.dcbu.sm.common.rif.CapacityRif;
import com.cisco.dcbu.sm.server.bean.CapacityMBean;
import com.cisco.dcbu.sm.server.inventory.CapacityManager;
import com.cisco.dcbu.sm.server.scheduler.SchedulerManagerImpl;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.DependsOn;
import javax.ejb.Remote;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.quartz.JobDataMap;
import org.quartz.SchedulerException;

@Remote(value={CapacityRif.class})
@DependsOn(value={"user:service=QuartzService,name=QuartzService"})
@Singleton
@Startup
public class Capacity
extends CapacityManager
implements CapacityMBean {
    static Logger _Logger = Logger.getLogger((String)"Capacity");
    public static final int SCHEDULE_SUCCESS = 0;
    public static final int SCHEDULE_DUPLICATE_NAME = -1;
    public static final int SCHEDULE_UNDEFINED_JOB_TYPE = -2;
    public static final int CAPACITY_JOB = 8;
    public static final int RUN_ONCE = 1;
    public static final int RUN_DAILY = 2;
    public static final int RUN_TEST = 4;
    public static final int ONE_HOUR = 3600000;
    String _JobName = null;
    private MBeanServer platformMBeanServer;
    private ObjectName objectName = null;

    public void create() throws Exception {
    }

    @Override
    @PostConstruct
    public void start() throws Exception {
        _Logger.info((Object)"Capacity service bean starting....");
        this.registerInJMX();
        try {
            JobDataMap jobStatesMap = new JobDataMap();
            this._JobName = "capacity_job_" + InetAddress.getLocalHost().getHostName();
            Date startDate = new Date(System.currentTimeMillis() + 3600000L);
            SchedulerManagerImpl.getInstance().deleteJob(this._JobName);
            int scheduleResultCode = SchedulerManagerImpl.getInstance().scheduleJob(2, 8, this._JobName, jobStatesMap, startDate, null, true);
            if (scheduleResultCode != 0) {
                _Logger.warn((Object)("Error: Job " + this._JobName + " scheduling failed"));
            } else {
                _Logger.info((Object)("Sucessfully scheduled job " + this._JobName + "."));
            }
        }
        catch (SchedulerException e) {
            _Logger.warn((Object)("Error: " + e.getMessage()));
        }
        catch (Exception e) {
            _Logger.warn((Object)("Error: " + e.getMessage()));
        }
    }

    @Override
    @PreDestroy
    public void stop() {
        _Logger.info((Object)"Capacity service bean stopping....");
        this.unregisterFromJMX();
        try {
            SchedulerManagerImpl.getInstance().deleteJob(this._JobName);
        }
        catch (Exception e) {
            _Logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
    }

    public void registerInJMX() {
        try {
            _Logger.warn((Object)"********* Registering dcm:service=Capacity");
            this.objectName = new ObjectName("dcm:service=Capacity");
            this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.platformMBeanServer.registerMBean(this, this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during registration of Monitoring into JMX:" + e);
        }
    }

    public void unregisterFromJMX() {
        try {
            this.platformMBeanServer.unregisterMBean(this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during unregistration of Monitoring into JMX:" + e);
        }
    }
}

