/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.bean;

import com.cisco.dcbu.sm.server.bean.ILog4jMXBean;
import java.lang.management.ManagementFactory;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

@Singleton
@Startup
public class MXLog4jMgr
implements ILog4jMXBean {
    private MBeanServer platformMBeanServer;
    private ObjectName objectName = null;

    @Override
    @PostConstruct
    public void start() {
        this.registerInJMX();
    }

    @Override
    @PreDestroy
    public void stop() {
        this.unregisterFromJMX();
    }

    public void registerInJMX() {
        try {
            this.objectName = new ObjectName("dcm:service=LogMgr");
            this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.platformMBeanServer.registerMBean(this, this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during registration of Monitoring into JMX:" + e);
        }
    }

    public void unregisterFromJMX() {
        try {
            this.platformMBeanServer.unregisterMBean(this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during unregistration of Monitoring into JMX:" + e);
        }
    }

    @Override
    public void setLoggerLevel(String logger, String level) {
        Level newLevel = Level.toLevel((String)level);
        Logger _Logger = Logger.getLogger((String)logger);
        _Logger.setLevel(newLevel);
    }
}

