/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.bean;

import com.cisco.dcbu.sm.common.rif.DDMCreationRif;
import com.cisco.dcbu.sm.common.rif.DDMServerRif;
import com.cisco.dcbu.sm.common.rif.ESPRif;
import com.cisco.dcbu.sm.common.rif.FCoEConfigurationRif;
import com.cisco.dcbu.sm.common.rif.FlexAtahRif;
import com.cisco.dcbu.sm.common.rif.IOARif;
import com.cisco.dcbu.sm.common.rif.ModelFacadeRif;
import com.cisco.dcbu.sm.common.rif.SecureEraseRif;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.server.facade.DDMServerImpl;
import com.cisco.dcbu.sm.server.facade.ESPImpl;
import com.cisco.dcbu.sm.server.facade.FCoEConfigurationImpl;
import com.cisco.dcbu.sm.server.facade.FlexAtahImpl;
import com.cisco.dcbu.sm.server.facade.IOAImpl;
import com.cisco.dcbu.sm.server.facade.ModelFacadeImpl;
import com.cisco.dcbu.sm.server.facade.SecureEraseImpl;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.interceptor.InvocationContext;
import org.apache.log4j.Logger;

public class SessionHelper {
    transient Field _wrappedField = null;
    transient Field _metadataField = null;
    transient ThreadLocal<String> _sessionIdObj;
    transient HashMap<String, SessionRif> _sessionMap = new HashMap();
    transient HashMap<String, DDMServerRif> _dmmServerMap = new HashMap();
    transient HashMap<String, DDMCreationRif> _dmmCreationMap = new HashMap();
    transient HashMap<String, SecureEraseRif> _secureEraseMap = new HashMap();
    transient HashMap<String, ModelFacadeRif> _modelFacadeMap = new HashMap();
    transient HashMap<String, FlexAtahRif> _flexAtahMap = new HashMap();
    transient HashMap<String, ESPRif> _espMap = new HashMap();
    transient HashMap<String, IOARif> _ioaMap = new HashMap();
    transient HashMap<String, FCoEConfigurationRif> _fcoeConfigurationMap = new HashMap();
    private static SessionHelper _instance;
    static Logger _log;

    private SessionHelper() {
        if (!Boolean.getBoolean("fm.standalone")) {
            this._sessionIdObj = new ThreadLocal();
        }
    }

    private void init() {
        Class<?> classObj;
        try {
            this._sessionIdObj = new ThreadLocal();
            classObj = Class.forName("org.jboss.ejb3.interceptor.InvocationContextImpl");
            this._wrappedField = classObj.getDeclaredField("wrapped");
            this._wrappedField.setAccessible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            classObj = Class.forName("org.jboss.aop.joinpoint.InvocationBase");
            this._metadataField = classObj.getDeclaredField("metadata");
            this._metadataField.setAccessible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionHelper getInstance() {
        if (_instance == null) {
            Logger logger = _log;
            synchronized (logger) {
                if (_instance == null) {
                    _instance = new SessionHelper();
                }
            }
        }
        return _instance;
    }

    public void setSessionId(InvocationContext ctx, Logger logger) {
        String obj = null;
        obj = (String)ctx.getContextData().get("SESSIONID");
        if (this._sessionIdObj != null && obj != null) {
            this._sessionIdObj.set(obj);
        }
    }

    public String getSessionId() {
        String sessionId = this._sessionIdObj == null ? null : this._sessionIdObj.get();
        return sessionId;
    }

    public void register(DDMCreationRif rif) {
        this._dmmCreationMap.put(this.getSessionId(), rif);
    }

    public void register(SecureEraseRif rif) {
        this._secureEraseMap.put(this.getSessionId(), rif);
    }

    public void register(FlexAtahRif rif) {
        this._flexAtahMap.put(this.getSessionId(), rif);
    }

    public void registerSession(String sessionId, SessionRif rif) {
        this._sessionMap.put(sessionId, rif);
    }

    public void removeSession() {
        this.removeSession(this.getSessionId());
    }

    public void removeSession(String id) {
        this._sessionMap.remove(id);
        this._dmmServerMap.remove(id);
        this._modelFacadeMap.remove(id);
        this._dmmCreationMap.remove(id);
        this._flexAtahMap.remove(id);
        this._secureEraseMap.remove(id);
        this._espMap.remove(id);
        this._ioaMap.remove(id);
        this._fcoeConfigurationMap.remove(id);
    }

    public SessionRif getSession() {
        return this._sessionMap.get(this.getSessionId());
    }

    public SessionRif getSession(String sessionId) {
        return this._sessionMap.get(sessionId);
    }

    public DDMServerRif getDDMServer() throws RemoteException {
        DDMServerRif ret;
        if (this.getSessionId() == null) {
            _log.debug((Object)" no session id is passed");
        }
        if ((ret = this._dmmServerMap.get(this.getSessionId())) == null) {
            ret = new DDMServerImpl(true);
            ((DDMServerImpl)ret).init(this.getSession());
            this._dmmServerMap.put(this.getSessionId(), ret);
        }
        return ret;
    }

    public FlexAtahRif getFlexAtah() throws RemoteException {
        FlexAtahRif ret;
        if (this.getSessionId() == null) {
            _log.debug((Object)"flexAtach: no session id is passed");
        }
        if ((ret = this._flexAtahMap.get(this.getSessionId())) == null) {
            ret = new FlexAtahImpl(true);
            ((FlexAtahImpl)ret).init(this.getSession());
            this._flexAtahMap.put(this.getSessionId(), ret);
        }
        return ret;
    }

    public ModelFacadeRif getModelFacade() throws RemoteException {
        ModelFacadeRif ret;
        if (this.getSessionId() == null) {
            _log.debug((Object)" no session id is passed");
        }
        if ((ret = this._modelFacadeMap.get(this.getSessionId())) == null) {
            ret = new ModelFacadeImpl(true);
            ((ModelFacadeImpl)ret).init(this.getSession());
            this._modelFacadeMap.put(this.getSessionId(), ret);
        }
        return ret;
    }

    public DDMCreationRif getDDMCreation() throws RemoteException {
        if (this.getSessionId() == null) {
            _log.debug((Object)" no session id is passed");
        }
        DDMCreationRif ret = this._dmmCreationMap.get(this.getSessionId());
        return ret;
    }

    public SecureEraseRif getSecureErase() throws RemoteException {
        SecureEraseRif ret;
        if (this.getSessionId() == null) {
            _log.debug((Object)" no session id is passed");
        }
        if ((ret = this._secureEraseMap.get(this.getSessionId())) == null) {
            ret = new SecureEraseImpl(true);
            ((SecureEraseImpl)ret).init(this.getSession());
            this._secureEraseMap.put(this.getSessionId(), ret);
        }
        return ret;
    }

    public ESPRif getESP() throws RemoteException {
        ESPRif ret;
        if (this.getSessionId() == null) {
            _log.debug((Object)" no session id is passed");
        }
        if ((ret = this._espMap.get(this.getSessionId())) == null) {
            ret = new ESPImpl();
            ((ESPImpl)ret).init(this.getSession());
            this._espMap.put(this.getSessionId(), ret);
        }
        return ret;
    }

    public IOARif getIOA() throws RemoteException {
        IOARif ret;
        if (this.getSessionId() == null) {
            _log.debug((Object)" no session id is passed");
        }
        if ((ret = this._ioaMap.get(this.getSessionId())) == null) {
            ret = new IOAImpl();
            ((IOAImpl)ret).init(this.getSession());
            this._ioaMap.put(this.getSessionId(), ret);
        }
        return ret;
    }

    public FCoEConfigurationRif getFCoEConfiguration() throws RemoteException {
        FCoEConfigurationRif ret;
        if (this.getSessionId() == null) {
            _log.debug((Object)" no session id is passed");
        }
        if ((ret = this._fcoeConfigurationMap.get(this.getSessionId())) == null) {
            ret = new FCoEConfigurationImpl();
            ((FCoEConfigurationImpl)ret).init(this.getSession());
            this._fcoeConfigurationMap.put(this.getSessionId(), ret);
        }
        return ret;
    }

    static {
        _log = Logger.getLogger(SessionHelper.class);
    }
}

