/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.bean;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.EthIslBase;
import com.cisco.dcbu.sm.common.model.EthSwitchBase;
import com.cisco.dcbu.sm.common.model.GroupBase;
import com.cisco.dcbu.sm.common.model.IslBase;
import com.cisco.dcbu.sm.common.model.NpvLinkBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.rif.TopologyLocal;
import com.cisco.dcbu.sm.common.rif.TopologyManager;
import com.cisco.dcbu.sm.common.rif.TopologyRemote;
import com.cisco.dcbu.sm.common.topology.dto.TopoAbstractDto;
import com.cisco.dcbu.sm.common.topology.dto.TopoEdgeLinkDto;
import com.cisco.dcbu.sm.common.topology.dto.TopoEnclosureDto;
import com.cisco.dcbu.sm.common.topology.dto.TopoEthIslDto;
import com.cisco.dcbu.sm.common.topology.dto.TopoEthSwitchDto;
import com.cisco.dcbu.sm.common.topology.dto.TopoHubDto;
import com.cisco.dcbu.sm.common.topology.dto.TopoIslDto;
import com.cisco.dcbu.sm.common.topology.dto.TopoNpvLinkDto;
import com.cisco.dcbu.sm.common.topology.dto.TopoNxPortDto;
import com.cisco.dcbu.sm.common.topology.dto.TopoSwitchDto;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.GroupPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.visio.VisioEdgeLinkIntf;
import com.cisco.dcbu.sm.common.visio.VisioExportAdapter2;
import com.cisco.dcbu.sm.common.visio.VisioGraph;
import com.cisco.dcbu.sm.common.visio.VisioGraphIntf;
import com.cisco.dcbu.sm.common.visio.VisioIslLinkIntf;
import com.cisco.dcbu.sm.common.visio.VisioLayoutServer2;
import com.cisco.dcbu.sm.common.visio.VisioLinkIntf;
import com.cisco.dcbu.sm.common.visio.VisioLoopLink;
import com.cisco.dcbu.sm.common.visio.VisioLoopNodeIntf;
import com.cisco.dcbu.sm.common.visio.VisioMapFactory;
import com.cisco.dcbu.sm.common.visio.VisioNode;
import com.cisco.dcbu.sm.common.visio.VisioNodeIntf;
import com.cisco.dcbu.sm.common.visio.VisioSwitchNodeIntf;
import com.cisco.dcbu.sm.server.bean.TopologyBeanMBean;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.EthIslImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.GroupManager;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.NpvLinkImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.management.ManagementFactory;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Remote;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

@Remote(value={TopologyRemote.class})
@Singleton
@Startup
public class TopologyBean
implements TopologyLocal,
TopologyRemote,
TopologyManager,
TopologyBeanMBean {
    public static final int TOOLTIP_LINE_LENGTH = 60;
    private MBeanServer platformMBeanServer;
    private ObjectName objectName = null;
    Logger logger = Logger.getLogger((String)"fms");
    String fabricName = null;
    int maxNodes = 3000;

    public GroupBase getGroup(int fabricID, String groupName) {
        GroupPK groupPK = new GroupPK(new FabricPK(fabricID), groupName);
        GroupBase group = GroupManager.getInstance().getGroup(groupPK);
        return group;
    }

    public GroupBase getGroup(long groupDBID) {
        GroupBase[] groups = GroupManager.getInstance().getGroups();
        for (int i = 0; i < groups.length; ++i) {
            if (groups[i].getDBID() != groupDBID) continue;
            return groups[i];
        }
        return null;
    }

    public VsanImpl[] getVsans(int fabricID, int vsanID) throws RemoteException {
        FabricImpl fabric = SanManager.getInstance().findFabric(new FabricPK(fabricID));
        if (fabric == null) {
            RemoteException remoteException = new RemoteException("Cannot generate visio diagram.  Fabric no longer exists or is not managed: fabric=" + this.fabricName);
            this.logger.debug((Object)remoteException);
            throw remoteException;
        }
        return fabric.findVsan(vsanID);
    }

    public TopoEthSwitchDto[] getEthSwitches() throws RemoteException {
        TopoEthSwitchDto[] topoEthSwitchDto = null;
        ArrayList<EthSwitchImpl> allSwitches = new ArrayList<EthSwitchImpl>();
        try {
            List<EthSwitchImpl> switchList;
            LanImpl lanImpl;
            DCManager dcManager = DCManager.getInstance();
            if (dcManager != null && (lanImpl = dcManager.getLan()) != null && (switchList = lanImpl.getEthSwitches()) != null) {
                allSwitches.addAll(switchList);
            }
        }
        catch (Exception ex) {
            this.logger.debug((Object)ex);
            throw new RemoteException("Cannot get ethernet switches", ex);
        }
        if (allSwitches != null && allSwitches.size() > 0) {
            topoEthSwitchDto = new TopoEthSwitchDto[allSwitches.size()];
            for (int i = 0; i < allSwitches.size(); ++i) {
                topoEthSwitchDto[i] = this.createTopoEthSwitchDto((EthSwitchImpl)allSwitches.get(i));
            }
        }
        if (topoEthSwitchDto == null) {
            topoEthSwitchDto = new TopoEthSwitchDto[]{};
        }
        this.logger.debug((Object)("getEthSwiches numSwitches=" + topoEthSwitchDto.length));
        return topoEthSwitchDto;
    }

    public TopoEthIslDto[] getEthIsls() throws RemoteException {
        TopoEthIslDto[] topoEthIslDto = null;
        ArrayList<EthIslImpl> allIsls = new ArrayList<EthIslImpl>();
        try {
            List<EthIslImpl> switchList;
            LanImpl lanImpl;
            DCManager dcManager = DCManager.getInstance();
            if (dcManager != null && (lanImpl = dcManager.getLan()) != null && (switchList = lanImpl.getEthIsls()) != null) {
                allIsls.addAll(switchList);
            }
        }
        catch (Exception ex) {
            this.logger.debug((Object)ex);
            throw new RemoteException("Cannot get ethernet isls", ex);
        }
        if (allIsls != null && allIsls.size() > 0) {
            topoEthIslDto = new TopoEthIslDto[allIsls.size()];
            for (int i = 0; i < allIsls.size(); ++i) {
                topoEthIslDto[i] = this.createTopoEthIslDto((EthIslImpl)allIsls.get(i));
            }
        }
        if (topoEthIslDto == null) {
            topoEthIslDto = new TopoEthIslDto[]{};
        }
        this.logger.debug((Object)("getEthIsls numIsls=" + topoEthIslDto.length));
        return topoEthIslDto;
    }

    @Override
    public String getUri() throws RemoteException {
        return GenUtil.getWebServerPath();
    }

    public TopoSwitchDto[] getAllSwitches() throws RemoteException {
        TopoSwitchDto[] topoSwitches = null;
        ArrayList<SwitchImpl> allSwitches = new ArrayList<SwitchImpl>();
        try {
            FabricImpl[] fabrics = SanManager.getInstance().getFabrics();
            FabricImpl fabric = null;
            if (fabrics != null) {
                for (int i = 0; i < fabrics.length; ++i) {
                    SwitchImpl[] fcSwitchList;
                    fabric = fabrics[i];
                    if (fabric == null || !SanManager.getInstance().isOpened(fabric.getPK()) || (fcSwitchList = fabric.getSwitches()) == null || fcSwitchList.length <= 0) continue;
                    for (int j = 0; j < fcSwitchList.length; ++j) {
                        allSwitches.add(fcSwitchList[j]);
                    }
                }
            }
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            this.logger.debug((Object)ex);
            throw new RemoteException("Cannot get switches", ex);
        }
        if (allSwitches != null && allSwitches.size() > 0) {
            topoSwitches = new TopoSwitchDto[allSwitches.size()];
            for (int i = 0; i < allSwitches.size(); ++i) {
                topoSwitches[i] = this.createTopoSwitchDto((SwitchImpl)allSwitches.get(i));
            }
        }
        if (topoSwitches == null) {
            topoSwitches = new TopoSwitchDto[]{};
        }
        this.logger.debug((Object)("getAllSwitches numSwitches=" + topoSwitches.length));
        return topoSwitches;
    }

    public TopoIslDto[] getAllIsls() throws RemoteException {
        TopoIslDto[] topoIsls = null;
        ArrayList<IslImpl> allIsls = new ArrayList<IslImpl>();
        try {
            FabricImpl[] fabrics = SanManager.getInstance().getFabrics();
            FabricImpl fabric = null;
            if (fabrics != null) {
                for (int i = 0; i < fabrics.length; ++i) {
                    IslImpl[] islList;
                    fabric = fabrics[i];
                    if (fabric == null || !SanManager.getInstance().isOpened(fabric.getPK()) || (islList = fabric.getIsls()) == null || islList.length <= 0) continue;
                    for (int j = 0; j < islList.length; ++j) {
                        allIsls.add(islList[j]);
                    }
                }
            }
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            this.logger.debug((Object)ex);
            throw new RemoteException("Cannot get isls", ex);
        }
        if (allIsls != null && allIsls.size() > 0) {
            topoIsls = new TopoIslDto[allIsls.size()];
            for (int i = 0; i < allIsls.size(); ++i) {
                topoIsls[i] = this.createTopoIslDto((IslImpl)allIsls.get(i));
            }
        }
        if (topoIsls == null) {
            topoIsls = new TopoIslDto[]{};
        }
        this.logger.debug((Object)("getAllIsls numIsls=" + topoIsls.length));
        return topoIsls;
    }

    public TopoNpvLinkDto[] getAllNpvLinks() throws RemoteException {
        TopoNpvLinkDto[] topoNpvLinks = null;
        ArrayList<NpvLinkImpl> allNpvLinks = new ArrayList<NpvLinkImpl>();
        try {
            FabricImpl[] fabrics = SanManager.getInstance().getFabrics();
            FabricImpl fabric = null;
            if (fabrics != null) {
                for (int i = 0; i < fabrics.length; ++i) {
                    NpvLinkImpl[] npvLinkList;
                    fabric = fabrics[i];
                    if (fabric == null || !SanManager.getInstance().isOpened(fabric.getPK()) || (npvLinkList = fabric.getNpvLinks()) == null || npvLinkList.length <= 0) continue;
                    for (int j = 0; j < npvLinkList.length; ++j) {
                        allNpvLinks.add(npvLinkList[j]);
                    }
                }
            }
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            this.logger.debug((Object)ex);
            throw new RemoteException("Cannot get isls", ex);
        }
        if (allNpvLinks != null && allNpvLinks.size() > 0) {
            topoNpvLinks = new TopoNpvLinkDto[allNpvLinks.size()];
            for (int i = 0; i < allNpvLinks.size(); ++i) {
                topoNpvLinks[i] = this.createTopoNpvLinkDto((NpvLinkImpl)allNpvLinks.get(i));
            }
        }
        if (topoNpvLinks == null) {
            topoNpvLinks = new TopoNpvLinkDto[]{};
        }
        this.logger.debug((Object)("getAllNpvLinks numNpvLinks=" + topoNpvLinks.length));
        return topoNpvLinks;
    }

    @Override
    public TopoSwitchDto[] getSwitches(int fabricID) throws RemoteException {
        TopoSwitchDto[] topoSwitches = null;
        try {
            FabricImpl fabric = SanManager.getInstance().findFabric(new FabricPK(fabricID));
            if (fabric == null) {
                RemoteException remoteException = new RemoteException("Cannot generate visio diagram.  Fabric no longer exists or is not managed: fabric=" + this.fabricName);
                this.logger.debug((Object)remoteException);
                throw remoteException;
            }
            if (!SanManager.getInstance().isOpened(new FabricPK(fabricID))) {
                RemoteException remoteException = new RemoteException("Cannot generate visio diagram.  Fabric is not managed: fabric=" + this.fabricName);
                this.logger.debug((Object)remoteException);
                throw remoteException;
            }
            SwitchImpl[] fcSwitchList = fabric.getSwitches();
            if (fcSwitchList != null && fcSwitchList.length > 0) {
                topoSwitches = new TopoSwitchDto[fcSwitchList.length];
                for (int i = 0; i < fcSwitchList.length; ++i) {
                    topoSwitches[i] = this.createTopoSwitchDto(fcSwitchList[i]);
                }
            }
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            this.logger.debug((Object)ex);
            throw new RemoteException("Cannot get switches", ex);
        }
        if (topoSwitches == null) {
            topoSwitches = new TopoSwitchDto[]{};
        }
        this.logger.debug((Object)("getSwitches fabric=" + this.fabricName + " numSwitches=" + topoSwitches.length));
        return topoSwitches;
    }

    public TopoEthIslDto createTopoEthIslDto(EthIslImpl islImpl) {
        EthIslBase islBase = (EthIslBase)islImpl.getBaseObject();
        TopoEthIslDto topoIslDto = new TopoEthIslDto(islBase);
        topoIslDto.setSwitch1PK(islImpl.getSwitch1().getSwitchPK());
        topoIslDto.setSwitch2PK(islImpl.getSwitch2().getSwitchPK());
        topoIslDto.setSwitch1Name(islImpl.getSwitch1().getName());
        topoIslDto.setSwitch2Name(islImpl.getSwitch2().getName());
        topoIslDto.setIfIndex1Name(islImpl.getIfIndex1Name());
        topoIslDto.setIfIndex2Name(islImpl.getIfIndex2Name());
        topoIslDto.setPresent(islImpl.isPresent());
        topoIslDto.setStatus(islImpl.getStatus());
        return topoIslDto;
    }

    public TopoEthSwitchDto createTopoEthSwitchDto(EthSwitchImpl switchImpl) {
        EthSwitchBase switchBase = (EthSwitchBase)switchImpl.getBaseObject();
        TopoEthSwitchDto topoSwitchDto = new TopoEthSwitchDto(switchBase);
        topoSwitchDto.setName(switchImpl.getName());
        return topoSwitchDto;
    }

    public TopoSwitchDto createTopoSwitchDto(SwitchImpl switchImpl) {
        SwitchBase switchBase = (SwitchBase)switchImpl.getBaseObject();
        TopoSwitchDto topoSwitchDto = new TopoSwitchDto(switchBase);
        topoSwitchDto.setName(switchImpl.getName());
        return topoSwitchDto;
    }

    @Override
    public TopoIslDto[] getIsls(int fabricID) {
        TopoIslDto[] topoIsls = new TopoIslDto[]{};
        FabricImpl fabric = SanManager.getInstance().findFabric(new FabricPK(fabricID));
        if (fabric == null) {
            return topoIsls;
        }
        IslImpl[] islList = fabric.getIsls();
        IslImpl islImpl = null;
        if (islList != null && islList.length > 0) {
            topoIsls = new TopoIslDto[islList.length];
            for (int i = 0; i < islList.length; ++i) {
                islImpl = islList[i];
                if (islImpl == null) continue;
                if (islImpl.getSwitch1() != null && islImpl.getSwitch2() != null) {
                    topoIsls[i] = this.createTopoIslDto(islImpl);
                    continue;
                }
                this.logger.warn((Object)("getIsls() islImpl.getSwitch1()==null or islImpl.getSwitch2()==null, islImpl=" + islImpl.getPK()), (Throwable)new NullPointerException());
            }
        }
        if (topoIsls == null) {
            topoIsls = new TopoIslDto[]{};
        }
        this.logger.debug((Object)("getIsls fabric=" + this.fabricName + " numIsls=" + topoIsls.length));
        return topoIsls;
    }

    public TopoNpvLinkDto[] getNpvLinks(int fabricID) {
        TopoNpvLinkDto[] topoNpvLinks = new TopoNpvLinkDto[]{};
        FabricImpl fabric = SanManager.getInstance().findFabric(new FabricPK(fabricID));
        if (fabric == null) {
            return topoNpvLinks;
        }
        NpvLinkImpl[] npvLinkList = fabric.getNpvLinks();
        if (npvLinkList != null && npvLinkList.length > 0) {
            topoNpvLinks = new TopoNpvLinkDto[npvLinkList.length];
            for (int i = 0; i < npvLinkList.length; ++i) {
                topoNpvLinks[i] = this.createTopoNpvLinkDto(npvLinkList[i]);
            }
        }
        if (topoNpvLinks == null) {
            topoNpvLinks = new TopoNpvLinkDto[]{};
        }
        this.logger.debug((Object)("getNpvLinks fabric=" + this.fabricName + " numNpvLinks=" + topoNpvLinks.length));
        return topoNpvLinks;
    }

    public TopoIslDto createTopoIslDto(IslImpl islImpl) {
        IslBase islBase = (IslBase)islImpl.getBaseObject();
        TopoIslDto topoIslDto = new TopoIslDto(islBase);
        topoIslDto.setSwitch1PK(islImpl.getSwitch1().getSwitchPK());
        topoIslDto.setSwitch2PK(islImpl.getSwitch2().getSwitchPK());
        topoIslDto.setFCIP(islImpl.isFCIP());
        topoIslDto.setPortChannel(islImpl.isPortChannel());
        topoIslDto.setSwitch1Name(islImpl.getSwitch1().getName());
        topoIslDto.setSwitch2Name(islImpl.getSwitch2().getName());
        topoIslDto.setIfIndex1Name(islImpl.getIfIndex1Name());
        topoIslDto.setIfIndex2Name(islImpl.getIfIndex2Name());
        topoIslDto.setPresent(islImpl.isPresent());
        topoIslDto.setStatus(islImpl.getStatus());
        topoIslDto.setPcMemberLinksAsStringSwap(this.getPCMemberLinksAsString(true, islImpl));
        topoIslDto.setPcMemberLinksAsString(this.getPCMemberLinksAsString(false, islImpl));
        return topoIslDto;
    }

    public TopoNpvLinkDto createTopoNpvLinkDto(NpvLinkImpl npvLinkImpl) {
        NpvLinkBase npvLinkBase = (NpvLinkBase)npvLinkImpl.getBaseObject();
        TopoNpvLinkDto topoNpvLinkDto = new TopoNpvLinkDto(npvLinkBase);
        topoNpvLinkDto.setSwitch1PK(npvLinkImpl.getCoreSwitch().getSwitchPK());
        topoNpvLinkDto.setSwitch2PK(npvLinkImpl.getEdgeSwitch().getSwitchPK());
        topoNpvLinkDto.setFCIP(false);
        topoNpvLinkDto.setPortChannel(false);
        topoNpvLinkDto.setSwitch1Name(npvLinkImpl.getCoreSwitch().getName());
        topoNpvLinkDto.setSwitch2Name(npvLinkImpl.getEdgeSwitch().getName());
        topoNpvLinkDto.setIfIndex1Name(npvLinkImpl.getFPortIfname());
        topoNpvLinkDto.setIfIndex2Name(npvLinkImpl.getNpPortIfname());
        topoNpvLinkDto.setPresent(npvLinkImpl.isPresent());
        topoNpvLinkDto.setStatus(npvLinkImpl.getStatus());
        topoNpvLinkDto.setPcMemberLinksAsStringSwap(this.getPCMemberLinksAsString(true, npvLinkImpl));
        topoNpvLinkDto.setPcMemberLinksAsString(this.getPCMemberLinksAsString(false, npvLinkImpl));
        return topoNpvLinkDto;
    }

    private String getPCMemberLinksAsString(boolean swap, NpvLinkImpl npvLinkImpl) {
        return null;
    }

    private String getPCMemberLinksAsString(boolean swap, IslImpl islImpl) {
        int eachSideLength = 60;
        List<int[]> children = islImpl.getChildren();
        if (children == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        int length = 0;
        for (int[] pair : children) {
            String str2;
            String str;
            if (swap) {
                str = islImpl.getSwitch2().ifIndexToName(pair[1]);
                str2 = islImpl.getSwitch1().ifIndexToName(pair[0]);
            } else {
                str = islImpl.getSwitch1().ifIndexToName(pair[0]);
                str2 = islImpl.getSwitch2().ifIndexToName(pair[1]);
            }
            if (eachSideLength >= 20 && (length += str.length() + 2) > eachSideLength) {
                sb.append(" <-> ");
                sb.append(sb2).append("\n");
                sb2.setLength(0);
                length = str.length() + 2;
            }
            sb.append(str).append(", ");
            sb2.append(str2).append(", ");
        }
        if (sb.length() > 2) {
            sb.setLength(sb.length() - 2);
        }
        if (sb2.length() > 2) {
            sb2.setLength(sb2.length() - 2);
            sb.append(" <-> ");
            sb.append(sb2);
        }
        return sb.toString();
    }

    @Override
    public TopoEnclosureDto[] getEnclosures(int fabricID) {
        TopoEnclosureDto[] topoEnclosures = new TopoEnclosureDto[]{};
        FabricImpl fabric = SanManager.getInstance().findFabric(new FabricPK(fabricID));
        if (fabric == null) {
            return topoEnclosures;
        }
        EnclosureImpl[] enclosureList = fabric.getEnclosures(3);
        if (enclosureList != null && enclosureList.length > 0) {
            topoEnclosures = new TopoEnclosureDto[enclosureList.length];
            for (int i = 0; i < enclosureList.length; ++i) {
                topoEnclosures[i] = this.createTopoEnclosureDto(enclosureList[i]);
            }
        }
        if (topoEnclosures == null) {
            topoEnclosures = new TopoEnclosureDto[]{};
        }
        this.logger.debug((Object)("getEnclosures fabric=" + this.fabricName + " numEnclosures=" + topoEnclosures.length));
        return topoEnclosures;
    }

    public TopoEnclosureDto createTopoEnclosureDto(EnclosureImpl enclosureImpl) {
        EnclosureBase enclosureBase = (EnclosureBase)enclosureImpl.getBaseObject();
        TopoEnclosureDto topoEnclosureDto = new TopoEnclosureDto(enclosureBase);
        List<EndPortImpl> endPortImplList = enclosureImpl.getEndPorts();
        TopoNxPortDto endPortDto = null;
        for (int j = 0; j < endPortImplList.size(); ++j) {
            endPortDto = this.createTopoNxPortDto(endPortImplList.get(j));
            topoEnclosureDto.addEndPort(endPortDto);
            endPortDto.setEnclosure(topoEnclosureDto);
            topoEnclosureDto.addVsanIds(endPortImplList.get(j).getVsanMembership());
        }
        return topoEnclosureDto;
    }

    @Override
    public TopoEdgeLinkDto[] getEdgeLinksForEnclosures(int fabricID) {
        TopoEdgeLinkDto[] topoEdgeLinks = new TopoEdgeLinkDto[]{};
        FabricImpl fabric = SanManager.getInstance().findFabric(new FabricPK(fabricID));
        if (fabric == null) {
            return topoEdgeLinks;
        }
        TopoEdgeLinkDto edgeLinkDto = null;
        EnclosureImpl[] enclosureList = fabric.getEnclosures(3);
        EndPortImpl nxPort = null;
        if (enclosureList != null && enclosureList.length > 0) {
            ArrayList<TopoEdgeLinkDto> arrayList = new ArrayList<TopoEdgeLinkDto>();
            for (int i = 0; i < enclosureList.length; ++i) {
                List<EndPortImpl> nxPortList = enclosureList[i].getEndPorts();
                for (int j = 0; j < nxPortList.size(); ++j) {
                    nxPort = nxPortList.get(j);
                    if (nxPort == null) continue;
                    if (nxPort.getSwitch() != null) {
                        edgeLinkDto = this.createTopoEdgeLinkDto(nxPort);
                        arrayList.add(edgeLinkDto);
                        edgeLinkDto.setEnclosurePK(enclosureList[i].getPK());
                        continue;
                    }
                    this.logger.warn((Object)("getEdgeLinksForEnclosures() nxPort.getSwitch() == null, endPortImpl=" + nxPort.getName()), (Throwable)new NullPointerException());
                }
            }
            topoEdgeLinks = new TopoEdgeLinkDto[arrayList.size()];
            topoEdgeLinks = arrayList.toArray(topoEdgeLinks);
        }
        if (topoEdgeLinks == null) {
            topoEdgeLinks = new TopoEdgeLinkDto[]{};
        }
        this.logger.debug((Object)("getEdgeLinksForEnclosures fabric=" + this.fabricName + " numEdgeLinks=" + topoEdgeLinks.length));
        return topoEdgeLinks;
    }

    @Override
    public TopoNxPortDto[] getNxPorts(int fabricID) {
        TopoNxPortDto[] topoNxPorts = new TopoNxPortDto[]{};
        FabricImpl fabric = SanManager.getInstance().findFabric(new FabricPK(fabricID));
        if (fabric == null) {
            return topoNxPorts;
        }
        EndPortImpl[] nxPortList = fabric.getEndPorts();
        if (nxPortList != null && nxPortList.length > 0) {
            topoNxPorts = new TopoNxPortDto[nxPortList.length];
            for (int i = 0; i < nxPortList.length; ++i) {
                topoNxPorts[i] = this.createTopoNxPortDto(nxPortList[i]);
            }
        }
        if (topoNxPorts == null) {
            topoNxPorts = new TopoNxPortDto[]{};
        }
        this.logger.debug((Object)("getNxPorts fabric=" + this.fabricName + " numNxPorts=" + topoNxPorts.length));
        return topoNxPorts;
    }

    public TopoNxPortDto createTopoNxPortDto(EndPortImpl endPortImpl) {
        EndPortBase endPortBase = (EndPortBase)endPortImpl.getBaseObject();
        TopoNxPortDto topoNxPortDto = new TopoNxPortDto(endPortBase);
        topoNxPortDto.setName(endPortImpl.getName());
        return topoNxPortDto;
    }

    @Override
    public TopoEdgeLinkDto[] getEdgeLinksForNxPorts(int fabricID) {
        TopoEdgeLinkDto[] topoEdgeLinks = new TopoEdgeLinkDto[]{};
        FabricImpl fabric = SanManager.getInstance().findFabric(new FabricPK(fabricID));
        if (fabric == null) {
            return topoEdgeLinks;
        }
        EndPortImpl[] nxPortList = fabric.getEndPorts();
        if (nxPortList != null && nxPortList.length > 0) {
            topoEdgeLinks = new TopoEdgeLinkDto[nxPortList.length];
            for (int i = 0; i < nxPortList.length; ++i) {
                topoEdgeLinks[i] = this.createTopoEdgeLinkDto(nxPortList[i]);
            }
        }
        if (topoEdgeLinks == null) {
            topoEdgeLinks = new TopoEdgeLinkDto[]{};
        }
        this.logger.debug((Object)("getEdgeLinksForNxPorts fabric=" + this.fabricName + " numEdgeLinks=" + topoEdgeLinks.length));
        return topoEdgeLinks;
    }

    public TopoEdgeLinkDto createTopoEdgeLinkDto(EndPortImpl endPortImpl) {
        EndPortBase endPortBase = (EndPortBase)endPortImpl.getBaseObject();
        TopoEdgeLinkDto topoEdgeLinkDto = new TopoEdgeLinkDto(endPortBase);
        topoEdgeLinkDto.setSwitchIsMDS(endPortImpl.getSwitch().isMDS());
        topoEdgeLinkDto.setSwitchIsQuail(endPortImpl.getSwitch().isQuail());
        topoEdgeLinkDto.setIsFCoE(endPortImpl.isFCoE());
        topoEdgeLinkDto.setSwitchIfIndexToName(endPortImpl.getIfName());
        topoEdgeLinkDto.setName(endPortImpl.getName());
        topoEdgeLinkDto.setSwitchName(endPortImpl.getSwitch().getName());
        topoEdgeLinkDto.setStatus(endPortImpl.getStatus());
        return topoEdgeLinkDto;
    }

    @Override
    public TopoHubDto[] getHubs(int fabricID) {
        TopoHubDto[] topoHubs = new TopoHubDto[]{};
        FabricImpl fabric = SanManager.getInstance().findFabric(new FabricPK(fabricID));
        if (fabric == null) {
            return topoHubs;
        }
        HashMap<SwitchIntKey, TopoHubDto> hubHashMap = new HashMap<SwitchIntKey, TopoHubDto>();
        EndPortImpl[] nxPortList = fabric.getEndPorts();
        if (nxPortList != null && nxPortList.length > 0) {
            for (int i = 0; i < nxPortList.length; ++i) {
                if (!((EndPortBase)nxPortList[i].getBaseObject()).isLoop()) continue;
                SwitchIntKey swk = nxPortList[i].getSwitchIntKey();
                TopoHubDto hubDto = (TopoHubDto)hubHashMap.get(swk);
                if (hubDto == null) {
                    hubDto = new TopoHubDto(swk._swPK, swk._index);
                    hubDto.setIfIndexName(nxPortList[i].getIfName());
                    hubDto.setSwitchName(nxPortList[i].getSwitch().getName());
                    hubDto.setSwitchPK(nxPortList[i].getSwitch().getPK());
                    hubHashMap.put(swk, hubDto);
                }
                hubDto.addMember((EndPortBase)nxPortList[i].getBaseObject());
            }
        }
        ArrayList<TopoHubDto> hubList = new ArrayList<TopoHubDto>();
        Collection hubCollection = hubHashMap.values();
        for (TopoHubDto topoHub : hubCollection) {
            if (topoHub.getMembers().size() <= 1) continue;
            hubList.add(topoHub);
        }
        topoHubs = new TopoHubDto[hubList.size()];
        if ((topoHubs = hubList.toArray(topoHubs)) == null) {
            topoHubs = new TopoHubDto[]{};
        }
        this.logger.debug((Object)("getHubs fabric=" + this.fabricName + " numHubs=" + topoHubs.length));
        return topoHubs;
    }

    @Override
    public Properties loadProperties(String name) throws RemoteException {
        if (name == null || name.length() == 0) {
            return null;
        }
        try {
            Properties properties = new Properties();
            String userDirName = "/temp";
            File userDir = new File(userDirName);
            if (!userDir.exists() || !userDir.canRead()) {
                return null;
            }
            File userFile = new File(userDirName, name);
            if (!userFile.canRead()) {
                return null;
            }
            FileInputStream fis = new FileInputStream(userFile);
            properties.load(fis);
            fis.close();
            return properties;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            this.logger.debug((Object)ex);
            throw new RemoteException("Can't read properties for fileName=" + name, ex);
        }
    }

    public Properties loadMapLayoutFile(String userName, String mapLayoutFileName) throws RemoteException {
        if (mapLayoutFileName == null || mapLayoutFileName.length() == 0) {
            return null;
        }
        try {
            Properties properties = new Properties();
            String userDirName = ClientCache.getInstallLocation() + "db" + File.separator + (userName == null ? "admin" : userName);
            File userDir = new File(userDirName);
            if (!userDir.exists() || !userDir.canRead()) {
                return null;
            }
            File userFile = new File(userDirName, mapLayoutFileName);
            if (!userFile.canRead()) {
                return null;
            }
            FileInputStream fis = new FileInputStream(userFile);
            properties.load(fis);
            fis.close();
            return properties;
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            this.logger.debug((Object)ex);
            throw new RemoteException("Can't read properties for userName=" + userName + " mapLayoutFileName=" + mapLayoutFileName, ex);
        }
    }

    @Override
    public void storeProperties(String name, Properties properties, String header) throws RemoteException {
        if (properties == null || name == null || name.length() == 0) {
            return;
        }
        try {
            String userDirName = "/temp";
            File userDir = new File(userDirName);
            if (!userDir.exists()) {
                userDir.mkdirs();
            }
            if (!userDir.canWrite()) {
                throw new RemoteException("Can't write file to " + userDir);
            }
            File userFile = new File(userDirName, name);
            userFile.createNewFile();
            if (!userFile.canWrite()) {
                throw new RemoteException("Can't write file to " + userFile);
            }
            FileOutputStream fos = new FileOutputStream(userFile);
            properties.store(fos, header);
            fos.close();
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            this.logger.debug((Object)ex);
            throw new RemoteException("Can't save properties", ex);
        }
    }

    public PKIf getSeedSwitchPK(int fabricID) throws RemoteException {
        PKIf pk = null;
        FabricImpl fabric = SanManager.getInstance().findFabric(new FabricPK(fabricID));
        if (fabric == null) {
            RemoteException remoteException = new RemoteException("Cannot generate visio diagram.  Fabric no longer exists or is not managed: fabric=" + this.fabricName);
            this.logger.debug((Object)remoteException);
            throw remoteException;
        }
        pk = fabric.getSeed().getPK();
        return pk;
    }

    public Wwn getSeedSwitchWwn(int fabricID) throws RemoteException {
        Wwn wwn = null;
        FabricImpl fabric = SanManager.getInstance().findFabric(new FabricPK(fabricID));
        if (fabric == null) {
            RemoteException remoteException = new RemoteException("Cannot generate visio diagram.  Fabric no longer exists or is not managed: fabric=" + this.fabricName);
            this.logger.debug((Object)remoteException);
            throw remoteException;
        }
        wwn = fabric.getSeed().getWwn();
        return wwn;
    }

    private String getFabricName(long fabricID) {
        FabricImpl fabric = SanManager.getInstance().findFabric(new FabricPK((int)fabricID));
        if (fabric == null) {
            return null;
        }
        return fabric.getPK().getName();
    }

    @Override
    public String createVisioMap(String fileName, String userName, int fabricID, boolean showLinkLabels, boolean expandMultiLinks, boolean showEndDevices) throws RemoteException {
        this.logger.debug((Object)("createVisioMap for fabric fileName=" + fileName + " userName=" + userName + " fabricID=" + fabricID + " showLinkLabels=" + showLinkLabels + " expandMultiLinks=" + expandMultiLinks + " showEndDevices=" + showEndDevices));
        return this.createVisioMap(fileName, userName, fabricID, -1, null, showLinkLabels, expandMultiLinks, showEndDevices);
    }

    @Override
    public String createVisioMap(String fileName, String userName, int fabricID, int vsanID, boolean showLinkLabels, boolean expandMultiLinks, boolean showEndDevices) throws RemoteException {
        this.logger.debug((Object)("createVisioMap for vsan fileName=" + fileName + " userName=" + userName + " fabricID=" + fabricID + " vsanID=" + vsanID + " showLinkLabels=" + showLinkLabels + " expandMultiLinks=" + expandMultiLinks + " showEndDevices=" + showEndDevices));
        return this.createVisioMap(fileName, userName, fabricID, vsanID, null, showLinkLabels, expandMultiLinks, showEndDevices);
    }

    @Override
    public String createVisioMap(String fileName, String userName, int fabricID, String groupName, boolean showLinkLabels, boolean expandMultiLinks, boolean showEndDevices) throws RemoteException {
        this.logger.debug((Object)("createVisioMap for group fileName=" + fileName + " userName=" + userName + " fabricID=" + fabricID + " groupName=" + groupName + " showLinkLabels=" + showLinkLabels + " expandMultiLinks=" + expandMultiLinks + " showEndDevices=" + showEndDevices));
        return this.createVisioMap(fileName, userName, fabricID, -1, groupName, showLinkLabels, expandMultiLinks, showEndDevices);
    }

    @Override
    public String createVisioMapForGroup(String fileName, String userName, long groupDBID, boolean showLinkLabels, boolean expandMultiLinks, boolean showEndDevices) throws RemoteException {
        this.logger.debug((Object)("createVisioMapForGroup fileName=" + fileName + " userName=" + userName + " groupDBID=" + groupDBID + " showLinkLabels=" + showLinkLabels + " expandMultiLinks=" + expandMultiLinks + " showEndDevices=" + showEndDevices));
        return this.createVisioMap(fileName, userName, -1, -1, groupDBID, showLinkLabels, expandMultiLinks, showEndDevices);
    }

    @Override
    public String createVisioMapForDataCenter(String fileName, String userName, boolean showLinkLabels, boolean expandMultiLinks) throws RemoteException {
        this.logger.debug((Object)("createVisioMapForGroup fileName=" + fileName + " userName=" + userName + " showLinkLabels=" + showLinkLabels + " expandMultiLinks=" + expandMultiLinks));
        String returnStatus = "";
        try {
            GroupBase group = null;
            int fabricID = -1;
            this.fabricName = "DataCenter";
            TopoSwitchDto[] fcSwitches = this.getAllSwitches();
            TopoEthSwitchDto[] ethSwitches = this.getEthSwitches();
            TopoIslDto[] isls = this.getAllIsls();
            TopoNpvLinkDto[] npvLinks = this.getAllNpvLinks();
            TopoEthIslDto[] ethIsls = this.getEthIsls();
            VisioMapGenerator visioMapGenerator = new VisioMapGenerator();
            visioMapGenerator.setTitle(this.fabricName);
            visioMapGenerator.addSwitches(fcSwitches);
            visioMapGenerator.addEthSwitches(ethSwitches);
            visioMapGenerator.addIsls(isls);
            visioMapGenerator.addNpvLinks(npvLinks);
            visioMapGenerator.addEthIsls(ethIsls);
            visioMapGenerator.setGroup(group);
            Properties mapLayoutProperties = this.loadMapLayoutFile(userName, this.fabricName + "-Default.map");
            returnStatus = visioMapGenerator.createVisioMap(fileName, fabricID, -1, showLinkLabels, expandMultiLinks, true, mapLayoutProperties);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            this.logger.debug((Object)"createVisioMap", (Throwable)ex);
            throw new RemoteException("Cannot generate visio diagram.  ", ex);
        }
        return returnStatus;
    }

    @Override
    public String createVisioMapForLan(String fileName, String userName, boolean showLinkLabels, boolean expandMultiLinks) throws RemoteException {
        this.logger.debug((Object)("createVisioMapForGroup fileName=" + fileName + " userName=" + userName + " showLinkLabels=" + showLinkLabels + " expandMultiLinks=" + expandMultiLinks));
        String returnStatus = "";
        try {
            GroupBase group = null;
            int fabricID = -1;
            this.fabricName = "LAN";
            TopoEthSwitchDto[] switches = this.getEthSwitches();
            TopoEthIslDto[] isls = this.getEthIsls();
            VisioMapGenerator visioMapGenerator = new VisioMapGenerator();
            visioMapGenerator.setTitle(this.fabricName);
            visioMapGenerator.addEthSwitches(switches);
            visioMapGenerator.addEthIsls(isls);
            visioMapGenerator.setGroup(group);
            Properties mapLayoutProperties = this.loadMapLayoutFile(userName, this.fabricName + "-Default.map");
            returnStatus = visioMapGenerator.createVisioMap(fileName, fabricID, -1, showLinkLabels, expandMultiLinks, true, mapLayoutProperties);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            this.logger.debug((Object)"createVisioMap", (Throwable)ex);
            throw new RemoteException("Cannot generate visio diagram.  ", ex);
        }
        return returnStatus;
    }

    private String createVisioMap(String fileName, String userName, int fabricID, int vsanID, String groupName, boolean showLinkLabels, boolean expandMultiLinks, boolean showEndDevices) throws RemoteException {
        String returnStatus = "";
        try {
            VsanImpl[] vsans;
            this.fabricName = this.getFabricName(fabricID);
            TopoSwitchDto[] switches = this.getSwitches(fabricID);
            TopoIslDto[] isls = this.getIsls(fabricID);
            TopoNpvLinkDto[] npvLinks = this.getNpvLinks(fabricID);
            TopoNxPortDto[] nxPorts = this.getNxPorts(fabricID);
            TopoEnclosureDto[] enclosures = this.getEnclosures(fabricID);
            TopoEdgeLinkDto[] edgeLinksForEnclosures = this.getEdgeLinksForEnclosures(fabricID);
            TopoHubDto[] hubs = this.getHubs(fabricID);
            GroupBase group = null;
            if (groupName != null && groupName.length() > 0 && (group = this.getGroup(fabricID, groupName)) == null) {
                this.logger.debug((Object)("Group not found.  fabric=" + this.fabricName + " groupName=" + groupName));
                throw new RemoteException("Cannot generate visio diagram.  Group not found.  fabric=" + this.fabricName + " groupName=" + groupName);
            }
            if (vsanID > -1 && ((vsans = this.getVsans(fabricID, vsanID)) == null || vsans.length == 0)) {
                this.logger.debug((Object)("Vsan not found.  fabric=" + this.fabricName + " vsanID=" + vsanID));
                throw new RemoteException("Cannot generate visio diagram.  Vsan not found.  fabric=" + this.fabricName + " vsanID=" + vsanID);
            }
            VisioMapGenerator visioMapGenerator = new VisioMapGenerator();
            visioMapGenerator.setTitle(this.fabricName);
            visioMapGenerator.addSwitches(switches);
            visioMapGenerator.addIsls(isls);
            visioMapGenerator.addNpvLinks(npvLinks);
            visioMapGenerator.addNxPorts(nxPorts);
            visioMapGenerator.addEnclosures(enclosures);
            visioMapGenerator.addEdgeLinksForEnclosures(edgeLinksForEnclosures);
            visioMapGenerator.addHubs(hubs);
            visioMapGenerator.setGroup(group);
            if (enclosures != null && enclosures.length > this.maxNodes) {
                showEndDevices = false;
                expandMultiLinks = false;
                this.logger.debug((Object)("createVisioMap fabric=" + this.fabricName + " hiding end devices, collapsing multiple links, number of nodes=" + enclosures.length));
            }
            Properties mapLayoutProperties = this.loadMapLayoutFile(userName, this.fabricName + "-Default.map");
            returnStatus = visioMapGenerator.createVisioMap(fileName, fabricID, vsanID, showLinkLabels, expandMultiLinks, showEndDevices, mapLayoutProperties);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            this.logger.debug((Object)"createVisioMap", (Throwable)ex);
            throw new RemoteException("Cannot generate visio diagram.  ", ex);
        }
        return returnStatus;
    }

    private String createVisioMap(String fileName, String userName, int ignoreFabricID, int ignoreVsanID, long groupDBID, boolean showLinkLabels, boolean expandMultiLinks, boolean showEndDevices) throws RemoteException {
        String returnStatus = "";
        try {
            GroupBase group = null;
            if (groupDBID > 0L) {
                group = this.getGroup(groupDBID);
            }
            if (group == null) {
                this.logger.debug((Object)("Group not found groupDBID=" + groupDBID));
                throw new RemoteException("Cannot generate visio diagram.  Group not found groupDBID=" + groupDBID);
            }
            int fabricID = group.getFabricPK().get_fid();
            this.fabricName = this.getFabricName(fabricID);
            TopoSwitchDto[] switches = this.getSwitches(fabricID);
            TopoIslDto[] isls = this.getIsls(fabricID);
            TopoNpvLinkDto[] npvLinks = this.getNpvLinks(fabricID);
            TopoNxPortDto[] nxPorts = this.getNxPorts(fabricID);
            TopoEnclosureDto[] enclosures = this.getEnclosures(fabricID);
            TopoEdgeLinkDto[] edgeLinksForEnclosures = this.getEdgeLinksForEnclosures(fabricID);
            TopoHubDto[] hubs = this.getHubs(fabricID);
            VisioMapGenerator visioMapGenerator = new VisioMapGenerator();
            visioMapGenerator.setTitle(this.fabricName);
            visioMapGenerator.addSwitches(switches);
            visioMapGenerator.addIsls(isls);
            visioMapGenerator.addNpvLinks(npvLinks);
            visioMapGenerator.addNxPorts(nxPorts);
            visioMapGenerator.addEnclosures(enclosures);
            visioMapGenerator.addEdgeLinksForEnclosures(edgeLinksForEnclosures);
            visioMapGenerator.addHubs(hubs);
            visioMapGenerator.setGroup(group);
            if (enclosures != null && enclosures.length > this.maxNodes) {
                showEndDevices = false;
                expandMultiLinks = false;
                this.logger.debug((Object)("createVisioMap fabric=" + this.fabricName + " hiding end devices, collapsing multiple links, number of nodes=" + enclosures.length));
            }
            Properties mapLayoutProperties = this.loadMapLayoutFile(userName, this.fabricName + "-Default.map");
            returnStatus = visioMapGenerator.createVisioMap(fileName, fabricID, ignoreVsanID, showLinkLabels, expandMultiLinks, showEndDevices, mapLayoutProperties);
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception ex) {
            this.logger.debug((Object)"createVisioMap", (Throwable)ex);
            throw new RemoteException("Cannot generate visio diagram.  ", ex);
        }
        return returnStatus;
    }

    @PostConstruct
    public void registerInJMX() {
        try {
            this.logger.warn((Object)"********* Registering dcm:service=TopologyBean");
            this.objectName = new ObjectName("dcm:service=TopologyBean");
            this.platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.platformMBeanServer.registerMBean(this, this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during registration of Monitoring into JMX:" + e);
        }
    }

    @PreDestroy
    public void unregisterFromJMX() {
        try {
            this.platformMBeanServer.unregisterMBean(this.objectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem during unregistration of Monitoring into JMX:" + e);
        }
    }

    class VisioMapGenerator {
        TopoSwitchDto[] switches = new TopoSwitchDto[0];
        TopoIslDto[] isls = new TopoIslDto[0];
        TopoNpvLinkDto[] npvLinks = new TopoNpvLinkDto[0];
        TopoNxPortDto[] nxPorts = new TopoNxPortDto[0];
        TopoEnclosureDto[] enclosures = new TopoEnclosureDto[0];
        TopoEdgeLinkDto[] edgeLinksForEnclosures = new TopoEdgeLinkDto[0];
        TopoHubDto[] hubs = new TopoHubDto[0];
        GroupBase group = null;
        String title = "no title";
        Properties properties = null;
        boolean expandMultiLinks = false;
        String userName = "admin";
        TopoEthSwitchDto[] ethSwitches = new TopoEthSwitchDto[0];
        TopoEthIslDto[] ethIsls = new TopoEthIslDto[0];
        static final String SEPARATOR_STRING = "|";

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void addSwitches(TopoSwitchDto[] switches) {
            if (switches != null) {
                this.switches = switches;
            }
        }

        public void addEthSwitches(TopoEthSwitchDto[] ethSwitches) {
            if (ethSwitches != null) {
                this.ethSwitches = ethSwitches;
            }
        }

        public void addIsls(TopoIslDto[] isls) {
            if (isls != null) {
                this.isls = isls;
            }
        }

        public void addEthIsls(TopoEthIslDto[] ethIsls) {
            if (ethIsls != null) {
                this.ethIsls = ethIsls;
            }
        }

        public void addNpvLinks(TopoNpvLinkDto[] npvLinks) {
            if (npvLinks != null) {
                this.npvLinks = npvLinks;
            }
        }

        public void addNxPorts(TopoNxPortDto[] nxPorts) {
            if (nxPorts != null) {
                this.nxPorts = nxPorts;
            }
        }

        public void addEnclosures(TopoEnclosureDto[] enclosures) {
            if (enclosures != null) {
                this.enclosures = enclosures;
            }
        }

        public void addEdgeLinksForEnclosures(TopoEdgeLinkDto[] edgeLinksForEnclosures) {
            if (edgeLinksForEnclosures != null) {
                this.edgeLinksForEnclosures = edgeLinksForEnclosures;
            }
        }

        public void addHubs(TopoHubDto[] hubs) {
            if (hubs != null) {
                this.hubs = hubs;
            }
        }

        public void setGroup(GroupBase group) {
            this.group = group;
        }

        private boolean loadCoordinates(VisioNode n, boolean wwnenabled) {
            if (this.properties != null) {
                try {
                    if (wwnenabled) {
                        WwnDictionary.setEnabled(false);
                    }
                    String pk = ((TopoAbstractDto)n.getModel()).getPK().toString();
                    String key = (String)this.properties.get(pk);
                    this.setProperties(n, key, true, true);
                    if (wwnenabled) {
                        WwnDictionary.setEnabled(true);
                    }
                    if (key != null && key.length() > 0) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }

        public void setProperties(VisioNode node, String prop, boolean expand, boolean override) {
            String expandLinks;
            if (node == null) {
                return;
            }
            if (prop == null) {
                node.setIconCenter(0, 0);
                node.setExpanded(expand);
                return;
            }
            StringTokenizer st = new StringTokenizer(prop, SEPARATOR_STRING);
            String x = st.hasMoreTokens() ? st.nextToken().trim() : null;
            String y = st.hasMoreTokens() ? st.nextToken().trim() : null;
            String fixed = st.hasMoreTokens() ? st.nextToken().trim() : null;
            String expanded = st.hasMoreTokens() ? st.nextToken().trim() : null;
            String string = expandLinks = st.hasMoreTokens() ? st.nextToken().trim() : null;
            if (x != null && y != null) {
                try {
                    node.setIconCenter(Integer.parseInt(x), Integer.parseInt(y));
                }
                catch (Exception ex) {
                    node.setIconCenter(0, 0);
                }
            } else {
                node.setIconCenter(0, 0);
            }
            if (fixed == null || fixed.equals("true")) {
                // empty if block
            }
            if (override && expanded != null && expanded.length() > 0) {
                if (expanded.equals("true")) {
                    node.setExpanded(true);
                } else {
                    node.setExpanded(false);
                }
            } else {
                node.setExpanded(expand);
            }
            if (!override || expandLinks == null || expandLinks.length() <= 0 || expandLinks.equals("true")) {
                // empty if block
            }
        }

        private short[] getNxPortVsans(GroupBase group) {
            if (group == null) {
                return new short[0];
            }
            ArrayList<Short> vsanIdList = new ArrayList<Short>();
            if (this.nxPorts != null) {
                TopoNxPortDto nxPort = null;
                for (int i = 0; i < this.nxPorts.length; ++i) {
                    short[] ids;
                    nxPort = this.nxPorts[i];
                    if (nxPort == null || !group.hasMember(nxPort.getPK()) || (ids = nxPort.getVsanIds()) == null) continue;
                    for (int j = 0; j < ids.length; ++j) {
                        if (vsanIdList.contains(ids[j])) continue;
                        vsanIdList.add(ids[j]);
                    }
                }
                Collections.sort(vsanIdList);
            }
            short[] vsanIds = new short[vsanIdList.size()];
            for (int k = 0; k < vsanIdList.size(); ++k) {
                vsanIds[k] = (Short)vsanIdList.get(k);
            }
            return vsanIds;
        }

        private ArrayList<TopoNxPortDto> getNxPortsInGroup(GroupBase group) {
            ArrayList<TopoNxPortDto> nxPortsInGroup = new ArrayList<TopoNxPortDto>();
            if (this.nxPorts != null) {
                TopoNxPortDto nxPort = null;
                for (int i = 0; i < this.nxPorts.length; ++i) {
                    nxPort = this.nxPorts[i];
                    if (nxPort == null || !group.hasMember(nxPort.getPK())) continue;
                    nxPortsInGroup.add(nxPort);
                }
            }
            return nxPortsInGroup;
        }

        private ArrayList<PKIf> getSwitchPksInGroup(GroupBase group) {
            ArrayList<PKIf> switchPksInGroup = new ArrayList<PKIf>();
            if (group == null) {
                return switchPksInGroup;
            }
            ArrayList<TopoNxPortDto> nxPortsInGroup = this.getNxPortsInGroup(group);
            for (int i = 0; i < nxPortsInGroup.size(); ++i) {
                switchPksInGroup.add(nxPortsInGroup.get(i).getSwitchPK());
            }
            return switchPksInGroup;
        }

        public String createVisioMap(String fileName, int fabricID, int vsanID, boolean showLinkLabels, boolean expandMultiLinks, boolean showEndDevices, Properties properties) throws RemoteException {
            String filePath;
            StringBuffer summary = new StringBuffer();
            VisioGraph visioGraph = new VisioGraph();
            visioGraph.setTitle(this.title);
            this.properties = properties;
            this.expandMultiLinks = expandMultiLinks;
            visioGraph.setExpandeMultipleLinks(expandMultiLinks);
            HashMap<PKIf, VisioNodeIntf> nodeMap = new HashMap<PKIf, VisioNodeIntf>();
            HashMap<PKIf, VisioLinkIntf> linkMap = new HashMap<PKIf, VisioLinkIntf>();
            summary.append("\n fileName=" + fileName);
            summary.append("\n fabricID=" + fabricID);
            summary.append("\n fabric=" + TopologyBean.this.fabricName);
            summary.append("\n vsanID=" + vsanID);
            if (this.group != null) {
                summary.append("\n groupName=" + this.group.toString());
            }
            short[] nxPortVsans = this.getNxPortVsans(this.group);
            summary.append("\n switches.length=" + this.switches.length);
            VisioSwitchNodeIntf visioSwitchNode = null;
            TopoSwitchDto switchDto = null;
            HashMap<PKIf, TopoSwitchDto> switchMapByPK = new HashMap<PKIf, TopoSwitchDto>();
            for (int i = 0; i < this.switches.length; ++i) {
                if (this.switches[i] == null) continue;
                switchDto = this.switches[i];
                switchMapByPK.put(switchDto.getPK(), switchDto);
                if (vsanID < 0 ? this.group != null && !switchDto.isMemberOfGroup(this.group) : !switchDto.isMemberOfVsan((short)vsanID)) continue;
                if (switchDto == null || nodeMap.get(switchDto.getPK()) != null) continue;
                visioSwitchNode = VisioMapFactory.createSwitchNode(switchDto);
                this.loadCoordinates((VisioNode)((Object)visioSwitchNode), true);
                visioGraph.addNode(visioSwitchNode);
                nodeMap.put(switchDto.getPK(), visioSwitchNode);
            }
            if (this.group != null && this.group.getType() == 2) {
                ArrayList<PKIf> switchPksInGroup = this.getSwitchPksInGroup(this.group);
                for (int i = 0; i < switchPksInGroup.size(); ++i) {
                    switchDto = (TopoSwitchDto)switchMapByPK.get(switchPksInGroup.get(i));
                    if (switchDto == null || nodeMap.get(switchDto.getPK()) != null) continue;
                    visioSwitchNode = VisioMapFactory.createSwitchNode(switchDto);
                    this.loadCoordinates((VisioNode)((Object)visioSwitchNode), true);
                    visioGraph.addNode(visioSwitchNode);
                    nodeMap.put(switchDto.getPK(), visioSwitchNode);
                }
            }
            summary.append("\n ethernet switches.length=" + this.ethSwitches.length);
            VisioSwitchNodeIntf visioEthSwitchNode = null;
            TopoEthSwitchDto ethSwitchDto = null;
            for (int i = 0; i < this.ethSwitches.length; ++i) {
                if (this.ethSwitches[i] == null || (ethSwitchDto = this.ethSwitches[i]) == null || nodeMap.get(ethSwitchDto.getPK()) != null) continue;
                visioEthSwitchNode = VisioMapFactory.createEthSwitchNode(ethSwitchDto);
                this.loadCoordinates((VisioNode)((Object)visioEthSwitchNode), true);
                visioGraph.addNode(visioEthSwitchNode);
                nodeMap.put(ethSwitchDto.getPK(), visioEthSwitchNode);
            }
            summary.append("\n isls.length=" + this.isls.length);
            VisioIslLinkIntf visioIslLink = null;
            TopoIslDto islDto = null;
            for (int i = 0; i < this.isls.length; ++i) {
                VisioNodeIntf switch2;
                if (this.isls[i] == null) continue;
                islDto = this.isls[i];
                if (vsanID < 0 ? this.group != null && this.group.getType() == 1 && !islDto.isMemberOfGroup(this.group) : !islDto.isMemberOfVsan((short)vsanID)) continue;
                if (islDto == null || nodeMap.get(islDto.getPK()) != null) continue;
                visioIslLink = VisioMapFactory.createIslLink(islDto);
                linkMap.put(islDto.getPK(), visioIslLink);
                VisioNodeIntf switch1 = (VisioNodeIntf)nodeMap.get(islDto.getSwitch1PK());
                if (switch1 == null && TopologyBean.this.logger.isDebugEnabled()) {
                    summary.append("visioIslLink from node is null " + islDto.getSwitch1PK() + ",");
                }
                if ((switch2 = (VisioNodeIntf)nodeMap.get(islDto.getSwitch2PK())) == null && TopologyBean.this.logger.isDebugEnabled()) {
                    summary.append("visioIslLink to node is null " + islDto.getSwitch2PK() + ",");
                }
                if (switch1 == null || switch2 == null) continue;
                visioIslLink.setFromNode(switch1);
                visioIslLink.setToNode(switch2);
                visioGraph.addLink(visioIslLink);
            }
            summary.append("\n ethernet isls.length=" + this.ethIsls.length);
            Object visioEthIslLink = null;
            TopoEthIslDto ethIslDto = null;
            for (int i = 0; i < this.ethIsls.length; ++i) {
                VisioNodeIntf switch2;
                if (this.ethIsls[i] == null) continue;
                ethIslDto = this.ethIsls[i];
                if (vsanID < 0 ? this.group != null && !ethIslDto.isMemberOfGroup(this.group) : !ethIslDto.isMemberOfVsan((short)vsanID)) continue;
                if (ethIslDto == null || nodeMap.get(ethIslDto.getPK()) != null) continue;
                visioIslLink = VisioMapFactory.createEthIslLink(ethIslDto);
                linkMap.put(ethIslDto.getPK(), visioIslLink);
                VisioNodeIntf switch1 = (VisioNodeIntf)nodeMap.get(ethIslDto.getSwitch1PK());
                if (switch1 == null && TopologyBean.this.logger.isDebugEnabled()) {
                    summary.append("visioIslLink from node is null " + ethIslDto.getSwitch1PK() + ",");
                }
                if ((switch2 = (VisioNodeIntf)nodeMap.get(ethIslDto.getSwitch2PK())) == null && TopologyBean.this.logger.isDebugEnabled()) {
                    summary.append("visioIslLink to node is null " + ethIslDto.getSwitch2PK() + ",");
                }
                if (switch1 == null || switch2 == null) continue;
                visioIslLink.setFromNode(switch1);
                visioIslLink.setToNode(switch2);
                visioGraph.addLink(visioIslLink);
            }
            summary.append("\n npvLinks.length=" + this.npvLinks.length);
            VisioIslLinkIntf visioNpvLink = null;
            TopoNpvLinkDto npvLinkDto = null;
            for (int i = 0; i < this.npvLinks.length; ++i) {
                VisioNodeIntf switch2;
                if (this.npvLinks[i] == null) continue;
                npvLinkDto = this.npvLinks[i];
                if (vsanID < 0 ? this.group != null && this.group.getType() == 1 && !npvLinkDto.isMemberOfGroup(this.group) : !npvLinkDto.isMemberOfVsan((short)vsanID)) continue;
                if (npvLinkDto == null || nodeMap.get(npvLinkDto.getPK()) != null) continue;
                visioNpvLink = VisioMapFactory.createNpvLink(npvLinkDto);
                linkMap.put(npvLinkDto.getPK(), visioNpvLink);
                VisioNodeIntf switch1 = (VisioNodeIntf)nodeMap.get(npvLinkDto.getSwitch1PK());
                if (switch1 == null && TopologyBean.this.logger.isDebugEnabled()) {
                    summary.append("visioNpvLink from node is null " + npvLinkDto.getSwitch1PK() + ",");
                }
                if ((switch2 = (VisioNodeIntf)nodeMap.get(npvLinkDto.getSwitch2PK())) == null && TopologyBean.this.logger.isDebugEnabled()) {
                    summary.append("visioNpvLink to node is null " + npvLinkDto.getSwitch2PK() + ",");
                }
                if (switch1 == null || switch2 == null) continue;
                visioNpvLink.setFromNode(switch1);
                visioNpvLink.setToNode(switch2);
                visioGraph.addLink(visioNpvLink);
            }
            if (showEndDevices) {
                summary.append("\n hubs.length=" + this.hubs.length);
                VisioLoopNodeIntf visioLoopNode = null;
                TopoHubDto hubDto = null;
                for (int i = 0; i < this.hubs.length; ++i) {
                    if (this.hubs[i] == null) continue;
                    hubDto = this.hubs[i];
                    if (vsanID < 0 ? this.group != null && !hubDto.isMemberOfGroup(this.group) : !hubDto.isMemberOfVsan((short)vsanID)) continue;
                    if (hubDto == null || nodeMap.get(hubDto.getPK()) != null) continue;
                    visioLoopNode = VisioMapFactory.createLoopNode(hubDto);
                    this.loadCoordinates((VisioNode)((Object)visioLoopNode), true);
                    visioGraph.addNode(visioLoopNode);
                    nodeMap.put(hubDto.getPK(), visioLoopNode);
                    VisioNode fromSwitchNode = (VisioNode)nodeMap.get(this.hubs[i].getSwitchPK());
                    VisioNode toHubNode = (VisioNode)nodeMap.get(this.hubs[i].getPK());
                    VisioLoopLink link = new VisioLoopLink();
                    if (fromSwitchNode == null || toHubNode == null) continue;
                    link.setFromNode(fromSwitchNode);
                    link.setToNode(toHubNode);
                    visioGraph.addLink(link);
                }
                summary.append("\n enclosures.length=" + this.enclosures.length);
                VisioNodeIntf visioDeviceNode = null;
                TopoEnclosureDto enclosureDto = null;
                for (int i = 0; i < this.enclosures.length; ++i) {
                    if (this.enclosures[i] == null) continue;
                    enclosureDto = this.enclosures[i];
                    if (vsanID < 0 ? this.group != null && !enclosureDto.isMemberOfGroup(this.group) : !enclosureDto.isMemberOfVsan((short)vsanID)) continue;
                    if (enclosureDto == null || nodeMap.get(enclosureDto.getPK()) != null) continue;
                    visioDeviceNode = VisioMapFactory.createEndNode(enclosureDto.getFirstEndPort());
                    visioDeviceNode.setName(enclosureDto.getName());
                    this.loadCoordinates((VisioNode)visioDeviceNode, true);
                    visioGraph.addNode(visioDeviceNode);
                    nodeMap.put(enclosureDto.getPK(), visioDeviceNode);
                }
                summary.append("\n edgeLinksForEnclosures.length=" + this.edgeLinksForEnclosures.length);
                VisioEdgeLinkIntf visioEdgeLink = null;
                TopoEdgeLinkDto edgeLinkDto = null;
                visioLoopNode = null;
                for (int i = 0; i < this.edgeLinksForEnclosures.length; ++i) {
                    VisioNodeIntf enclosureNode;
                    if (this.edgeLinksForEnclosures[i] == null) continue;
                    edgeLinkDto = this.edgeLinksForEnclosures[i];
                    if (vsanID < 0 ? this.group != null && !edgeLinkDto.isMemberOfGroup(this.group) : !edgeLinkDto.isMemberOfVsan((short)vsanID)) continue;
                    if (edgeLinkDto == null || nodeMap.get(edgeLinkDto.getPK()) != null) continue;
                    visioEdgeLink = VisioMapFactory.createEdgeLink(edgeLinkDto);
                    linkMap.put(edgeLinkDto.getPK(), visioEdgeLink);
                    VisioNodeIntf visioNode = null;
                    visioNode = (VisioNodeIntf)nodeMap.get(edgeLinkDto.getSwitchPK());
                    if (visioNode == null) {
                        summary.append("visioEdgeLink switch node is null " + edgeLinkDto.getSwitchPK() + ",");
                    } else {
                        VisioSwitchNodeIntf switchNode = (VisioSwitchNodeIntf)visioNode;
                        switchDto = (TopoSwitchDto)switchNode.getModel();
                        if (switchDto.isFeatureEnabled(AbstractSwitchBase.Feature.NPV.flag())) {
                            visioEdgeLink.setDotDashed(true);
                        }
                    }
                    visioLoopNode = (VisioLoopNodeIntf)nodeMap.get(this.edgeLinksForEnclosures[i].getFPortPK());
                    if (visioLoopNode != null) {
                        visioNode = visioLoopNode;
                    }
                    if ((enclosureNode = (VisioNodeIntf)nodeMap.get(edgeLinkDto.getEnclosurePK())) == null) {
                        summary.append("visioEdgeLink enclosure node is null " + edgeLinkDto.getEnclosurePK() + ",");
                    }
                    if (visioNode == null || enclosureNode == null) continue;
                    visioEdgeLink.setFromNode(visioNode);
                    visioEdgeLink.setToNode(enclosureNode);
                    visioGraph.addLink(visioEdgeLink);
                }
            }
            if (properties == null) {
                VisioLayoutServer2 layoutServer = new VisioLayoutServer2();
                try {
                    layoutServer.layout(visioGraph);
                }
                catch (Exception e) {
                    TopologyBean.this.logger.error((Object)e);
                }
            }
            try {
                filePath = this.exportToFile(visioGraph, fileName, showLinkLabels);
            }
            catch (Exception e) {
                TopologyBean.this.logger.debug((Object)e);
                throw new RemoteException("Can't export visio fileName=" + fileName, e);
            }
            TopologyBean.this.logger.info((Object)("createVisioMap" + summary));
            if (filePath == null) {
                throw new RemoteException("Can't export visio fileName=" + fileName);
            }
            return filePath;
        }

        private String exportToFile(VisioGraphIntf visioGraph, String filename, boolean showLinkLabels) throws Exception {
            String reformatFile = filename.replaceAll("\\\\", this.escapeSeparator(File.separator));
            reformatFile = reformatFile.replaceAll("/", this.escapeSeparator(File.separator));
            int endIdx = reformatFile.lastIndexOf(File.separator);
            String visioPath = reformatFile.substring(0, endIdx);
            visioPath = ClientCache.getDcmDir() + visioPath.substring(visioPath.indexOf("dcm") + 4);
            reformatFile = ClientCache.getDcmDir() + reformatFile.substring(reformatFile.indexOf("dcm") + 4);
            visioPath = visioPath.replaceAll(Pattern.quote(File.separator), "/");
            reformatFile = reformatFile.replaceAll(Pattern.quote(File.separator), "/");
            File visioDir = new File(visioPath);
            if (!visioDir.exists() || !visioDir.isDirectory()) {
                visioDir.mkdir();
            }
            File file = new File(reformatFile);
            VisioExportAdapter2 visioExportAdapter2 = new VisioExportAdapter2(file, visioGraph, showLinkLabels);
            visioExportAdapter2.setTitle(this.title);
            visioExportAdapter2.exportToVisio();
            return reformatFile;
        }

        private String escapeSeparator(String separator) {
            if ("\\".equals(separator)) {
                return "\\" + separator;
            }
            return separator;
        }
    }
}

