/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.db;

import com.cisco.dcbu.lib.util.ReportUtil;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.OracleWrapper;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.db.PersistentWrapperIf;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

class PostgresWrapper
extends OracleWrapper
implements PersistentWrapperIf {
    public static Logger _Logger = LogManager.getLogger((String)"FM.db");
    Field _stmtField = null;

    PostgresWrapper() {
        try {
            Class<?> classObj = Class.forName("org.apache.commons.dbcp.DelegatingPreparedStatement");
            this._stmtField = classObj.getDeclaredField("_stmt");
            this._stmtField.setAccessible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.vacuum();
        this.clean();
    }

    @Override
    public String getNanVL(String columnName) {
        return columnName;
    }

    @Override
    public Boolean isOracleDB() {
        return false;
    }

    @Override
    public Boolean isPostgresDB() {
        return true;
    }

    @Override
    public void setStatementCacheSize(Connection conn, int size) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vacuum() {
        _Logger.info((Object)"Vacuum running");
        Connection con = null;
        Statement stat = null;
        ResultSet rs = null;
        ArrayList<String> tables = new ArrayList<String>();
        try {
            con = ConnectionManager.getConnection();
        }
        catch (SQLException ex) {
            _Logger.error((Object)"SQL error in Vacuum", (Throwable)ex);
            return;
        }
        try {
            DatabaseMetaData meta = con.getMetaData();
            String[] types = new String[]{"TABLE"};
            rs = meta.getTables(null, null, null, types);
            String dbUser = System.getProperties().getProperty("db.user");
            while (rs.next()) {
                String tableName = rs.getString(3);
                String tableCat = rs.getString(2);
                if (!tableCat.equals(dbUser)) continue;
                tables.add(tableName);
            }
            stat = con.createStatement();
            PersistentHelper._Logger.debug((Object)" vacuum_analyze");
            for (String tableName : tables) {
                PersistentHelper._Logger.info((Object)tableName);
                stat.execute("vacuum analyze " + tableName);
            }
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            PersistentHelper._Logger.debug((Object)(" vacuum_analyze failed:" + ex.getMessage()));
            return;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        _Logger.info((Object)"Vacuum complete");
    }

    private PreparedStatement getStmtField(Object obj) {
        try {
            return (PreparedStatement)this._stmtField.get(obj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public String getQueryString(String in) {
        String ret = in.replaceAll("CONVERT", "TO_CHAR");
        ret = ret.replaceAll(".VARCHAR", "");
        return ret;
    }

    @Override
    public boolean getBooleanFromStringField(ResultSet rs, String colName) throws SQLException {
        return rs.getString(colName).equals("t");
    }

    @Override
    public double getDouble(ResultSet rs, int pos) throws SQLException {
        return rs.getDouble(pos);
    }

    @Override
    public double getPmDouble(ResultSet rs, int pos) throws SQLException {
        double dValue = rs.getDouble(pos);
        return dValue < 0.0 ? Double.NaN : dValue;
    }

    @Override
    public void setBinaryDouble(PreparedStatement stat, double value, int pos) throws SQLException {
        stat.setDouble(pos, value);
    }

    @Override
    public void tableAnalyze() throws SQLException {
        this.vacuum();
    }

    @Override
    public String getInvISLIdxQuery() {
        return "  \tSELECT ISL.ID, S1.SYS_NAME || ':' || SP1.IF_NAME ||'<->'|| S2.SYS_NAME || ':' || SP2.IF_NAME , S1.WWN, S2.WWN, NULL,S1.IP_ADDRESS,S2.IP_ADDRESS, FABRIC.FID, NULL, NULL    \tFROM ISL, SWITCH_PORT SP1,SWITCH S1, SWITCH_PORT SP2, SWITCH S2, FABRIC \tWHERE ( ISL.PORT1_ID = SP1.ID) AND ( SP1.SWITCH_ID = S1.ID) AND ( ISL.PORT2_ID = SP2.ID) AND \t( SP2.SWITCH_ID = S2.ID) AND ( ISL.IS_CHANNELMEMBER=FALSE) AND S1.FABRIC_ID = FABRIC.ID  UNION   \tSELECT ISL.ID, S1.SYS_NAME || ':' || SP1.IF_NAME ||'<->'|| S2.SYS_NAME || ':' || SP2.IF_NAME , NULL, NULL, NULL,S1.IP_ADDRESS,S2.IP_ADDRESS, LAN.lan_id, NULL, NULL    \tFROM ETHISL ISL, ETHSWITCH_PORT SP1,ETHSWITCH S1, ETHSWITCH_PORT SP2, ETHSWITCH S2, LANSWITCH_MAP LSM, LAN \tWHERE ( ISL.PORT1_ID = SP1.ID) AND ( SP1.SWITCH_ID = S1.ID) AND ( ISL.PORT2_ID = SP2.ID) AND \t( SP2.SWITCH_ID = S2.ID) AND (( LSM.ID = S1.ID) AND (LSM.lan_id = LAN.ID)) ";
    }

    @Override
    public String getPerfIslIdxQuery() {
        return "\tSELECT  STAT.SRC_ID,STAT.DEST_ID, S1.SYS_NAME || ':' || SP1.IF_NAME ||'<->'||S2.SYS_NAME || ':' || SP2.IF_NAME, S1.WWN, S2.WWN, \tNULL,S1.IP_ADDRESS,S2.IP_ADDRESS, FABRIC.FID \tFROM STATISTICS STAT,ISL, SWITCH_PORT SP1,SWITCH S1, SWITCH_PORT SP2, SWITCH S2,FABRIC \tWHERE ( ISL.PORT1_ID = SP1.ID) AND ( SP1.SWITCH_ID = S1.ID) AND ( ISL.PORT2_ID = SP2.ID) AND ( SP2.SWITCH_ID = S2.ID) AND \t( STAT.TYPE=1) AND ( ISL.IS_CHANNELMEMBER=FALSE) AND  (FABRIC.ID = S1.FABRIC_ID) AND \t( (STAT.SRC_ID=ISL.PORT1_ID AND STAT.DEST_ID=ISL.PORT2_ID ) OR (STAT.SRC_ID=ISL.PORT2_ID AND STAT.DEST_ID=ISL.PORT1_ID ))  UNION \tSELECT  STAT.SRC_ID,STAT.DEST_ID, S1.SYS_NAME || ':' || SP1.IF_NAME ||'<->'||S2.SYS_NAME || ':' || SP2.IF_NAME, null, null, \tNULL,S1.IP_ADDRESS,S2.IP_ADDRESS, LAN.lan_id \tFROM STATISTICS STAT,ETHISL ISL, ETHSWITCH_PORT SP1,ETHSWITCH S1, ETHSWITCH_PORT SP2, ETHSWITCH S2, LANSWITCH_MAP LSM, LAN \tWHERE ( ISL.PORT1_ID = SP1.ID) AND ( SP1.SWITCH_ID = S1.ID) AND ( ISL.PORT2_ID = SP2.ID) AND ( SP2.SWITCH_ID = S2.ID) AND \t( STAT.TYPE=10) AND (( LSM.ID = S1.ID) AND (LSM.lan_id = LAN.ID)) AND \t( (STAT.SRC_ID=ISL.PORT1_ID AND STAT.DEST_ID=ISL.PORT2_ID ) OR (STAT.SRC_ID=ISL.PORT2_ID AND STAT.DEST_ID=ISL.PORT1_ID )) ";
    }

    @Override
    public String getIvrZoneSqlQuery() {
        return "SELECT  FABRIC.NAME, ZONE.PARENT_ID, ZONE.IS_IVR, ZONE.ZONE_INDEX, ZONE.NAME, ZONE.READ_ONLY, ZONE_MEMBER.TYPE,ZONE_MEMBER.MEMBER_ID, ZONE_MEMBER.LUN_ID, ZONE_MEMBER.IVR_VSAN_ID,FABRIC.IVR_ENF_ZONESET_NAME,ZONE_MEMBER.ID FROM ZONE, ZONE_MEMBER, FABRIC WHERE (ZONE_MEMBER.ZONE_ID = ZONE.ID) AND ( ZONE.IS_IVR=TRUE) AND ( ZONE.PARENT_ID = FABRIC.ID)";
    }

    @Override
    public String getZoneSqlQuery() {
        return "SELECT   FABRIC.NAME, VSAN.VSAN_ID,ZONE.PARENT_ID, ZONE.IS_IVR, ZONE.ZONE_INDEX, ZONE.NAME, ZONE.READ_ONLY, ZONE_MEMBER.TYPE,ZONE_MEMBER.MEMBER_ID, ZONE_MEMBER.LUN_ID, ZONE_MEMBER.IVR_VSAN_ID,ENF_ZONESET_NAME,ZONE_MEMBER.ID FROM VSAN,ZONE,ZONE_MEMBER, FABRIC WHERE (ZONE.ID = ZONE_MEMBER.ZONE_ID) AND ( ZONE.PARENT_ID = VSAN.ID) AND (ZONE.IS_IVR is FALSE) AND (VSAN.FABRIC_ID = FABRIC.ID) AND(FABRIC.ID=VSAN.FABRIC_ID)";
    }

    @Override
    public long retrieveFile(String fileName, File destination, String userName) throws Exception {
        return this.retrieveFile(fileName, destination, userName, "xmlDocs");
    }

    @Override
    public long retrieveFile(String fileName, File destination, String userName, String tableName) throws Exception {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        long checksum = 0L;
        try {
            String sql = "SELECT content, checksum FROM " + tableName + "  WHERE document_name = ? and user_name = ?";
            _Logger.debug((Object)("retrieveFile() path: " + destination.getPath()));
            _Logger.debug((Object)("retrieveFile()  sql: " + sql));
            conn = ConnectionManager.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, fileName);
            ps.setString(2, userName);
            rs = ps.executeQuery();
            while (rs.next()) {
                byte[] content = rs.getBytes(1);
                FileOutputStream fos = new FileOutputStream(destination);
                fos.write(content);
                fos.close();
                checksum = rs.getLong(2);
            }
            _Logger.info((Object)("Document: " + fileName + " retrieved successfully."));
        }
        catch (Exception ex) {
            try {
                _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(ps);
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(ps);
        DbUtil.close(conn);
        return checksum;
    }

    @Override
    public void storeFile(File file, String userName) throws Exception {
        this.storeFile(file, userName, "xmlDocs");
    }

    @Override
    public void storeFile(File file, String userName, String tableName) throws Exception {
        Connection conn = null;
        PreparedStatement ps = null;
        FileInputStream fis = null;
        try {
            conn = ConnectionManager.getConnection();
            fis = new FileInputStream(file);
            String sql = "INSERT INTO " + tableName + " (document_name, user_name, content, checksum, last_update_time, filesize) " + "  VALUES (?, ?, ?,?, ?, ?)";
            ps = conn.prepareStatement(sql);
            _Logger.debug((Object)("storeFile() path: " + file.getPath()));
            _Logger.debug((Object)("storeFile()  sql: " + sql));
            ps.setString(1, file.getName());
            ps.setString(2, userName);
            ps.setBinaryStream(3, (InputStream)fis, (int)file.length());
            ps.setLong(4, ReportUtil.getFileCheckSum(file, '!'));
            ps.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
            ps.setLong(6, file.length());
            ps.executeUpdate();
            _Logger.info((Object)("Document: " + file.getName() + " inserted into database successfully."));
        }
        catch (Exception ex) {
            try {
                _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                if (fis != null) {
                    fis.close();
                }
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        if (fis != null) {
            fis.close();
        }
        DbUtil.close(conn);
    }

    @Override
    public PreparedStatement getPreparedStmt(Connection conn, String sql, int resultSetType, int resultSetCon) throws Exception {
        return conn.prepareStatement(sql, resultSetType, resultSetCon);
    }
}

