/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.discovery;

import com.cisco.dcbu.lib.jnm.Fc4Decoder;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.model.Hba;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.server.discovery.DiscoveryException;
import com.cisco.dcbu.sm.server.discovery.SnmpAdapter;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.NpvLinkImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class BrcdSnmpAdapter
extends SnmpAdapter {
    static Logger _Logger = LogManager.getLogger((String)BrcdSnmpAdapter.class.getName());
    static boolean _SIMULATION = true;
    static final SnmpOID[] _BrcdSwInfoOids;
    static final SnmpOID _BrcdNsTableCntOid;
    static final SnmpOID _BrcdNsTableOid;
    static final int[][] _BrcdNsInfoOids;
    static final int[][] _BrcdConnLinkOids;

    public static void validateSeedSwitch(SnmpPeer peer, boolean supportBrcdNpvDisc) throws Exception {
        block21: {
            if (peer == null) {
                throw new IllegalArgumentException("SnmpPeer cannot be null");
            }
            StringBuilder msgBuf = new StringBuilder();
            msgBuf.append("Validate seed switch:").append(peer).append(" failed \n");
            try {
                SnmpPDU reqPdu = null;
                SnmpPDU respPdu = null;
                VarBindList vbl = null;
                SnmpVar var = null;
                reqPdu = new SnmpPDU(-96, new VarBindList(_GenSysVars.length));
                for (int i = 0; i < _GenSysVars.length; ++i) {
                    reqPdu.addNull(_GenSysVars[i]);
                }
                respPdu = peer.send(reqPdu);
                vbl = respPdu.getVariables();
                var = respPdu.getVar(0);
                if (var.getType() != 6) {
                    throw new SnmpException(peer.getAddress() + " returns bad sysObjectID");
                }
                VendorOid vendorOid = null;
                int type = -1;
                boolean isMds = false;
                boolean isQuail = false;
                int[] sysObjectID = ((SnmpOID)respPdu.getVar(0)).getValue();
                if (sysObjectID.length >= 7) {
                    vendorOid = VendorOid.getVendor(sysObjectID[6]);
                    type = sysObjectID[sysObjectID.length - 1];
                    if (vendorOid == VendorOid.Cisco) {
                        if (SnmpOID.startsWith(sysObjectID, CISCO_CHASSIS_OID)) {
                            isMds = true;
                        } else if (type == 514) {
                            isQuail = true;
                        }
                    }
                }
                if (vendorOid == VendorOid.Cisco) {
                    if (isMds || isQuail) {
                        boolean isNPVEnabled = false;
                        vbl = new VarBindList(AbstractSwitchBase.NUM_FEATURES);
                        for (int i = 1; i <= AbstractSwitchBase.NUM_FEATURES; ++i) {
                            vbl.add(_FeatureOid, i);
                        }
                        SnmpPDU pdu = new SnmpPDU(-96, vbl);
                        pdu = peer.send(pdu);
                        vbl = pdu.getVariables();
                        boolean[] flags = new boolean[AbstractSwitchBase.NUM_FEATURES];
                        for (SnmpVarBind vb : vbl) {
                            var = vb.getVar();
                            if (var.getType() != 2 || ((SnmpInt)var).getValue() != 2) continue;
                            flags[vb.getOid().getIndexFromEnd((int)0) - 1] = true;
                        }
                        if (flags[AbstractSwitchBase.Feature.NPV.flag()]) {
                            isNPVEnabled = true;
                            msgBuf.append("NPV enabled switch cannot act as a seed switch");
                        }
                        if (isNPVEnabled) {
                            throw new Exception(msgBuf.toString());
                        }
                        break block21;
                    }
                    msgBuf.append("It is not a MDS switch device: " + type);
                    throw new Exception(msgBuf.toString());
                }
                if (vendorOid == VendorOid.Brocade && supportBrcdNpvDisc) {
                    reqPdu = new SnmpPDU(-96, new VarBindList(_BrcdSwInfoOids.length));
                    for (int i = 0; i < _BrcdSwInfoOids.length; ++i) {
                        reqPdu.addNull(_BrcdSwInfoOids[i]);
                    }
                    respPdu = peer.send(reqPdu);
                    vbl = respPdu.getVariables();
                    boolean hasValue = false;
                    if (vbl != null) {
                        for (SnmpVarBind vb : vbl) {
                            if (vb.getVar() == null) continue;
                            hasValue = true;
                            break;
                        }
                    }
                    if (!hasValue) {
                        msgBuf.append("Brocade switch does not support SW-MIB, cannot be NPV core");
                        throw new Exception(msgBuf.toString());
                    }
                    break block21;
                }
                msgBuf.append("Invalid switch vendor:" + vendorOid.getName());
                throw new Exception(msgBuf.toString());
            }
            catch (SnmpException e) {
                msgBuf.append("Cannot verify seed switch from SNMP:").append(e.getMessage());
                _Log.warn((Object)msgBuf.toString(), (Throwable)e);
                throw new Exception(msgBuf.toString(), e);
            }
        }
    }

    public static boolean isBrcdSwitch(SnmpPeer peer) throws SnmpException {
        VendorOid vendorOid;
        if (peer == null) {
            throw new IllegalArgumentException("SnmpPeer cannot be null");
        }
        SnmpOID sysOid = new SnmpOID(MibNode.get("sysObjectID").getOid(), 0);
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(1));
        reqPdu.addNull(sysOid);
        SnmpPDU rspPdu = peer.send(reqPdu);
        int[] sysObjectID = ((SnmpOID)rspPdu.getVar(0)).getValue();
        return sysObjectID.length >= 7 && (vendorOid = VendorOid.getVendor(sysObjectID[6])) == VendorOid.Brocade;
    }

    public static byte[] getBrcdSwitchWwn(SnmpPeer peer) throws SnmpException {
        if (peer == null) {
            throw new IllegalArgumentException("SnmpPeer cannot be null");
        }
        SnmpOID swwnOid = new SnmpOID(MibNode.get("fcFeElementName").getOid(), 0);
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(1));
        reqPdu.addNull(swwnOid);
        SnmpPDU rspPdu = peer.send(reqPdu);
        byte[] b = rspPdu.getVariables().byteValue(0);
        if (WwnDictionary.isBrocadeWwn(b)) {
            return b;
        }
        throw new SnmpException("Cannot get Brocade switch wwn from peer:" + peer);
    }

    public static String getBrcdSwitchVersion(SnmpPeer peer) throws SnmpException {
        if (peer == null) {
            throw new IllegalArgumentException("SnmpPeer cannot be null");
        }
        SnmpOID versionOid = new SnmpOID(MibNode.get("swFirmwareVersion").getOid(), 0);
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(1));
        reqPdu.addNull(versionOid);
        SnmpPDU rspPdu = peer.send(reqPdu);
        String version = rspPdu.getVariables().stringValue(0);
        return version;
    }

    public static boolean discoverSwitchInfo(SwitchImpl sw) throws SnmpException {
        if (sw == null || !sw.isBrocade()) {
            throw new SnmpException("Invalid Brocade switch:" + sw);
        }
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(_BrcdSwInfoOids.length));
        for (int i = 0; i < _BrcdSwInfoOids.length; ++i) {
            reqPdu.addNull(_BrcdSwInfoOids[i]);
        }
        SnmpPDU rspPdu = sw.createPeer().send(reqPdu);
        VarBindList vbl = rspPdu.getVariables();
        byte[] dateBytes = vbl.get(0).byteValue();
        BigInteger bint = new BigInteger(dateBytes);
        sw.setVersion(vbl.get(1).stringValue());
        int opStatus = vbl.get(2).intValue();
        int adminStatus = vbl.get(3).intValue();
        int domainID = vbl.get(4).intValue();
        sw.setWwn(new Wwn(vbl.get(5).byteValue()));
        sw.setNumFeModules(vbl.get(6).intValue());
        sw.setNumConnUnits(vbl.get(7).intValue());
        FabricImpl fabImpl = sw.getFabric();
        if (fabImpl != null) {
            if (fabImpl.getNumVsans() == 0) {
                int vid = 1;
                VsanImpl vsan = sw.getFabric().createVsan(vid, sw.getWwn());
                vsan.setOperState((byte)1);
                vsan.syncLastScanTime();
                vsan.setSeed(sw);
                vsan.addSwitch(sw, domainID, sw.getWwn());
            } else {
                VsanImpl[] vsans;
                for (VsanImpl v : vsans = fabImpl.getVsans()) {
                    v.addSwitch(sw, domainID, sw.getWwn());
                }
            }
        }
        sw.resetDiscFlag(2);
        return true;
    }

    private static VsanImpl createBrcdDummyVsan(SwitchImpl sw) {
        String vsanName = "Brcd_VSAN_1";
        byte adminState = 1;
        byte opState = 1;
        byte interop = 0;
        int mtu = 0;
        byte lbType = 0;
        boolean ioDelivery = true;
        int latency = 0;
        Wwn prinwwn = sw.getWwn();
        VsanPK vkey = new VsanPK(1, sw.getWwn());
        VsanImpl vsan = sw.getFabric().createVsan(vkey, vsanName, adminState, opState, interop, mtu, lbType, ioDelivery, latency);
        return vsan;
    }

    public static boolean discoverIsls(SwitchImpl sw) {
        return true;
    }

    public static boolean discoverEndPorts(SwitchImpl sw) throws SnmpException {
        byte[] bNodeIp;
        String nodeSymbName;
        int i;
        if (sw == null || !sw.isBrocade()) {
            throw new SnmpException("Invalid Brocade switch:" + sw);
        }
        VsanImpl vsan = sw.getVsan((short)1);
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(1));
        reqPdu.addNull(_BrcdNsTableCntOid);
        SnmpPDU rspPdu = sw.createPeer().send(reqPdu);
        int nsCnt = rspPdu.getVariables().get(0).intValue();
        if (nsCnt < 1) {
            _Log.debug((Object)("discoverEndPorts: sw has empty entries -- switch:" + sw.getIpAddress()));
            return true;
        }
        HashMap<Wwn, Wwn> linkWwnMap = new HashMap<Wwn, Wwn>();
        VarBindList vbl = new VarBindList(_BrcdConnLinkOids.length);
        for (int i2 = 0; i2 < _BrcdConnLinkOids.length; ++i2) {
            vbl.add(_BrcdConnLinkOids[i2]);
        }
        rspPdu = SnmpFetch.getBulk(sw.getPeer(), vbl, _Logger);
        VarBindList rspVbl = rspPdu.getVariables();
        for (int i3 = 0; i3 < rspVbl.size(); i3 += _BrcdConnLinkOids.length) {
            byte[] bfwwn = rspVbl.byteValue(i3);
            Wwn fwwn = new Wwn(bfwwn);
            byte[] bpwwn = rspVbl.byteValue(i3 + 1);
            Wwn pwwn = new Wwn(bpwwn);
            linkWwnMap.put(pwwn, fwwn);
        }
        vbl.clear();
        rspVbl.clear();
        SanManager sm = SanManager.getInstance();
        InventoryManager im = InventoryManager.getInstance();
        FabricImpl fabric = sw.getFabric();
        HashMap<Short, VsanImpl> vsanById = new HashMap<Short, VsanImpl>(1);
        vsanById.put((short)1, vsan);
        HashMap<Short, List<EndPortImpl>> oldEpsByVid = new HashMap<Short, List<EndPortImpl>>(vsanById.size());
        HashMap<Short, List<NpvLinkImpl>> oldNpvlsByVid = new HashMap<Short, List<NpvLinkImpl>>(vsanById.size());
        HashMap<Short, List<SwitchImpl>> oldNpvsByVid = new HashMap<Short, List<SwitchImpl>>(vsanById.size());
        for (Map.Entry ent : vsanById.entrySet()) {
            short vid = (Short)ent.getKey();
            VsanImpl v = (VsanImpl)ent.getValue();
            oldEpsByVid.put(vid, v.getEndPorts());
            oldNpvlsByVid.put(vid, v.getNpvLinks());
            oldNpvsByVid.put(vid, v.getNpvEdgeSwitches());
        }
        vbl = new VarBindList(_BrcdNsInfoOids.length);
        for (int i4 = 0; i4 < _BrcdNsInfoOids.length; ++i4) {
            vbl.add(_BrcdNsInfoOids[i4]);
        }
        rspPdu = SnmpFetch.getBulk(sw.getPeer(), vbl, nsCnt);
        rspVbl = rspPdu.getVariables();
        short vsanId = 1;
        HashMap<Wwn, SwitchImpl> npvSwByFwwn = new HashMap<Wwn, SwitchImpl>();
        HashMap<Integer, SwitchImpl> npvSwByFcid = new HashMap<Integer, SwitchImpl>();
        HashSet<SwitchImpl> newNpvSws = new HashSet<SwitchImpl>();
        HashSet<Integer> npvEntries = new HashSet<Integer>();
        for (i = 0; i < rspVbl.size(); i += _BrcdNsInfoOids.length) {
            Wwn fwwn;
            SwitchImpl oldnpvSw;
            int[] fc4Type;
            byte[] btype = rspVbl.byteValue(i + 8);
            if (btype == null || !Fc4Decoder.isFc4TypeSet(fc4Type = SnmpIntList.valueOf(btype), 229)) continue;
            npvEntries.add(i);
            byte[] bnpwwn = rspVbl.byteValue(i + 2);
            if (bnpwwn.length == 0 || bnpwwn[0] == 0 || !WwnDictionary.isCiscoWwn(bnpwwn)) {
                _Log.debug((Object)(sw.getIpAddress() + " -- ignore NPV device with no valid PWWN:" + SnmpString.toHexString(bnpwwn)));
                continue;
            }
            Wwn npwwn = new Wwn(bnpwwn);
            byte[] bnwwn = rspVbl.byteValue(i + 4);
            byte[] bvwwn = new byte[8];
            System.arraycopy(bnwwn, 0, bvwwn, 0, 8);
            Wwn swwn = BrcdSnmpAdapter.vsanWwnToSwitchWwn(bvwwn);
            SwitchImpl npvSw = SanManager.getInstance().findSwitch(swwn, fabric.getPK());
            if (npvSw == null) {
                npvSw = SanManager.getInstance().createSwitch(swwn, null, fabric);
                newNpvSws.add(npvSw);
            } else if (npvSw.getFabric() == null) {
                npvSw.setFabric(fabric);
            } else if (npvSw.getFabric() != fabric && (oldnpvSw = npvSw) != (npvSw = SanManager.getInstance().mergeSwitch(npvSw, fabric))) {
                newNpvSws.add(npvSw);
            }
            npvSw.setFeatureEnabled(AbstractSwitchBase.Feature.NPV.flag(), true);
            ((List)oldNpvsByVid.get(vsanId)).remove(npvSw);
            byte[] bFcId = rspVbl.byteValue(i);
            int fcId = (bFcId[bFcId.length - 3] << 16) + (bFcId[bFcId.length - 2] << 8) + bFcId[bFcId.length - 1];
            npvSwByFcid.put(fcId, npvSw);
            vsan.addSwitch(npvSw, fcId, new Wwn(bnwwn));
            String portSymbName = rspVbl.stringValue(i + 3);
            nodeSymbName = rspVbl.stringValue(i + 5);
            bNodeIp = rspVbl.byteValue(i + 6);
            InetAddress nodeIp = null;
            if (!GenUtil.isValueFilled(bNodeIp, (byte)0)) {
                try {
                    nodeIp = GenUtil.startsWith(bNodeIp, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1}) ? Inet4Address.getByAddress(new byte[]{bNodeIp[12], bNodeIp[13], bNodeIp[14], bNodeIp[15]}) : Inet6Address.getByAddress(bNodeIp);
                }
                catch (UnknownHostException uhe) {
                    _Log.error((Object)(sw.getIpAddress() + " -- returns invalid node IP address: " + SnmpString.toHexString(bNodeIp)));
                }
            }
            if (!GenUtil.equals(npvSw.getInetAddress(), nodeIp)) {
                npvSw.setManagementAddresses(new InetAddress[]{nodeIp});
            }
            npvSw.setManageable(true, null);
            if (nodeSymbName != null && nodeSymbName.length() != 0 && npvSw.getSysName() == null) {
                npvSw.setSysName(nodeSymbName);
            }
            if ((fwwn = (Wwn)linkWwnMap.get(npwwn)) == null) {
                _Log.warn((Object)("discoverEndPorts: cannot find the fwwn for the np port:" + npwwn));
                continue;
            }
            npvSwByFwwn.put(fwwn, npvSw);
            SwitchImpl coreSw = sw;
            byte[] bfwwn = fwwn.getValue();
            int fpIfindex = coreSw.getBase().ifWwn2IfIndex(bfwwn, IfIndexIf.FwwnInfo.NPV);
            int npIfindex = npvSw.getBase().ifWwn2IfIndex(bnpwwn, IfIndexIf.FwwnInfo.NPV);
            if (fpIfindex != -1 && npIfindex != -1) {
                NpvLinkImpl npvl = fabric.createNpvLink(coreSw, npvSw, fpIfindex, npIfindex, bfwwn, bnpwwn);
                vsan.addNpvLink(npvl);
                ((List)oldNpvlsByVid.get(vsanId)).remove(npvl);
                if (!_Log.isDebugEnabled()) continue;
                _Log.debug((Object)(sw.getIpAddress() + " -- NP link discovered " + coreSw.getWwn() + "/" + SnmpString.toHexString(fwwn.getValue()) + " <-> " + npvSw.getWwn() + "/" + SnmpString.toHexString(bnpwwn) + " in VSAN " + vsanId));
                continue;
            }
            _Log.warn((Object)(sw.getIpAddress() + " -- skip the NP link cannot resolve the ifindex" + coreSw.getWwn() + "/" + SnmpString.toHexString(fwwn.getValue()) + " <-> " + npvSw.getWwn() + "/" + SnmpString.toHexString(bnpwwn) + " in VSAN " + vsanId));
        }
        for (i = 0; i < rspVbl.size(); i += _BrcdNsInfoOids.length) {
            Hba hba;
            if (npvEntries.contains(i)) continue;
            byte[] bFcId = rspVbl.byteValue(i);
            byte domainId = bFcId[bFcId.length - 3];
            byte ifIndex = bFcId[bFcId.length - 2];
            byte alpaId = bFcId[bFcId.length - 1];
            int fcId = (domainId << 16) + (ifIndex << 8) + alpaId;
            int portType = rspVbl.get(i + 1).intValue();
            byte[] bpwwn = rspVbl.byteValue(i + 2);
            Wwn pwwn = new Wwn(bpwwn);
            String portSymbName = rspVbl.stringValue(i + 3);
            byte[] bnwwn = rspVbl.byteValue(i + 4);
            Wwn nwwn = new Wwn(bnwwn);
            nodeSymbName = rspVbl.stringValue(i + 5);
            bNodeIp = rspVbl.byteValue(i + 6);
            String cos = rspVbl.stringValue(i + 7);
            byte[] btype = rspVbl.byteValue(i + 8);
            int[] fc4Type = SnmpIntList.valueOf(btype);
            EndPortImpl ep = sm.findEndPort(pwwn, fabric.getPK());
            if (ep == null) {
                ep = sm.createEndPort(pwwn, nwwn, fc4Type, null, fabric);
            } else {
                ep.setFc4Type(fc4Type);
                ep.setFc4Feature(null);
                ep.setFabric(fabric);
                ep.setNodeWwn(nwwn);
            }
            ep.setLoop(portType == 3);
            Wwn fwwn = (Wwn)linkWwnMap.get(pwwn);
            SwitchImpl npvSw = (SwitchImpl)npvSwByFwwn.get(fwwn);
            if (npvSw == null) {
                ep.setFPort(sw, ifIndex);
                ep.setIfName(sw, ifIndex);
            } else {
                ep.setFPort(npvSw, 1);
                ep.setIfName(npvSw, 1);
            }
            ep.setSymPortName(portSymbName);
            ep.setSymNodeName(nodeSymbName);
            if (nodeSymbName != null && nodeSymbName.length() > 0 && (hba = im.createHba(ep.getPortWwn(), ep.getNodeWwn(), nodeSymbName)) != null && ep.getEnclosure() != null) {
                ep.getEnclosure().addHba(hba);
            }
            InetAddress nodeIp = null;
            if (!GenUtil.isValueFilled(bNodeIp, (byte)0)) {
                try {
                    nodeIp = GenUtil.startsWith(bNodeIp, new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1}) ? Inet4Address.getByAddress(new byte[]{bNodeIp[12], bNodeIp[13], bNodeIp[14], bNodeIp[15]}) : Inet6Address.getByAddress(bNodeIp);
                }
                catch (UnknownHostException uhe) {
                    _Log.error((Object)(sw.getIpAddress() + " -- returns invalid node IP address: " + SnmpString.toHexString(bNodeIp)));
                }
            }
            if (nodeIp != null) {
                ep.setNodeIpAddress(nodeIp.getHostAddress());
            }
            if (ep.getLastScanTime() < fabric.getLastScanTime()) {
                ep.syncLastScanTime();
            }
            ((List)oldEpsByVid.get(vsanId)).remove(ep);
            vsan.addEndPort(ep, fcId);
            if (!_Log.isDebugEnabled()) continue;
            _Log.debug((Object)("discoverEndPorts--sw:" + sw.getIpAddress() + " ep:" + ep));
        }
        for (VsanImpl v : vsanById.values()) {
            v.resetDiscFlag(2);
            for (EndPortImpl rep : (List)oldEpsByVid.get(v.getId())) {
                v.removeEndPort(rep);
            }
            for (NpvLinkImpl npvl : (List)oldNpvlsByVid.get(v.getId())) {
                v.removeNpvLink(npvl);
            }
            for (SwitchImpl npv : (List)oldNpvsByVid.get(v.getId())) {
                if (npv == null || !npv.isNpvEnabled()) continue;
                v.removeSwitch(npv);
            }
        }
        for (SwitchImpl npvsw : newNpvSws) {
            try {
                fabric.getWorker().startSwitchWorker(npvsw);
            }
            catch (DiscoveryException dex) {
                _Log.warn((Object)("starting switch worker failed: " + dex.getMessage()));
            }
        }
        return true;
    }

    static {
        String[] brcdSwInfoMibNodeNames = new String[]{"swBootDate", "swFirmwareVersion", "swOperStatus", "swAdmStatus", "swDomainID", "fcFeElementName", "fcFeModuleCapacity", "uNumber"};
        _BrcdSwInfoOids = new SnmpOID[brcdSwInfoMibNodeNames.length];
        for (int i = 0; i < brcdSwInfoMibNodeNames.length; ++i) {
            BrcdSnmpAdapter._BrcdSwInfoOids[i] = new SnmpOID(MibNode.get(brcdSwInfoMibNodeNames[i]).getOid(), 0);
        }
        _BrcdNsTableCntOid = new SnmpOID(MibNode.get("swNsLocalNumEntry").getOid(), 0);
        _BrcdNsTableOid = new SnmpOID(MibNode.get("swNsLocalNumEntry").getOid(), 0);
        String[] brcdNsMibNodeName = new String[]{"swNsPortID", "swNsPortType", "swNsPortName", "swNsPortSymb", "swNsNodeName", "swNsNodeSymb", "swNsIpAddress", "swNsCos", "swNsFc4"};
        _BrcdNsInfoOids = new int[brcdNsMibNodeName.length][];
        for (int i = 0; i < brcdNsMibNodeName.length; ++i) {
            BrcdSnmpAdapter._BrcdNsInfoOids[i] = MibNode.get(brcdNsMibNodeName[i]).getOid();
        }
        String[] brcdConnLinkNodeName = new String[]{"connUnitLinkPortWwnX", "connUnitLinkPortWwnY"};
        _BrcdConnLinkOids = new int[brcdConnLinkNodeName.length][];
        for (int i = 0; i < brcdConnLinkNodeName.length; ++i) {
            BrcdSnmpAdapter._BrcdConnLinkOids[i] = MibNode.get(brcdConnLinkNodeName[i]).getOid();
        }
    }

    public static enum VendorOid {
        Cisco("Cisco", new int[]{9}),
        Brocade("Brocade", new int[]{1588}),
        McData("McData", new int[]{289}),
        QLogic("QLogic", new int[]{1663, 3873}),
        Unknown("Unknown", new int[0]);

        private int[] oids;
        private String name;

        private VendorOid(String name, int[] oids) {
            this.name = name;
            this.oids = oids;
        }

        public int[] getOids() {
            return this.oids;
        }

        public String getName() {
            return this.name;
        }

        public boolean matchVendorOid(int oid) {
            if (this == Unknown) {
                return !Cisco.matchVendorOid(oid) && !Brocade.matchVendorOid(oid) && !McData.matchVendorOid(oid) && !QLogic.matchVendorOid(oid);
            }
            for (int i = 0; i < this.oids.length; ++i) {
                if (oid != this.oids[i]) continue;
                return true;
            }
            return false;
        }

        public static VendorOid getVendor(int oid) {
            if (Cisco.matchVendorOid(oid)) {
                return Cisco;
            }
            if (Brocade.matchVendorOid(oid)) {
                return Brocade;
            }
            if (McData.matchVendorOid(oid)) {
                return McData;
            }
            if (QLogic.matchVendorOid(oid)) {
                return QLogic;
            }
            return Unknown;
        }
    }
}

