/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.discovery;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.sm.server.discovery.BrcdSnmpAdapter;
import com.cisco.dcbu.sm.server.discovery.DiscoveryException;
import com.cisco.dcbu.sm.server.discovery.SnmpAdapter;
import com.cisco.dcbu.sm.server.discovery.SwType;
import com.cisco.dcbu.sm.server.discovery.SwitchWorker;
import com.cisco.dcbu.sm.server.discovery.WorkerCallbackIf;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class BrcdSwitchWorker
extends SwitchWorker {
    static Logger _Logger = LogManager.getLogger((String)BrcdSwitchWorker.class.getName());
    static BrcdSwDiscProc[] _BrcdProcs = new BrcdSwDiscProc[]{new BrcdSwDiscProc(1, SwType.BRCD, 1), new BrcdSwDiscProc(2, SwType.BRCD, 2), new BrcdSwDiscProc(3, SwType.BRCD, 4), new BrcdSwDiscProc(20, SwType.BRCD, 0)};

    BrcdSwitchWorker(SwitchImpl seed, WorkerCallbackIf observer) {
        super(seed, observer);
    }

    @Override
    protected void exec() throws Exception {
        boolean wasManageable = this._seed.isManageable();
        if (this._seed.getPeer() == null || !this._seed.isManageable()) {
            try {
                this._seed.createPeer();
            }
            catch (Exception se) {
                if (wasManageable) {
                    _Logger.warn((Object)(this + " discovery skipped: " + se.getMessage()), (Throwable)se);
                }
                return;
            }
        }
        for (BrcdSwDiscProc proc : _BrcdProcs) {
            if (this._status.get() == 1) {
                long time = _Logger.isDebugEnabled() ? System.currentTimeMillis() : 0L;
                boolean execed = proc.discover(this._seed);
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)(this + ": " + proc + (execed ? " done in " + (System.currentTimeMillis() - time) + " ms" : " skipped")));
                }
            } else if (this._status.get() == 2) {
                _Logger.warn((Object)(this + ": " + proc + " interrupted abruptly"));
                return;
            }
            this.sendUpdate(proc);
        }
    }

    @Override
    public String toString() {
        return this._seed.getIpAddress() + " -- BrcdSwitchWorker";
    }

    static class BrcdSwDiscProc
    extends SwitchWorker.SwDiscProc {
        BrcdSwDiscProc(byte step, SwType swtype, int flag) {
            super(step, swtype, flag);
        }

        @Override
        public String toString() {
            return "discover " + SwitchWorker._DescrTable[this._step - 1];
        }

        @Override
        boolean discover(SwitchImpl sw) throws DiscoveryException {
            boolean b = false;
            if (this._flag != 0 && !sw.isDiscFlagSet(this._flag) || this._swtype != SwType.BRCD) {
                return false;
            }
            try {
                switch (this._step) {
                    case 1: {
                        b = SnmpAdapter.discoverSysInfo(sw);
                        break;
                    }
                    case 2: {
                        b = BrcdSnmpAdapter.discoverSwitchInfo(sw);
                        break;
                    }
                    case 3: {
                        b = SnmpAdapter.discoverConnUnitInfo(sw);
                        break;
                    }
                    case 20: {
                        b = BrcdSnmpAdapter.discoverEndPorts(sw);
                    }
                }
            }
            catch (SnmpException se) {
                _Logger.warn((Object)(sw.getIpAddress() + " -- BrcdSwitchWorker: " + this + " exception: " + se.getMessage()), (Throwable)se);
            }
            catch (Exception ex) {
                if (!sw.isPeerCreated()) {
                    sw.setManageable(false, "peer failure");
                    throw new DiscoveryException(sw.getIpAddress() + " -- BrcdSwitchWorker: " + this + " " + "peer failure", ex);
                }
                if (ex instanceof DiscoveryException && ((DiscoveryException)ex).isCausedBySnmp()) {
                    _Logger.log((Priority)Level.WARN, (Object)(sw.getIpAddress() + " -- BrcdSwitchWorker: " + this + " exception: " + ex.getMessage()));
                }
                _Logger.log((Priority)Level.WARN, (Object)(sw.getIpAddress() + " -- BrcdSwitchWorker: " + this + " exception: " + ex.getMessage()), (Throwable)ex);
            }
            return b;
        }
    }
}

