/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.discovery;

import com.cisco.dcbu.lib.jnm.Bits;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.IpUtil;
import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.mds.CatEntityMibHelper;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.mds.NexusEntityMibHelper;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpNull;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.dto.HwInventoryType;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.type.MacAddress;
import com.cisco.dcbu.sm.common.type.PlatformType;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class CdpSnmpAdapter {
    public static final TraceLogger _Tracer;
    public static final MibEnum[] CdpCapabilityEnum;
    public static final String SERIAL_MAP_FILE;
    public static Map<String, List<String>> serialNumMap;
    public static final int[] CISCO_NX_CHASSIS_OID;
    public static final int[] CISCO_CAT6_CHASSIS_OID;
    public static final int[] CISCO_CAT5_CHASSIS_OID;
    public static final int[] CISCO_IP_PHONE_OID;
    public static final String MibCmd_StrValue = "_strValue";
    public static final int UnknownEnt = 0;
    public static final int OtherEnt = 1;
    public static final int MdsEnt = 2;
    public static final int CatEnt = 3;
    public static final int N5KEnt = 4;
    public static final int UCSEnt = 5;
    public static final int N1KEnt = 6;
    public static final int GenSys_sysOid_idx = 0;
    public static final int GenSys_sysDesc_idx = 1;
    public static final int GenSys_sysUptime_idx = 2;
    public static final int GenSys_sysContact_idx = 3;
    public static final int GenSys_sysName_idx = 4;
    public static final int GenSys_sysLoc_idx = 5;
    public static final String[] GenSys_MibCmds;
    public final int SwInfo_telnetService_idx = 0;
    public final int SwInfo_sshSerive_idx = 0;
    public static final String[] SwInfo_MibCmds;
    public static final int CdpCache_addr_idx = 0;
    public static final int CdpCache_deviceId_idx = 1;
    public static final int CdpCache_platf_idx = 2;
    public static final int CdpCache_version_idx = 3;
    public static final int CdpCache_devicePort_idx = 4;
    public static final int CdpCache_capa_idx = 5;
    public static final int CdpCache_nativeVlan_idx = 6;
    public static final int CdpCache_vtpMgmtDomain_idx = 7;
    public static final int CdpCache_primMgmtAddr_idx = 8;
    public static final int CdpCache_secMgmtAddr_idx = 9;
    public static final int CdpCache_sysName_idx = 10;
    public static final int CdpCache_sysOID_idx = 11;
    public static final int CdpCache_sysLoc_idx = 12;
    public static final String[] CdpCache_MibCmds;
    public static final int CdpCacheIndex_ifIndex_idx = 0;
    public static final int CdpCacheIndex_deviceIndex_idx = 1;
    public static final String[] CdpCacheIndex_MibCmds;
    public static final int CdpGlobal_run_idx = 0;
    public static final int CdpGlobal_deviceId_idx = 1;
    public static final String[] CdpGlobal_MibCmds;
    public static final String CdpLastChange_MibCmd = "cdpGlobalLastChange";
    public static final int CiscoRF_unitId_idx = 0;
    public static final int CiscoRF_unitState_idx = 1;
    public static final int CiscoRF_peerUnitId_idx = 2;
    public static final int CiscoRF_peerUnitState_idx = 3;
    public static final String[] CiscoRF_MibCmds;
    public static final int EntTable_class_idx = 0;
    public static final int EntTable_parentRelPos_idx = 1;
    public static final int EntTable_vendorType_idx = 2;
    public static final int EntTable_name_idx = 3;
    public static final int EntTable_hwRev_idx = 4;
    public static final int EntTable_fwRev_idx = 5;
    public static final int EntTable_swRev_idx = 6;
    public static final int EntTable_serialNum_idx = 7;
    public static final int EntTable_mfgName_idx = 8;
    public static final int EntTable_modelName_idx = 9;
    public static final int EntTable_assetID_idx = 10;
    public static final int EntTable_containedIn_idx = 11;
    public static final String[] EntTable_MibCmds;
    public static final String EntTable_phyIndex_MibCmd = "entPhysicalIndex";
    public static final int EntLastChange_time_idx = 0;
    public static final int EntLastChange_activeUnitId_idx = 1;
    public static final String[] EntLastChange_MibCmds;
    public static final String[] CiscoChassis_MibCmds;
    public static final int Module_adminStatus_idx = 0;
    public static final int Module_operStatus_idx = 1;
    public static final int Module_resetReason_idx = 2;
    public static final int Module_lastChangetTime_idx = 3;
    public static final int Module_powerAdminStatus_idx = 4;
    public static final int Module_powerOperStatus_idx = 5;
    public static final int Module_powerCurrent_idx = 6;
    public static final int Module_phyDescr_idx = 7;
    public static final String[] Module_MibCmds;
    public static final int Power_operStatus_idx = 0;
    public static final int Power_redundancy_idx = 1;
    public static final int Power_totalAvailCurrent_idx = 2;
    public static final int Power_totalDrawnCurrent_idx = 3;
    public static final int Power_unit_idx = 4;
    public static final String[] Power_MibCmds;
    public static final int Fan_operStatus_idx = 0;
    public static final String[] Fan_MibCmds;
    public static final int EthIf_ifDescr_idx = 0;
    public static final int EthIf_ifType_idx = 1;
    public static final int EthIf_ifMtu_idx = 2;
    public static final int EthIf_ifSpeed_idx = 3;
    public static final int EthIf_ifPhyAddr_idx = 4;
    public static final int EthIf_ifadminStatus_idx = 5;
    public static final int EthIf_ifoperStatus_idx = 6;
    public static final int EthIf_ifHighSpeed_idx = 7;
    public static final int EthIf_ifAlias_idx = 8;
    public static final int EthIf_fcIfOperStatusCause_idx = 9;
    public static final String[] EthIf_MibCmds;
    public static final int[] _EthIfOperStatusOid;
    public static final int NxEthChannel_adminStatus_idx = 0;
    public static final int NxEthChannel_portList_idx = 1;
    public static final int NxEthChannel_portIndexList_idx = 2;
    public static final String[] NxEthChannel_MibCmds;
    public static final int PortAccessVlan_type_idx = 0;
    public static final int PortAccessVlan_status_idx = 1;
    public static final int PortAccessVlan_vlan_idx = 2;
    public static final String[] PortAccessVlan_MibCmds;
    public static final int PortTrunkVlan_dynStatus_idx = 0;
    public static final int PortTrunkVlan_nativeVlan_idx = 1;
    public static final int PortTrunkVlan_first2kVlan_idx = 2;
    public static final int PortTrunkVlan_sec2kVlan_idx = 3;
    public static final String[] PortTrunkVlan_MibCmds;
    public static final int CatEthChannel_portState_idx = 0;
    public static final int CatEthChannel_partnerDeviceId_idx = 1;
    public static final int CatEthChannel_partnerIfIndex_idx = 2;
    public static final int CatEthChannel_partnerGrpIfIndex_idx = 3;
    public static final String[] CatEthChannel_MibCmds;
    public static final String[] CatEthChannelMap_MibCmds;
    public static final int Vdc_name_idx = 0;
    public static final int Vdc_state_idx = 1;
    public static final int Vdc_fcoeCapa_idx = 2;
    public static final int Vdc_mac_idx = 3;
    public static final int Vdc_switchId_idx = 4;
    public static final String[] Vdc_MibCmds;
    public static final String[] License_MibCmds;
    public static final int CatUsage_avgBusy_idx = 0;
    public static final int CatUsage_memPoolUsage_idx = 1;
    public static final int CatUsage_memPoolFree_idx = 2;
    public static final String[] CatUsage_MibCmds;
    public static final int NxUsage_cpuUtil_idx = 0;
    public static final int NxUsage_memUtil_idx = 1;
    public static final String[] NxUsage_MibCmds;
    public static final String CiscoFeature_MibCmd = "cfcFeatureCtrlOpStatus";
    public static final String CiscoFeatureSet_MibCmd = "cfcFeatureSetOpStatus";
    public static final String CiscoSharedEthIf_MidCmd = "cieIfSharedConfig";
    public static final String CiscoNumOfLic_MidCmd = "clmNoOfLicensedFeatures";
    static final SnmpOID[] GenSysVars;
    static final SnmpOID[] SwInfoVars;
    static final SnmpOID[] CdpGlobalVars;
    static final SnmpOID[] EntLastChangeVars;
    static final SnmpOID[] CiscoRFVars;
    static final SnmpOID EntLastCheckVar;
    static final SnmpOID CdpEnableVar;
    static final SnmpOID CiscoNumOfLicVar;
    static final SnmpOID CdpLastChangeVar;
    static final int[] CiscoFeatureOid;
    static final int[] CiscoFeatureSetOid;
    static final int[] CiscoSharedEthIfOid;
    static final int[][] EntOids;
    static final int[][] CiscoChassisOids;
    static final int[][] ModuleOids;
    static final int[][] PowerOids;
    static final int[][] FanOids;
    static final int[][] EthIfOids;
    static final int[][] CdpCacheOids;
    static final int[][] NxEthChannelOids;
    static final int[][] CatEthChannelOids;
    static final int[][] CatEthChannelMapOids;
    static final int[][] PortAccessVlanOids;
    static final int[][] PortTrunkVlanOids;
    static final int[][] VdcOids;
    static final int[][] LicenseOids;
    static final int[][] CatUsageOids;
    static final int[][] NxUsageOids;

    public static boolean isPeerReachable(SnmpPeer peer) {
        if (peer == null) {
            return false;
        }
        InetAddress ip = peer.getAddress();
        if (IpUtil.isAllZeros(ip)) {
            return false;
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "isPeerReachable");
        }
        boolean ret = false;
        try {
            SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(1));
            reqPdu.addNull(GenSysVars[0]);
            SnmpPDU rspPdu = peer.send(reqPdu);
            SnmpVar var = rspPdu.getVar(0);
            if (var.getType() == 6) {
                ret = true;
            }
        }
        catch (Throwable e) {
            _Tracer.log(Level.DEBUG, peer + " is not reachable:" + e.getMessage());
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "isPeerReachable", ret);
        }
        return ret;
    }

    public static boolean isCdpEnabled(SnmpPeer peer) {
        if (peer == null) {
            return false;
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "isCdpEnabled");
        }
        boolean ret = false;
        try {
            SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(1));
            reqPdu.addNull(CdpEnableVar);
            SnmpPDU rspPdu = peer.send(reqPdu);
            VarBindList vbl = rspPdu.getVariables();
            SnmpVarBind vb = vbl.getVb(0);
            if (!vb.isNull() && vb.intValue() == 1) {
                ret = true;
            }
        }
        catch (Throwable e) {
            _Tracer.log(Level.DEBUG, peer + " cdp is not enable:" + e.getMessage());
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "isCdpEnabled", ret);
        }
        return ret;
    }

    public static Map getGenSysInfo(SnmpPeer peer) throws SnmpException {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer:" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getGenSysInfo");
        }
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(GenSysVars.length));
        for (int i = 0; i < GenSysVars.length; ++i) {
            reqPdu.addNull(GenSysVars[i]);
        }
        SnmpPDU rspPdu = peer.send(reqPdu);
        VarBindList vbl = rspPdu.getVariables();
        SnmpVar var = rspPdu.getVar(0);
        if (var.getType() != 6) {
            throw new SnmpException(rspPdu.getHostAddress() + " returned bad sysObjectID");
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>(GenSysVars.length);
        for (int i = 0; i < vbl.size(); ++i) {
            if (i == 0) {
                int[] sysObjectID = ((SnmpOID)rspPdu.getVar(i)).getValue();
                retMap.put(GenSys_MibCmds[i], sysObjectID);
                continue;
            }
            if (i == 2) {
                retMap.put(GenSys_MibCmds[i], vbl.longValue(i));
                continue;
            }
            retMap.put(GenSys_MibCmds[i], vbl.stringValue(i));
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getGenSysInfo", retMap);
        }
        return retMap;
    }

    public static String getNxVersion(SnmpPeer peer, int activeSupIndex) throws SnmpException {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer:" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getNxVersion");
        }
        String version = null;
        try {
            if (activeSupIndex < 0) {
                return null;
            }
            Map<HwInventoryType, List<Integer>> indexMap = CdpSnmpAdapter.getEntityIndexMap(peer, new HwInventoryType[]{HwInventoryType.MODULE}, new int[][]{{activeSupIndex}}, null, true);
            Map<HwInventoryType, List<Map>> entMap = CdpSnmpAdapter.getEntityBasicInfo(peer, indexMap);
            if (entMap == null) {
                return null;
            }
            List<Map> list = entMap.get((Object)HwInventoryType.MODULE);
            if (list == null || list.size() == 0) {
                return null;
            }
            Map supMap = list.get(0);
            version = (String)supMap.get(EntTable_MibCmds[6]);
        }
        catch (Exception ex) {
            _Tracer.log(Level.WARN, peer + " cannot getNxVersion", ex);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getNxVersion", version);
        }
        return version;
    }

    public static Map getSwitchInfo(SnmpPeer peer) throws SnmpException {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer:" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getSwitchInfo");
        }
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(SwInfoVars.length));
        for (int i = 0; i < SwInfoVars.length; ++i) {
            reqPdu.addNull(SwInfoVars[i]);
        }
        SnmpPDU rspPdu = peer.send(reqPdu);
        VarBindList vbl = rspPdu.getVariables();
        HashMap<String, Boolean> retMap = new HashMap<String, Boolean>(SwInfoVars.length);
        for (int i = 0; i < vbl.size(); ++i) {
            if (vbl.get(i).getVar().getType() == 2) {
                retMap.put(SwInfo_MibCmds[i], vbl.intValue(i) == 1);
                continue;
            }
            retMap.put(SwInfo_MibCmds[i], true);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getSwitchInfo", retMap);
        }
        return retMap;
    }

    public static Map<String, Long> getEntityLastChange(SnmpPeer peer) throws SnmpException {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer:" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getEntityLastChange");
        }
        VarBindList vbl = new VarBindList(EntLastChangeVars.length);
        for (SnmpOID var : EntLastChangeVars) {
            vbl.add(new SnmpVarBind(var));
        }
        SnmpPDU pdu = new SnmpPDU(-96, vbl);
        pdu = peer.send(pdu);
        vbl = pdu.getVariables();
        HashMap<String, Long> retMap = new HashMap<String, Long>(EntLastChangeVars.length);
        for (int i = 0; i < EntLastChangeVars.length; ++i) {
            if (i == 0) {
                retMap.put(EntLastChange_MibCmds[i], vbl.longValue(i));
                continue;
            }
            retMap.put(EntLastChange_MibCmds[i], Long.valueOf(vbl.intValue(i)));
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getEntityLastChange", retMap);
        }
        return retMap;
    }

    public static Map<String, Integer> getRedundancyInfo(SnmpPeer peer) throws SnmpException {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer:" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getRedundancyInfo");
        }
        VarBindList vbl = new VarBindList(CiscoRFVars.length);
        for (SnmpOID var : CiscoRFVars) {
            vbl.add(new SnmpVarBind(var));
        }
        SnmpPDU pdu = new SnmpPDU(-96, vbl);
        pdu = peer.send(pdu);
        vbl = pdu.getVariables();
        HashMap<String, Integer> retMap = new HashMap<String, Integer>(CiscoRFVars.length);
        for (int i = 0; i < CiscoRFVars.length; ++i) {
            retMap.put(CiscoRF_MibCmds[i], vbl.intValue(i));
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getRedundancyInfo", retMap);
        }
        return retMap;
    }

    public static HashMap<Integer, HashMap<String, Object>> getVdcInfo(SnmpPeer peer) throws SnmpException {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer :" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getVdcInfo");
        }
        VarBindList vbl = new VarBindList(VdcOids.length);
        for (int i = 0; i < VdcOids.length; ++i) {
            vbl.add(VdcOids[i]);
        }
        SnmpPDU rspPdu = SnmpFetch.getBulk(peer, vbl);
        VarBindList rspVbl = rspPdu.getVariables();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getVdcInfo", "--response=" + rspVbl);
        }
        HashMap<Integer, HashMap<String, Object>> retMap = new HashMap<Integer, HashMap<String, Object>>();
        if (rspVbl.size() < VdcOids.length) {
            return retMap;
        }
        SnmpVar var = rspVbl.getVb(0).getVar();
        if (var == null || var.isNullType()) {
            return retMap;
        }
        int[] oid = rspVbl.getVb(0).getOid().getValue();
        int vdcId = oid[oid.length - 1];
        HashMap<String, Object> vdcMap = new HashMap<String, Object>(5);
        try {
            for (int k = 0; k < VdcOids.length; ++k) {
                Object value = null;
                switch (k) {
                    case 0: {
                        value = rspVbl.stringValue(k);
                        break;
                    }
                    case 1: 
                    case 2: {
                        value = new Integer(rspVbl.intValue(k));
                        break;
                    }
                    case 3: 
                    case 4: {
                        String vdcMac = rspVbl.stringValue(k);
                        value = new MacAddress(vdcMac);
                    }
                }
                if (value == null) continue;
                vdcMap.put(Vdc_MibCmds[k], value);
            }
            retMap.put(vdcId, vdcMap);
        }
        catch (Exception e) {
            if (_Tracer.isDebuggable()) {
                _Tracer.log(Level.WARN, peer + " discoverVdcInfo: did not return valid data, cannot discover vdc", e);
            }
            _Tracer.log(Level.WARN, peer + " discoverVdcInfo: did not return valid data, cannot discover vdc");
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getVdcInfo", retMap);
        }
        return retMap;
    }

    public static Map<Integer, Integer> getFeatureStatus(SnmpPeer peer, int[] checkFeatures) throws SnmpException {
        int i;
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer :" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getFeatures");
        }
        VarBindList vbl = null;
        if (checkFeatures == null || checkFeatures.length == 0) {
            vbl = new VarBindList(AbstractSwitchBase.NUM_FEATURES);
            for (i = 1; i <= AbstractSwitchBase.NUM_FEATURES; ++i) {
                vbl.add(CiscoFeatureOid, i);
            }
        } else {
            vbl = new VarBindList(checkFeatures.length);
            for (i = 0; i < checkFeatures.length; ++i) {
                vbl.add(CiscoFeatureOid, checkFeatures[i]);
            }
        }
        HashMap<Integer, Integer> retMap = new HashMap<Integer, Integer>();
        SnmpPDU pdu = new SnmpPDU(-96, vbl);
        try {
            pdu = peer.send(pdu);
        }
        catch (Exception ex) {
            if (_Tracer.isDebuggable()) {
                _Tracer.log(Level.DEBUG, peer.getAddress() + " failed to getFeatures: featureCtrl mib not supported", ex);
            }
            return retMap;
        }
        vbl = pdu.getVariables();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getFeatures", "--response=" + vbl);
        }
        for (SnmpVarBind vb : vbl) {
            int featureIndex = vb.getOid().getIndexFromEnd(0);
            SnmpVar var = vb.getVar();
            if (var != null && var.getType() == 2) {
                retMap.put(featureIndex, vb.intValue());
                continue;
            }
            retMap.put(featureIndex, 5);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getFeatures", retMap);
        }
        return retMap;
    }

    public static Map<Integer, Integer> getFeatureSetStatus(SnmpPeer peer, int[] checkFeatureSets) throws SnmpException {
        int i;
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer :" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getFeatureSets");
        }
        VarBindList vbl = null;
        if (checkFeatureSets == null || checkFeatureSets.length == 0) {
            vbl = new VarBindList();
            for (i = 0; i < AbstractSwitchBase.NUM_FEATURESETS; ++i) {
                vbl.add(CiscoFeatureSetOid, i);
            }
        } else {
            vbl = new VarBindList(checkFeatureSets.length);
            for (i = 0; i < checkFeatureSets.length; ++i) {
                vbl.add(CiscoFeatureSetOid, checkFeatureSets[i]);
            }
        }
        HashMap<Integer, Integer> retMap = new HashMap<Integer, Integer>();
        SnmpPDU pdu = new SnmpPDU(-96, vbl);
        try {
            pdu = peer.send(pdu);
        }
        catch (Exception ex) {
            if (_Tracer.isDebuggable()) {
                _Tracer.log(Level.DEBUG, peer.getAddress() + " failed to getFCoEFeatureSetStatus: featureSet mib not supported", ex);
            }
            return retMap;
        }
        vbl = pdu.getVariables();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getFeatureSets", "--response=" + vbl);
        }
        for (SnmpVarBind vb : vbl) {
            int index = vb.getOid().getIndexFromEnd(0);
            SnmpVar var = vb.getVar();
            if (var != null && !var.isNullType()) {
                retMap.put(index, vb.intValue());
                continue;
            }
            retMap.put(index, AbstractSwitchBase.FeatureStatus.uninstalled.value());
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getFeatureSets", retMap);
        }
        return retMap;
    }

    public static int getNexusNumOfLicenses(SnmpPeer peer) throws SnmpException {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer :" + peer);
        }
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(1));
        pdu.addNull(CiscoNumOfLicVar);
        pdu = peer.send(pdu);
        return pdu.getVariables().intValue(0);
    }

    public static Map<String, Map<String, Object>> getNexusLicenses(SnmpPeer peer) throws SnmpException {
        int[] oid;
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer :" + peer);
        }
        int numOfLic = CdpSnmpAdapter.getNexusNumOfLicenses(peer);
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getNexusLicenses");
        }
        VarBindList vbl = new VarBindList(LicenseOids.length);
        for (int i = 0; i < LicenseOids.length; ++i) {
            vbl.add(LicenseOids[i]);
        }
        SnmpPDU rspPdu = SnmpFetch.getBulk(peer, vbl, numOfLic);
        VarBindList rspVbl = rspPdu.getVariables();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getNexusLicenses", "--response=" + rspVbl);
        }
        int offset = LicenseOids[0].length + 1;
        HashMap<String, Map<String, Object>> retMap = new HashMap<String, Map<String, Object>>();
        for (int i = 0; i < rspVbl.size() && SnmpOID.startsWith(oid = rspVbl.getVb(i).getOid().getValue(), LicenseOids[0]); i += LicenseOids.length) {
            String licName = SnmpString.toString(oid, offset, oid.length);
            HashMap<String, Object> licMap = new HashMap<String, Object>();
            for (int k = 0; k < License_MibCmds.length; ++k) {
                if (k == 0 || k == 4) {
                    licMap.put(License_MibCmds[k], rspVbl.byteValue(k + i));
                    continue;
                }
                licMap.put(License_MibCmds[k], rspVbl.intValue(k + i));
            }
            retMap.put(licName, licMap);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getNexusLicenses", retMap);
        }
        return retMap;
    }

    public static Map getChassisInfo(SnmpPeer peer, PlatformType platf) throws SnmpException {
        Map<HwInventoryType, List<Integer>> indexMap;
        Map<HwInventoryType, List<Map>> retMap;
        List<Map> list;
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getChassisInfo");
        }
        if ((list = (retMap = CdpSnmpAdapter.getEntityBasicInfo(peer, indexMap = CdpSnmpAdapter.getEntityIndexMap(peer, new HwInventoryType[]{HwInventoryType.CHASSIS}, null, platf, true))).get((Object)HwInventoryType.CHASSIS)) == null || list.size() == 0) {
            _Tracer.log(Level.WARN, peer + " getChassisInfo -- There is no chassis available");
            return Collections.EMPTY_MAP;
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getChassisInfo", list.get(0));
        }
        return list.get(0);
    }

    public static Map<HwInventoryType, List<Map>> getAllEntityInfo(SnmpPeer peer, PlatformType platf) throws SnmpException {
        HwInventoryType[] hwTypes = new HwInventoryType[]{HwInventoryType.CHASSIS, HwInventoryType.MODULE, HwInventoryType.POWERSUPPLY, HwInventoryType.FAN};
        Map<HwInventoryType, List<Integer>> indexMap = CdpSnmpAdapter.getEntityIndexMap(peer, hwTypes, null, platf, false);
        return CdpSnmpAdapter.getEntityFullInfo(peer, indexMap);
    }

    public static Map<HwInventoryType, List<Map>> getEntityFullInfo(SnmpPeer peer, Map<HwInventoryType, List<Integer>> indexMap) throws SnmpException {
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getEntityFullInfo");
        }
        if (indexMap == null || indexMap.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<HwInventoryType, List<Map>> retMap = new HashMap<HwInventoryType, List<Map>>();
        VarBindList vbl = new VarBindList();
        for (Map.Entry<HwInventoryType, List<Integer>> ent : indexMap.entrySet()) {
            int[][] detailedOids;
            HwInventoryType t = ent.getKey();
            List<Integer> indexes = ent.getValue();
            if (indexes == null) continue;
            if (t == HwInventoryType.CHASSIS) {
                detailedOids = CiscoChassisOids;
            } else if (t == HwInventoryType.MODULE) {
                detailedOids = ModuleOids;
            } else if (t == HwInventoryType.POWERSUPPLY) {
                detailedOids = PowerOids;
            } else {
                if (t != HwInventoryType.FAN) continue;
                detailedOids = FanOids;
            }
            for (int i = 0; i < indexes.size(); ++i) {
                int k;
                int phyIndex = indexes.get(i);
                for (k = 0; k < EntOids.length; ++k) {
                    vbl.add(EntOids[k], phyIndex);
                }
                for (k = 0; k < detailedOids.length; ++k) {
                    vbl.add(detailedOids[k], phyIndex);
                }
            }
        }
        if (vbl.size() == 0) {
            return Collections.EMPTY_MAP;
        }
        SnmpPDU rspPdu = SnmpFetch.get(peer, vbl);
        VarBindList rspVbl = rspPdu.getVariables();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getEntityFullInfo", "--- response=" + rspVbl);
        }
        int i = 0;
        while (i < rspVbl.size()) {
            int cmdIdx;
            HashMap<String, Object> entMap = new HashMap<String, Object>(25);
            int phyIndex = rspVbl.getVb(i).getOid().getIndexFromEnd(0);
            entMap.put(EntTable_phyIndex_MibCmd, phyIndex);
            int classType = -1;
            int[] vendorType = null;
            for (int cmdIdx2 = 0; cmdIdx2 < EntTable_MibCmds.length; ++cmdIdx2) {
                if (rspVbl.get(i) == null) {
                    ++i;
                    continue;
                }
                if (cmdIdx2 == 0) {
                    classType = rspVbl.intValue(i++);
                    entMap.put(EntTable_MibCmds[cmdIdx2], classType);
                    continue;
                }
                if (cmdIdx2 == 1 || cmdIdx2 == 11) {
                    entMap.put(EntTable_MibCmds[cmdIdx2], rspVbl.intValue(i++));
                    continue;
                }
                if (cmdIdx2 == 2) {
                    SnmpVar var;
                    if ((var = rspVbl.getVb(i++).getVar()) instanceof SnmpNull) continue;
                    int[] oid = ((SnmpOID)var).getValue();
                    if (oid != null && oid.length > 6) {
                        vendorType = new int[oid.length - 6];
                        System.arraycopy(oid, 6, vendorType, 0, vendorType.length);
                    }
                    entMap.put(EntTable_MibCmds[cmdIdx2], vendorType);
                    continue;
                }
                entMap.put(EntTable_MibCmds[cmdIdx2], rspVbl.stringValue(i++));
            }
            HwInventoryType hwType = null;
            if (classType == HwInventoryType.MODULE.value()) {
                hwType = HwInventoryType.MODULE;
                for (cmdIdx = 0; cmdIdx < Module_MibCmds.length; ++cmdIdx) {
                    if (cmdIdx == 1) {
                        int operStatus = rspVbl.intValue(i);
                        entMap.put(Module_MibCmds[cmdIdx], operStatus);
                        entMap.put(Module_MibCmds[cmdIdx] + MibCmd_StrValue, rspVbl.enumValue(i));
                        ++i;
                        continue;
                    }
                    if (cmdIdx == 2 || cmdIdx == 7) {
                        entMap.put(Module_MibCmds[cmdIdx], rspVbl.stringValue(i++));
                        continue;
                    }
                    if (cmdIdx == 3) {
                        entMap.put(Module_MibCmds[cmdIdx], rspVbl.longValue(i++));
                        continue;
                    }
                    entMap.put(Module_MibCmds[cmdIdx], rspVbl.intValue(i++));
                }
            } else if (classType == HwInventoryType.POWERSUPPLY.value()) {
                hwType = HwInventoryType.POWERSUPPLY;
                for (cmdIdx = 0; cmdIdx < Power_MibCmds.length; ++cmdIdx) {
                    if (cmdIdx == 0) {
                        entMap.put(Power_MibCmds[cmdIdx], rspVbl.enumValue(i++));
                        continue;
                    }
                    if (cmdIdx == 4) {
                        entMap.put(Power_MibCmds[cmdIdx], rspVbl.stringValue(i++));
                        continue;
                    }
                    entMap.put(Power_MibCmds[cmdIdx], rspVbl.intValue(i++));
                }
            } else if (classType == HwInventoryType.CHASSIS.value()) {
                hwType = HwInventoryType.CHASSIS;
                for (cmdIdx = 0; cmdIdx < CiscoChassis_MibCmds.length; ++cmdIdx) {
                    entMap.put(CiscoChassis_MibCmds[cmdIdx], rspVbl.stringValue(i++));
                }
            } else if (classType == HwInventoryType.FAN.value()) {
                hwType = HwInventoryType.FAN;
                for (cmdIdx = 0; cmdIdx < Fan_MibCmds.length; ++cmdIdx) {
                    entMap.put(Fan_MibCmds[cmdIdx], rspVbl.enumValue(i++));
                }
            } else if (classType == 0 && NexusEntityMibHelper.hasOtherChassisIndex(phyIndex)) {
                hwType = null;
                for (cmdIdx = 0; cmdIdx < CiscoChassis_MibCmds.length; ++cmdIdx) {
                    entMap.put(CiscoChassis_MibCmds[cmdIdx], rspVbl.stringValue(i++));
                }
            } else {
                _Tracer.log(Level.WARN, peer + " invalid classType:" + classType);
                break;
            }
            if (hwType == null) continue;
            ArrayList tlist = (ArrayList)retMap.get((Object)hwType);
            if (tlist == null) {
                tlist = new ArrayList(indexMap.get((Object)hwType).size());
                retMap.put(hwType, tlist);
            }
            tlist.add(entMap);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getEntityFullInfo", retMap);
        }
        return retMap;
    }

    public static Map<HwInventoryType, List<Map>> getEntityBasicInfo(SnmpPeer peer, Map<HwInventoryType, List<Integer>> indexMap) throws SnmpException {
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getEntityBasicInfo");
        }
        if (indexMap == null || indexMap.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<HwInventoryType, List<Map>> retMap = new HashMap<HwInventoryType, List<Map>>();
        VarBindList vbl = new VarBindList();
        for (Map.Entry<HwInventoryType, List<Integer>> ent : indexMap.entrySet()) {
            HwInventoryType t = ent.getKey();
            List<Integer> indexes = ent.getValue();
            if (indexes == null) continue;
            for (int i = 0; i < indexes.size(); ++i) {
                int phyIndex = indexes.get(i);
                for (int k = 0; k < EntOids.length; ++k) {
                    vbl.add(EntOids[k], phyIndex);
                }
            }
        }
        SnmpPDU rspPdu = SnmpFetch.get(peer, vbl);
        VarBindList rspVbl = rspPdu.getVariables();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getEntityBasicInfo", "--response=" + rspVbl);
        }
        int i = 0;
        while (i < rspVbl.size()) {
            HashMap<String, Object> entMap = new HashMap<String, Object>(EntTable_MibCmds.length + 1);
            int phyIndex = rspVbl.getVb(i).getOid().getIndexFromEnd(0);
            entMap.put(EntTable_phyIndex_MibCmd, phyIndex);
            int[] vendorType = null;
            int classType = -1;
            for (int cmdIdx = 0; cmdIdx < EntTable_MibCmds.length; ++cmdIdx) {
                SnmpVar var;
                if (rspVbl.get(i) == null) {
                    ++i;
                    continue;
                }
                if (cmdIdx == 0) {
                    classType = rspVbl.intValue(i++);
                    entMap.put(EntTable_MibCmds[cmdIdx], classType);
                    continue;
                }
                if (cmdIdx == 1 || cmdIdx == 11) {
                    entMap.put(EntTable_MibCmds[cmdIdx], rspVbl.intValue(i++));
                    continue;
                }
                if (cmdIdx == 2) {
                    if ((var = rspVbl.getVb(i++).getVar()) instanceof SnmpNull) continue;
                    int[] oid = ((SnmpOID)var).getValue();
                    if (oid != null && oid.length > 6) {
                        vendorType = new int[oid.length - 6];
                        System.arraycopy(oid, 6, vendorType, 0, vendorType.length);
                    }
                    entMap.put(EntTable_MibCmds[cmdIdx], vendorType);
                    continue;
                }
                if (cmdIdx == 7 || cmdIdx == 9) {
                    if ((var = rspVbl.get(i++).getVar()) instanceof SnmpNull) continue;
                    List<String> values = serialNumMap.get(peer.getAddress().getHostAddress());
                    if (cmdIdx == 7 && values != null) {
                        entMap.put(EntTable_MibCmds[cmdIdx], values.get(1));
                        continue;
                    }
                    entMap.put(EntTable_MibCmds[cmdIdx], ((SnmpString)var).toString());
                    continue;
                }
                entMap.put(EntTable_MibCmds[cmdIdx], rspVbl.stringValue(i++));
            }
            HwInventoryType hwType = null;
            if (classType == HwInventoryType.MODULE.value()) {
                hwType = HwInventoryType.MODULE;
            } else if (classType == HwInventoryType.POWERSUPPLY.value()) {
                hwType = HwInventoryType.POWERSUPPLY;
            } else if (classType == HwInventoryType.CHASSIS.value()) {
                hwType = HwInventoryType.CHASSIS;
            } else if (classType == HwInventoryType.FAN.value()) {
                hwType = HwInventoryType.FAN;
            } else if (classType == HwInventoryType.STACK.value()) {
                hwType = HwInventoryType.STACK;
            } else {
                _Tracer.log(Level.WARN, peer + " invalid classType:" + classType);
                continue;
            }
            if (hwType == null) continue;
            ArrayList tlist = (ArrayList)retMap.get((Object)hwType);
            if (tlist == null) {
                tlist = new ArrayList();
                retMap.put(hwType, tlist);
            }
            tlist.add(entMap);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getEntityBasicInfo", retMap);
        }
        return retMap;
    }

    public static Map<HwInventoryType, List<Map>> getEntityDetailedInfo(SnmpPeer peer, Map<HwInventoryType, List<Integer>> indexMap) throws SnmpException {
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getEntityDetailedInfo");
        }
        if (indexMap == null || indexMap.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<HwInventoryType, List<Map>> retMap = new HashMap<HwInventoryType, List<Map>>();
        VarBindList vbl = new VarBindList();
        for (Map.Entry<HwInventoryType, List<Integer>> ent : indexMap.entrySet()) {
            int[][] detailedOids;
            HwInventoryType t = ent.getKey();
            List<Integer> indexes = ent.getValue();
            if (indexes == null) continue;
            if (t == HwInventoryType.CHASSIS) {
                detailedOids = CiscoChassisOids;
            } else if (t == HwInventoryType.MODULE) {
                detailedOids = ModuleOids;
            } else if (t == HwInventoryType.POWERSUPPLY) {
                detailedOids = PowerOids;
            } else {
                if (t != HwInventoryType.FAN) continue;
                detailedOids = FanOids;
            }
            for (int i = 0; i < indexes.size(); ++i) {
                int phyIndex = indexes.get(i);
                vbl.add(EntOids[0], phyIndex);
                for (int k = 0; k < detailedOids.length; ++k) {
                    vbl.add(detailedOids[k], phyIndex);
                }
            }
        }
        SnmpPDU rspPdu = SnmpFetch.get(peer, vbl);
        VarBindList rspVbl = rspPdu.getVariables();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getEntityDetailedInfo", "--response=" + rspVbl);
        }
        int i = 0;
        while (i < rspVbl.size()) {
            int cmdIdx;
            HashMap<String, Object> entMap = new HashMap<String, Object>(15);
            int phyIndex = rspVbl.getVb(i).getOid().getIndexFromEnd(0);
            entMap.put(EntTable_phyIndex_MibCmd, phyIndex);
            int classType = -1;
            Object vendorType = null;
            classType = rspVbl.intValue(i++);
            entMap.put(EntTable_MibCmds[0], classType);
            HwInventoryType hwType = null;
            if (classType == HwInventoryType.MODULE.value()) {
                hwType = HwInventoryType.MODULE;
                for (cmdIdx = 0; cmdIdx < Module_MibCmds.length; ++cmdIdx) {
                    if (cmdIdx == 1) {
                        int operStatus = rspVbl.intValue(i);
                        entMap.put(Module_MibCmds[cmdIdx], operStatus);
                        entMap.put(Module_MibCmds[cmdIdx] + MibCmd_StrValue, rspVbl.enumValue(i));
                        ++i;
                        continue;
                    }
                    if (cmdIdx == 2 || cmdIdx == 7) {
                        entMap.put(Module_MibCmds[cmdIdx], rspVbl.stringValue(i++));
                        continue;
                    }
                    if (cmdIdx == 3) {
                        entMap.put(Module_MibCmds[cmdIdx], rspVbl.longValue(i++));
                        continue;
                    }
                    entMap.put(Module_MibCmds[cmdIdx], rspVbl.intValue(i++));
                }
            } else if (classType == HwInventoryType.POWERSUPPLY.value()) {
                hwType = HwInventoryType.POWERSUPPLY;
                for (cmdIdx = 0; cmdIdx < Power_MibCmds.length; ++cmdIdx) {
                    if (cmdIdx == 0) {
                        entMap.put(Power_MibCmds[cmdIdx], rspVbl.enumValue(i++));
                        continue;
                    }
                    if (cmdIdx == 4) {
                        entMap.put(Power_MibCmds[cmdIdx], rspVbl.stringValue(i++));
                        continue;
                    }
                    entMap.put(Power_MibCmds[cmdIdx], rspVbl.intValue(i++));
                }
            } else if (classType == HwInventoryType.CHASSIS.value()) {
                hwType = HwInventoryType.CHASSIS;
                for (cmdIdx = 0; cmdIdx < CiscoChassis_MibCmds.length; ++cmdIdx) {
                    entMap.put(CiscoChassis_MibCmds[cmdIdx], rspVbl.stringValue(i++));
                }
            } else if (classType == HwInventoryType.FAN.value()) {
                hwType = HwInventoryType.FAN;
                for (cmdIdx = 0; cmdIdx < Fan_MibCmds.length; ++cmdIdx) {
                    entMap.put(Fan_MibCmds[cmdIdx], rspVbl.enumValue(i++));
                }
            } else {
                _Tracer.log(Level.WARN, peer + " invalid classType:" + classType);
                break;
            }
            if (hwType == null) continue;
            ArrayList tlist = (ArrayList)retMap.get((Object)hwType);
            if (tlist == null) {
                tlist = new ArrayList(indexMap.get((Object)hwType).size());
                retMap.put(hwType, tlist);
            }
            tlist.add(entMap);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getEntityDetailedInfo", retMap);
        }
        return retMap;
    }

    public static Map<HwInventoryType, List<Integer>> getDefaultEntityIndexMap(SnmpPeer peer, HwInventoryType[] hwTypes, boolean onlyOne) throws SnmpException {
        if (peer == null || hwTypes == null || hwTypes.length == 0) {
            throw new SnmpException("Invalid snmp peer and entity type:" + peer + "," + Arrays.toString((Object[])hwTypes));
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getDefaultEntityIndexMap");
        }
        HashMap<HwInventoryType, List<Integer>> indexMap = new HashMap<HwInventoryType, List<Integer>>();
        int entCnt = 0;
        SnmpPDU pdu = new SnmpPDU(new VarBindList(1));
        SnmpOID queryOid = new SnmpOID(EntOids[0]);
        int phyIndex = -1;
        for (int i = 0; i < 300; ++i) {
            pdu.reset();
            pdu.setCommand((byte)-95);
            if (phyIndex == -1) {
                pdu.addNull(queryOid);
            } else {
                pdu.addNull(new SnmpOID(EntOids[0], phyIndex));
            }
            try {
                pdu = peer.send(pdu);
            }
            catch (Exception e) {
                _Tracer.log(Level.DEBUG, peer + "--getDefaultEntityIndexMap-- timeout on pdu:" + pdu, e);
            }
            SnmpVarBind vb = pdu.getVariables().get(0);
            if (vb.getVar() == null) {
                if (!_Tracer.isTraceable()) break;
                _Tracer.log(Level.TRACE, peer + "--getDefaultEntityIndexMap-- break for no return from pdu:" + pdu);
                break;
            }
            int[] oid = vb.getOid().getValue();
            phyIndex = oid[oid.length - 1];
            if (!SnmpOID.startsWith(oid, queryOid.getValue())) {
                if (i < 1) continue;
                if (!_Tracer.isTraceable()) break;
                _Tracer.log(Level.TRACE, peer + "--getDefaultEntityIndexMap-- break for no return from pdu:" + pdu);
                break;
            }
            int typeValue = ((SnmpInt)vb.getVar()).getValue();
            if (typeValue == HwInventoryType.CHASSIS.value() && NexusEntityMibHelper.isFexChassisPhyIndex(phyIndex)) {
                if (!_Tracer.isTraceable()) break;
                _Tracer.log(Level.TRACE, peer + "--getDefaultEntityIndexMap-- break for entering fex section pdu:" + pdu);
                break;
            }
            HwInventoryType type = null;
            for (HwInventoryType t : hwTypes) {
                if (t.value() != typeValue) continue;
                type = t;
                break;
            }
            if (type == null) continue;
            ArrayList<Integer> list = (ArrayList<Integer>)indexMap.get((Object)type);
            if (list == null) {
                list = new ArrayList<Integer>();
                indexMap.put(type, list);
            }
            list.add(phyIndex);
            ++entCnt;
            if (!onlyOne) continue;
            if (!_Tracer.isTraceable()) break;
            _Tracer.log(Level.TRACE, peer + "--getDefaultEntityIndexMap-- break for only care entity");
            break;
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getDefaultEntityIndexMap", indexMap);
        }
        if (entCnt == 0) {
            return Collections.emptyMap();
        }
        return indexMap;
    }

    public static PlatformType getPlatformType(SnmpPeer peer) throws SnmpException {
        PlatformType type;
        block7: {
            if (peer == null) {
                throw new SnmpException("Invalid snmp peer:" + peer);
            }
            if (_Tracer.isTraceable()) {
                _Tracer.traceFuncBegin(peer, "getPlatformType");
            }
            type = PlatformType.UNKNOWN;
            try {
                VarBindList vbl = new VarBindList();
                vbl.add(EntOids[0], CatEntityMibHelper.getChassisPhyIndex());
                vbl.add(EntOids[9], CatEntityMibHelper.getChassisPhyIndex());
                vbl.add(EntOids[0], CatEntityMibHelper.getChassis2PhyIndex());
                vbl.add(EntOids[9], CatEntityMibHelper.getChassis2PhyIndex());
                vbl.add(EntOids[0], NexusEntityMibHelper.getChassisPhyIndex());
                vbl.add(EntOids[9], NexusEntityMibHelper.getChassisPhyIndex());
                vbl.add(EntOids[0], NexusEntityMibHelper.getChassisPhyIndex(PlatformType.N1K));
                vbl.add(EntOids[9], NexusEntityMibHelper.getChassisPhyIndex(PlatformType.N1K));
                vbl.add(EntOids[0], NexusEntityMibHelper.getOtherChassisPhyIndex(PlatformType.N1K));
                vbl.add(EntOids[9], NexusEntityMibHelper.getOtherChassisPhyIndex(PlatformType.N1K));
                vbl.add(EntOids[0], NexusEntityMibHelper.getOtherChassisPhyIndex(PlatformType.N1KV));
                vbl.add(EntOids[9], NexusEntityMibHelper.getOtherChassisPhyIndex(PlatformType.N1KV));
                SnmpPDU rspPdu = SnmpFetch.get(peer, vbl);
                VarBindList rspVbl = rspPdu.getVariables();
                if (_Tracer.isTraceable()) {
                    _Tracer.traceFunc(peer, "getPlatformType", "--response=" + rspVbl);
                }
                for (int i = 0; i < rspVbl.size(); i += 2) {
                    SnmpVarBind vb = rspVbl.get(i);
                    if (vb.isNull() || vb.intValue() != HwInventoryType.CHASSIS.value()) continue;
                    vb = rspVbl.get(i + 1);
                    String platf = vb.stringValue();
                    type = PlatformType.getTypeByDeviceKey(platf);
                    break;
                }
            }
            catch (Exception ex) {
                if (!_Tracer.isDebuggable()) break block7;
                _Tracer.debug(peer.getAddress() + " cannot getPlatformType", ex);
            }
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getPlatformType", (Object)type);
        }
        return type;
    }

    public static Map<HwInventoryType, List<Integer>> getEntityIndexMap(SnmpPeer peer, HwInventoryType[] hwTypes, int[][] phyIndexes, PlatformType platf, boolean onlyOne) throws SnmpException {
        if (peer == null || hwTypes == null || hwTypes.length == 0) {
            throw new SnmpException("Invalid snmp peer and entity type:" + peer + "," + Arrays.toString((Object[])hwTypes));
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getEntityIndexMap");
        }
        Map<Object, Object> indexMap = Collections.EMPTY_MAP;
        if (phyIndexes == null) {
            if (platf == PlatformType.UNKNOWN || platf == null) {
                platf = CdpSnmpAdapter.getPlatformType(peer);
            }
            indexMap = PlatformType.isCATSwitch(platf) ? CdpSnmpAdapter.getCatEntityIndexMap(peer, hwTypes, platf, onlyOne) : (PlatformType.isMdsSwitch(platf) || PlatformType.isNexusSwitch(platf) ? CdpSnmpAdapter.getNxEntityIndexMap(peer, hwTypes, platf, onlyOne) : CdpSnmpAdapter.getDefaultEntityIndexMap(peer, hwTypes, onlyOne));
        } else {
            indexMap = new HashMap();
            for (int tidx = 0; tidx < hwTypes.length; ++tidx) {
                if (phyIndexes[tidx] == null || phyIndexes[tidx].length <= 0) continue;
                ArrayList<Integer> list = new ArrayList<Integer>(phyIndexes[tidx].length);
                for (int idx : phyIndexes[tidx]) {
                    list.add(idx);
                }
                indexMap.put((Object)hwTypes[tidx], list);
            }
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getEntityIndexMap", indexMap);
        }
        return indexMap;
    }

    public static Map<HwInventoryType, List<Integer>> getNxEntityIndexMap(SnmpPeer peer, HwInventoryType[] hwTypes, PlatformType platf, boolean onlyOne) throws SnmpException {
        if (peer == null || hwTypes == null || hwTypes.length == 0) {
            throw new SnmpException("Invalid snmp peer and entity type:" + peer + "," + Arrays.toString((Object[])hwTypes));
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getNxEntityIndexMap");
        }
        HashMap<HwInventoryType, List<Integer>> indexMap = new HashMap<HwInventoryType, List<Integer>>();
        boolean entCnt = false;
        VarBindList vbl = new VarBindList();
        for (HwInventoryType type : NexusEntityMibHelper.getClassOrder()) {
            boolean selectedType = false;
            for (HwInventoryType t : hwTypes) {
                if (type != t) continue;
                selectedType = true;
                break;
            }
            if (!selectedType) continue;
            if (type == HwInventoryType.CHASSIS) {
                int phyIndex = NexusEntityMibHelper.getChassisPhyIndex(platf);
                ArrayList<Integer> list = null;
                if (platf == PlatformType.N1K || platf == PlatformType.N1KV) {
                    int phyIndexOther = NexusEntityMibHelper.getOtherChassisPhyIndex(platf);
                    list = new ArrayList(2);
                    list.add(phyIndex);
                    list.add(phyIndexOther);
                } else {
                    list = new ArrayList<Integer>(1);
                    list.add(phyIndex);
                }
                indexMap.put(HwInventoryType.CHASSIS, list);
                continue;
            }
            if (type == HwInventoryType.OTHER || type == HwInventoryType.PORT || type == HwInventoryType.SENSOR || type == HwInventoryType.UNKNOWN) continue;
            int phyIndex = NexusEntityMibHelper.getEntityPhyIndex(platf, type.value());
            int maxPhyIndex = NexusEntityMibHelper.getEntityPhyMaxIndex(platf, type.value());
            if (phyIndex > 0 && maxPhyIndex > 0) {
                for (int i = phyIndex; i <= maxPhyIndex; ++i) {
                    vbl.add(EntOids[0], i);
                }
            }
            indexMap.put(type, new ArrayList());
        }
        if (vbl.size() > 0) {
            SnmpPDU rspPdu = SnmpFetch.get(peer, vbl);
            VarBindList rspVbl = rspPdu.getVariables();
            for (int i = 0; i < rspVbl.size(); ++i) {
                SnmpVarBind vb = rspVbl.get(i);
                if (vb.isNull() || vb.intValue() == 0) continue;
                int phyIndex = vb.getOid().getIndexFromEnd(0);
                int classType = vb.intValue();
                List list = (List)indexMap.get((Object)HwInventoryType.getType(classType));
                if (list == null) continue;
                list.add(phyIndex);
                if (!onlyOne) continue;
                if (!_Tracer.isTraceable()) break;
                _Tracer.log(Level.TRACE, peer + "--getNxEntityIndexMap-- break for only care entity");
                break;
            }
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getNxEntityIndexMap", indexMap);
        }
        return indexMap;
    }

    public static Map<HwInventoryType, List<Integer>> getCatEntityIndexMap(SnmpPeer peer, HwInventoryType[] hwTypes, PlatformType platf, boolean onlyOne) throws SnmpException {
        int i;
        int phyIndex;
        if (peer == null || hwTypes == null || hwTypes.length == 0) {
            throw new SnmpException("Invalid snmp peer and entity type:" + peer + "," + Arrays.toString((Object[])hwTypes));
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getCatEntityIndexMap");
        }
        HashMap<HwInventoryType, List<Integer>> indexMap = new HashMap<HwInventoryType, List<Integer>>();
        VarBindList vbl = new VarBindList();
        boolean hasModule = false;
        boolean hasOthers = false;
        for (HwInventoryType type : hwTypes) {
            if (type == HwInventoryType.CHASSIS) {
                phyIndex = CatEntityMibHelper.getChassisPhyIndex();
                ArrayList<Integer> list = new ArrayList<Integer>(1);
                list.add(phyIndex);
                int phyIndex2 = CatEntityMibHelper.getChassis2PhyIndex();
                list.add(phyIndex2);
                indexMap.put(HwInventoryType.CHASSIS, list);
                continue;
            }
            if (type == HwInventoryType.PORT || type == HwInventoryType.SENSOR || type == HwInventoryType.UNKNOWN) continue;
            hasOthers = true;
            if (type == HwInventoryType.MODULE) {
                hasModule = true;
            }
            indexMap.put(type, new ArrayList());
        }
        if (hasOthers) {
            int phyIndex2 = CatEntityMibHelper.getNonPortModuleClassPhyIndex();
            int maxPhyIndex = CatEntityMibHelper.getNonPortModuleClassMaxPhyIndex();
            if (phyIndex2 > 0 && maxPhyIndex > 0) {
                for (i = phyIndex2; i <= maxPhyIndex; ++i) {
                    vbl.add(EntOids[0], i);
                }
            }
        }
        if (hasModule) {
            int mIndex = CatEntityMibHelper.getPortModulePhyIndex();
            int offset = CatEntityMibHelper.getPortModuleOffset();
            int maxSlot = CatEntityMibHelper.getPortModuleMaxSlot();
            for (int i2 = 1; i2 <= maxSlot; ++i2) {
                vbl.add(EntOids[0], mIndex + (i2 - 1) * offset);
            }
        }
        if (vbl.size() > 0) {
            SnmpPDU rspPdu = SnmpFetch.get(peer, vbl);
            VarBindList rspVbl = rspPdu.getVariables();
            if (_Tracer.isTraceable()) {
                _Tracer.traceFunc(peer, "getCatEntityIndexMap", "--response=" + rspVbl);
            }
            for (i = 0; i < rspVbl.size(); ++i) {
                SnmpVarBind vb = rspVbl.get(i);
                if (vb.isNull() || vb.intValue() == 0) continue;
                phyIndex = vb.getOid().getIndexFromEnd(0);
                int classType = vb.intValue();
                List list = (List)indexMap.get((Object)HwInventoryType.getType(classType));
                if (list == null) continue;
                list.add(phyIndex);
                if (!onlyOne) continue;
                if (!_Tracer.isTraceable()) break;
                _Tracer.log(Level.TRACE, peer + "--getCatEntityIndexMap-- break for only care entity");
                break;
            }
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getCatEntityIndexMap", indexMap);
        }
        return indexMap;
    }

    public static Map<Integer, String> getFexChassisIndex(SnmpPeer peer, PlatformType platf, SwitchVersion version) throws SnmpException {
        if (peer == null || !PlatformType.isFEXSwitch(platf)) {
            throw new SnmpException("Invalid snmp peer and platform type:" + peer + "," + (Object)((Object)platf));
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getFexChassisIndex");
        }
        int chassisIndex = NexusEntityMibHelper.getFexChassisPhyIndex();
        int maxChassisIndex = NexusEntityMibHelper.getFexChassisPhyIndexMax();
        HashMap<Integer, String> retMap = new HashMap<Integer, String>();
        VarBindList vbl = new VarBindList(1);
        vbl.add(EntOids[7]);
        SnmpPDU rspPdu = SnmpFetch.getBulkWithStartIndexFix(peer, vbl, 0, new int[]{chassisIndex}, new int[]{maxChassisIndex});
        VarBindList rspVbl = rspPdu.getVariables();
        for (int i = 0; i < rspVbl.size(); ++i) {
            int index = NexusEntityMibHelper.getFexIdByPhyIndex(rspVbl.get(i).getIndexFromEnd(0));
            List<String> values = serialNumMap.get(peer.getAddress().getHostAddress());
            if (values != null) {
                retMap.put(index, values.get(1));
                continue;
            }
            String name = rspVbl.stringValue(i);
            retMap.put(index, name);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getFexChassisIndex", retMap);
        }
        return retMap;
    }

    public static Map<Integer, String> getFexIsls(SnmpPeer peer, int[] phyIndexes) throws SnmpException {
        if (peer == null || phyIndexes == null || phyIndexes.length == 0) {
            throw new SnmpException("Invalid snmp peer and index:" + peer + "," + phyIndexes);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getFexIsls");
        }
        HashMap<Integer, String> retMap = new HashMap<Integer, String>();
        VarBindList vbl = new VarBindList();
        for (int index : phyIndexes) {
            vbl.add(EntOids[3], index);
        }
        SnmpPDU rspPdu = SnmpFetch.get(peer, vbl);
        VarBindList rspVbl = rspPdu.getVariables();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getFexIsls", "-- response=" + rspVbl);
        }
        for (int i = 0; i < rspVbl.size(); ++i) {
            String name;
            SnmpVarBind vb = rspVbl.get(i);
            if (vb == null || vb.getVar() == null || vb.getVar().getType() != 4 || (name = vb.stringValue()).equalsIgnoreCase("n/a")) continue;
            int phyIndex = vb.getIndexFromEnd(0);
            retMap.put(phyIndex, name);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getFexIsls", retMap);
        }
        return retMap;
    }

    public static Map<Integer, String> getFexVersion(SnmpPeer peer, int[] phyIndexes) throws SnmpException {
        if (peer == null || phyIndexes == null || phyIndexes.length == 0) {
            throw new SnmpException("Invalid snmp peer and index:" + peer + "," + phyIndexes);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getFexVersion");
        }
        HashMap<Integer, String> retMap = new HashMap<Integer, String>();
        VarBindList vbl = new VarBindList();
        for (int index : phyIndexes) {
            vbl.add(EntOids[6], index);
        }
        SnmpPDU rspPdu = SnmpFetch.get(peer, vbl);
        VarBindList rspVbl = rspPdu.getVariables();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getFexVersion", "-- response=" + rspVbl);
        }
        for (int i = 0; i < rspVbl.size(); ++i) {
            String version;
            SnmpVarBind vb = rspVbl.get(i);
            if (vb == null || vb.isNull() || vb.getVar() == null || (version = vb.stringValue()).equalsIgnoreCase("n/a")) continue;
            int phyIndex = vb.getIndexFromEnd(0);
            retMap.put(phyIndex, version);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getFexVersion", retMap);
        }
        return retMap;
    }

    public static Map<HwInventoryType, List<Integer>> getFexEntityIndexMap(SnmpPeer peer, int[] fexIds, HwInventoryType[] hwTypes, PlatformType platf, SwitchVersion version) throws SnmpException {
        List list;
        int classType;
        int pIndex;
        int i;
        if (peer == null || hwTypes == null || hwTypes.length == 0) {
            throw new SnmpException("Invalid snmp peer and entity type:" + peer + "," + Arrays.toString((Object[])hwTypes));
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getFexEntityIndexMap");
        }
        HashMap<HwInventoryType, List<Integer>> indexMap = new HashMap<HwInventoryType, List<Integer>>();
        boolean hasPort = false;
        boolean hasOther = false;
        for (HwInventoryType t : hwTypes) {
            indexMap.put(t, new ArrayList());
        }
        for (HwInventoryType type : hwTypes) {
            if (type == HwInventoryType.CHASSIS || type == HwInventoryType.MODULE) {
                List list2 = (List)indexMap.get((Object)type);
                for (int fexId : fexIds) {
                    list2.add(NexusEntityMibHelper.getFexEntityIndex(type.value(), fexId));
                }
                continue;
            }
            if (type == HwInventoryType.PORT) {
                hasPort = true;
                continue;
            }
            hasOther = true;
        }
        if (hasOther) {
            for (int fexId : fexIds) {
                int phyIndex = NexusEntityMibHelper.getFexEntityIndex(HwInventoryType.MODULE.value(), fexId);
                int maxPhyIndex = NexusEntityMibHelper.getFexEntityIndex(HwInventoryType.PORT.value(), fexId) - 1;
                VarBindList vbl = new VarBindList(1);
                vbl.add(EntOids[0]);
                SnmpPDU rspPdu = SnmpFetch.getBulkWithStartIndexFix(peer, vbl, 0, new int[]{phyIndex - 1}, new int[]{maxPhyIndex});
                VarBindList rspVbl = rspPdu.getVariables();
                if (_Tracer.isTraceable()) {
                    _Tracer.traceFunc(peer, "getFextEntityIndexMap", "--other response=" + rspVbl);
                }
                for (i = 0; i < rspVbl.size(); ++i) {
                    pIndex = rspVbl.get(i).getIndexFromEnd(0);
                    classType = rspVbl.intValue(i);
                    list = (List)indexMap.get((Object)HwInventoryType.getType(classType));
                    if (list == null) continue;
                    list.add(pIndex);
                }
            }
        }
        if (hasPort) {
            block5: for (int fexId : fexIds) {
                int phyIndex = NexusEntityMibHelper.getFexEntityIndex(HwInventoryType.PORT.value(), fexId);
                int maxPhyIndex = phyIndex + 128;
                VarBindList vbl = new VarBindList(1);
                vbl.add(EntOids[0]);
                SnmpPDU rspPdu = SnmpFetch.getBulkWithStartIndexFix(peer, vbl, 0, new int[]{phyIndex - 1}, new int[]{maxPhyIndex});
                VarBindList rspVbl = rspPdu.getVariables();
                if (_Tracer.isTraceable()) {
                    _Tracer.traceFunc(peer, "getFextEntityIndexMap", "--port response=" + rspVbl);
                }
                for (i = 0; i < rspVbl.size(); ++i) {
                    pIndex = rspVbl.get(i).getIndexFromEnd(0);
                    classType = rspVbl.intValue(i);
                    if (classType != HwInventoryType.PORT.value()) continue block5;
                    list = (List)indexMap.get((Object)HwInventoryType.PORT);
                    list.add(pIndex);
                }
            }
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getFexEntityIndexMap", indexMap);
        }
        return indexMap;
    }

    public static Map<HwInventoryType, List<Map>> getFexEntityInfo(SnmpPeer peer, int[] fexIds, HwInventoryType[] hwTypes, PlatformType platf, SwitchVersion version) throws SnmpException {
        Map<HwInventoryType, List<Integer>> indexMap;
        if (peer == null || hwTypes == null || hwTypes.length == 0) {
            throw new SnmpException("Invalid snmp peer and entity type:" + peer + "," + Arrays.toString((Object[])hwTypes));
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getFexEntityInfo");
        }
        if ((indexMap = CdpSnmpAdapter.getFexEntityIndexMap(peer, fexIds, hwTypes, platf, version)) == null || indexMap.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        ArrayList<Integer> phyIndexList = new ArrayList<Integer>();
        for (HwInventoryType t : hwTypes) {
            List<Integer> indexes = indexMap.get((Object)t);
            if (indexes == null) continue;
            phyIndexList.addAll(indexes);
        }
        Collections.sort(phyIndexList);
        int[] phyIndexes = new int[phyIndexList.size()];
        for (int i = 0; i < phyIndexList.size(); ++i) {
            phyIndexes[i] = (Integer)phyIndexList.get(i);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getFexEntityInfo", "--phyindexes=" + Arrays.toString(phyIndexes));
        }
        Map<HwInventoryType, List<Map>> retMap = CdpSnmpAdapter.getFexEntityInfoByIndex(peer, phyIndexes);
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getFexEntityInfo", retMap);
        }
        return retMap;
    }

    public static Map<HwInventoryType, List<Map>> getFexEntityInfoByIndex(SnmpPeer peer, int[] phyIndexes) throws SnmpException {
        if (peer == null || phyIndexes == null || phyIndexes.length == 0) {
            throw new SnmpException("Invalid snmp peer and entity phyindex:" + peer + "," + Arrays.toString(phyIndexes));
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getFexEntityInfoByIndex");
        }
        HashMap<HwInventoryType, List<Map>> retMap = new HashMap<HwInventoryType, List<Map>>();
        VarBindList vbl = new VarBindList();
        for (int phyIndex : phyIndexes) {
            for (int j = 0; j < EntOids.length; ++j) {
                vbl.add(EntOids[j], phyIndex);
            }
        }
        SnmpPDU rspPdu = SnmpFetch.get(peer, vbl);
        VarBindList rspVbl = rspPdu.getVariables();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getFexEntityInfoByIndex", "--- response=" + rspVbl);
        }
        int i = 0;
        while (i < rspVbl.size()) {
            HashMap<String, Object> entMap = new HashMap<String, Object>(25);
            int phyIndex = rspVbl.getVb(i).getOid().getIndexFromEnd(0);
            entMap.put(EntTable_phyIndex_MibCmd, phyIndex);
            int classType = -1;
            for (int cmdIdx = 0; cmdIdx < EntTable_MibCmds.length; ++cmdIdx) {
                if (cmdIdx == 0) {
                    classType = rspVbl.intValue(i++);
                    entMap.put(EntTable_MibCmds[cmdIdx], classType);
                    continue;
                }
                if (cmdIdx == 1 || cmdIdx == 11) {
                    entMap.put(EntTable_MibCmds[cmdIdx], rspVbl.intValue(i++));
                    continue;
                }
                if (cmdIdx == 2) {
                    SnmpVar var;
                    if (!((var = rspVbl.getVb(i++).getVar()) instanceof SnmpOID)) continue;
                    int[] oid = ((SnmpOID)var).getValue();
                    entMap.put(EntTable_MibCmds[cmdIdx], oid);
                    continue;
                }
                entMap.put(EntTable_MibCmds[cmdIdx], rspVbl.stringValue(i++));
            }
            HwInventoryType hwType = HwInventoryType.getType(classType);
            if (hwType == HwInventoryType.UNKNOWN) continue;
            ArrayList tlist = (ArrayList)retMap.get((Object)hwType);
            if (tlist == null) {
                tlist = new ArrayList();
                retMap.put(hwType, tlist);
            }
            tlist.add(entMap);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getFexEntityInfoByIndex", retMap);
        }
        return retMap;
    }

    public static Map getCdpNodes(SnmpPeer peer) throws SnmpException {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer:" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getCdpNodes");
        }
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(CdpGlobalVars.length));
        for (int i = 0; i < CdpGlobalVars.length; ++i) {
            reqPdu.addNull(CdpGlobalVars[i]);
        }
        SnmpPDU rspPdu = peer.send(reqPdu);
        VarBindList vbl = rspPdu.getVariables();
        HashMap<String, Object> retMap = new HashMap<String, Object>(CdpGlobalVars.length);
        for (int i = 0; i < vbl.size(); ++i) {
            if (i == 0) {
                retMap.put(CdpGlobal_MibCmds[i], vbl.intValue(i) == 1);
                continue;
            }
            if (i == 1) {
                List<String> values = serialNumMap.get(peer.getAddress().getHostAddress());
                if (values != null) {
                    retMap.put(CdpGlobal_MibCmds[i], values.get(0));
                    continue;
                }
                retMap.put(CdpGlobal_MibCmds[i], vbl.stringValue(i));
                continue;
            }
            retMap.put(CdpGlobal_MibCmds[i], vbl.stringValue(i));
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getCdpNodes", retMap);
        }
        return retMap;
    }

    public static List<Map> getCdpCachedConns(SnmpPeer peer) throws SnmpException {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer :" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getCdpCachedConns");
        }
        int colSize = CdpCacheOids.length;
        VarBindList vbl = new VarBindList(colSize);
        for (int i = 0; i < colSize; ++i) {
            vbl.add(CdpCacheOids[i]);
        }
        SnmpPDU rspPdu = SnmpFetch.getBulk(peer, vbl);
        vbl = rspPdu.getVariables();
        ArrayList<Map> retList = new ArrayList<Map>();
        int i = 0;
        while (i < vbl.size()) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>(colSize);
            int[] oidF = vbl.getVb(i).getOid().getValue();
            MibNode nodeF = MibNode.oidToNode(oidF);
            int locIfIndex = oidF[oidF.length - 2];
            valueMap.put(CdpCacheIndex_MibCmds[0], locIfIndex);
            int remoteDeviceIndex = oidF[oidF.length - 1];
            valueMap.put(CdpCacheIndex_MibCmds[1], remoteDeviceIndex);
            for (int col = 0; col < colSize && vbl.getVb(i) != null; ++col) {
                int[] oid = vbl.getVb(i).getOid().getValue();
                MibNode node = MibNode.oidToNode(oid);
                if (MibNode.equals(node.getOid(), MibNode.get(CdpCache_MibCmds[col]).getOid()) != 0) {
                    if (_Tracer.isDebuggable()) {
                        _Tracer.log(Level.DEBUG, "skip unspecified oid " + MibNode.oidToName(oid) + " expect " + CdpCache_MibCmds[col]);
                    }
                    ++i;
                    continue;
                }
                if (oid[oid.length - 2] != oidF[oidF.length - 2] || oid[oid.length - 1] != oidF[oidF.length - 1]) {
                    if (_Tracer.isDebuggable()) {
                        _Tracer.log(Level.DEBUG, "skip unmatched index in column " + col + ": oid " + MibNode.oidToName(oid) + ", expected index is " + oidF[oidF.length - 2] + "." + oidF[oidF.length - 1]);
                    }
                    ++i;
                    continue;
                }
                if (col == 0 || col == 8 || col == 9) {
                    InetAddress addr = null;
                    byte[] addrBytes = null;
                    try {
                        addrBytes = vbl.byteValue(i++);
                        if (addrBytes != null && addrBytes.length > 0) {
                            addr = InetAddress.getByAddress(addrBytes);
                        }
                    }
                    catch (Throwable e) {
                        _Tracer.log(Level.DEBUG, "Invalid cdp cached address: " + Arrays.toString(addrBytes));
                    }
                    valueMap.put(CdpCache_MibCmds[col], addr);
                    continue;
                }
                if (col == 4) {
                    String ifname = vbl.stringValue(i++);
                    valueMap.put(CdpCache_MibCmds[col], ifname);
                    continue;
                }
                if (col == 5) {
                    byte[] capBits;
                    if ((capBits = vbl.byteValue(i++)) != null) {
                        valueMap.put(CdpCache_MibCmds[col], new Bits(CdpCapabilityEnum, capBits));
                        continue;
                    }
                    valueMap.put(CdpCache_MibCmds[col], null);
                    continue;
                }
                if (col == 6) {
                    valueMap.put(CdpCache_MibCmds[col], (short)vbl.intValue(i++));
                    continue;
                }
                if (col == 7) {
                    valueMap.put(CdpCache_MibCmds[col], vbl.byteValue(i++));
                    continue;
                }
                if (col == 11) {
                    byte[] sysObjectID = vbl.byteValue(i++);
                    continue;
                }
                if (col == 1) {
                    if (peer.getAddress() != null && peer.getAddress().getHostAddress() != null && serialNumMap.get(peer.getAddress().getHostAddress()) != null) {
                        List<String> values = serialNumMap.get(peer.getAddress().getHostAddress());
                        valueMap.put(CdpCache_MibCmds[col], values.get(0));
                        continue;
                    }
                    valueMap.put(CdpCache_MibCmds[col], vbl.stringValue(i++));
                    continue;
                }
                valueMap.put(CdpCache_MibCmds[col], vbl.stringValue(i++));
            }
            retList.add(valueMap);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getCdpCachedConns", retList);
        }
        return retList;
    }

    public static List<Integer> getCdpIfindexes(SnmpPeer peer) throws SnmpException {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer :" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getCdpCachedConns");
        }
        int colSize = CdpCacheOids.length;
        VarBindList vbl = new VarBindList(1);
        for (int i = 0; i < colSize; ++i) {
            vbl.add(CdpCacheOids[0]);
        }
        SnmpPDU rspPdu = SnmpFetch.getBulk(peer, vbl);
        vbl = rspPdu.getVariables();
        ArrayList<Integer> retList = new ArrayList<Integer>();
        for (int i = 0; i < vbl.size(); ++i) {
            int[] oid = vbl.getVb(i).getOid().getValue();
            int locIfIndex = oid[oid.length - 2];
            retList.add(locIfIndex);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getCdpIfindexes", retList);
        }
        return retList;
    }

    public static long getCdpLastChange(SnmpPeer peer) throws SnmpException {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer:" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getCdpLastChange");
        }
        VarBindList vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(CdpLastChangeVar));
        SnmpPDU pdu = new SnmpPDU(-96, vbl);
        pdu = peer.send(pdu);
        vbl = pdu.getVariables();
        long lastChange = vbl.longValue(0);
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getEntityLastChange", lastChange);
        }
        return lastChange;
    }

    public static Map<Integer, Object> getEthIfValue(SnmpPeer peer, int[] ifindexes, int ifTableCol) throws SnmpException {
        VarBindList vbl;
        if (peer == null || ifTableCol < 0 || ifTableCol >= EthIfOids.length) {
            throw new SnmpException("Invalid snmp peer :" + peer + "," + ifTableCol);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getEthIfValue");
        }
        VarBindList rspVbl = null;
        if (ifindexes == null) {
            vbl = new VarBindList(1);
            vbl.add(EthIfOids[ifTableCol]);
            SnmpPDU rspPdu = SnmpFetch.getBulk(peer, vbl);
            rspVbl = rspPdu.getVariables();
        } else {
            if (ifindexes.length == 0) {
                return null;
            }
            vbl = new VarBindList(ifindexes.length);
            for (int i = 0; i < ifindexes.length; ++i) {
                if (IfIndexUtil.isFmIfIndex(ifindexes[i])) continue;
                vbl.add(EthIfOids[ifTableCol], ifindexes[i]);
            }
            if (vbl.size() > 0) {
                SnmpPDU rspPdu = SnmpFetch.get(peer, vbl);
                rspVbl = rspPdu.getVariables();
            }
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getEthIfValue", "--response=" + rspVbl);
        }
        HashMap<Integer, Object> retMap = new HashMap<Integer, Object>();
        if (rspVbl != null) {
            for (int i = 0; i < rspVbl.size(); ++i) {
                SnmpVarBind vb = rspVbl.getVb(i);
                if (vb.getVar().isNullType() || vb.getVar().getType() == 5) continue;
                int[] oid = vb.getOid().getValue();
                int ifindex = oid[oid.length - 1];
                if (ifTableCol == 0) {
                    String ifDescr = rspVbl.stringValue(i++);
                    retMap.put(ifindex, ifDescr);
                    continue;
                }
                if (ifTableCol == 1 || ifTableCol == 2 || ifTableCol == 5 || ifTableCol == 6) {
                    retMap.put(ifindex, rspVbl.intValue(i++));
                    continue;
                }
                if (ifTableCol == 3 || ifTableCol == 7) {
                    retMap.put(ifindex, rspVbl.longValue(i++));
                    continue;
                }
                if (ifTableCol == 4) {
                    byte[] b = rspVbl.byteValue(i++);
                    byte[] nb = new byte[6];
                    System.arraycopy(b, 0, nb, 0, b.length >= 6 ? 6 : b.length);
                    MacAddress macAddr = null;
                    try {
                        macAddr = new MacAddress(nb);
                    }
                    catch (Exception e) {
                        _Tracer.log(Level.DEBUG, peer + " cannot recognized mac address:" + Arrays.toString(nb), e);
                    }
                    retMap.put(ifindex, macAddr);
                    continue;
                }
                retMap.put(ifindex, rspVbl.stringValue(i++));
            }
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getEthIfValue", retMap);
        }
        return retMap;
    }

    public static List<Integer> getEthIfIndexes(SnmpPeer peer, boolean upOnly, int[] ifTypes) throws SnmpException {
        int i;
        int operStatus;
        VarBindList vbl;
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer :" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getEthIfIndexes");
        }
        HashSet<Integer> types = null;
        if (upOnly && ifTypes != null && ifTypes.length > 0) {
            vbl = new VarBindList(2);
            vbl.add(EthIfOids[6]);
            vbl.add(EthIfOids[1]);
        } else if (ifTypes != null && ifTypes.length > 0) {
            vbl = new VarBindList(1);
            vbl.add(EthIfOids[1]);
            types = new HashSet<Integer>(ifTypes.length);
            for (int t : ifTypes) {
                types.add(t);
            }
        } else {
            vbl = new VarBindList(1);
            vbl.add(EthIfOids[6]);
        }
        SnmpPDU rspPdu = SnmpFetch.getBulk(peer, vbl);
        VarBindList rspVbl = rspPdu.getVariables();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getEthIfIndexes", "--response=" + rspVbl);
        }
        ArrayList<Integer> ifindexes = new ArrayList<Integer>(10);
        if (upOnly && ifTypes != null && ifTypes.length > 0) {
            types = new HashSet(ifTypes.length);
            int[] arr$ = ifTypes;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer t = arr$[i$];
                types.add(t);
            }
            for (int i2 = 0; i2 < rspVbl.size() - 1; i2 += 2) {
                operStatus = rspVbl.intValue(i2);
                int iftype = rspVbl.intValue(i2 + 1);
                if (operStatus != 1 || !types.contains(iftype)) continue;
                ifindexes.add(rspVbl.get(i2).getOid().getIndexFromEnd(0));
            }
        } else if (upOnly) {
            for (i = 0; i < rspVbl.size(); ++i) {
                operStatus = rspVbl.intValue(i);
                if (operStatus != 1) continue;
                ifindexes.add(vbl.get(i).getOid().getIndexFromEnd(0));
            }
        } else if (ifTypes != null && ifTypes.length > 0) {
            for (i = 0; i < rspVbl.size(); ++i) {
                int iftype = rspVbl.intValue(i + 1);
                if (!types.contains(iftype)) continue;
                ifindexes.add(rspVbl.get(i).getOid().getIndexFromEnd(0));
            }
        } else {
            for (i = 0; i < rspVbl.size(); ++i) {
                operStatus = rspVbl.intValue(i);
                ifindexes.add(rspVbl.get(i).getOid().getIndexFromEnd(0));
            }
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getEthPortIfIndexes", ifindexes);
        }
        return ifindexes;
    }

    public static Map<Integer, Map> getEthPortInfo(SnmpPeer peer, int[] ifindexes, boolean hasShared) throws SnmpException {
        int i;
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer :" + peer);
        }
        if (ifindexes == null) {
            throw new IllegalArgumentException("ifindexes cannot be null");
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getEthPortInfo");
        }
        VarBindList rspVbl = null;
        if (ifindexes.length == 0) {
            return Collections.EMPTY_MAP;
        }
        VarBindList vbl = new VarBindList(EthIfOids.length * ifindexes.length);
        for (i = 0; i < ifindexes.length; ++i) {
            if (IfIndexUtil.isFmIfIndex(ifindexes[i])) continue;
            for (int k = 0; k < EthIfOids.length; ++k) {
                vbl.add(EthIfOids[k], ifindexes[i]);
            }
            if (!hasShared) continue;
            vbl.add(CiscoSharedEthIfOid, ifindexes[i]);
        }
        if (vbl.size() > 0) {
            SnmpPDU rspPdu = SnmpFetch.get(peer, vbl);
            rspVbl = rspPdu.getVariables();
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getEthPortInfo", "-- response=" + rspVbl);
        }
        HashMap<Integer, Map> retMap = new HashMap<Integer, Map>();
        if (rspVbl != null) {
            i = 0;
            while (i < rspVbl.size()) {
                int[] oid = rspVbl.getVb(i).getOid().getValue();
                int ifindex = oid[oid.length - 1];
                HashMap<String, Object> ifMap = new HashMap<String, Object>();
                for (int col = 0; col < EthIf_MibCmds.length; ++col) {
                    if (col == 0) {
                        String ifDescr = rspVbl.stringValue(i++);
                        ifMap.put(EthIf_MibCmds[col], ifDescr);
                        continue;
                    }
                    if (col == 1 || col == 2 || col == 5 || col == 6 || col == 9) {
                        ifMap.put(EthIf_MibCmds[col], rspVbl.intValue(i++));
                        continue;
                    }
                    if (col == 3 || col == 7) {
                        ifMap.put(EthIf_MibCmds[col], rspVbl.longValue(i++));
                        continue;
                    }
                    if (col == 4) {
                        byte[] b = rspVbl.byteValue(i++);
                        byte[] nb = new byte[6];
                        System.arraycopy(b, 0, nb, 0, b.length >= 6 ? 6 : b.length);
                        MacAddress macAddr = null;
                        try {
                            macAddr = new MacAddress(nb);
                        }
                        catch (Exception e) {
                            _Tracer.log(Level.DEBUG, peer + " cannot recognized mac address:" + Arrays.toString(nb), e);
                        }
                        ifMap.put(EthIf_MibCmds[col], macAddr);
                        continue;
                    }
                    ifMap.put(EthIf_MibCmds[col], rspVbl.stringValue(i++));
                }
                if (hasShared) {
                    if (rspVbl.getVb(i).getVar() != null && rspVbl.getVb(i).getVar().getType() == 2) {
                        ifMap.put(CiscoSharedEthIf_MidCmd, rspVbl.intValue(i));
                    } else {
                        ifMap.put(CiscoSharedEthIf_MidCmd, 2);
                    }
                    ++i;
                }
                retMap.put(ifindex, ifMap);
            }
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getEthPortInfo", retMap);
        }
        return retMap;
    }

    public static Map<Integer, Map<String, Object>> getEthPortAccessVlans(SnmpPeer peer, int[] ifindexes) throws SnmpException {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer :" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getEthPortAccessVlans");
        }
        if (ifindexes.length == 0) {
            return Collections.EMPTY_MAP;
        }
        VarBindList rspVbl = null;
        VarBindList vbl = new VarBindList(PortAccessVlanOids.length * ifindexes.length);
        for (int i = 0; i < ifindexes.length; ++i) {
            if (IfIndexUtil.isFmIfIndex(ifindexes[i])) continue;
            for (int k = 0; k < PortAccessVlanOids.length; ++k) {
                vbl.add(PortAccessVlanOids[k], ifindexes[i]);
            }
        }
        if (vbl.size() > 0) {
            SnmpPDU rspPdu = SnmpFetch.get(peer, vbl);
            rspVbl = rspPdu.getVariables();
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getEthPortAccessVlans", "--response=" + rspVbl);
        }
        HashMap<Integer, Map<String, Object>> retMap = new HashMap<Integer, Map<String, Object>>();
        if (rspVbl != null) {
            for (int i = 0; i < vbl.size(); i += PortAccessVlanOids.length) {
                SnmpVarBind vb = rspVbl.getVb(i);
                if (vb == null || vb.getVar() == null) continue;
                int[] oid = vb.getOid().getValue();
                int ifindex = oid[oid.length - 1];
                HashMap<String, Integer> vlanMap = new HashMap<String, Integer>();
                retMap.put(ifindex, vlanMap);
                for (int k = 0; k < PortAccessVlanOids.length; ++k) {
                    vb = rspVbl.getVb(i + k);
                    if (vb.getVar().getType() != 2) continue;
                    vlanMap.put(PortAccessVlan_MibCmds[k], vb.intValue());
                }
            }
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getEthPortAccessVlans", retMap);
        }
        return retMap;
    }

    public static Map<Integer, Map<String, Object>> getEthPortTrunkVlans(SnmpPeer peer, int[] ifindexes) throws SnmpException {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer :" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getEthPortTrunkVlans");
        }
        if (ifindexes.length == 0) {
            return Collections.EMPTY_MAP;
        }
        VarBindList rspVbl = null;
        VarBindList vbl = new VarBindList(PortTrunkVlanOids.length * ifindexes.length);
        for (int i = 0; i < ifindexes.length; ++i) {
            if (IfIndexUtil.isFmIfIndex(ifindexes[i])) continue;
            for (int k = 0; k < PortTrunkVlanOids.length; ++k) {
                vbl.add(PortTrunkVlanOids[k], ifindexes[i]);
            }
        }
        if (vbl.size() > 0) {
            SnmpPDU rspPdu = SnmpFetch.get(peer, vbl);
            rspVbl = rspPdu.getVariables();
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getEthPortTrunkVlans", "--response=" + rspVbl);
        }
        HashMap<Integer, Map<String, Object>> retMap = new HashMap<Integer, Map<String, Object>>();
        if (rspVbl != null) {
            for (int i = 0; i < rspVbl.size(); i += PortTrunkVlanOids.length) {
                byte[] secondVlans;
                int v;
                byte b;
                short offset;
                int k;
                byte[] firstVlans;
                SnmpVarBind vb = rspVbl.getVb(i);
                if (vb == null || vb.getVar() == null) continue;
                int[] oid = vb.getOid().getValue();
                int ifindex = oid[oid.length - 1];
                HashMap<String, Serializable> vlanMap = (HashMap<String, Serializable>)retMap.get(ifindex);
                if (vlanMap == null) {
                    vlanMap = new HashMap<String, Serializable>();
                    retMap.put(ifindex, vlanMap);
                }
                boolean isTrunking = false;
                if (vb.getVar().getType() == 2) {
                    vlanMap.put(PortTrunkVlan_MibCmds[0], Integer.valueOf(vb.intValue()));
                    boolean bl = isTrunking = vb.intValue() == 1;
                }
                if ((vb = rspVbl.get(i + 1)) != null && vb.getVar().getType() == 2) {
                    vlanMap.put(PortTrunkVlan_MibCmds[1], Integer.valueOf(vb.intValue()));
                }
                if (!isTrunking) continue;
                ArrayList<Short> vlanIds = new ArrayList<Short>();
                vb = rspVbl.get(i + 2);
                if (vb != null && vb.getVar() != null && vb.getVar().getType() == 4 && (firstVlans = vb.byteValue()) != null) {
                    for (k = 0; k < firstVlans.length; ++k) {
                        offset = (short)(k * 8);
                        b = firstVlans[k];
                        for (v = 1; v <= 8; ++v) {
                            if ((b >> 8 - v & 1) == 0) continue;
                            vlanIds.add((short)(offset + v - 1));
                        }
                    }
                }
                if ((vb = rspVbl.get(i + 3)) != null && vb.getVar() != null && vb.getVar().getType() == 4 && (secondVlans = vb.byteValue()) != null) {
                    for (k = 0; k < secondVlans.length; ++k) {
                        offset = (short)(k * 8 + 2048);
                        b = secondVlans[k];
                        for (v = 1; v <= 8; ++v) {
                            if ((b >> 8 - v & 1) == 0) continue;
                            vlanIds.add((short)(offset + v - 1));
                        }
                    }
                }
                vlanMap.put(PortTrunkVlan_MibCmds[2], vlanIds);
            }
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getEthPortTrunkVlans", retMap);
        }
        return retMap;
    }

    public static Map<Integer, int[]> getNxEthChannelMap(SnmpPeer peer) throws SnmpException {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer:" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getNxEthChannelMap");
        }
        HashMap<Integer, int[]> retMap = new HashMap<Integer, int[]>();
        EthSwitchImpl sw = DCManager.getInstance().findEthSwitchBySwIp(peer.getAddress());
        boolean _is6dot2_8 = sw != null && sw.getSwVersion() != null && !sw.getSwVersion().lessThan(new SwitchVersion("6.2(7)"));
        VarBindList vbl = new VarBindList(1);
        if (_is6dot2_8 && sw.getBase().isN7K()) {
            vbl.add(NxEthChannelOids[2]);
        } else {
            vbl.add(NxEthChannelOids[1]);
        }
        SnmpPDU respPdu = SnmpFetch.getBulk(peer, vbl);
        VarBindList rspVbl = respPdu.getVariables();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getNxEthChannelMap", "-- response=" + rspVbl);
        }
        for (int i = 0; i < rspVbl.size(); ++i) {
            int[] childIfindexes;
            byte[] portBytes;
            int channelIfindex;
            SnmpVarBind vb = rspVbl.getVb(i);
            if (_is6dot2_8 && sw.getBase().isN7K() && vb.getOid().startsWith(NxEthChannelOids[2])) {
                channelIfindex = vb.getOid().getIndexFromEnd(0);
                portBytes = vb.byteValue();
                childIfindexes = IfIndexUtil.interfaceIndexList2ifIndexes(portBytes);
                if (childIfindexes == null) continue;
                retMap.put(channelIfindex, childIfindexes);
                continue;
            }
            if (!vb.getOid().startsWith(NxEthChannelOids[1])) continue;
            channelIfindex = vb.getOid().getIndexFromEnd(0);
            portBytes = vb.byteValue();
            childIfindexes = IfIndexUtil.dot1Indexes2IfIndexes(portBytes);
            if (childIfindexes == null) continue;
            retMap.put(channelIfindex, childIfindexes);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getNxEthChannelMap", retMap);
        }
        return retMap;
    }

    public static int[] getNxEthChannels(SnmpPeer peer) throws SnmpException {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer:" + peer);
        }
        int[] ret = null;
        SnmpPDU pdu = new SnmpPDU(-91, new VarBindList(1));
        pdu.addNull(new SnmpOID(NxEthChannelOids[0]));
        pdu.setMaxRptr(36);
        SnmpPDU respPdu = peer.send(pdu);
        VarBindList rspVbl = respPdu.getVariables();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getNxEthChannels", "-- response=" + rspVbl);
        }
        ret = new int[rspVbl.size()];
        for (int i = 0; i < rspVbl.size(); ++i) {
            SnmpVarBind vb = rspVbl.getVb(i);
            if (!vb.getOid().startsWith(NxEthChannelOids[0])) continue;
            ret[i] = vb.getOid().getIndexFromEnd(0);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getNxEthChannels", Arrays.toString(ret));
        }
        return ret;
    }

    public static Map<Integer, Map> getNxEthChannelInfo(SnmpPeer peer) throws SnmpException {
        boolean _is6dot2_8;
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer:" + peer);
        }
        EthSwitchImpl sw = DCManager.getInstance().findEthSwitchBySwIp(peer.getAddress());
        boolean bl = _is6dot2_8 = sw != null && !sw.getSwVersion().lessThan(new SwitchVersion("6.2(8)"));
        if (_is6dot2_8) {
            CdpSnmpAdapter.NxEthChannelOids[1] = MibNode.get("clagAggPortListInterfaceIndexList").getOid();
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getNxEthChannelMap");
        }
        HashMap<Integer, Map> retMap = new HashMap<Integer, Map>();
        SnmpPDU pdu = new SnmpPDU(-91, new VarBindList(NxEthChannelOids.length));
        for (int i = 0; i < NxEthChannelOids.length; ++i) {
            pdu.addNull(new SnmpOID(NxEthChannelOids[i]));
        }
        pdu.setMaxRptr(36);
        SnmpPDU respPdu = peer.send(pdu);
        VarBindList rspVbl = respPdu.getVariables();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getNxEthChannelMap", "-- response=" + rspVbl);
        }
        for (int i = 0; i < rspVbl.size(); i += 2) {
            SnmpVarBind vb = rspVbl.getVb(i);
            if (!vb.getOid().startsWith(NxEthChannelOids[0])) continue;
            HashMap<String, Object> pcMap = new HashMap<String, Object>();
            int channelIfindex = vb.getOid().getIndexFromEnd(0);
            int adminState = vb.intValue();
            pcMap.put(NxEthChannel_MibCmds[0], adminState);
            byte[] portBytes = rspVbl.byteValue(i + 1);
            int[] childIfindexes = _is6dot2_8 ? IfIndexUtil.interfaceIndexList2ifIndexes(portBytes) : IfIndexUtil.dot1Indexes2IfIndexes(portBytes);
            pcMap.put(NxEthChannel_MibCmds[1], childIfindexes);
            retMap.put(channelIfindex, pcMap);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getNxEthChannelInfo", retMap);
        }
        return retMap;
    }

    public static Map<Integer, Integer> getCatEthChannelMap(SnmpPeer peer, int[] ifindexes) throws SnmpException {
        int i;
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer:" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getCatEthChannelMap");
        }
        VarBindList rspVbl = null;
        if (ifindexes != null && ifindexes.length > 0) {
            VarBindList vbl = new VarBindList(ifindexes.length);
            for (i = 0; i < ifindexes.length; ++i) {
                if (IfIndexUtil.isFmIfIndex(ifindexes[i])) continue;
                vbl.add(CatEthChannelMapOids[0], ifindexes[i]);
            }
            if (vbl.size() > 0) {
                SnmpPDU rspPdu = SnmpFetch.get(peer, vbl);
                rspVbl = rspPdu.getVariables();
            }
            if (_Tracer.isTraceable()) {
                _Tracer.traceFunc(peer, "getCatEthChannelMap", "-- FetchNext response=" + rspVbl);
            }
        } else {
            SnmpPDU pdu = new SnmpPDU(-91, new VarBindList(1));
            pdu.addNull(new SnmpOID(CatEthChannelOids[0]));
            SnmpPDU respPdu = peer.send(pdu);
            rspVbl = respPdu.getVariables();
            if (_Tracer.isTraceable()) {
                _Tracer.traceFunc(peer, "getCatEthChannelMap", "-- GetBulk response=" + rspVbl);
            }
        }
        HashMap<Integer, Integer> retMap = new HashMap<Integer, Integer>(10);
        if (rspVbl != null) {
            for (i = 0; i < rspVbl.size(); ++i) {
                SnmpVarBind vb = rspVbl.getVb(i);
                if (vb.getVar() == null) continue;
                int portIfindex = vb.getOid().getIndexFromEnd(0);
                int channelIfindex = vb.intValue();
                if (channelIfindex <= 0) continue;
                retMap.put(portIfindex, channelIfindex);
            }
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getCatEthChannelMap", retMap);
        }
        return retMap;
    }

    public static Map<Integer, Map> getCatEthChannelInfo(SnmpPeer peer, int[] ifindexes) throws SnmpException {
        int i;
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer:" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getCatEthChannelInfo");
        }
        VarBindList rspVbl = null;
        if (ifindexes != null && ifindexes.length > 0) {
            VarBindList vbl = new VarBindList(CatEthChannelOids.length * ifindexes.length);
            for (i = 0; i < ifindexes.length; ++i) {
                if (IfIndexUtil.isFmIfIndex(ifindexes[i])) continue;
                for (int k = 0; k < CatEthChannelOids.length; ++k) {
                    vbl.add(CatEthChannelOids[k], ifindexes[i]);
                }
            }
            if (vbl.size() > 0) {
                SnmpPDU rspPdu = SnmpFetch.get(peer, vbl);
                rspVbl = rspPdu.getVariables();
            }
            if (_Tracer.isTraceable()) {
                _Tracer.traceFunc(peer, "getCatEthChannelInfo", "--Fetch  response=" + rspVbl);
            }
        } else {
            SnmpPDU pdu = new SnmpPDU(-91, new VarBindList(CatEthChannelOids.length));
            for (int k = 0; k < CatEthChannelOids.length; ++k) {
                pdu.addNull(new SnmpOID(CatEthChannelOids[k]));
            }
            SnmpPDU respPdu = peer.send(pdu);
            rspVbl = respPdu.getVariables();
            if (_Tracer.isTraceable()) {
                _Tracer.traceFunc(peer, "getCatEthChannelInfo", "--GetBulk response=" + rspVbl);
            }
        }
        HashMap<Integer, Map> retMap = new HashMap<Integer, Map>();
        if (rspVbl != null) {
            for (i = 0; i < rspVbl.size(); i += CatEthChannelOids.length) {
                SnmpVarBind vb = rspVbl.getVb(i);
                if (vb.getVar() == null) continue;
                int[] oid = rspVbl.getVb(i).getOid().getValue();
                int portIfindex = oid[oid.length - 1];
                int opMode = rspVbl.intValue(i);
                if (opMode != 7) continue;
                HashMap<String, Serializable> pcMap = new HashMap<String, Serializable>();
                retMap.put(portIfindex, pcMap);
                pcMap.put(CatEthChannel_MibCmds[0], Integer.valueOf(opMode));
                for (int cmdIdx = 1; cmdIdx < CatEthChannel_MibCmds.length; ++cmdIdx) {
                    if (cmdIdx == 1) {
                        InetAddress addr = null;
                        byte[] addrBytes = null;
                        try {
                            addrBytes = rspVbl.byteValue(i + cmdIdx);
                            if (addrBytes != null && addrBytes.length > 0) {
                                addr = InetAddress.getByAddress(addrBytes);
                            }
                        }
                        catch (Throwable e) {
                            _Tracer.log(Level.DEBUG, "Invalid Cat EthChannel partner device Id: " + Arrays.toString(addrBytes));
                        }
                        pcMap.put(CatEthChannel_MibCmds[cmdIdx], addr);
                        continue;
                    }
                    pcMap.put(CatEthChannel_MibCmds[cmdIdx], Integer.valueOf(rspVbl.intValue(i + cmdIdx)));
                }
            }
            if (_Tracer.isTraceable()) {
                _Tracer.traceFunc(peer, "getCatEthChannelInfo", "-- channelInfo: " + retMap);
            }
            if (retMap.size() > 0) {
                ArrayList chList = new ArrayList(retMap.keySet());
                Collections.sort(chList);
                int[] chArray = new int[chList.size()];
                for (int i2 = 0; i2 < chList.size(); ++i2) {
                    chArray[i2] = (Integer)chList.get(i2);
                }
                Map<Integer, Integer> channelMap = CdpSnmpAdapter.getCatEthChannelMap(peer, chArray);
                for (Map.Entry<Integer, Integer> ent : channelMap.entrySet()) {
                    Map pcMap;
                    int childIfindex = ent.getKey();
                    int channelIfindex = ent.getValue();
                    if (channelIfindex <= 0 || (pcMap = (Map)retMap.get(childIfindex)) == null) continue;
                    pcMap.put(CatEthChannelMap_MibCmds[0], channelIfindex);
                }
            }
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getCatEthChannelInfo", retMap);
        }
        return retMap;
    }

    public static Map<String, Long> getCatUsage(SnmpPeer peer) throws SnmpException {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer:" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getCatUsage");
        }
        VarBindList vbl = new VarBindList(CatUsageOids.length);
        for (int i = 0; i < CatUsageOids.length; ++i) {
            if (i == 1 || i == 2) {
                vbl.add(CatUsageOids[i], 1);
                continue;
            }
            vbl.add(CatUsageOids[i], 0);
        }
        SnmpPDU rspPdu = SnmpFetch.get(peer, vbl);
        VarBindList rspVbl = rspPdu.getVariables();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getCatUsage", "--Fetch  response=" + rspVbl);
        }
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(CatUsageOids.length));
        HashMap<String, Long> retMap = new HashMap<String, Long>(CatUsageOids.length);
        for (int i = 0; i < rspVbl.size(); ++i) {
            SnmpVar var = rspVbl.get(i).getVar();
            if (var == null || var.isNullType()) continue;
            retMap.put(CatUsage_MibCmds[i], rspVbl.longValue(i));
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getCatUsage", retMap);
        }
        return retMap;
    }

    public static Map<String, Long> getNxUsage(SnmpPeer peer) throws SnmpException {
        if (peer == null) {
            throw new SnmpException("Invalid snmp peer:" + peer);
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncBegin(peer, "getNxUsage");
        }
        VarBindList vbl = new VarBindList(NxUsageOids.length);
        for (int i = 0; i < NxUsageOids.length; ++i) {
            vbl.add(NxUsageOids[i], 0);
        }
        SnmpPDU rspPdu = SnmpFetch.get(peer, vbl);
        VarBindList rspVbl = rspPdu.getVariables();
        if (_Tracer.isTraceable()) {
            _Tracer.traceFunc(peer, "getNxUsage", "--Fetch  response=" + rspVbl);
        }
        SnmpPDU reqPdu = new SnmpPDU(-96, new VarBindList(NxUsageOids.length));
        HashMap<String, Long> retMap = new HashMap<String, Long>(NxUsageOids.length);
        for (int i = 0; i < rspVbl.size(); ++i) {
            SnmpVar var = rspVbl.get(i).getVar();
            if (var == null || var.isNullType()) continue;
            retMap.put(NxUsage_MibCmds[i], rspVbl.longValue(i));
        }
        if (_Tracer.isTraceable()) {
            _Tracer.traceFuncEnd(peer, "getNxUsage", retMap);
        }
        return retMap;
    }

    public static int getVendorOidFromSysOid(int[] sysObjectID) {
        if (sysObjectID.length >= 7) {
            return sysObjectID[6];
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSerialNumMap() {
        if (SERIAL_MAP_FILE == null || SERIAL_MAP_FILE.trim().equals("")) {
            return;
        }
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(".." + File.separator + "conf" + File.separator + SERIAL_MAP_FILE));
            String line = r.readLine();
            while (line != null) {
                StringTokenizer tokenizer;
                if (line.indexOf("#") == 0) {
                    line = r.readLine();
                    continue;
                }
                if (line.indexOf(124) > 0 && (tokenizer = new StringTokenizer(line, "|")).countTokens() == 3) {
                    String ip = tokenizer.nextToken();
                    String device_id = tokenizer.nextToken();
                    String serial = tokenizer.nextToken();
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(device_id);
                    values.add(serial);
                    serialNumMap.put(ip, values);
                }
                line = r.readLine();
            }
            _Tracer.log(Level.DEBUG, "loadSerialNumMap: " + serialNumMap.size());
        }
        catch (FileNotFoundException e) {
            _Tracer.log(Level.DEBUG, "loadSerialNumMap: file '" + SERIAL_MAP_FILE + "' cannot be found. " + e.getMessage());
        }
        catch (IOException e) {
            _Tracer.log(Level.DEBUG, "loadSerialNumMap failed: " + e.getMessage());
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static void main(String[] args) {
        try {
            SnmpSession session = SnmpSession.getInstance();
            session.open();
            HwInventoryType[] hwTypes = new HwInventoryType[]{HwInventoryType.CHASSIS, HwInventoryType.MODULE, HwInventoryType.CONTAINER, HwInventoryType.FAN, HwInventoryType.POWERSUPPLY, HwInventoryType.BACKPLANE};
            SnmpUserOpt snmpUserOpt = null;
            SnmpPeer peer = null;
            InetAddress swIP = null;
            snmpUserOpt = new SnmpUserOpt("admin", "dcnm_2008", "public", 0, true);
            swIP = InetAddress.getByName("172.22.31.111");
            peer = null;
            if (snmpUserOpt.isV3()) {
                peer = new SnmpPeer(swIP, session, snmpUserOpt.getUsername(), snmpUserOpt.getPassword(), snmpUserOpt.getAuthProtocol(), snmpUserOpt.getPrivPassword(), snmpUserOpt.getPrivProtocol());
                peer.setVersion(3);
            } else {
                peer = new SnmpPeer(swIP, snmpUserOpt.getCommunity(), snmpUserOpt.getCommunity(), session);
                peer.setVersion(1);
            }
            SnmpPeer.addPeer(peer);
            System.err.println("========= N5K-FEX============");
            CdpSnmpAdapter.getDefaultEntityIndexMap(peer, hwTypes, false);
            CdpSnmpAdapter.getEntityIndexMap(peer, hwTypes, null, null, false);
            CdpSnmpAdapter.getChassisInfo(peer, null);
            CdpSnmpAdapter.getFexChassisIndex(peer, PlatformType.N5K, FRUConstants.VERSION_5_0);
            CdpSnmpAdapter.getFexEntityInfo(peer, new int[]{101}, new HwInventoryType[]{HwInventoryType.MODULE, HwInventoryType.CONTAINER, HwInventoryType.FAN, HwInventoryType.POWERSUPPLY}, PlatformType.N5K, FRUConstants.VERSION_5_0);
            CdpSnmpAdapter.getFexEntityInfo(peer, new int[]{101}, new HwInventoryType[]{HwInventoryType.PORT}, PlatformType.N5K, FRUConstants.VERSION_5_0);
            SnmpPeer.removePeer(peer);
            session.close();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        System.exit(0);
    }

    static {
        int i;
        _Tracer = new TraceLogger(Logger.getLogger((String)"fms.disc"), false, true, false, false);
        CdpCapabilityEnum = new MibEnum[5];
        SERIAL_MAP_FILE = System.getProperty("server.simulationFile");
        serialNumMap = new HashMap<String, List<String>>();
        String[] labels = new String[]{"Router", "TB Bridge", "SR Bridge", "Switch", "Host"};
        for (int i2 = 0; i2 < 5; ++i2) {
            CdpSnmpAdapter.CdpCapabilityEnum[i2] = new MibEnum(labels[i2], i2);
        }
        CdpSnmpAdapter.loadSerialNumMap();
        CISCO_NX_CHASSIS_OID = new int[]{1, 3, 6, 1, 4, 1, 9, 12, 3, 1, 3};
        CISCO_CAT6_CHASSIS_OID = new int[]{1, 3, 6, 1, 4, 1, 9, 1};
        CISCO_CAT5_CHASSIS_OID = new int[]{1, 3, 6, 1, 4, 1, 9, 5};
        CISCO_IP_PHONE_OID = new int[]{1, 3, 6, 1, 4, 1, 9, 9};
        GenSys_MibCmds = new String[]{"sysObjectID", "sysDescr", "sysUpTime", "sysContact", "sysName", "sysLocation"};
        SwInfo_MibCmds = new String[]{"cseSysTelnetServiceActivation", "cssServiceActivation"};
        CdpCache_MibCmds = new String[]{"cdpCacheAddress", "cdpCacheDeviceId", "cdpCachePlatform", "cdpCacheVersion", "cdpCacheDevicePort", "cdpCacheCapabilities", "cdpCacheNativeVLAN", "cdpCacheVTPMgmtDomain", "cdpCachePrimaryMgmtAddr", "cdpCacheSecondaryMgmtAddr", "cdpCacheSysName", "cdpCacheSysObjectID", "cdpCachePhysLocation"};
        CdpCacheIndex_MibCmds = new String[]{"cdpCacheIfIndex", "cdpCacheDeviceIndex"};
        CdpGlobal_MibCmds = new String[]{"cdpGlobalRun", "cdpGlobalDeviceId"};
        CiscoRF_MibCmds = new String[]{"cRFStatusUnitId", "cRFStatusUnitState", "cRFStatusPeerUnitId", "cRFStatusPeerUnitState"};
        EntTable_MibCmds = new String[]{"entPhysicalClass", "entPhysicalParentRelPos", "entPhysicalVendorType", "entPhysicalName", "entPhysicalHardwareRev", "entPhysicalFirmwareRev", "entPhysicalSoftwareRev", "entPhysicalSerialNum", "entPhysicalMfgName", "entPhysicalModelName", "entPhysicalAssetID", "entPhysicalContainedIn"};
        EntLastChange_MibCmds = new String[]{"entLastChangeTime", "cRFStatusUnitId"};
        CiscoChassis_MibCmds = new String[]{"ceEntPhysicalSecondSerialNum"};
        Module_MibCmds = new String[]{"cefcModuleAdminStatus", "cefcModuleOperStatus", "cefcModuleResetReasonDescription", "cefcModuleStatusLastChangeTime", "cefcFRUPowerAdminStatus", "cefcFRUPowerOperStatus", "cefcFRUCurrent", "entPhysicalDescr"};
        Power_MibCmds = new String[]{"cefcFRUPowerOperStatus", "cefcPowerRedundancyMode", "cefcTotalAvailableCurrent", "cefcTotalDrawnCurrent", "cefcPowerUnits"};
        Fan_MibCmds = new String[]{"cefcFanTrayOperStatus"};
        EthIf_MibCmds = new String[]{"ifDescr", "ifType", "ifMtu", "ifSpeed", "ifPhysAddress", "ifAdminStatus", "ifOperStatus", "ifHighSpeed", "ifAlias", "fcIfOperStatusCause"};
        _EthIfOperStatusOid = MibNode.get("ifOperStatus").getOid();
        NxEthChannel_MibCmds = new String[]{"clagAggPortAdminStatus", "clagAggPortListPorts", "clagAggPortListInterfaceIndexList"};
        PortAccessVlan_MibCmds = new String[]{"vmVlanType", "vmPortStatus", "vmVlan"};
        PortTrunkVlan_MibCmds = new String[]{"vlanTrunkPortDynamicStatus", "vlanTrunkPortNativeVlan", "vlanTrunkPortVlansActiveFirst2k", "vlanTrunkPortVlansActiveSecond2k"};
        CatEthChannel_MibCmds = new String[]{"pagpPortState", "pagpPartnerDeviceId", "pagpPartnerIfIndex", "pagpPartnerGroupIfIndex"};
        CatEthChannelMap_MibCmds = new String[]{"pagpGroupIfIndex"};
        Vdc_MibCmds = new String[]{"ciscoVdcName", "ciscoVdcState", "ciscoVdcFcoeCapable", "ciscoVdcMac", "ciscoVdcSwitchId"};
        License_MibCmds = new String[]{"clmLicenseFlag", "clmNoOfLicenseCurrentUsages", "clmNoOfLicenseMaxUsages", "clmNoOfMissingUsageLicenses", "clmLicenseExpiryDate", "clmLicenseGracePeriod", "clmLicenseGracePeriodLeft"};
        CatUsage_MibCmds = new String[]{"avgBusy5", "ciscoMemoryPoolUsed", "ciscoMemoryPoolFree"};
        NxUsage_MibCmds = new String[]{"cseSysCPUUtilization", "cseSysMemoryUtilization"};
        GenSysVars = new SnmpOID[GenSys_MibCmds.length];
        for (i = 0; i < GenSys_MibCmds.length; ++i) {
            CdpSnmpAdapter.GenSysVars[i] = new SnmpOID(MibNode.get(GenSys_MibCmds[i]).getOid(), 0);
        }
        SwInfoVars = new SnmpOID[SwInfo_MibCmds.length];
        for (i = 0; i < SwInfo_MibCmds.length; ++i) {
            CdpSnmpAdapter.SwInfoVars[i] = new SnmpOID(MibNode.get(SwInfo_MibCmds[i]).getOid(), 0);
        }
        CdpGlobalVars = new SnmpOID[CdpGlobal_MibCmds.length];
        for (i = 0; i < CdpGlobal_MibCmds.length; ++i) {
            CdpSnmpAdapter.CdpGlobalVars[i] = new SnmpOID(MibNode.get(CdpGlobal_MibCmds[i]).getOid(), 0);
        }
        CdpLastChangeVar = new SnmpOID(MibNode.get(CdpLastChange_MibCmd).getOid(), 0);
        EntLastChangeVars = new SnmpOID[EntLastChange_MibCmds.length];
        for (i = 0; i < EntLastChange_MibCmds.length; ++i) {
            CdpSnmpAdapter.EntLastChangeVars[i] = new SnmpOID(MibNode.get(EntLastChange_MibCmds[i]).getOid(), 0);
        }
        EntOids = new int[EntTable_MibCmds.length][];
        for (i = 0; i < EntOids.length; ++i) {
            CdpSnmpAdapter.EntOids[i] = MibNode.get(EntTable_MibCmds[i]).getOid();
        }
        EntLastCheckVar = new SnmpOID(MibNode.get("entLastChangeTime").getOid());
        CiscoRFVars = new SnmpOID[CiscoRF_MibCmds.length];
        for (i = 0; i < CiscoRFVars.length; ++i) {
            CdpSnmpAdapter.CiscoRFVars[i] = new SnmpOID(MibNode.get(CiscoRF_MibCmds[i]).getOid(), 0);
        }
        CiscoChassisOids = new int[CiscoChassis_MibCmds.length][];
        for (i = 0; i < CiscoChassisOids.length; ++i) {
            CdpSnmpAdapter.CiscoChassisOids[i] = MibNode.get(CiscoChassis_MibCmds[i]).getOid();
        }
        ModuleOids = new int[Module_MibCmds.length][];
        for (i = 0; i < ModuleOids.length; ++i) {
            CdpSnmpAdapter.ModuleOids[i] = MibNode.get(Module_MibCmds[i]).getOid();
        }
        FanOids = new int[Fan_MibCmds.length][];
        for (i = 0; i < FanOids.length; ++i) {
            CdpSnmpAdapter.FanOids[i] = MibNode.get(Fan_MibCmds[i]).getOid();
        }
        PowerOids = new int[Power_MibCmds.length][];
        for (i = 0; i < PowerOids.length; ++i) {
            CdpSnmpAdapter.PowerOids[i] = MibNode.get(Power_MibCmds[i]).getOid();
        }
        EthIfOids = new int[EthIf_MibCmds.length][];
        for (i = 0; i < EthIfOids.length; ++i) {
            CdpSnmpAdapter.EthIfOids[i] = MibNode.get(EthIf_MibCmds[i]).getOid();
        }
        CdpCacheOids = new int[CdpCache_MibCmds.length][];
        for (i = 0; i < CdpCache_MibCmds.length; ++i) {
            CdpSnmpAdapter.CdpCacheOids[i] = MibNode.get(CdpCache_MibCmds[i]).getOid();
        }
        CdpEnableVar = new SnmpOID(MibNode.get(CdpGlobal_MibCmds[0]).getOid(), 0);
        NxEthChannelOids = new int[NxEthChannel_MibCmds.length][];
        for (i = 0; i < NxEthChannel_MibCmds.length; ++i) {
            CdpSnmpAdapter.NxEthChannelOids[i] = MibNode.get(NxEthChannel_MibCmds[i]).getOid();
        }
        CatEthChannelOids = new int[CatEthChannel_MibCmds.length][];
        for (i = 0; i < CatEthChannel_MibCmds.length; ++i) {
            CdpSnmpAdapter.CatEthChannelOids[i] = MibNode.get(CatEthChannel_MibCmds[i]).getOid();
        }
        CatEthChannelMapOids = new int[CatEthChannelMap_MibCmds.length][];
        for (i = 0; i < CatEthChannelMap_MibCmds.length; ++i) {
            CdpSnmpAdapter.CatEthChannelMapOids[i] = MibNode.get(CatEthChannelMap_MibCmds[i]).getOid();
        }
        PortTrunkVlanOids = new int[PortTrunkVlan_MibCmds.length][];
        for (i = 0; i < PortTrunkVlan_MibCmds.length; ++i) {
            CdpSnmpAdapter.PortTrunkVlanOids[i] = MibNode.get(PortTrunkVlan_MibCmds[i]).getOid();
        }
        PortAccessVlanOids = new int[PortAccessVlan_MibCmds.length][];
        for (i = 0; i < PortAccessVlan_MibCmds.length; ++i) {
            CdpSnmpAdapter.PortAccessVlanOids[i] = MibNode.get(PortAccessVlan_MibCmds[i]).getOid();
        }
        VdcOids = new int[Vdc_MibCmds.length][];
        for (i = 0; i < Vdc_MibCmds.length; ++i) {
            CdpSnmpAdapter.VdcOids[i] = MibNode.get(Vdc_MibCmds[i]).getOid();
        }
        LicenseOids = new int[License_MibCmds.length][];
        for (i = 0; i < License_MibCmds.length; ++i) {
            CdpSnmpAdapter.LicenseOids[i] = MibNode.get(License_MibCmds[i]).getOid();
        }
        CatUsageOids = new int[CatUsage_MibCmds.length][];
        for (i = 0; i < CatUsage_MibCmds.length; ++i) {
            CdpSnmpAdapter.CatUsageOids[i] = MibNode.get(CatUsage_MibCmds[i]).getOid();
        }
        NxUsageOids = new int[NxUsage_MibCmds.length][];
        for (i = 0; i < NxUsage_MibCmds.length; ++i) {
            CdpSnmpAdapter.NxUsageOids[i] = MibNode.get(NxUsage_MibCmds[i]).getOid();
        }
        CiscoFeatureOid = MibNode.get(CiscoFeature_MibCmd).getOid();
        CiscoFeatureSetOid = MibNode.get(CiscoFeatureSet_MibCmd).getOid();
        CiscoSharedEthIfOid = MibNode.get(CiscoSharedEthIf_MidCmd).getOid();
        CiscoNumOfLicVar = new SnmpOID(MibNode.get(CiscoNumOfLic_MidCmd).getOid(), 0);
    }
}

