/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.discovery;

import com.cisco.dcbu.lib.sshexec.CliAdapterFactory;
import com.cisco.dcbu.lib.sshexec.ILldpAdapter;
import com.cisco.dcbu.sm.common.type.PlatformType;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.HostImpl;
import com.cisco.dcbu.sm.server.model.LanHostImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.NotSupportedException;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LanHostWorker
implements Runnable {
    static Logger logger = LogManager.getLogger((String)"fms.disc");
    private static AtomicBoolean discovering = new AtomicBoolean();
    private static long startTime = 0L;
    private LanImpl lan = null;
    private List<EthSwitchImpl> switches = null;

    public LanHostWorker() {
    }

    public LanHostWorker(LanImpl lan, List<EthSwitchImpl> switches) {
        this.lan = lan;
        this.switches = switches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block35: {
            Connection con = null;
            try {
                boolean discoverEnabled = Boolean.parseBoolean(System.getProperty("cdp.discoverLanHosts", "true"));
                if (!discoverEnabled) {
                    logger.info((Object)("LAN host discovery is disabled, cdp.discoverLanHosts=" + discoverEnabled));
                    return;
                }
                if (discovering.get()) {
                    logger.info((Object)"LAN host discovery is in progress");
                    return;
                }
                discovering.set(true);
                startTime = System.currentTimeMillis();
                logger.info((Object)("start LAN host discovery at " + new Date(startTime)));
                con = ConnectionManager.getConnection();
                HostImpl.deleteOldLanHosts(con);
                if (this.switches != null) {
                    int count = 0;
                    for (EthSwitchImpl sw : this.switches) {
                        if (this.lan.findEthSwitchByDBID(sw.getDBID()) == null) continue;
                        ArrayList<LanHostImpl> neighbors = new ArrayList<LanHostImpl>();
                        Map<String, String> ipMap = null;
                        if (!PlatformType.isNexusSwitch(sw.getPlatformType())) continue;
                        try {
                            ++count;
                            ILldpAdapter adapter = null;
                            if (sw.getPeer() != null) {
                                adapter = CliAdapterFactory.getLldpAdapter(sw);
                                if (sw.getPlatformType() == PlatformType.N1K || sw.getPlatformType() == PlatformType.N1K1 || sw.getPlatformType() == PlatformType.N1KV) {
                                    neighbors.addAll(adapter.showMacAddressTableXml());
                                } else {
                                    neighbors.addAll(adapter.showMacAddressTable());
                                    neighbors.addAll(adapter.showLldpNeighborsDetail());
                                }
                                ipMap = adapter.showIpArp();
                            }
                        }
                        catch (NotSupportedException e) {
                            logger.log((Priority)Level.WARN, (Object)e.getMessage());
                        }
                        catch (Exception e) {
                            logger.log((Priority)Level.WARN, (Object)("LAN host discovery caught exception for switch '" + sw.getIpAddress() + "'"), (Throwable)e);
                        }
                        if (neighbors == null) continue;
                        ArrayList<LanHostImpl> hosts = new ArrayList<LanHostImpl>();
                        for (LanHostImpl h : neighbors) {
                            String key = h.getMac() + "-" + h.getVlan();
                            if (ipMap.containsKey(key)) {
                                h.setIpAddress(ipMap.get(key));
                            }
                            if (h.getEthIfName().startsWith("Eth")) {
                                StringTokenizer tokenizer = new StringTokenizer(h.getEthIfName(), "/");
                                if (!tokenizer.hasMoreElements()) continue;
                                String temp = null;
                                if (h.getEthIfName().startsWith("Ethernet")) {
                                    temp = ((String)tokenizer.nextElement()).substring("Ethernet".length());
                                } else if (h.getEthIfName().startsWith("Eth")) {
                                    temp = ((String)tokenizer.nextElement()).substring("Eth".length());
                                }
                                if (temp == null || temp.equals("")) continue;
                                int fexId = -1;
                                try {
                                    fexId = Integer.parseInt(temp);
                                }
                                catch (Exception e) {
                                    logger.log((Priority)Level.DEBUG, (Object)("ifname='" + h.getEthIfName() + "', switch='" + sw.getIpAddress() + "'." + e.getMessage()));
                                }
                                logger.log((Priority)Level.DEBUG, (Object)("fexID: " + fexId));
                                if (fexId >= 100) {
                                    ResultSet rs;
                                    PreparedStatement queryStat;
                                    block34: {
                                        queryStat = null;
                                        rs = null;
                                        try {
                                            queryStat = con.prepareStatement("select fs.id, fs.sys_name from ethswitch s, ethswitch fs, ethswitch_fex f where s.id=? and f.switch_id=s.id and fs.id=f.fex_id and fs.fex_id=?");
                                            queryStat.setLong(1, sw.getDBID());
                                            queryStat.setInt(2, fexId);
                                            rs = queryStat.executeQuery();
                                            if (rs != null) {
                                                while (rs.next()) {
                                                    h.setEthSwitchId(rs.getLong(1));
                                                    String ethSwName = rs.getString(2);
                                                    logger.log((Priority)Level.DEBUG, (Object)("fex switch name: " + ethSwName));
                                                    hosts.add(h);
                                                }
                                                break block34;
                                            }
                                            logger.debug((Object)("Cannot find fex switch with fexID=" + fexId + " for switch '" + sw.getName() + "'"));
                                        }
                                        catch (SQLException e) {
                                            try {
                                                logger.info((Object)("Query FEX switch ID and name failed." + e.getMessage()));
                                            }
                                            catch (Throwable throwable) {
                                                DbUtil.close(rs);
                                                DbUtil.close(queryStat);
                                                throw throwable;
                                            }
                                            DbUtil.close(rs);
                                            DbUtil.close(queryStat);
                                            continue;
                                        }
                                    }
                                    DbUtil.close(rs);
                                    DbUtil.close(queryStat);
                                    continue;
                                }
                                h.setEthSwitchId(sw.getDBID());
                                hosts.add(h);
                                continue;
                            }
                            h.setEthSwitchId(sw.getDBID());
                            hosts.add(h);
                        }
                        try {
                            LanHostImpl.createHosts(con, hosts);
                        }
                        catch (Exception e) {
                            logger.log((Priority)Level.WARN, (Object)"LAN host discovery caught exception", (Throwable)e);
                        }
                    }
                    HostImpl.deleteOldLanHosts(con);
                    logger.info((Object)("finished LAN host discovery for " + count + " switches in " + (System.currentTimeMillis() - startTime) + "ms"));
                }
                discovering.set(false);
            }
            catch (Exception e) {
                logger.error((Object)"Failed LAN host discovery", (Throwable)e);
                break block35;
            }
            finally {
                discovering.set(false);
                DbUtil.close(con);
            }
            DbUtil.close(con);
        }
    }
}

