/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.dmm;

import com.cisco.dcbu.sm.server.dmm.MetaClassInfo;
import java.io.PrintWriter;

public class MetaAttributeInfo {
    public String m_name;
    String m_type;
    int m_length = -1;
    String m_source;
    String m_custom = null;
    boolean m_isCollection = false;
    boolean m_isTransient = false;

    public MetaAttributeInfo(String name, String type, String length, String isCollection, String source, String custom, String isTransient) {
        this.m_name = name;
        this.m_type = type;
        this.m_source = source;
        this.m_custom = custom;
        if (this.m_custom.equals("")) {
            this.m_custom = null;
        }
        if (isCollection != null && isCollection.equals("1")) {
            this.m_isCollection = true;
        }
        if (isTransient != null && isTransient.equals("1")) {
            this.m_isTransient = true;
        }
        if (length != null && length.length() > 0) {
            this.m_length = length.indexOf(".") > 0 ? Integer.parseInt(length.substring(length.indexOf(".") + 1)) : Integer.parseInt(length);
        }
    }

    public void generateAttrCode(PrintWriter writer) {
        writer.print("     private " + this.toJavaType() + " m_" + this.m_name);
        writer.print(";\n\n");
    }

    String getDataSourceName() {
        if (this.m_source != null && this.m_source.length() > 1) {
            if (this.m_type.equals("byte")) {
                return "(byte)m_" + this.m_source + ".size()";
            }
            if (this.m_type.equals("short")) {
                return "(short)m_" + this.m_source + ".size()";
            }
            return "m_" + this.m_source + ".size()";
        }
        return "m_" + this.m_name;
    }

    public void generateOutputCode(PrintWriter writer) {
        if (this.m_isTransient) {
            return;
        }
        if (this.m_isCollection) {
            this.generateCollectionOutputCode(writer);
        } else {
            if (this.m_custom != null) {
                return;
            }
            if (this.m_type.equals("int")) {
                writer.print("\t\tSshMediatorHelper.writeInt(stream, " + this.getDataSourceName() + "," + this.m_length + ");");
            } else if (this.m_type.equals("short")) {
                writer.print("\t\tSshMediatorHelper.writeShort(stream, " + this.getDataSourceName() + "," + this.m_length + ");");
            } else if (this.m_type.equals("byte")) {
                writer.print("\t\tSshMediatorHelper.writeByte(stream, " + this.getDataSourceName() + "," + this.m_length + ");");
            } else if (this.m_type.equals("long")) {
                writer.print("\t\tSshMediatorHelper.writeLong(stream, " + this.getDataSourceName() + "," + this.m_length + ");");
            } else if (this.m_type.equals("String")) {
                writer.print("\t\tSshMediatorHelper.writeString(stream, " + this.getDataSourceName() + "," + this.m_length + ");");
            } else if (this.m_type.equals("Wwn")) {
                writer.print("\t\tSshMediatorHelper.writeWwn(stream, " + this.getDataSourceName() + "," + this.m_length + ");");
            } else {
                writer.print("\t\tSshMediatorHelper.writeByteArray(stream, m_" + this.m_name + ".toByteArray()); ");
            }
        }
        writer.print("\n");
    }

    private void generateCollectionOutputCode(PrintWriter writer) {
        writer.print("\t\tfor(int i=0;i<m_" + this.m_name + ".size();i++) {\n");
        writer.print("\t\t\t" + this.toElementType() + " obj = (" + this.toElementType() + ") m_" + this.m_name + ".get(i);\n");
        if (this.m_type.equals("int")) {
            writer.print("\t\t\tSshMediatorHelper.writeInt(stream, obj.intValue()," + this.m_length + ");");
        } else if (this.m_type.equals("short")) {
            writer.print("\t\t\tSshMediatorHelper.writeShort(stream,  obj.shortValue()," + this.m_length + ");");
        } else if (this.m_type.equals("byte")) {
            writer.print("\t\t\tSshMediatorHelper.writeByte(stream,  obj.byteValue()," + this.m_length + ");");
        } else if (this.m_type.equals("long")) {
            writer.print("\t\t\tSshMediatorHelper.writeLong(stream, obj.longValue()," + this.m_length + ");");
        } else if (this.m_type.equals("Wwn")) {
            writer.print("\t\t\tSshMediatorHelper.writeWwn(stream, obj.longValue()," + this.m_length + ");");
        } else if (this.m_type.equals("String")) {
            writer.print("\t\t\tSshMediatorHelper.writeString(stream, obj," + this.m_length + ");");
        } else if (this.m_type.equals("se_TLV")) {
            writer.print("\t\t\tSshMediatorHelper.writeSeTLV(stream, obj);");
        } else {
            writer.print("\t\t\tSshMediatorHelper.writeByteArray(stream, obj.toByteArray());\n");
        }
        writer.print("\t\t}\n");
    }

    public void generateInputCode(PrintWriter writer) {
        if (this.m_isTransient) {
            return;
        }
        if (this.m_isCollection) {
            this.generateCollectionInputCode(writer);
        } else if (this.m_custom != null && this.m_custom.equals("in")) {
            writer.print("\t\tm_" + this.m_name + " =SshMediatorHelper.readCustom" + "(stream, this);");
        } else if (this.m_type.equals("int")) {
            writer.print("\t\tm_" + this.m_name + " =SshMediatorHelper.readInt(stream," + this.m_length + ");");
        } else if (this.m_type.equals("short")) {
            writer.print("\t\tm_" + this.m_name + " =SshMediatorHelper.readShort(stream," + this.m_length + ");");
        } else if (this.m_type.equals("byte")) {
            writer.print("\t\tm_" + this.m_name + " =SshMediatorHelper.readByte(stream," + this.m_length + ");");
        } else if (this.m_type.equals("long")) {
            writer.print("\t\tm_" + this.m_name + " =SshMediatorHelper.readLong(stream," + this.m_length + ");");
        } else if (this.m_type.equals("String")) {
            writer.print("\t\tm_" + this.m_name + " =SshMediatorHelper.readString(stream," + this.m_length + ");");
        } else if (this.m_type.equals("Wwn")) {
            writer.print("\t\tm_" + this.m_name + " =SshMediatorHelper.readWwn(stream," + this.m_length + ");");
        } else if (this.m_custom == null || !this.m_custom.equals("out")) {
            writer.print("\t\tm_" + this.m_name + " = new " + this.toJavaType() + "();\n");
            writer.print("\t\tm_" + this.m_name + ".fromByteArray(stream);\n");
        }
        writer.print("\n");
    }

    public void generateToStringCode(PrintWriter writer) {
        if (this.m_isTransient) {
            return;
        }
        if (this.m_isCollection) {
            this.generateCollectionToStringCode(writer);
        } else if (this.m_custom != null && this.m_custom.equals("in")) {
            writer.print("\t\tbuf.append(\"m_" + this.m_name + ":\" + m_" + this.m_name + "+\":\");");
        } else if (this.m_type.equals("int") || this.m_type.equals("short") || this.m_type.equals("byte") || this.m_type.equals("long") || this.m_type.equals("String")) {
            writer.print("\t\tbuf.append(\"m_" + this.m_name + ":\" + m_" + this.m_name + "+\":\");");
        } else if (this.m_type.equals("Wwn")) {
            writer.print("\t\tbuf.append(\"m_" + this.m_name + ":\" + m_" + this.m_name + ".toString()+\":\");");
        }
        writer.print("\n");
    }

    private void generateCollectionToStringCode(PrintWriter writer) {
        writer.print("\t\tbuf.append(\"m_" + this.m_name + ":\");\n");
        writer.print("\t\tfor(int i=0;i<m_" + this.m_name + ".size();i++) {\n");
        writer.print("\t\t\tbuf.append(\":\" +m_" + this.m_name + ".get(i));\n");
        writer.print("\t\t}\n");
    }

    private void generateCollectionInputCode(PrintWriter writer) {
        writer.print("\t\tm_" + this.m_name + "= new ArrayList();\n");
        writer.print("\t\tfor(int i=0;i<m_" + this.m_source + ";i++) {\n");
        if (this.m_type.equals("int")) {
            writer.print("\t\t\t" + this.toElementType() + " obj = new " + this.toElementType() + "(" + " SshMediatorHelper.readInt(stream," + this.m_length + "));\n");
        } else if (this.m_type.equals("short")) {
            writer.print("\t\t\t" + this.toElementType() + " obj = new " + this.toElementType() + "(" + " SshMediatorHelper.readShort(stream," + this.m_length + "));\n");
        } else if (this.m_type.equals("byte")) {
            writer.print("\t\t\t" + this.toElementType() + " obj = new " + this.toElementType() + "(" + " SshMediatorHelper.readByte(stream," + this.m_length + "));\n");
        } else if (this.m_type.equals("long")) {
            writer.print("\t\t\t" + this.toElementType() + " obj = new " + this.toElementType() + "(" + " SshMediatorHelper.readLong(stream," + this.m_length + "));\n");
        } else if (this.m_type.equals("String")) {
            writer.print("\t\t\t" + this.toElementType() + " obj = new " + this.toElementType() + "(" + " SshMediatorHelper.readString(stream," + this.m_length + "));\n");
        } else if (this.m_type.equals("Wwn")) {
            writer.print("\t\t\t" + this.toElementType() + " obj = new " + this.toElementType() + "(" + " SshMediatorHelper.readWwn(stream," + this.m_length + "));\n");
        } else {
            writer.print("\t\t\t" + this.toElementType() + " obj = new " + this.toElementType() + "();\n");
            writer.print("\t\t\tobj.fromByteArray(stream);\n");
        }
        writer.print("\t\t\tm_" + this.m_name + ".add(obj);\n");
        writer.print("\t\t}\n");
    }

    public void generateAttrMethodCode(PrintWriter writer) {
        writer.print("     public void set" + MetaClassInfo.toClassName(this.m_name) + "(" + this.toJavaType() + " " + this.m_name + ") {\n");
        writer.print("         m_" + this.m_name + " = " + this.m_name + ";\n");
        writer.print("     }\n\n");
        writer.print("     public " + this.toJavaType() + " get" + MetaClassInfo.toClassName(this.m_name) + "( ) {\n");
        writer.print("         return m_" + this.m_name + ";\n");
        writer.print("     }\n\n");
    }

    String toJavaType() {
        if (this.m_isCollection) {
            return "List";
        }
        if (this.m_type.equals("int") || this.m_type.equals("short") || this.m_type.equals("byte") || this.m_type.equals("long") || this.m_type.equals("Wwn")) {
            return this.m_type;
        }
        return MetaClassInfo.toClassName(this.m_type);
    }

    String toElementType() {
        return MetaClassInfo.toClassName(this.m_type);
    }
}

