/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.dmm;

import com.cisco.dcbu.sm.server.dmm.MetaAttributeInfo;
import com.cisco.dcbu.sm.server.dmm.MetaClassInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SshMediatorMeta {
    static Logger _Logger = LogManager.getLogger((String)"dmm");
    private static SshMediatorMeta s_instance = null;
    Map m_metaTable = new HashMap();

    public static void main(String[] args) {
        SshMediatorMeta meta = new SshMediatorMeta();
        meta.generateFiles();
    }

    private SshMediatorMeta() {
        String dmmConfigFile = "com/cisco/dcbu/sm/server/dmm/dmm.xml";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(Thread.currentThread().getContextClassLoader().getResourceAsStream(dmmConfigFile));
            NodeList list = document.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(0);
                if (!node.getNodeName().equals("Mediator")) continue;
                NodeList medList = node.getChildNodes();
                for (int j = 0; j < medList.getLength(); ++j) {
                    if (!medList.item(j).getNodeName().equals("SSH")) continue;
                    this.processSSHNode(medList.item(j));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            _Logger.debug((Object)("cannot load " + dmmConfigFile));
        }
    }

    private void processSSHNode(Node node) {
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!list.item(i).getNodeName().equals("struct")) continue;
            this.processSSHStructNode((Element)list.item(i));
        }
    }

    private void generateFiles() {
        Collection keys = this.m_metaTable.values();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            ((MetaClassInfo)iter.next()).generateJavaFile();
        }
    }

    private void processSSHStructNode(Element node) {
        String structName = node.getAttribute("name");
        MetaClassInfo classInfo = new MetaClassInfo(structName);
        if (this.m_metaTable.get(structName) != null) {
            System.err.println(" duplicate declaration for:" + structName);
        }
        this.m_metaTable.put(structName, classInfo);
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!list.item(i).getNodeName().equals("attr")) continue;
            Element attrNode = (Element)list.item(i);
            MetaAttributeInfo attr = new MetaAttributeInfo(attrNode.getFirstChild().getNodeValue(), attrNode.getAttribute("type"), attrNode.getAttribute("length"), attrNode.getAttribute("collection"), attrNode.getAttribute("source"), attrNode.getAttribute("custom"), attrNode.getAttribute("transient"));
            classInfo.addAttribute(attr);
        }
        System.out.println(structName);
    }

    public synchronized SshMediatorMeta getInstance() {
        if (s_instance == null) {
            s_instance = new SshMediatorMeta();
        }
        return s_instance;
    }
}

