/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.dmm.pdu;

import com.cisco.dcbu.sm.server.dmm.SshMediatorHelper;
import com.cisco.dcbu.sm.server.dmm.SshMediatorReqPdu;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmPduHdr;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DmmJobSessionQueryReq
implements SshMediatorReqPdu {
    private DmmPduHdr m_pdu_hdr;
    private short m_attr_bit_map;
    private long m_job_id;
    private int m_num_sessions;

    @Override
    public void setPduHdr(DmmPduHdr pdu_hdr) {
        this.m_pdu_hdr = pdu_hdr;
    }

    @Override
    public DmmPduHdr getPduHdr() {
        return this.m_pdu_hdr;
    }

    public void setAttrBitMap(short attr_bit_map) {
        this.m_attr_bit_map = attr_bit_map;
    }

    public short getAttrBitMap() {
        return this.m_attr_bit_map;
    }

    public void setJobId(long job_id) {
        this.m_job_id = job_id;
    }

    public long getJobId() {
        return this.m_job_id;
    }

    public void setNumSessions(int num_sessions) {
        this.m_num_sessions = num_sessions;
    }

    public int getNumSessions() {
        return this.m_num_sessions;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteBuffer stream = ByteBuffer.allocate(10000);
        SshMediatorHelper.writeByteArray(stream, this.m_pdu_hdr.toByteArray());
        SshMediatorHelper.writeShort(stream, this.m_attr_bit_map, 2);
        SshMediatorHelper.writeLong(stream, this.m_job_id, 8);
        SshMediatorHelper.writeInt(stream, this.m_num_sessions, 4);
        int pos = stream.position();
        stream.rewind();
        byte[] ret = new byte[pos];
        stream.get(ret, 0, pos);
        return ret;
    }

    @Override
    public void fromByteArray(ByteBuffer stream) throws IOException {
        this.m_pdu_hdr = new DmmPduHdr();
        this.m_pdu_hdr.fromByteArray(stream);
        this.m_attr_bit_map = SshMediatorHelper.readShort(stream, 2);
        this.m_job_id = SshMediatorHelper.readLong(stream, 8);
        this.m_num_sessions = SshMediatorHelper.readInt(stream, 4);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("(DmmJobSessionQueryReq:");
        buf.append("m_attr_bit_map:" + this.m_attr_bit_map + ":");
        buf.append("m_job_id:" + this.m_job_id + ":");
        buf.append("m_num_sessions:" + this.m_num_sessions + ":");
        buf.append(")");
        return buf.toString();
    }
}

