/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.dmm.pdu;

import com.cisco.dcbu.sm.server.dmm.SshMediatorHelper;
import com.cisco.dcbu.sm.server.dmm.SshMediatorPdu;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmPduHdr;
import com.cisco.dcbu.sm.server.dmm.pdu.DmmViAttr;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DmmShowViListResp
implements SshMediatorPdu {
    private DmmPduHdr m_pdu_hdr;
    private byte m_num_dpps;
    private int m_rsvd;
    private List m_vi_list;

    public void setPduHdr(DmmPduHdr pdu_hdr) {
        this.m_pdu_hdr = pdu_hdr;
    }

    public DmmPduHdr getPduHdr() {
        return this.m_pdu_hdr;
    }

    public void setNumDpps(byte num_dpps) {
        this.m_num_dpps = num_dpps;
    }

    public byte getNumDpps() {
        return this.m_num_dpps;
    }

    public void setRsvd(int rsvd) {
        this.m_rsvd = rsvd;
    }

    public int getRsvd() {
        return this.m_rsvd;
    }

    public void setViList(List vi_list) {
        this.m_vi_list = vi_list;
    }

    public List getViList() {
        return this.m_vi_list;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteBuffer stream = ByteBuffer.allocate(10000);
        SshMediatorHelper.writeByteArray(stream, this.m_pdu_hdr.toByteArray());
        SshMediatorHelper.writeByte(stream, this.m_num_dpps, 1);
        SshMediatorHelper.writeInt(stream, this.m_rsvd, 3);
        for (int i = 0; i < this.m_vi_list.size(); ++i) {
            DmmViAttr obj = (DmmViAttr)this.m_vi_list.get(i);
            SshMediatorHelper.writeByteArray(stream, obj.toByteArray());
        }
        int pos = stream.position();
        stream.rewind();
        byte[] ret = new byte[pos];
        stream.get(ret, 0, pos);
        return ret;
    }

    @Override
    public void fromByteArray(ByteBuffer stream) throws IOException {
        this.m_pdu_hdr = new DmmPduHdr();
        this.m_pdu_hdr.fromByteArray(stream);
        this.m_num_dpps = SshMediatorHelper.readByte(stream, 1);
        this.m_rsvd = SshMediatorHelper.readInt(stream, 3);
        this.m_vi_list = new ArrayList();
        for (int i = 0; i < this.m_num_dpps; ++i) {
            DmmViAttr obj = new DmmViAttr();
            obj.fromByteArray(stream);
            this.m_vi_list.add(obj);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("(DmmShowViListResp:");
        buf.append("m_num_dpps:" + this.m_num_dpps + ":");
        buf.append("m_rsvd:" + this.m_rsvd + ":");
        buf.append("m_vi_list:");
        for (int i = 0; i < this.m_vi_list.size(); ++i) {
            buf.append(":" + this.m_vi_list.get(i));
        }
        buf.append(")");
        return buf.toString();
    }
}

