/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.em;

import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.sm.server.em.Consumer;
import com.cisco.dcbu.sm.server.em.EventManagerService;
import com.cisco.dcbu.sm.server.em.EventThread;
import java.util.LinkedList;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

abstract class AbstractReceiver
implements Runnable {
    protected final String _name;
    protected final int _type;
    protected LinkedList<Object> _queue = new LinkedList();
    protected EventThread _thread;
    protected Thread _processThread;
    protected Object _lock = new Object();
    protected int _throttlePoint;
    protected boolean _throttle;
    protected long _processed;
    protected long _totalProcTime;
    protected Consumer[] _consumers;
    boolean tplogged = false;
    static Logger _Logger = LogManager.getLogger((String)"fms.em");

    AbstractReceiver(String name, int type) throws Exception {
        this._name = name;
        this._type = type;
        this._thread = new EventThread(this, this._name + "Handler");
    }

    String getName() {
        return this._name;
    }

    void enableThrottle(boolean b) {
        this._throttle = b;
    }

    boolean isThrottleEnabled() {
        return this._throttle;
    }

    int getThrottlePoint() {
        return this._throttlePoint;
    }

    void setThrottlePoint(int t) {
        this._throttlePoint = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        _Logger.info((Object)(this._name + " started"));
        while (this._thread.isRunning()) {
            LinkedList<Object> linkedList;
            while (this._thread.isRunning() && this._queue.size() == 0) {
                linkedList = this._queue;
                synchronized (linkedList) {
                    if (this._queue.size() == 0) {
                        try {
                            this._queue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this._thread.isRunning() && this._processThread == null) {
                this._processThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (AbstractReceiver.this._thread.isRunning()) {
                            Object event;
                            LinkedList<Object> linkedList;
                            long currTime = System.currentTimeMillis();
                            while (AbstractReceiver.this._thread.isRunning() && AbstractReceiver.this._queue.size() == 0) {
                                linkedList = AbstractReceiver.this._queue;
                                synchronized (linkedList) {
                                    try {
                                        AbstractReceiver.this._queue.wait();
                                    }
                                    catch (InterruptedException ex1) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (!AbstractReceiver.this._thread.isRunning()) continue;
                            linkedList = AbstractReceiver.this._queue;
                            synchronized (linkedList) {
                                event = AbstractReceiver.this._queue.removeFirst();
                                AbstractReceiver.this._queue.notifyAll();
                            }
                            Object nevent = AbstractReceiver.this.normalize(event);
                            Object object = AbstractReceiver.this._lock;
                            synchronized (object) {
                                if (nevent != null && AbstractReceiver.this._consumers != null) {
                                    for (int i = 0; i < AbstractReceiver.this._consumers.length; ++i) {
                                        Consumer consumer = AbstractReceiver.this._consumers[i];
                                        if (!consumer.accept(nevent)) continue;
                                        try {
                                            consumer.consume(null, nevent);
                                            continue;
                                        }
                                        catch (Exception ex) {
                                            _Logger.log((Priority)Level.WARN, (Object)"Consumer error", (Throwable)ex);
                                        }
                                    }
                                }
                                AbstractReceiver.this._lock.notifyAll();
                            }
                            AbstractReceiver.this._totalProcTime += System.currentTimeMillis() - currTime;
                        }
                    }
                };
                this._processThread.start();
            }
            linkedList = this._queue;
            synchronized (linkedList) {
                if (this._queue.size() > 0) {
                    this._queue.notifyAll();
                }
            }
        }
        _Logger.info((Object)"End Handler");
    }

    void start() {
        this._thread.start();
    }

    void stop() {
        this.stopInput();
        this.flushQueue();
        this.stopThreads();
    }

    void stopInput() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushQueue() {
        while (this._queue.size() > 0) {
            LinkedList<Object> linkedList = this._queue;
            synchronized (linkedList) {
                if (this._queue.size() > 0) {
                    try {
                        this._queue.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopThreads() {
        this._thread.shut();
        LinkedList<Object> linkedList = this._queue;
        synchronized (linkedList) {
            this._queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(Object event) {
        LinkedList<Object> linkedList = this._queue;
        synchronized (linkedList) {
            while (this.isThrottleEnabled() && this._queue.size() == this.getThrottlePoint()) {
                try {
                    if (!this.tplogged) {
                        _Logger.warn((Object)("Reached throttle point and processed: " + this._processed));
                        this.tplogged = true;
                    }
                    this._queue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this._queue.add(event);
            this._queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reload() {
        Object object = this._lock;
        synchronized (object) {
            this.loadConfig();
            this._lock.notifyAll();
        }
    }

    void loadConfig() {
        this._consumers = ((EventManagerService)ServiceConfig.findService("Event Manager Service")).getConsumers(this._type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reload(EventManagerService emService) {
        Object object = this._lock;
        synchronized (object) {
            this.loadConfig(emService);
            this._lock.notifyAll();
        }
    }

    void loadConfig(EventManagerService emService) {
        this._consumers = emService.getConsumers(this._type);
    }

    Object normalize(Object event) {
        ++this._processed;
        return event;
    }

    public String toString() {
        return new StringBuffer(this.getName()).append(" ").append(this._processed).append(" processed, ").append(this._processed != 0L ? this._totalProcTime / this._processed : 0L).append(" ms avg time\n").toString();
    }

    public String toHtml() {
        return new StringBuffer(this.getName()).append("<br>").append(this._processed).append(" processed, ").append(this._processed != 0L ? this._totalProcTime / this._processed : 0L).append(" ms avg time<br>").toString();
    }
}

