/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.esp;

import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.dto.QueueResponseBaseModelObject;
import com.cisco.dcbu.sm.common.dto.SecurityAssociationDto;
import com.cisco.dcbu.sm.common.event.CommunicationObjectSender;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.server.esp.BaseRunnable;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.security.FMUser;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SASetRunnable
extends BaseRunnable {
    static Logger _logger = LogManager.getLogger((String)"fms.esp");
    protected Map<SwitchBase, List<SecurityAssociationDto>> _swSa;

    public SASetRunnable(long requestId, FMUser user, Map<SwitchBase, List<SecurityAssociationDto>> swSa, CommunicationObjectSender sender) {
        super(requestId, user, sender);
        this._swSa = swSa;
    }

    @Override
    public void run() {
        Set<SwitchBase> switches = this._swSa.keySet();
        boolean errored = false;
        for (SwitchBase nextSw : switches) {
            try {
                QueueResponseBaseModelObject result;
                if (!errored) {
                    result = new QueueResponseBaseModelObject(this._requestId, nextSw, nextSw, 3, "In Progress", null);
                    this._sender.send(result);
                    this.setFcspSA(nextSw, this._swSa.get(nextSw));
                    result = new QueueResponseBaseModelObject(this._requestId, nextSw, nextSw, 1, "Successful", null);
                    this._sender.send(result);
                    continue;
                }
                result = new QueueResponseBaseModelObject(this._requestId, nextSw, nextSw, 4, null, new Exception("This action was aborted because the setting of SA on another switch failed."));
                this._sender.send(result);
            }
            catch (RemoteException re) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Unable to set SA config for switch:" + nextSw.toString() + " received error: " + re.getMessage()));
                }
                QueueResponseBaseModelObject result = new QueueResponseBaseModelObject(this._requestId, nextSw, nextSw, 4, null, re);
                this._sender.send(result);
                errored = true;
            }
        }
    }

    private void setFcspSA(SwitchBase sw, List<SecurityAssociationDto> sa) throws RemoteException {
        SanManager sanMan = SanManager.getInstance();
        SwitchImpl swImpl = sanMan.findSwitch(sw.getWwn(), sw.getFabricPK());
        try {
            SnmpPeer peer = this.getPeer(swImpl);
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
            pdu.setIgnoreSetCount(true);
            pdu.setRetries(0);
            for (SecurityAssociationDto nextDto : sa) {
                int spi = nextDto.getSpi();
                pdu.addVar(new SnmpOID(_CfcspSARowStatusOid, spi), CREATE_AND_GO);
                pdu.addVar(new SnmpOID(_CfcspSaltOid, spi), new SnmpUnsignedInt(nextDto.getSalt()));
                String key = nextDto.getKey();
                byte[] keyBytes = SnmpString.fromHexString(key, false);
                pdu.addVar(new SnmpOID(_CfcspKeyOid, spi), new SnmpString(keyBytes));
            }
            peer.set(pdu);
        }
        catch (Exception ex) {
            RemoteException exc = new RemoteException("Unable to set Security Associations for switch " + sw + ": received error (" + ex.getMessage() + ") ");
            exc.setStackTrace(ex.getStackTrace());
            throw exc;
        }
    }
}

