/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.event;

import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.event.DiscoveryEvent;
import com.cisco.dcbu.sm.common.event.InventoryChangeEvent;
import com.cisco.dcbu.sm.common.event.LogEvent;
import com.cisco.dcbu.sm.common.event.ModelEvent;
import com.cisco.dcbu.sm.common.event.ModelEventType;
import com.cisco.dcbu.sm.common.event.MovedModelObject;
import com.cisco.dcbu.sm.common.event.ServerEvent;
import com.cisco.dcbu.sm.common.event.SessionEvent;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.FabricBase;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.HwInventoryComponent;
import com.cisco.dcbu.sm.common.model.InventoryComponent;
import com.cisco.dcbu.sm.common.model.IslBase;
import com.cisco.dcbu.sm.common.model.NpvLinkBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.IslPK;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.VsanFcIdKey;
import com.cisco.dcbu.sm.common.type.VsanFportKey;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.discovery.DiscoveryEventListenerIf;
import com.cisco.dcbu.sm.server.discovery.DiscoveryManager;
import com.cisco.dcbu.sm.server.event.SimpleEventForwarder;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import com.cisco.dcbu.sm.server.facade.FMSessionManager;
import com.cisco.dcbu.sm.server.facade.SessionEventListenerIf;
import com.cisco.dcbu.sm.server.inventory.InventoryEventListenerIf;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.CdpSeedImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.ModelEventListenerIf;
import com.cisco.dcbu.sm.server.model.SanManager;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketException;
import java.util.Arrays;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class EventForwarder
implements ModelEventListenerIf,
SessionEventListenerIf,
DiscoveryEventListenerIf,
InventoryEventListenerIf,
ExceptionListener {
    private static final String FABRIC_MANAGER_STAND_ALONE_EVENT_CHANNEL = "FabricManagerStandAloneEventChannel";
    private static final String TOPIC_FM = "topic/fmsTopic";
    private static final String FM_STANDALONE = "fm.standalone";
    private static volatile EventForwarder _Instance;
    private static boolean _standAloneNoJMS;
    static Logger _Logger;
    static Logger _SELogger;
    static Logger _MELogger;
    static Logger _DELogger;
    static Logger _LELogger;
    private List _sessionListCopy;
    private Connection _conn = null;
    private Session _session = null;
    private Topic _topic = null;
    private MessageProducer _sender = null;
    private boolean _isShuttingDown = false;

    EventForwarder() {
        FMServerImpl.getInstance().addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EventForwarder getInstance() {
        if (_Instance == null) {
            Logger logger = _Logger;
            synchronized (logger) {
                if (_Instance == null) {
                    if (System.getProperty(FM_STANDALONE) != null && "true".equalsIgnoreCase(System.getProperty(FM_STANDALONE))) {
                        _standAloneNoJMS = true;
                        _Instance = new SimpleEventForwarder();
                    } else {
                        _Instance = new EventForwarder();
                        try {
                            _Instance.setupPubSub();
                        }
                        catch (JMSException jex) {
                            _Logger.log((Priority)Level.ERROR, (Object)"JMSEventForwarder setupPubSub", (Throwable)jex);
                        }
                        catch (NamingException ex) {
                            _Logger.log((Priority)Level.ERROR, (Object)"JMSEventForwarder.setupPubSub ", (Throwable)ex);
                        }
                    }
                    SanManager.addListener(_Instance);
                    DCManager.getInstance().addListener(_Instance);
                    InventoryManager.getInstance().addEventListener(_Instance);
                    DiscoveryManager.getInstance().addListener(_Instance);
                }
            }
        }
        return _Instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException ex) {
        if (this._isShuttingDown) {
            return;
        }
        _Logger.error((Object)"onException(): EventForward receive JMS Exception", (Throwable)ex);
        if (ex instanceof IllegalStateException || ex.getCause() instanceof SocketException || ex.getCause() instanceof IOException || ex.getCause() instanceof EOFException) {
            EventForwarder eventForwarder = this;
            synchronized (eventForwarder) {
                this.disconnect();
                try {
                    this.setupPubSub();
                }
                catch (Exception jex) {
                    _Logger.error((Object)"EventForward Re-establish connection", (Throwable)jex);
                }
            }
        }
    }

    public void stop() {
        this._isShuttingDown = true;
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() {
        try {
            if (this._session != null) {
                this._session.close();
            }
        }
        catch (Throwable t) {
            _Logger.debug((Object)t.getMessage());
        }
        try {
            if (this._conn != null) {
                this._conn.close();
            }
        }
        catch (Throwable t) {
            _Logger.debug((Object)t.getMessage());
        }
        finally {
            this._topic = null;
            this._session = null;
            this._conn = null;
        }
    }

    public synchronized void setupPubSub() throws JMSException, NamingException {
        try {
            InitialContext iniCtx = new InitialContext();
            Object tmp = iniCtx.lookup("/ConnectionFactory");
            ConnectionFactory tcf = (ConnectionFactory)tmp;
            this._conn = tcf.createConnection();
            this._topic = (Topic)iniCtx.lookup(TOPIC_FM);
            this._session = this._conn.createSession(false, 1);
            this._conn.start();
            this._sender = this._session.createProducer((Destination)this._topic);
            this._conn.setExceptionListener((ExceptionListener)this);
        }
        catch (NamingException ex) {
            _Logger.error((Object)("(jms/topic/fmsTopic)can not get initial context :" + ex.getMessage()));
        }
    }

    public String toString() {
        return "EventForwarder";
    }

    private boolean assertSession() {
        if (this._session == null) {
            try {
                this.setupPubSub();
            }
            catch (Exception ex) {
                _Logger.error((Object)"can not re-establish topic connection: ");
            }
        }
        return this._session != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void queue(Object evtObj) {
        if (!this.assertSession()) {
            _Logger.error((Object)"EventForwader.queue(): cannot send message, topic session is down");
            return;
        }
        try {
            if (evtObj == null) {
                return;
            }
            ObjectMessage obj = this._session.createObjectMessage();
            obj.setObject((Serializable)evtObj);
            if (evtObj instanceof DiscoveryEvent) {
                obj.setIntProperty("type", 1);
                obj.setIntProperty("discoveryType", ((DiscoveryEvent)evtObj).getType().value());
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)("Forward DiscoveryEvent:" + (DiscoveryEvent)evtObj));
                }
            } else if (evtObj instanceof ModelEvent) {
                if (((ModelEvent)evtObj).getType().isLanEvent()) {
                    obj.setIntProperty("type", 10);
                } else {
                    obj.setIntProperty("type", 2);
                    obj.setIntProperty("modelType", (int)((ModelEvent)evtObj).getType().value());
                    if (((ModelEvent)evtObj).getFabricPK() != null) {
                        obj.setLongProperty("fabric", (long)((ModelEvent)evtObj).getFabricPK().get_fid());
                    }
                    if (_Logger.isDebugEnabled()) {
                        _Logger.debug((Object)("Forward ModelEvent:" + EventForwarder.toString((ModelEvent)evtObj)));
                    }
                }
            } else if (evtObj instanceof LogEvent) {
                obj.setIntProperty("type", 3);
                obj.setLongProperty("fabric", (long)((FabricPK)((LogEvent)evtObj).getSource()).get_fid());
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)("Forward LogEvent:" + (LogEvent)evtObj));
                }
            } else if (evtObj instanceof InventoryChangeEvent) {
                obj.setIntProperty("type", 4);
                InventoryComponent comp = ((InventoryChangeEvent)evtObj).getEntity();
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)("Forward InventoryEvent:" + (InventoryChangeEvent)evtObj));
                }
                if (comp == null) {
                    return;
                }
                if (!(comp instanceof HwInventoryComponent)) return;
                Object swPK = ((HwInventoryComponent)comp).getSwitchPK();
                if (swPK instanceof WwnKey) {
                    FabricPK[] pks = SanManager.getInstance().getFabricPKs();
                    FabricImpl fabric = null;
                    Boolean found = false;
                    for (FabricPK fKey : pks) {
                        fabric = SanManager.getInstance().findFabricBySwitchPK((WwnKey)swPK, fKey);
                        if (fabric == null) continue;
                        obj.setLongProperty("fabric", (long)fabric.getPK().get_fid());
                        found = true;
                    }
                    if (!found.booleanValue()) {
                        return;
                    }
                } else if (swPK instanceof SerialNumKey) {
                    LanImpl lan = DCManager.getInstance().getLan();
                    if (lan == null) return;
                    obj.setLongProperty("lan", (long)lan.getPK().getId());
                }
            } else if (evtObj instanceof ServerEvent) {
                obj.setIntProperty("type", 5);
                obj.setIntProperty("serverType", ((ServerEvent)evtObj).getType());
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)("Forward serverEvent:" + (ServerEvent)evtObj));
                }
            } else if (evtObj instanceof SessionEvent) {
                obj.setIntProperty("type", 6);
                obj.setStringProperty("sessionId", ((SessionEvent)evtObj).getSessionID());
                obj.setIntProperty("sessionType", ((SessionEvent)evtObj).getType());
                if (_Logger.isDebugEnabled()) {
                    _Logger.warn((Object)("Forward sessionEvent:" + (SessionEvent)evtObj));
                }
            } else if (_Logger.isDebugEnabled()) {
                _Logger.warn((Object)("Forward unknow Event:" + evtObj));
            }
            this._sender.send((Message)obj);
            return;
        }
        catch (JMSException ex) {
            _Logger.error((Object)("EventForwader.queue(): cannot send message. " + ex.getMessage()));
            this.onException(ex);
        }
    }

    @Override
    public void fabricDiscovered(FabricImpl fabric) {
    }

    @Override
    public void fabricOpened(FabricImpl fImpl) {
        this.queue(new ModelEvent(fImpl.getPK(), ModelEventType.FABRIC_OPENED, null));
    }

    @Override
    public void fabricRemoved(FabricImpl fabric) {
    }

    @Override
    public void fabricClosed(FabricImpl fImpl) {
        this.queue(new ModelEvent(fImpl.getPK(), ModelEventType.FABRIC_CLOSED, null));
    }

    @Override
    public void fabricClosed(FabricPK fpk) {
        this.queue(new ModelEvent(fpk, ModelEventType.FABRIC_CLOSED, null));
    }

    @Override
    public void fabricMerged(FabricImpl mergerFabric, FabricPK mergeePK) {
        Object[] pkeys = new FabricPK[]{mergerFabric.getPK(), mergeePK};
        this.queue(new ModelEvent(mergerFabric.getPK(), ModelEventType.FABRIC_MERGED, pkeys));
        this.queue(new ModelEvent(mergeePK, ModelEventType.FABRIC_MERGED, pkeys));
    }

    @Override
    public void fabricSplit(FabricImpl origFabric, FabricImpl newFabric) {
        this.queue(new ModelEvent(origFabric.getPK(), ModelEventType.FABRIC_SPLIT, (Object[])new FabricPK[]{origFabric.getPK(), newFabric.getPK()}));
    }

    @Override
    public void fabricRediscovered(FabricImpl fabric) {
    }

    @Override
    public void fabricEmptied(FabricImpl fabric) {
        this.queue(new ModelEvent(fabric.getPK(), ModelEventType.FABRIC_EMPTIED, null));
    }

    @Override
    public void membersAdded(FabricImpl fImpl, AbstractModelObjectImpl[] mos) {
        _Logger.trace((Object)"queuing member added event");
        BaseModelObject[] bmos = new BaseModelObject[mos.length];
        for (int i = 0; i < mos.length; ++i) {
            bmos[i] = mos[i].getBaseObject();
        }
        this.queue(ModelEvent.createAddEvent(fImpl.getPK(), bmos));
    }

    @Override
    public void membersRemoved(FabricImpl fImpl, PKIf[] o) {
        _Logger.trace((Object)"queuing member removed event");
        this.queue(ModelEvent.createRemoveEvent(fImpl.getPK(), o));
    }

    @Override
    public void membersChanged(FabricImpl fImpl, ChangedModelObject[] o) {
        _Logger.trace((Object)"queuing member changed event");
        this.queue(ModelEvent.createChangeEvent(fImpl.getPK(), o));
    }

    @Override
    public void membersMoved(FabricImpl fImpl, MovedModelObject[] o) {
        _Logger.trace((Object)"queuing member moved event");
        this.queue(ModelEvent.createMoveEvent(fImpl.getPK(), o));
    }

    @Override
    public void memberPurged(FabricImpl fImpl, PKIf[] o) {
        _Logger.trace((Object)"queuing member purged event");
        this.queue(ModelEvent.createPurgedEvent(fImpl.getPK(), o));
    }

    @Override
    public void modelObjectCreated(AbstractModelObjectImpl mo) {
    }

    @Override
    public void modelObjectRemoved(AbstractModelObjectImpl mo) {
    }

    @Override
    public void dbObjectPurged(long dbid) {
    }

    @Override
    public void cdpSeedAdded(CdpSeedImpl cdpSeed) {
        if (cdpSeed == null) {
            return;
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(cdpSeed.getPK() + " queuing CDP seed added event"));
        }
        this.queue(new ModelEvent(cdpSeed.getLan().getPK(), ModelEventType.CDP_SEED_ADDED, null));
    }

    @Override
    public void cdpSeedRemoved(CdpSeedImpl cdpSeed) {
        if (cdpSeed == null || cdpSeed.getLan() == null) {
            return;
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(cdpSeed.getPK() + " queuing CDP seed removed event"));
        }
        this.queue(new ModelEvent(cdpSeed.getLan().getPK(), ModelEventType.CDP_SEED_REMOVED, null));
    }

    @Override
    public void lanOpened(LanImpl lan) {
        if (lan == null) {
            return;
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(lan.getPK() + " queuing lan opened event"));
        }
        this.queue(new ModelEvent(lan.getPK(), ModelEventType.LAN_OPENED, null));
    }

    @Override
    public void lanClosed(LanImpl lan) {
        if (lan == null) {
            return;
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(lan.getPK() + " queuing lan closed event"));
        }
        this.queue(new ModelEvent(lan.getPK(), ModelEventType.LAN_CLOSED, null));
    }

    @Override
    public void lanRemoved(CdpSeedImpl cdpSeed, LanImpl lan) {
        if (lan == null) {
            return;
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(lan.getPK() + " queuing lan removed event"));
        }
        this.queue(new ModelEvent(lan.getPK(), ModelEventType.LAN_REMOVED, null));
    }

    @Override
    public void lanDiscovered(LanImpl lan) {
    }

    @Override
    public void lanRediscovered(LanImpl lan) {
    }

    @Override
    public void membersAdded(LanImpl lan, AbstractModelObjectImpl[] mos) {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(lan.getPK() + " queuing lan member added event for " + Arrays.toString(mos)));
        }
        BaseModelObject[] bmos = new BaseModelObject[mos.length];
        for (int i = 0; i < mos.length; ++i) {
            bmos[i] = mos[i].getBaseObject();
        }
        this.queue(ModelEvent.createLanAddEvent(lan.getPK(), bmos));
    }

    @Override
    public void membersRemoved(LanImpl lan, PKIf[] pks) {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(lan.getPK() + " queuing lan member removed event for " + Arrays.toString(pks)));
        }
        this.queue(ModelEvent.createLanRemoveEvent(lan.getPK(), pks));
    }

    @Override
    public void membersChanged(LanImpl lan, ChangedModelObject[] mos) {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(lan.getPK() + " queuing lan member changed event for " + Arrays.toString(mos)));
        }
        this.queue(ModelEvent.createLanChangeEvent(lan.getPK(), mos));
    }

    @Override
    public void membersMoved(LanImpl lan, MovedModelObject[] mos) {
    }

    @Override
    public void memberPurged(LanImpl lan, PKIf[] pks) {
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)(lan.getPK() + " queuing lan member purged event for " + Arrays.toString(pks)));
        }
        this.queue(ModelEvent.createLanPurgedEvent(lan.getPK(), pks));
    }

    @Override
    public void discoveryEventReceived(DiscoveryEvent event) {
        this.queue(event);
    }

    @Override
    public void sessionOpened(String sessionId) {
        this._sessionListCopy = FMSessionManager.getInstance().getSessions();
    }

    @Override
    public void sessionClosed(String sessionId) {
        this._sessionListCopy = FMSessionManager.getInstance().getSessions();
        this.queue(new SessionEvent(sessionId, 2, "Session Closed"));
    }

    @Override
    public void inventoryEntityChanged(InventoryChangeEvent event) {
        this.queue(event);
    }

    static String toString(ModelEvent event) {
        StringBuffer sb;
        block39: {
            ChangedModelObject[] o;
            block40: {
                block38: {
                    sb = new StringBuffer();
                    if (event != null && event.getFabricPK() != null) {
                        sb.append(event.getFabricPK().toString()).append(", ").append(event.getType());
                    }
                    if (event.getType() != ModelEventType.ADDED) break block38;
                    BaseModelObject[] o2 = event.getAddedObjects();
                    if (o2 == null) break block39;
                    for (int i = 0; i < o2.length; ++i) {
                        sb.append("\n\t").append(o2[i]);
                    }
                    break block39;
                }
                if (event.getType() != ModelEventType.PURGED && event.getType() != ModelEventType.REMOVED) break block40;
                PKIf[] o3 = event.getRemovedObjects();
                if (o3 == null) break block39;
                for (int i = 0; i < o3.length; ++i) {
                    sb.append("\n\t");
                    if (o3[i] instanceof NameKey) {
                        sb.append("enclosure");
                    } else if (o3[i] instanceof WwnKey) {
                        sb.append("NxPort/switch");
                    } else if (o3[i] instanceof IslPK) {
                        sb.append("ISL");
                    } else if (o3[i] instanceof VsanPK) {
                        sb.append("VSAN");
                    }
                    sb.append(" ").append(o3[i]);
                }
                break block39;
            }
            if (event.getType() == ModelEventType.CHANGED && (o = event.getChangedObjects()) != null) {
                for (int i = 0; i < o.length; ++i) {
                    sb.append("\n\t");
                    PKIf pkey = o[i].getPK();
                    short propId = o[i]._propId;
                    String[] attrNames = null;
                    switch (propId & 0xFF00) {
                        case 512: {
                            sb.append("Fabric ");
                            attrNames = FabricBase._Attrs;
                            break;
                        }
                        case 1536: {
                            sb.append("NxPort ");
                            attrNames = EndPortBase._Attrs;
                            break;
                        }
                        case 1024: {
                            sb.append("Switch ");
                            attrNames = SwitchBase._Attrs;
                            break;
                        }
                        case 1280: {
                            sb.append("ISL ");
                            attrNames = IslBase._Attrs;
                            break;
                        }
                        case 768: {
                            sb.append("VSAN ");
                            attrNames = VsanBase._Attrs;
                            break;
                        }
                        case 1792: {
                            sb.append("Enclosure ");
                            attrNames = EnclosureBase._Attrs;
                            break;
                        }
                        case 2048: {
                            sb.append("Port ");
                            attrNames = FcPortBase._Attrs;
                            break;
                        }
                        case 3072: {
                            sb.append("NpvLink ");
                            attrNames = NpvLinkBase._Attrs;
                        }
                    }
                    sb.append(pkey).append(" ");
                    if (attrNames != null) {
                        sb.append(attrNames[(o[i]._propId & 0xFF) - 1]);
                    } else {
                        sb.append("unknown attribute ").append(o[i]._propId);
                    }
                    Object[] values = new Object[]{o[i].getOldValue(), o[i].getNewValue()};
                    block20: for (int j = 0; j < 2; ++j) {
                        sb.append(j == 0 ? ": " : " ==> ");
                        if (values[j] == null) {
                            sb.append("none");
                            continue;
                        }
                        VsanFcIdKey[] vfkeys = null;
                        VsanFportKey[] vfports = null;
                        switch (propId) {
                            case 1287: {
                                List children = (List)values[j];
                                for (int k = 0; k < children.size(); ++k) {
                                    sb.append(" ").append(children.get(k));
                                }
                                continue block20;
                            }
                            case 1544: {
                                if (values[j] != null) {
                                    vfkeys = (VsanFcIdKey[])values[j];
                                    for (int k = 0; k < vfkeys.length; ++k) {
                                        sb.append(" ").append(vfkeys[k]);
                                    }
                                    continue block20;
                                }
                                sb.append("null");
                                continue block20;
                            }
                            case 1555: {
                                if (values[j] != null) {
                                    vfports = (VsanFportKey[])values[j];
                                    for (int k = 0; k < vfports.length; ++k) {
                                        sb.append(" ").append(vfports[k]);
                                    }
                                    continue block20;
                                }
                                sb.append("null");
                                continue block20;
                            }
                            case 1284: 
                            case 3076: {
                                List vids = (List)values[j];
                                sb.append(StringUtil.getRangeString(vids));
                                continue block20;
                            }
                            case 1539: {
                                byte[] wwn = (byte[])values[j];
                                sb.append(SnmpString.toHexString(wwn));
                                continue block20;
                            }
                            default: {
                                sb.append(values[j].toString());
                            }
                        }
                    }
                }
            }
        }
        return sb.toString();
    }

    static {
        _standAloneNoJMS = false;
        _Logger = LogManager.getLogger((String)"fms.event");
        _SELogger = LogManager.getLogger((String)"fms.event.server");
        _MELogger = LogManager.getLogger((String)"fms.event.model");
        _DELogger = LogManager.getLogger((String)"fms.event.disc");
        _LELogger = LogManager.getLogger((String)"fms.event.log");
    }
}

