/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.event;

import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.lib.serviceconf.AbstractService;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.sm.common.dto.VsanDomain;
import com.cisco.dcbu.sm.common.event.ChangedModelObject;
import com.cisco.dcbu.sm.common.event.LogEvent;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.MovedModelObject;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.event.SyslogEntry;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.IslPK;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.em.AlertNotifier;
import com.cisco.dcbu.sm.server.event.EventBuilder;
import com.cisco.dcbu.sm.server.event.EventControllerService;
import com.cisco.dcbu.sm.server.event.EventFormatType;
import com.cisco.dcbu.sm.server.event.EventForwarder;
import com.cisco.dcbu.sm.server.event.SMISNotifications;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.CdpSeedImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.FcPortImpl;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.ModelEventListenerIf;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.sm.server.web.util.AppGroupUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class EventLoggerService
extends AbstractService
implements ModelEventListenerIf {
    static final String EVENT_PATTERN = "event.pattern";
    static final String EVENT_LIMIT = "event.limit";
    static final String EVENT_COUNT = "event.count";
    static final String EVENT_APPEND = "event.append";
    static final String EVENT_ALL_LOG = "events.log.all";
    static Logger _Logger = LogManager.getLogger((String)"fms.em");
    private AlertNotifier _efh;
    private EventForwarder _efd;

    public EventLoggerService() {
        this.setName("Event Logger Service");
        this._efh = AlertNotifier.getInstance();
        this._efd = EventForwarder.getInstance();
        SanManager.addListener(this, true);
        DCManager.getInstance().addListener(this);
    }

    public void logEvent(LogEvent event) {
        try {
            this._efd.queue(event);
        }
        catch (Exception ex) {
            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        try {
            ((EventControllerService)ServiceConfig.findService("Event Controller Service")).publishEvent(event);
        }
        catch (Exception ex) {
            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        try {
            this._efh.forwardEvent(event);
        }
        catch (Exception ex) {
            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void dispatchEvent(LogEvent event) {
        if (Boolean.getBoolean(EVENT_ALL_LOG)) {
            this.logEvent(event);
        }
    }

    public void logAccounting(SyslogEntry se) {
        ((EventControllerService)ServiceConfig.findService("Event Controller Service")).publishAccounting(se);
    }

    @Override
    public void fabricOpened(FabricImpl fImpl) {
    }

    @Override
    public void fabricDiscovered(FabricImpl fImpl) {
        if (fImpl == null) {
            return;
        }
        if (fImpl.getSeed() != null) {
            String username = fImpl.getFmUser();
            InetAddress clientIp = null;
            try {
                clientIp = fImpl.getClientIp() != null ? InetAddress.getByName(fImpl.getClientIp()) : InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                _Logger.debug((Object)("Failed to get client IP address '" + fImpl.getClientIp() + ". " + e.getMessage()));
            }
            if (username != null && !username.trim().equals("")) {
                SyslogEntry se = new SyslogEntry(fImpl.getPK(), clientIp, fImpl.getDBID(), "DCNM-SAN", LogEventType.FABRIC.toString(), username, "Fabric '" + fImpl.getPK().toString() + "' discovered", Severity.INFO.getValue(), 0);
                this.logAccounting(se);
            }
        }
    }

    @Override
    public void fabricRemoved(FabricImpl fImpl) {
    }

    @Override
    public void fabricClosed(FabricPK fpk) {
    }

    @Override
    public void fabricClosed(FabricImpl fImpl) {
    }

    @Override
    public void fabricRediscovered(FabricImpl fImpl) {
    }

    @Override
    public void fabricEmptied(FabricImpl fabric) {
    }

    @Override
    public void fabricMerged(FabricImpl mergerFabric, FabricPK mergeePK) {
    }

    @Override
    public void fabricSplit(FabricImpl origFabric, FabricImpl newFabric) {
    }

    @Override
    public void membersAdded(FabricImpl fImpl, AbstractModelObjectImpl[] o) {
        for (int i = 0; i < o.length; ++i) {
            Severity severity;
            long srcId;
            String enclosure;
            WwnKey switchPK;
            LogEventType type;
            String descr;
            String source;
            long switchDbId;
            block27: {
                switchDbId = 0L;
                source = fImpl.getPK().toString();
                descr = null;
                type = null;
                switchPK = null;
                enclosure = null;
                srcId = 0L;
                if (o[i] instanceof VsanImpl) {
                    severity = Severity.INFO;
                    VsanImpl v = (VsanImpl)o[i];
                    switchDbId = v.getPrincipalSwitchId();
                    VsanImpl[] vsans = fImpl.findVsan(v.getId());
                    boolean segmented = false;
                    if (vsans != null) {
                        for (int j = 0; j < vsans.length; ++j) {
                            segmented = segmented || vsans[j].isPresent() && v != vsans[j];
                        }
                    }
                    if (!segmented) {
                        type = LogEventType.VSAN;
                    }
                    descr = "VSAN added: " + fImpl.getPK().toString() + "/VSAN" + v.getId();
                } else if (o[i] instanceof SwitchImpl) {
                    type = LogEventType.SWITCH_MANAGEABILITY;
                    severity = Severity.INFO;
                    SwitchImpl s = (SwitchImpl)o[i];
                    switchDbId = s.getDBID();
                    descr = "Switch added: " + s.getName();
                    switchPK = s.getSwitchPK();
                } else if (o[i] instanceof IslImpl) {
                    type = LogEventType.PORT_UP;
                    severity = Severity.INFO;
                    IslImpl isl = (IslImpl)o[i];
                    if (isl.getSwitch1() != null) {
                        switchDbId = isl.getSwitch1().getDBID();
                    }
                    try {
                        descr = isl.getEventDesc(LogEventType.PORT_UP);
                        PKIf pkey = isl.getPK();
                        if (((IslPK)pkey).getSwitchIntKey1() == null) break block27;
                        try {
                            srcId = FcPortImpl.getSwitchPort(switchDbId, ((IslPK)pkey).getSwitchIntKey1()._index);
                        }
                        catch (SQLException e) {
                        }
                    }
                    catch (Exception e) {
                        type = null;
                        _Logger.debug((Object)"Port up logging error: ", (Throwable)e);
                    }
                } else if (o[i] instanceof EndPortImpl) {
                    type = LogEventType.PORT_UP;
                    severity = Severity.INFO;
                    EndPortImpl ep = (EndPortImpl)o[i];
                    if (ep.getSwitch() != null) {
                        switchDbId = ep.getSwitch().getDBID();
                    }
                    try {
                        descr = ep.getEventDesc(LogEventType.PORT_UP);
                        srcId = ep.getIfDbId();
                    }
                    catch (Exception e) {
                        type = null;
                        _Logger.debug((Object)"Port up logging error: ", (Throwable)e);
                    }
                    if (ep.getEnclosure() != null) {
                        enclosure = ep.getEnclosure().getName();
                    }
                    if (SMISNotifications.isSmisEnable()) {
                        SMISNotifications.getInstance().SMISNotif(o[i], 0);
                    }
                } else if (o[i] instanceof EnclosureImpl) {
                    type = LogEventType.OTHER;
                    severity = Severity.INFO;
                    descr = descr + ", Enclosure Added";
                } else {
                    type = null;
                    severity = null;
                }
            }
            if (type == null) continue;
            LogEvent e = new LogEvent((Object)fImpl.getPK(), type, severity, source, descr, fImpl.getDBID(), switchDbId, switchPK);
            if (enclosure != null) {
                e.setEnclosure(enclosure);
            }
            e.setSrcId(srcId);
            if (srcId != 0L) {
                Set<Integer> pgIds = AppGroupUtil.getInstance().getPortGroupId(srcId, switchDbId, 3);
                e.set_pgGroupIds(pgIds);
            }
            if (type == LogEventType.PORT_UP) {
                this.dispatchEvent(e);
                continue;
            }
            this.logEvent(e);
        }
    }

    @Override
    public void membersRemoved(FabricImpl fImpl, PKIf[] o) {
        for (int i = 0; i < o.length; ++i) {
            Severity severity;
            LogEventType type = null;
            String source = fImpl.getPK().toString();
            String descr = null;
            String enclosure = null;
            long switchDbId = 0L;
            long srcId = 0L;
            WwnKey switchPK = null;
            if (o[i] instanceof VsanPK) {
                type = LogEventType.VSAN;
                severity = Severity.WARNING;
                short vsanId = ((VsanPK)o[i])._id;
                VsanImpl[] vsans = fImpl.findVsan(vsanId);
                boolean vsanRemoved = true;
                if (vsans != null) {
                    for (int j = 0; j < vsans.length; ++j) {
                        if (!vsans[j].isPresent()) continue;
                        vsanRemoved = false;
                        break;
                    }
                }
                if (!vsanRemoved) continue;
                VsanPK vsanpk = (VsanPK)o[i];
                VsanImpl vsan = fImpl.findVsan(vsanpk);
                if (vsan != null) {
                    switchDbId = vsan.getPrincipalSwitchId();
                }
                descr = "VSAN Unreachable: " + fImpl.getPK().toString() + "/VSAN" + ((VsanPK)o[i])._id;
            } else if (o[i] instanceof NameKey) {
                type = LogEventType.OTHER;
                severity = Severity.WARNING;
                descr = "Enclosure removed: " + o[i].toString();
                EnclosureImpl enc = SanManager.getInstance().findEnclosureByPK((NameKey)o[i]);
                if (enc != null) {
                    enclosure = enc.getEnclosureName();
                }
            } else if (o[i] instanceof WwnKey) {
                type = LogEventType.PORT_DOWN;
                severity = Severity.INFO;
                EndPortImpl ep = SanManager.getInstance().findEndPortByPK((WwnKey)o[i]);
                if (ep != null && ep.getSwitch() != null) {
                    switchDbId = ep.getSwitch().getDBID();
                    if (ep.getSwitchIntKey() != null) {
                        try {
                            srcId = FcPortImpl.getSwitchPort(switchDbId, ep.getSwitchIntKey()._index);
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    try {
                        descr = ep.getEventDesc(LogEventType.PORT_DOWN);
                    }
                    catch (Exception e) {
                        type = null;
                        _Logger.debug((Object)"Port down logging error: ", (Throwable)e);
                    }
                    if (SMISNotifications.isSmisEnable()) {
                        SMISNotifications.getInstance().SMISNotif(ep, 1);
                    }
                }
            } else {
                type = null;
                severity = null;
                descr = null;
            }
            if (type == null) continue;
            LogEvent e = new LogEvent((Object)fImpl.getPK(), type, severity, source, descr, fImpl.getDBID(), switchDbId, switchPK);
            if (enclosure != null && enclosure.length() == 0) {
                e.setEnclosure(enclosure);
            }
            e.setSrcId(srcId);
            if (srcId != 0L) {
                Set<Integer> pgIds = AppGroupUtil.getInstance().getPortGroupId(srcId, switchDbId, 3);
                e.set_pgGroupIds(pgIds);
            }
            this.logEvent(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void membersChanged(FabricImpl fImpl, ChangedModelObject[] o) {
        block48: for (i = 0; i < o.length; ++i) {
            if (o[i] == null) continue;
            type = null;
            severity = null;
            sb = new StringBuffer();
            pkey = o[i].getPK();
            propId = o[i]._propId;
            attrType = (short)(propId & 65280);
            switchDbId = 0L;
            source = fImpl.getPK().toString();
            switchPk = null;
            enclosure = null;
            srcId = 0L;
            switch (attrType) {
                case 768: {
                    sb.append(source).append("/").append("VSAN").append(((VsanPK)pkey)._id);
                    vsan = fImpl.findVsan((VsanPK)pkey);
                    if (vsan == null) ** GOTO lbl280
                    switchDbId = vsan.getPrincipalSwitchId();
                    switch (propId) {
                        case 772: {
                            if ((Byte)o[i].getNewValue() == null) break;
                            if ((Byte)o[i].getNewValue() == 1) {
                                type = LogEventType.VSAN;
                                severity = Severity.INFO;
                                sb.insert(0, " VSAN up: ");
                                break;
                            }
                            type = LogEventType.VSAN;
                            severity = Severity.WARNING;
                            sb.insert(0, " VSAN down: ");
                            break;
                        }
                        case 783: {
                            old = (String)o[i].getOldValue();
                            if (old != null && old.length() == 0) break;
                            zoneset = null;
                            zoneset = (String)o[i].getNewValue();
                            sb.append(" ");
                            if (zoneset == null) {
                                sb.append(o[i].getOldValue());
                                sb.append(" deactivated on ");
                                sb.append(new Date());
                                severity = Severity.WARNING;
                                break;
                            }
                            sb.append(zoneset).append(" activated on ");
                            time = vsan.getEnforcedZoneSetActivateTime();
                            sb.append(new Date(time));
                            severity = Severity.INFO;
                            break;
                        }
                        case 779: {
                            if (vsan == null) break;
                            severity = Severity.WARNING;
                            if (vsan.isSegmented()) {
                                type = LogEventType.VSAN;
                                sb.insert(0, "VSAN segmented: ");
                                break;
                            }
                            type = LogEventType.VSAN;
                            sb.insert(0, "VSAN merged: ");
                        }
                    }
                    ** GOTO lbl280
                }
                case 1024: {
                    sw = SanManager.getInstance().findSwitch((WwnKey)pkey, fImpl.getPK());
                    if (sw == null) continue block48;
                    switchDbId = sw.getDBID();
                    switchPk = sw.getSwitchPK();
                    sb.append(sw.getName()).append(" ");
                    switch (propId) {
                        case 1025: {
                            if ((Boolean)o[i].getNewValue() == null) break;
                            if (((Boolean)o[i].getNewValue()).booleanValue()) {
                                type = LogEventType.SWITCH_MANAGEABILITY;
                                severity = Severity.INFO;
                                sb.insert(0, "Switch discovered: ");
                                break;
                            }
                            type = LogEventType.SWITCH_MANAGEABILITY;
                            severity = Severity.WARNING;
                            sb.insert(0, "Switch Unreachable: ");
                            break;
                        }
                        case 1038: {
                            if ((Boolean)o[i].getNewValue() == null) break;
                            if (((Boolean)o[i].getNewValue()).booleanValue()) {
                                type = LogEventType.SWITCH_MANAGEABILITY;
                                severity = Severity.INFO;
                                sb.insert(0, "Switch manageable: ");
                                break;
                            }
                            type = LogEventType.SWITCH_MANAGEABILITY;
                            severity = Severity.WARNING;
                            sb.insert(0, "Switch Unmanageable: ");
                            break;
                        }
                        case 1041: {
                            type = LogEventType.SWITCH_MANAGEABILITY;
                            severity = Severity.WARNING;
                            sb.append("Switch IP changed: Management address old: ");
                            if (o[i].getOldValue() != null) {
                                sb.append(((InetAddress)o[i].getOldValue()).getHostAddress()).append(" ");
                            } else {
                                sb.append("none");
                            }
                            sb.append(" new: ");
                            if (o[i].getNewValue() != null) {
                                sb.append(((InetAddress)o[i].getNewValue()).getHostAddress()).append(" ");
                                break;
                            }
                            sb.append("none");
                            break;
                        }
                        case 1046: {
                            if (o[i].getOldValue() == null || o[i].getNewValue() == null) break;
                            display = false;
                            oldFlags = (boolean[])o[i].getOldValue();
                            blnResult = Arrays.equals(oldFlags, newFlags = (boolean[])o[i].getNewValue());
                            if (blnResult) ** GOTO lbl280
                            for (ii = 0; ii < SwitchBase.NUM_FEATURES; ++ii) {
                                if (oldFlags[ii] == newFlags[ii]) continue;
                                sb.append(AbstractSwitchBase.Feature.getFeatureByFlag(ii).toString()).append(newFlags[ii] != false ? " enabled " : " disabled ");
                                display = true;
                            }
                            if (display) {
                                type = LogEventType.OTHER;
                                severity = Severity.INFO;
                                sb.insert(0, "Feature: ");
                                break;
                            }
                            ** GOTO lbl280
                        }
                        case 1047: {
                            oldDomain = (VsanDomain)o[i].getOldValue();
                            newDomain = (VsanDomain)o[i].getNewValue();
                            if (SMISNotifications.isSmisEnable() && newDomain != null) {
                                SMISNotifications.getInstance().VsanSMISNotif(fImpl.getPK(), true, switchPk, newDomain);
                                break;
                            }
                            if (!SMISNotifications.isSmisEnable() || oldDomain == null) break;
                            SMISNotifications.getInstance().VsanSMISNotif(fImpl.getPK(), false, switchPk, oldDomain);
                        }
                    }
                    ** GOTO lbl280
                }
                case 1280: {
                    switch (propId) {
                        case 1281: {
                            if (o[i].getNewValue() != null) {
                                if (((Boolean)o[i].getNewValue()).booleanValue()) {
                                    type = LogEventType.PORT_UP;
                                    severity = Severity.INFO;
                                } else {
                                    type = LogEventType.PORT_DOWN;
                                    severity = Severity.WARNING;
                                }
                            }
                            isl = fImpl.findIsl(((IslPK)pkey).getSwitchIntKey1());
                            try {
                                if (isl == null) {
                                    sb.append(IslImpl.getEventIslDesc((IslPK)pkey, type));
                                    fpk = SanManager.getInstance().findFabricPK((IslPK)pkey);
                                    sw1 = SanManager.getInstance().findSwitch(((IslPK)pkey).getSwitchIntKey1()._swPK, fpk);
                                    if (sw1 != null) {
                                        switchDbId = sw1.getDBID();
                                        if (((IslPK)pkey).getSwitchIntKey1() != null) {
                                            try {
                                                srcId = FcPortImpl.getSwitchPort(switchDbId, ((IslPK)pkey).getSwitchIntKey1()._index);
                                            }
                                            catch (SQLException e) {}
                                            break;
                                        }
                                    }
                                } else {
                                    sb.append(isl.getEventDesc(type));
                                    if (isl.getSwitch1() != null) {
                                        switchDbId = isl.getSwitch1().getDBID();
                                    }
                                    if (((IslPK)pkey).getSwitchIntKey1() != null) {
                                        try {
                                            srcId = FcPortImpl.getSwitchPort(switchDbId, ((IslPK)pkey).getSwitchIntKey1()._index);
                                            break;
                                        }
                                        catch (SQLException e) {
                                        }
                                    }
                                }
                                ** GOTO lbl280
                            }
                            catch (Exception e) {
                                type = null;
                                EventLoggerService._Logger.debug((Object)("logging error for event: " + e.getMessage()));
                            }
                            break;
                        }
                        case 1284: {
                            break;
                        }
                        case 1287: {
                            break;
                        }
                        case 1286: {
                            break;
                        }
                        case 1282: {
                            break;
                        }
                    }
                    ** GOTO lbl280
                }
                case 3072: {
                    switch (propId) {
                        case 3073: {
                            if ((Boolean)o[i].getNewValue() == null) break;
                            if (((Boolean)o[i].getNewValue()).booleanValue()) {
                                type = LogEventType.PORT_UP;
                                severity = Severity.INFO;
                            } else {
                                type = LogEventType.PORT_DOWN;
                                severity = Severity.WARNING;
                            }
                            npvl = fImpl.findNpvLink((SwitchIntKey)pkey);
                            if (npvl == null) ** GOTO lbl230
                            try {
                                npvl.getEventDesc(type);
                                if (npvl.getCoreSwitch() == null) ** GOTO lbl280
                                switchDbId = npvl.getCoreSwitch().getDBID();
                                if ((SwitchIntKey)pkey != null) {
                                    try {
                                        srcId = FcPortImpl.getSwitchPort(switchDbId, ((SwitchIntKey)pkey)._index);
                                        break;
                                    }
                                    catch (SQLException e) {
                                    }
                                }
                                ** GOTO lbl280
                            }
                            catch (Exception e) {
                                type = null;
                                EventLoggerService._Logger.debug((Object)("Logging error in NP Link event: " + e.getMessage()));
                            }
                            break;
lbl230:
                            // 1 sources

                            type = null;
                            EventLoggerService._Logger.debug((Object)("Can not find the NPVLink Object, Logging error in NP Link event: " + ((SwitchIntKey)pkey).toString()));
                            break;
                        }
                    }
                    ** GOTO lbl280
                }
                case 1536: {
                    switch (propId) {
                        case 1537: {
                            ep = SanManager.getInstance().findEndPortByPK((WwnKey)pkey);
                            if (ep != null && ep.getSwitch() != null) {
                                switchDbId = ep.getSwitch().getDBID();
                                switchPk = ep.getSwitch().getSwitchPK();
                                if (ep.getSwitchIntKey() != null) {
                                    try {
                                        srcId = FcPortImpl.getSwitchPort(switchDbId, ep.getSwitchIntKey()._index);
                                    }
                                    catch (SQLException e) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (ep != null && ep.getEnclosure() != null) {
                                enclosure = ep.getEnclosure().getName();
                            }
                            if (o[i].getNewValue() != null) {
                                if (((Boolean)o[i].getNewValue()).booleanValue()) {
                                    type = LogEventType.PORT_UP;
                                    severity = Severity.INFO;
                                } else if (ep != null && ep.getSwitch() != null && !ep.getSwitch().isDelayLinkEnabled()) {
                                    type = LogEventType.PORT_DOWN;
                                    severity = Severity.WARNING;
                                }
                                if (ep == null) {
                                    desc = pkey.toString();
                                    if (desc != null && desc.length() > 3) {
                                        try {
                                            sb.append(EventBuilder.formatString(EventFormatType.OTHER, desc, "", "", "", "", type));
                                        }
                                        catch (Exception e) {
                                            type = null;
                                            EventLoggerService._Logger.debug((Object)desc, (Throwable)e);
                                        }
                                        break;
                                    }
                                    type = null;
                                    break;
                                }
                                if (ep.getIfName() == null || ep.getIfName().equals("unknown")) continue block48;
                                try {
                                    sb.append(ep.getEventDesc(type));
                                    break;
                                }
                                catch (Exception e) {
                                    type = null;
                                    EventLoggerService._Logger.debug((Object)e.getMessage());
                                }
                            }
                        }
                        default: {
                            break;
                        }
                    }
                }
lbl280:
                // 20 sources

                default: {
                    if (type == null || sb.length() == 0) continue block48;
                    e = new LogEvent((Object)fImpl.getPK(), type, severity, source, sb.toString(), fImpl.getDBID(), switchDbId, switchPk);
                    if (enclosure != null) {
                        e.setEnclosure(enclosure);
                    }
                    e.setSrcId(srcId);
                    if (srcId != 0L) {
                        pgIds = AppGroupUtil.getInstance().getPortGroupId(srcId, switchDbId, 3);
                        e.set_pgGroupIds(pgIds);
                    }
                    if (type == LogEventType.PORT_UP) {
                        this.dispatchEvent(e);
                        continue block48;
                    }
                    this.logEvent(e);
                }
            }
        }
    }

    @Override
    public void membersMoved(FabricImpl fImpl, MovedModelObject[] o) {
    }

    @Override
    public void memberPurged(FabricImpl fImpl, PKIf[] o) {
        if (fImpl == null || o == null) {
            return;
        }
        if (fImpl.getSeed() != null) {
            SyslogEntry se = new SyslogEntry(fImpl.getPK(), IdentityManager.getInstance().getClientAddress(), fImpl.getDBID(), "DCNM-SAN", LogEventType.FABRIC.toString(), IdentityManager.getInstance().getCurrentUsername(), "Fabric '" + fImpl.getPK().toString() + "' purged all members", Severity.INFO.getValue(), 0);
            this.logAccounting(se);
        }
    }

    @Override
    public void modelObjectCreated(AbstractModelObjectImpl mo) {
        if (SMISNotifications.isSmisEnable() && (mo instanceof SwitchImpl || mo instanceof EndPortImpl)) {
            SMISNotifications.getInstance().SMISNotif(mo, 0);
        }
    }

    @Override
    public void modelObjectRemoved(AbstractModelObjectImpl mo) {
        if (SMISNotifications.isSmisEnable() && (mo instanceof SwitchImpl || mo instanceof EndPortImpl)) {
            SMISNotifications.getInstance().SMISNotif(mo, 1);
        }
    }

    @Override
    public void cdpSeedAdded(CdpSeedImpl cdpSeed) {
    }

    @Override
    public void cdpSeedRemoved(CdpSeedImpl cdpSeed) {
    }

    @Override
    public void lanOpened(LanImpl lan) {
    }

    @Override
    public void lanClosed(LanImpl lan) {
    }

    @Override
    public void lanRemoved(CdpSeedImpl cdpSeed, LanImpl lan) {
    }

    @Override
    public void lanDiscovered(LanImpl lan) {
    }

    @Override
    public void lanRediscovered(LanImpl lan) {
    }

    @Override
    public void membersAdded(LanImpl lan, AbstractModelObjectImpl[] mos) {
    }

    @Override
    public void membersRemoved(LanImpl lan, PKIf[] pks) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void membersChanged(LanImpl lan, ChangedModelObject[] mos) {
        int i = 0;
        while (i < mos.length) {
            if (mos[i] != null) {
                LogEventType type = null;
                Severity severity = null;
                StringBuffer sb = new StringBuffer();
                PKIf pkey = mos[i].getPK();
                short propId = mos[i]._propId;
                short attrType = (short)(propId & 0xFF00);
                String source = lan.getPK().toString();
                EthSwitchImpl sw = lan.findEthSwitchByPK(pkey);
                if (sw != null && sw.getDBID() != 0L) {
                    switch (attrType) {
                        case 1024: {
                            sb.append(sw.getName()).append(" ");
                            switch (propId) {
                                case 1038: {
                                    if ((Boolean)mos[i].getNewValue() == null) break;
                                    if (((Boolean)mos[i].getNewValue()).booleanValue()) {
                                        type = LogEventType.SWITCH_MANAGEABILITY;
                                        severity = Severity.INFO;
                                        sb.insert(0, "Switch manageable: ");
                                        break;
                                    }
                                    type = LogEventType.SWITCH_MANAGEABILITY;
                                    severity = Severity.WARNING;
                                    sb.insert(0, "Switch Unmanageable: ");
                                    break;
                                }
                            }
                        }
                        case 1280: {
                            switch (propId) {
                                case 1281: {
                                    if (mos[i].getNewValue() == null) break;
                                    if (((Boolean)mos[i].getNewValue()).booleanValue()) {
                                        type = LogEventType.PORT_UP;
                                        severity = Severity.INFO;
                                        sb.insert(0, "Link Up: ");
                                        break;
                                    }
                                    type = LogEventType.PORT_DOWN;
                                    severity = Severity.WARNING;
                                    sb.insert(0, "Link Down: ");
                                }
                            }
                            break;
                        }
                    }
                    if (type != null && sb.length() != 0) {
                        LogEvent e = new LogEvent((Object)lan.getPK(), type, severity, source, sb.toString(), System.currentTimeMillis(), sw.getInetAddress(), 1);
                        if (type == LogEventType.PORT_UP) {
                            this.dispatchEvent(e);
                        } else {
                            this.logEvent(e);
                        }
                    }
                }
            }
            ++i;
        }
        return;
    }

    @Override
    public void membersMoved(LanImpl lan, MovedModelObject[] mos) {
    }

    @Override
    public void memberPurged(LanImpl lan, PKIf[] pks) {
    }

    @Override
    public void dbObjectPurged(long dbid) {
    }

    @Override
    protected void stopImpl() {
        this._efd.stop();
    }
}

