/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.event;

import com.cisco.dcbu.lib.concurrent.PooledThreadExecutor;
import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.NotificationLogUtil;
import com.cisco.dcbu.lib.jnm.SnmpDateAndTime;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpCounter64;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.snmp.SnmpTrapSession;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.dto.DiscoveryType;
import com.cisco.dcbu.sm.common.dto.HwInventoryType;
import com.cisco.dcbu.sm.common.event.LogEvent;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.event.SnmpTrapEntry;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.EnclosureBase;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.HwInventoryComponent;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.SwitchIf;
import com.cisco.dcbu.sm.common.model.VdcBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SerialNumKey;
import com.cisco.dcbu.sm.common.type.SwitchIntKey;
import com.cisco.dcbu.sm.common.type.VdcPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.discovery.FabricWorker;
import com.cisco.dcbu.sm.server.event.EventLoggerService;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.EthIslImpl;
import com.cisco.dcbu.sm.server.model.EthPortImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.FcPortImpl;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.NpvLinkImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VdcImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.sm.server.web.util.AppGroupUtil;
import java.math.BigInteger;
import java.net.InetAddress;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

final class TrapHandler {
    public static final boolean _LogLinkDownTrap = Boolean.valueOf(System.getProperty("events.linkDown.log", "false"));
    public static final String TRAP_REGADDR = "trap.registaddress";
    static byte[][] _FilteredOids = new byte[][]{{43, 6, 1, 2, 1, 47, 2, 0, 1}, {43, 6, 1, 3, 94}, {43, 6, 1, 4, 1, 9, 9, 10}, {43, 6, 1, 4, 1, 9, 9, -125, 47, 0}, {43, 6, 1, 4, 1, 9, 9, 96, 2, 1, 1}, {43, 6, 1, 4, 1, 9, 9, -126, 33}, {43, 6, 1, 4, 1, 9, 9, -126, 34}, {43, 6, 1, 4, 1, 9, 9, -126, 35}, {43, 6, 1, 4, 1, 9, 9, -126, 39}, {43, 6, 1, 4, 1, 9, 9, -126, 40}, {43, 6, 1, 4, 1, 9, 9, -126, 41}, {43, 6, 1, 4, 1, 9, 9, -126, 42}, {43, 6, 1, 4, 1, 9, 9, -126, 48}, {43, 6, 1, 4, 1, 9, 10}, {43, 6, 1, 6, 3, 1, 1, 5, 5}, {43, 6, 1, 4, 1, 9, 9, 43, 2, 0, 2}, {43, 6, 1, 4, 1, 9, -126, 43, 12, 0, 1}};
    static final int[] _SnmpTrapEnterprise = new int[]{1, 3, 6, 1, 6, 3, 1, 1, 4, 3, 0};
    static final int[][] _EnabledNotifies = new int[][]{MibNode.get("dmReConfFabricChangeNotifyEnable").getOid(), MibNode.get("fspfNbrStateChangeNotifyEnable").getOid()};
    static final int[][] _AffectModelTrapOids = new int[][]{MibNode.get("coldStart").getOid(), MibNode.get("warmStart").getOid(), MibNode.get("linkUp").getOid(), MibNode.get("linkDown").getOid(), MibNode.get("fspfNbrStateChangeNotify").getOid(), MibNode.get("vsanStatusChange").getOid(), MibNode.get("dmDomainIdNotAssignedNotify").getOid(), MibNode.get("dmNewPrincipalSwitchNotify").getOid(), MibNode.get("dmFabricChangeNotify").getOid(), MibNode.get("zoneMergeSuccessNotify").getOid(), MibNode.get("zoneMergeFailureNotify").getOid(), MibNode.get("cefcFRUInserted").getOid(), MibNode.get("cefcFRURemoved").getOid(), MibNode.get("cefcModuleStatusChange").getOid(), MibNode.get("cefcPowerStatusChange").getOid(), MibNode.get("cefcFanTrayStatusChange").getOid(), MibNode.get("cseHaRestartNotify").getOid(), MibNode.get("ciscoRFSwactNotif").getOid(), MibNode.get("ciscoPsmPortBindFPortDenyNotify").getOid(), MibNode.get("ciscoPsmPortBindEPortDenyNotify").getOid(), MibNode.get("ciscoPsmFabricBindDenyNotify").getOid(), MibNode.get("ciscoPsmFabricBindDenyNotifyNew").getOid(), MibNode.get("ciuUpgradeOpCompletionNotify").getOid(), MibNode.get("vrrpTrapNewMaster").getOid(), MibNode.get("zoneDefZoneBehaviourChngNotify").getOid(), MibNode.get("ciscoFeatureOpStatusChange").getOid(), MibNode.get("civrZoneActivationDoneNotify").getOid(), MibNode.get("civrZoneDeactivationDoneNotify").getOid(), MibNode.get("civrDomainConflictNotify").getOid(), MibNode.get("civrAfidConfigNotify").getOid(), MibNode.get("fcNameServerEntryAdd").getOid(), MibNode.get("fcNameServerEntryDelete").getOid(), MibNode.get("cficonPortInfoChange").getOid(), MibNode.get("entConfigChange").getOid(), MibNode.get("ciscoCFSFeatureActionNotif").getOid(), MibNode.get("zoneActivateNotify").getOid(), MibNode.get("ciscoSmeInterfaceCreate").getOid(), MibNode.get("ciscoSmeInterfaceDelete").getOid(), MibNode.get("cieLinkUp").getOid(), MibNode.get("cieLinkDown").getOid(), MibNode.get("risingAlarm").getOid(), MibNode.get("hcRisingAlarm").getOid(), MibNode.get("cHcRisingAlarm").getOid(), MibNode.get("fallingAlarm").getOid(), MibNode.get("hcFallingAlarm").getOid(), MibNode.get("cHcFallingAlarm").getOid(), MibNode.get("cIfXcvrMonStatusChangeNotif").getOid(), MibNode.get("cieDelayedLinkUpDownNotif").getOid()};
    static final int[][] _LicenseMgrOids = new int[][]{MibNode.get("clmLicenseExpiryNotify").getOid(), MibNode.get("clmNoLicenseForFeatureNotify").getOid(), MibNode.get("clmLicenseFileMissingNotify").getOid(), MibNode.get("clmLicenseExpiryWarningNotify").getOid()};
    static final SnmpOID[] _SecurityOids = new SnmpOID[]{new SnmpOID(MibNode.get("casServerStateChange").getOid()), new SnmpOID(MibNode.get("cfcspAuthFailTrap").getOid()), new SnmpOID(MibNode.get("ciscoPsmFabricBindDenyNotifyNew").getOid()), new SnmpOID(MibNode.get("ciscoEnhIpsecFlowTunnelStart").getOid()), new SnmpOID(MibNode.get("ciscoEnhIpsecFlowTunnelStop").getOid()), new SnmpOID(MibNode.get("ciscoEnhIpsecFlowSysFailure").getOid()), new SnmpOID(MibNode.get("ciscoEnhIpsecFlowSetupFail").getOid()), new SnmpOID(MibNode.get("ciscoEnhIpsecFlowBadSa").getOid()), new SnmpOID(MibNode.get("ciscoIPsecProvCryptomapAdded").getOid()), new SnmpOID(MibNode.get("ciscoIPsecProvCryptomapDeleted").getOid()), new SnmpOID(MibNode.get("ciscoIPsecProvCryptomapAttached").getOid()), new SnmpOID(MibNode.get("ciscoIPsecProvCryptomapDetached").getOid()), new SnmpOID(MibNode.get("ciscoIkeConfigOperStateChanged").getOid()), new SnmpOID(MibNode.get("ciscoIkeConfigPskAdded").getOid()), new SnmpOID(MibNode.get("ciscoIkeConfigPskDeleted").getOid()), new SnmpOID(MibNode.get("ciscoIkeConfigPolicyAdded").getOid()), new SnmpOID(MibNode.get("ciscoIkeConfigPolicyDeleted").getOid()), new SnmpOID(MibNode.get("ciscoIkeFlowInNewGrpRejected").getOid()), new SnmpOID(MibNode.get("ciscoIkeFlowOutNewGrpRejected").getOid()), new SnmpOID(MibNode.get("ciscoIpsSgTunnelStart").getOid()), new SnmpOID(MibNode.get("ciscoIpsSgTunnelStop").getOid()), new SnmpOID(MibNode.get("ciscoIpsSgSysFailure").getOid()), new SnmpOID(MibNode.get("ciscoIpsSgCertCrlFailure").getOid())};
    static final int[][] _RmonVariableOids = new int[][]{MibNode.get("alarmVariable").getOid(), MibNode.get("hcAlarmVariable").getOid(), MibNode.get("cHcAlarmVariable").getOid()};
    static final int[][] _AlarmSampleTypeOids = new int[][]{MibNode.get("alarmSampleType").getOid(), MibNode.get("hcAlarmSampleType").getOid(), MibNode.get("cHcAlarmSampleType").getOid()};
    static final int[][] _AlarmValueOids = new int[][]{MibNode.get("alarmValue").getOid(), MibNode.get("hcAlarmAbsValue").getOid(), MibNode.get("cHcAlarmAbsValue").getOid()};
    static final int[][] _AlarmValueStatusOids = new int[][]{MibNode.get("hcAlarmValueStatus").getOid(), MibNode.get("cHcAlarmValueStatus").getOid()};
    static final int[][] _AlarmIntervals = new int[][]{MibNode.get("alarmInterval").getOid(), MibNode.get("hcAlarmInterval").getOid(), MibNode.get("cHcAlarmInterval").getOid()};
    static final int[][] _AlarmRisingThresholdLoOids = new int[][]{MibNode.get("hcAlarmRisingThreshAbsValueLo").getOid(), MibNode.get("cHcAlarmRisingThreshAbsValueLo").getOid()};
    static final int[][] _AlarmRisingThresholdHiOids = new int[][]{MibNode.get("hcAlarmRisingThreshAbsValueHi").getOid(), MibNode.get("cHcAlarmRisingThreshAbsValueHi").getOid()};
    static final int[][] _AlarmFallingThresholdLoOids = new int[][]{MibNode.get("hcAlarmFallingThreshAbsValueLo").getOid(), MibNode.get("cHcAlarmFallingThreshAbsValueLo").getOid()};
    static final int[][] _AlarmFallingThresholdHiOids = new int[][]{MibNode.get("hcAlarmFallingThreshAbsValueHi").getOid(), MibNode.get("cHcAlarmFallingThreshAbsValueHi").getOid()};
    static final int[] _AlarmRisingThresholdOid = MibNode.get("alarmRisingThreshold").getOid();
    static final int[] _AlarmFallingThresholdOid = MibNode.get("alarmFallingThreshold").getOid();
    static final int[] _CFSMergeFailOid = MibNode.get("ciscoCFSMergeFailNotif").getOid();
    static final int[] _CFSFeatureActionOid = MibNode.get("ciscoCFSFeatureActionNotif").getOid();
    static final int[] _EntSensorNotifyOid = MibNode.get("entSensorThresholdNotification").getOid();
    static final int[] _VsanPortChangeNotif = MibNode.get("vsanPortMembershipChange").getOid();
    static final int[] _CcmEventNotifOid = MibNode.get("ccmEventNotif").getOid();
    static final int[] _UcsNotify = MibNode.get("cucsFaultActiveNotif").getOid();
    static final int[] _EntPhysicalParentRelPos = new int[]{1, 3, 6, 1, 2, 1, 47, 1, 1, 1, 1, 6};
    static final int[] IFINDEX_OID = new int[]{1, 3, 6, 1, 2, 1, 2, 2, 1, 1};
    static final String[][] _PMOIDS = new String[][]{{"fcFxPortLinkFailures", "Link loss"}, {"fcIfLinkFailures", "Link loss"}, {"fcFxPortSyncLosses", "Sync loss"}, {"fcIfSyncLosses", "Sync loss"}, {"fcFxPortSigLosses", "Signal loss"}, {"fcIfSigLosses", "Signal loss"}, {"fcFxPortPrimSeqProtoErrors", "Protocol Error"}, {"fcIfPrimSeqProtoErrors", "Protocol Error"}, {"fcFxPortInvalidTxWords", "Invalid words"}, {"fcIfInvalidTxWords", "Invalid words"}, {"fcFxPortInvalidCrcs", "Invalid CRCs"}, {"fcIfInvalidCrcs", "Invalid CRCs"}, {"ifHCInOctets", "Rx Bytes"}, {"ifHCOutOctets", "Tx Bytes"}, {"fcIfLinkResetIns", "LR Rx"}, {"fcIfLinkResetOuts", "LR Tx"}, {"fcIfTimeOutDiscards", "Timeout Discards"}, {"fcIfOutDiscards", "Tx Discards"}, {"fcIfCreditLoss", "Credit Loss"}, {"fcIfTxWtAvgBBCreditTransitionToZero", "Tx Credit Not Available"}};
    static final byte COLD_START = 0;
    static final byte WARM_START = 1;
    static final byte LINK_UP = 2;
    static final byte LINK_DOWN = 3;
    static final byte FSPF_CHANGE = 4;
    static final byte VSAN_CHANGE = 5;
    static final byte DID_NOTASSIGNED = 6;
    static final byte NEW_PRISWITCH = 7;
    static final byte FABRIC_CHANGE = 8;
    static final byte ZONEMERGE_SUCC = 9;
    static final byte ZONEMERGE_FAIL = 10;
    static final byte FRU_INSERTED = 11;
    static final byte FRU_REMOVED = 12;
    static final byte MODULE_STATUS = 13;
    static final byte POWER_STATUS = 14;
    static final byte FAN_STATUS = 15;
    static final byte HA_RESTART = 16;
    static final byte RF_SWACT = 17;
    static final byte PSM_FPORT_DENY = 18;
    static final byte PSM_EPORT_DENY = 19;
    static final byte PSM_FABRIC_DENY = 20;
    static final byte PSM_FABRIC_DENYN = 21;
    static final byte IMAGE_UPGRADE = 22;
    static final byte VRRP_TRAP = 23;
    static final byte ZONE_BEHAVIOR = 24;
    static final byte FEATURE_CTRLCHG = 25;
    static final byte IVRZONE_ACT = 26;
    static final byte IVRZONE_DEACT = 27;
    static final byte IVR_DOMAIN_CONFLICT = 28;
    static final byte IVR_AFID_CONFLICT = 29;
    static final byte NS_ENTRY_ADD = 30;
    static final byte NS_ENTRY_DEL = 31;
    static final byte FICON_PORTCHG = 32;
    static final byte ENTITY_CFGCHG = 33;
    static final byte CFS_FEATURE_ACTION = 34;
    static final byte ZONE_ACTIVATE_NOTIFY = 35;
    static final byte SME_INTERF_CREATE = 36;
    static final byte SME_INTERF_REMOVE = 37;
    static final byte CIE_LINK_UP = 38;
    static final byte CIE_LINK_DOWN = 39;
    static final byte RISING_ALARM = 40;
    static final byte HC_RISING_ALARM = 41;
    static final byte CHC_RISING_ALARM = 42;
    static final byte FALLING_ALARM = 43;
    static final byte HC_FALLING_ALARM = 44;
    static final byte CHC_FALLING_ALARM = 45;
    static final byte SFP_DIAG_NOTIFY = 46;
    static final byte CIE_DELAYED_TRAP = 47;
    static final int INV_SLOT = -99;
    static final String SFP_DIAG_PREFIX = "cIfXcvrMonDigitalDiag";
    static HashMap<String, String> _PMOidStrs = new HashMap();
    static HashSet<SnmpOID> _SecurityOIDSet = new HashSet();
    static Logger _Logger = LogManager.getLogger((String)"fms.event.trap");
    private EventLoggerService _logger = (EventLoggerService)ServiceConfig.findService("Event Logger Service");
    private PooledThreadExecutor _trapPool = new PooledThreadExecutor("trapHandlerPool", 2, 10, 5000L);

    TrapHandler() {
    }

    void trapReceived(SnmpTrapEntry trapEntry) {
        int i;
        FabricPK[] pks;
        if (trapEntry.getLength() == 0) {
            return;
        }
        boolean trapHandled = false;
        InetAddress trapSrc = trapEntry.getAddr();
        AbstractModelObjectImpl sw = null;
        for (FabricPK fKey : pks = SanManager.getInstance().getFabricPKs()) {
            sw = SanManager.getInstance().findSwitch(trapSrc, fKey);
            if (sw != null) break;
        }
        if (sw == null) {
            sw = DCManager.getInstance().findEthSwitchBySwIp(trapSrc);
        }
        if (sw == null) {
            return;
        }
        sw.setTrapRegistered(true);
        boolean isInitialDiscovery = false;
        if (sw instanceof SwitchImpl) {
            isInitialDiscovery = ((SwitchImpl)sw).getFabric().isInitialDiscovery();
        } else if (sw instanceof EthSwitchImpl) {
            isInitialDiscovery = ((EthSwitchImpl)sw).getLan().isInitialDiscovery();
        }
        VarBindList vbl = trapEntry.getVarBindList();
        boolean rebooted = sw.getSysUpTime() > vbl.longValue(0) && !isInitialDiscovery;
        SnmpOID trapOid = (SnmpOID)trapEntry.getVar(1);
        for (i = 0; i < _AffectModelTrapOids.length; ++i) {
            if (!trapOid.startsWith(_AffectModelTrapOids[i])) continue;
            if (i == 0 || i == 1) {
                rebooted = true;
            }
            this.trapProcess(i, (SwitchIf<PKIf>)((Object)sw), vbl);
            trapHandled = true;
            break;
        }
        for (i = 0; i < _LicenseMgrOids.length && !trapHandled; ++i) {
            if (!trapOid.startsWith(_LicenseMgrOids[i])) continue;
            this.onLicenseTrap((SwitchIf<PKIf>)((Object)sw), trapOid, vbl);
            trapHandled = true;
            break;
        }
        if (!trapHandled) {
            this.onOtherTrap((SwitchIf<PKIf>)((Object)sw), trapOid, vbl);
        }
        if (rebooted) {
            if (sw instanceof SwitchImpl) {
                ((SwitchImpl)sw).getFabric().incrementChange(true);
            } else if (sw instanceof EthSwitchImpl) {
                ((EthSwitchImpl)sw).getLan().incrementChange(true);
            }
        }
    }

    private void trapProcess(int i, SwitchIf<PKIf> sw, VarBindList vbl) {
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("AffectModelTrap received: " + i));
        }
        switch (i) {
            case 0: {
                this.onSwitchReboot(sw, "coldStart");
                return;
            }
            case 1: {
                this.onSwitchReboot(sw, "warmStart");
                return;
            }
            case 2: 
            case 38: {
                this.onLinkUpTrap(sw, vbl);
                return;
            }
            case 3: {
                this.onLinkDownTrap(sw, vbl);
                return;
            }
            case 39: {
                this.onCieLinkDownTrap(sw, vbl);
            }
            case 4: {
                this.onFspfTrap(sw, vbl);
                return;
            }
            case 5: {
                if (sw instanceof SwitchImpl) {
                    this.onVsanChangeTrap((SwitchImpl)sw, vbl);
                } else {
                    _Logger.info((Object)("VSAN_CHANGE trap: " + vbl));
                }
                return;
            }
            case 6: {
                if (sw instanceof SwitchImpl) {
                    this.onDidNotAssignedTrap((SwitchImpl)sw, vbl);
                } else {
                    _Logger.info((Object)("DID_NOTASSIGNED trap: " + vbl));
                }
                return;
            }
            case 7: {
                if (sw instanceof SwitchImpl) {
                    this.onNewPrinSwitchTrap((SwitchImpl)sw, vbl);
                } else {
                    _Logger.info((Object)("NEW_PRISWITCH trap: " + vbl));
                }
                return;
            }
            case 8: {
                if (sw instanceof SwitchImpl) {
                    this.onFabricChangeTrap((SwitchImpl)sw, vbl);
                } else {
                    _Logger.info((Object)("FABRIC_CHANGE trap: " + vbl));
                }
                return;
            }
            case 9: {
                if (sw instanceof SwitchImpl) {
                    this.onZoneMergeTrap((SwitchImpl)sw, vbl, true);
                    ((SwitchImpl)sw).getFabric().incrementChange(false);
                } else {
                    _Logger.info((Object)("ZONEMERGE_SUCC trap: " + vbl));
                }
                return;
            }
            case 10: {
                if (sw instanceof SwitchImpl) {
                    this.onZoneMergeTrap((SwitchImpl)sw, vbl, false);
                    ((SwitchImpl)sw).getFabric().incrementChange(false);
                } else {
                    _Logger.info((Object)("ZONEMERGE_FAIL trap: " + vbl));
                }
                return;
            }
            case 11: 
            case 12: {
                this.onFRUChange(sw, vbl, i);
                return;
            }
            case 13: {
                this.onModuleStatusChangeTrap(sw, vbl);
                return;
            }
            case 14: {
                this.onPowerStatusChangeTrap(sw, vbl);
                return;
            }
            case 15: {
                this.onFanStatusChangeTrap(sw, vbl);
                return;
            }
            case 16: {
                this.onHaRestartTrap(sw, vbl);
                return;
            }
            case 17: {
                this.onRFSwactTrap(sw, vbl);
                return;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                if (sw instanceof SwitchImpl) {
                    this.onPsmDenyTrap((SwitchImpl)sw, vbl, i);
                } else {
                    _Logger.info((Object)("PSM_FABRIC_DENY trap: " + vbl));
                }
                return;
            }
            case 22: {
                this.onImageUpgradeTrap(sw, vbl);
                return;
            }
            case 23: {
                if (sw instanceof SwitchImpl) {
                    this.onVrrpTrap((SwitchImpl)sw, vbl);
                } else {
                    _Logger.info((Object)("VRRP_TRAP trap: " + vbl));
                }
                return;
            }
            case 24: {
                if (sw instanceof SwitchImpl) {
                    this.onZoneBehaviorTrap((SwitchImpl)sw, vbl);
                } else {
                    _Logger.info((Object)("ZONE_BEHAVIOR trap: " + vbl));
                }
                return;
            }
            case 25: {
                if (sw instanceof SwitchImpl) {
                    this.onFeatureControlChangeTrap((SwitchImpl)sw, vbl);
                } else {
                    _Logger.info((Object)("FEATURE_CTRLCHG trap: " + vbl));
                }
                return;
            }
            case 26: 
            case 27: {
                if (sw instanceof SwitchImpl) {
                    this.onIvrActivationTrap((SwitchImpl)sw, vbl);
                } else {
                    _Logger.info((Object)("IVRZONE_ACT trap: " + vbl));
                }
                return;
            }
            case 28: {
                if (sw instanceof SwitchImpl) {
                    this.onIvrDomainConflictTrap((SwitchImpl)sw, vbl);
                } else {
                    _Logger.info((Object)("IVR_DOMAIN_CONFLICT trap: " + vbl));
                }
                return;
            }
            case 29: {
                if (sw instanceof SwitchImpl) {
                    this.onIvrAfidMisConfigTrap((SwitchImpl)sw, vbl);
                } else {
                    _Logger.info((Object)("IVR_AFID_CONFLICT trap: " + vbl));
                }
                return;
            }
            case 30: 
            case 31: {
                this.onNsEntryTrap(sw, vbl);
                return;
            }
            case 32: {
                if (sw instanceof SwitchImpl) {
                    this.onFiconPortInfoChange((SwitchImpl)sw, vbl);
                } else {
                    _Logger.info((Object)("FICON_PORTCHG trap: " + vbl));
                }
                return;
            }
            case 33: {
                this.onEntityConfigChange(sw);
                return;
            }
            case 34: {
                if (sw instanceof SwitchImpl) {
                    this.onCFSFeatureAction((SwitchImpl)sw, vbl);
                } else {
                    _Logger.info((Object)("CFS_FEATURE_ACTION trap: " + vbl));
                }
                return;
            }
            case 35: {
                if (sw instanceof SwitchImpl) {
                    this.onZoneActivateNotify((SwitchImpl)sw, vbl, true);
                } else {
                    _Logger.info((Object)("ZONE_ACTIVATE_NOTIFY trap: " + vbl));
                }
                return;
            }
            case 36: 
            case 37: {
                if (sw instanceof SwitchImpl) {
                    this.onSmeInterfChange((SwitchImpl)sw, vbl, i);
                } else {
                    _Logger.info((Object)("SME_INTERF_CREATE trap: " + vbl));
                }
                return;
            }
            case 40: 
            case 41: 
            case 42: {
                if (sw instanceof SwitchImpl) {
                    this.onRmonTrap((SwitchImpl)sw, vbl, LogEventType.THRESHOLD, true);
                } else {
                    _Logger.info((Object)("RISING_ALARM trap: " + vbl));
                }
                return;
            }
            case 43: 
            case 44: 
            case 45: {
                if (sw instanceof SwitchImpl) {
                    this.onRmonTrap((SwitchImpl)sw, vbl, LogEventType.THRESHOLD, false);
                } else {
                    _Logger.info((Object)("FALLING_ALARM trap: " + vbl));
                }
                return;
            }
            case 46: {
                if (sw instanceof SwitchImpl) {
                    this.onSFPDiagTrap((SwitchImpl)sw, vbl);
                } else {
                    _Logger.info((Object)("SFP_DIAG_NOTIFY trap: " + vbl));
                }
                return;
            }
            case 47: {
                this.onDelayedLinkUpDown(sw, vbl);
                return;
            }
        }
        _Logger.info((Object)("trapHandler: " + vbl));
    }

    void onLinkUpTrap(SwitchIf<PKIf> sw, VarBindList vbl) {
        SnmpVarBind svb = this.getVar(vbl, "ifIndex");
        if (svb == null) {
            return;
        }
        int ifIndex = svb.intValue();
        String descr = null;
        if (sw instanceof SwitchImpl) {
            FabricImpl fabric = ((SwitchImpl)sw).getFabric();
            FabricWorker fWorker = fabric.getWorker();
            if (fWorker.getStatus() == 1) {
                fWorker.setNeedRediscover(true);
            } else {
                fWorker.setDiscoveryType(DiscoveryType.FABRIC_LINKUP);
                if (vbl.size() > 6) {
                    int opMode = 0;
                    svb = this.getVar(vbl, "fcIfOperMode");
                    if (svb != null) {
                        opMode = svb.intValue();
                    }
                    ((SwitchImpl)sw).getFabric().incrementChange(opMode > 0 && opMode != 2 && opMode != 3);
                } else {
                    ((SwitchImpl)sw).getFabric().incrementChange(true);
                }
            }
            descr = "Port " + ((SwitchImpl)sw).ifIndexToName(ifIndex) + " is up";
            long srcId = 0L;
            try {
                srcId = FcPortImpl.getSwitchPort(((SwitchImpl)sw).getDBID(), ifIndex);
            }
            catch (SQLException e) {
                _Logger.info((Object)e.getLocalizedMessage());
            }
            Set<Integer> pgIds = AppGroupUtil.getInstance().getPortGroupId(srcId, ((SwitchImpl)sw).getDBID(), 3);
            this.logEvent(sw, LogEventType.PORT_UP, Severity.INFO, descr, pgIds, srcId);
        } else if (sw instanceof EthSwitchImpl) {
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)("EthSwitch onLinkUpTrap: " + vbl));
            }
            int opMode = 0;
            svb = this.getVar(vbl, "ifOperStatus");
            if (svb != null) {
                opMode = svb.intValue();
            }
            ((EthSwitchImpl)sw).getLan().incrementChange(opMode > 0 && opMode != 2 && opMode != 3);
            Set<EthIslImpl> isls = ((EthSwitchImpl)sw).getLan().findEthIslsBySwPort(((EthSwitchImpl)sw).getSwitchPK(), ifIndex);
            if (isls != null && !isls.isEmpty()) {
                for (EthIslImpl isl : isls) {
                    isl.setPresent(true);
                }
            }
            EthPortImpl ep = ((EthSwitchImpl)sw).getLan().findEthPort(((EthSwitchImpl)sw).getSwitchPK(), ifIndex);
            ep.setIfOperMode(opMode);
            ep.setOperStatusCause((short)opMode);
            descr = "Port " + ep.getIfname() + " is up";
            LogEvent e = new LogEvent(LogEventType.PORT_UP, Severity.INFO, "Trap " + sw.getName(), descr, System.currentTimeMillis(), sw.getInetAddress(), 1);
            e.setSrcId(ep.getDBID());
            Set<Integer> pgIds = AppGroupUtil.getInstance().getPortGroupId(ep.getDBID(), ((EthSwitchImpl)sw).getDBID(), 4);
            e.set_pgGroupIds(pgIds);
            e.setSwitchId(((EthSwitchImpl)sw).getDBID());
            this._logger.logEvent(e);
        }
    }

    void onSwitchReboot(SwitchIf<PKIf> sw, String reason) {
        String descr = "Switch rebooted: " + sw.getName() + ", " + reason + ", sysUpTime=" + SnmpTimeticks.formatTimeElapsed(sw.getSysUpTime()) + ", " + (sw.getVersion() != null ? sw.getVersion() : "");
        this.logEvent(sw, LogEventType.SWITCH_MANAGEABILITY, Severity.CRITICAL, descr);
    }

    void onLinkDownTrap(SwitchIf<PKIf> sw, VarBindList vbl) {
        int cause = 1;
        SnmpVarBind svb = this.getVar(vbl, "ifIndex");
        if (svb == null) {
            return;
        }
        if (sw instanceof SwitchImpl) {
            FcPortBase fcPort = ((SwitchImpl)sw).findPort(svb.intValue());
            if (((SwitchImpl)sw).isDelayLinkEnabled() && fcPort != null && (fcPort.getIfOperMode() == 2 || fcPort.getIfOperMode() == 3 || fcPort.getIfOperMode() == 6)) {
                return;
            }
            if (vbl.size() > 6 && (svb = this.getVar(vbl, "fcIfOperStatusCause")) != null) {
                cause = svb.intValue();
            }
        } else if (sw instanceof EthSwitchImpl && (svb = this.getVar(vbl, "ifOperStatus")) != null) {
            cause = svb.intValue();
        }
        this.linkDown(sw, vbl, cause);
    }

    private SnmpVarBind getVar(VarBindList vbl, String mibStr) {
        SnmpVarBind svb = null;
        for (int i = 2; i < vbl.size(); ++i) {
            SnmpOID oid = vbl.getVb(i).getOid();
            if (!oid.startsWith(MibNode.get(mibStr).getOid())) continue;
            svb = vbl.get(i);
            break;
        }
        return svb;
    }

    void onCieLinkDownTrap(SwitchIf<PKIf> sw, VarBindList vbl) {
        this.linkDown(sw, vbl, 1);
    }

    private void linkDown(SwitchIf<PKIf> sw, VarBindList vbl, int cause) {
        SnmpVarBind svb = this.getVar(vbl, "ifIndex");
        if (svb == null) {
            return;
        }
        String descr = null;
        int ifIndex = svb.intValue();
        String endDevices = "";
        if (sw instanceof SwitchImpl) {
            IslImpl isl = ((SwitchImpl)sw).getFabric().findIsl(new SwitchIntKey(((SwitchImpl)sw).getSwitchPK(), ifIndex));
            if (isl != null) {
                isl.setPresent(false, cause);
            } else {
                ArrayList<EndPortImpl> list = ((SwitchImpl)sw).getFabric().findEndPortsBySwitchIfIndex((SwitchImpl)sw, ifIndex);
                if (list != null && !list.isEmpty()) {
                    for (int i = 0; i < list.size(); ++i) {
                        EndPortImpl ep = (EndPortImpl)list.get(i);
                        if (ep.isPresent()) {
                            endDevices = endDevices + " " + ep.getName();
                        }
                        ep.setOperStatusCause((short)cause);
                    }
                } else {
                    NpvLinkImpl nplink = ((SwitchImpl)sw).getFabric().findNpvLink((SwitchImpl)sw, ifIndex);
                    if (nplink != null) {
                        nplink.setPresent(false, cause);
                    } else {
                        ((SwitchImpl)sw).getFabric().incrementChange(false);
                    }
                }
            }
            if (_LogLinkDownTrap) {
                descr = ((SwitchImpl)sw).ifIndexToName(ifIndex) + " " + cause;
                Card mycard = InventoryManager.getInstance().findCard(sw.getSwitchPK(), IfIndexUtil.getIfIndexCard(ifIndex));
                if (mycard != null) {
                    String reason = "N/A";
                    svb = this.getVar(vbl, "fcIfOperStatusCause");
                    if (svb != null) {
                        reason = svb.enumValue();
                    }
                    descr = "Port " + ((SwitchImpl)sw).ifIndexToName(ifIndex);
                    descr = descr + (endDevices.length() == 0 ? "" : " (with end device:" + endDevices + ") ");
                    descr = descr + " in '" + mycard.getName() + "' in Slot " + mycard.getSlotId() + ": " + reason;
                }
                long srcId = 0L;
                try {
                    srcId = FcPortImpl.getSwitchPort(((SwitchImpl)sw).getDBID(), ifIndex);
                }
                catch (SQLException e) {
                    _Logger.info((Object)e.getLocalizedMessage());
                }
                Set<Integer> pgIds = AppGroupUtil.getInstance().getPortGroupId(srcId, ((SwitchImpl)sw).getDBID(), 3);
                this.logEvent(sw, LogEventType.PORT_DOWN, Severity.WARNING, descr, pgIds, srcId);
            }
        } else if (sw instanceof EthSwitchImpl) {
            EthPortImpl ep;
            Set<EthIslImpl> isls = ((EthSwitchImpl)sw).getLan().findEthIslsBySwPort(((EthSwitchImpl)sw).getSwitchPK(), ifIndex);
            if (isls != null && !isls.isEmpty()) {
                for (EthIslImpl isl : isls) {
                    isl.setPresent(false);
                }
            }
            if ((ep = ((EthSwitchImpl)sw).getLan().findEthPort(((EthSwitchImpl)sw).getSwitchPK(), ifIndex)).isPresent()) {
                endDevices = endDevices + " " + ep.getIfname();
            }
            ep.setIfOperMode(cause);
            ep.setOperStatusCause((short)cause);
            descr = ((EthSwitchImpl)sw).ifIndexToName(ifIndex) + " " + cause;
            Card mycard = InventoryManager.getInstance().findCard(sw.getSwitchPK(), IfIndexUtil.getIfIndexCard(ifIndex));
            if (mycard != null) {
                String reason = "N/A";
                svb = this.getVar(vbl, "ifOperStatus");
                if (svb != null) {
                    reason = svb.enumValue();
                }
                descr = "Port " + ((EthSwitchImpl)sw).ifIndexToName(ifIndex);
                descr = descr + (endDevices.length() == 0 ? "" : " (with end device:" + endDevices + ") ");
                descr = descr + " in '" + mycard.getName() + "' in Slot " + mycard.getSlotId() + ": " + reason;
            }
            LogEvent e = new LogEvent(LogEventType.PORT_DOWN, Severity.WARNING, "Trap " + sw.getName(), descr, System.currentTimeMillis(), sw.getInetAddress(), 1);
            long srcId = ep.getDBID();
            long eSwitchId = ((EthSwitchImpl)sw).getDBID();
            e.setSrcId(srcId);
            e.setSwitchId(eSwitchId);
            Set<Integer> pgIds = AppGroupUtil.getInstance().getPortGroupId(srcId, eSwitchId, 4);
            e.set_pgGroupIds(pgIds);
            this._logger.logEvent(e);
        }
    }

    void onDelayedLinkUpDown(SwitchIf<PKIf> sw, VarBindList vbl) {
        int ifIndex = vbl.getVb(2).getOid().getIndexFromEnd(0);
        StringBuilder sb = new StringBuilder();
        long srcId = 0L;
        if (sw instanceof SwitchImpl) {
            ArrayList<EndPortImpl> list = ((SwitchImpl)sw).getFabric().findEndPortsBySwitchIfIndex((SwitchImpl)sw, ifIndex);
            try {
                srcId = FcPortImpl.getSwitchPort(((SwitchImpl)sw).getDBID(), ifIndex);
            }
            catch (SQLException e1) {
                // empty catch block
            }
            if (list != null && !list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    EndPortImpl ep = (EndPortImpl)list.get(i);
                    try {
                        sb.append(ep.getEventDesc(LogEventType.PORT_DOWN, false));
                        continue;
                    }
                    catch (Exception e) {
                        if (!_Logger.isDebugEnabled()) continue;
                        _Logger.debug((Object)e.getMessage());
                    }
                }
            }
        } else if (sw instanceof EthSwitchImpl && _Logger.isInfoEnabled()) {
            _Logger.info((Object)("onDelayedLinkUpDown: " + vbl));
        }
        sb.append("State:");
        sb.append(vbl.enumValue(3));
        sb.append(", ");
        sb.append("Reason:");
        sb.append(vbl.enumValue(6));
        Set<Integer> pgIds = AppGroupUtil.getInstance().getPortGroupId(srcId, ((SwitchImpl)sw).getDBID(), 3);
        this.logEvent(sw, LogEventType.PORT_DOWN, Severity.WARNING, sb.toString(), pgIds, srcId);
    }

    void onVsanChangeTrap(SwitchImpl sw, VarBindList vbl) {
        short vid = (short)vbl.intValue(2);
        byte operState = (byte)vbl.intValue(4);
        VsanImpl vsan = sw.getVsan(vid);
        if (vsan != null) {
            vsan.setOperState(operState);
        } else {
            sw.getFabric().setDiscoveryType(DiscoveryType.FABRIC_AUTODEMAND);
            sw.getFabric().incrementChange(true);
        }
    }

    void onFspfTrap(SwitchIf<PKIf> sw, VarBindList vbl) {
        int ifIndex = vbl.intValue(2);
        short vid = (short)vbl.intValue(3);
        int did = vbl.intValue(4);
        int nbrDid = vbl.intValue(5);
        int state = vbl.intValue(6);
        if (sw instanceof SwitchImpl) {
            FabricImpl fabric = ((SwitchImpl)sw).getFabric();
            IslImpl isl = fabric.findIsl(new SwitchIntKey(((SwitchImpl)sw).getSwitchPK(), ifIndex));
            if (isl != null && isl.isMemberOfVsan(vid)) {
                if (state == 1) {
                    isl.setPresent(false);
                } else if (state == 6 && !isl.isPresent()) {
                    SwitchImpl nbrSw;
                    SwitchImpl sw1 = ((SwitchImpl)sw).findNeighborSwitch(vid, did);
                    SwitchImpl sw2 = ((SwitchImpl)sw).findNeighborSwitch(vid, nbrDid);
                    if (sw1 != null && sw2 != null && (nbrSw = isl.getNbrSwitch(sw1.getSwitchPK())) != null && nbrSw == sw2) {
                        isl.setPresent(true);
                    }
                }
            }
            ((SwitchImpl)sw).getFabric().incrementChange(true);
        } else if (sw instanceof EthSwitchImpl) {
            LanImpl lan;
            Set<EthIslImpl> isls;
            if (_Logger.isTraceEnabled()) {
                _Logger.trace((Object)("onFspfTrap: " + vbl));
            }
            if ((isls = (lan = ((EthSwitchImpl)sw).getLan()).findEthIslsBySwPort(((EthSwitchImpl)sw).getSwitchPK(), ifIndex)) != null) {
                for (EthIslImpl isl : isls) {
                    if (isl == null) continue;
                    if (state == 1) {
                        isl.setPresent(false);
                        continue;
                    }
                    if (state != 6 || isl.isPresent()) continue;
                    isl.setPresent(true);
                }
            }
        }
    }

    void onDidNotAssignedTrap(SwitchImpl sw, VarBindList vbl) {
        short vid = (short)vbl.intValue(2);
        VsanImpl vsan = sw.getVsan(vid);
        if (vsan != null) {
            Wwn wwn = new Wwn(vbl.byteValue(3));
            SwitchImpl sw1 = SanManager.getInstance().findSwitch(wwn, sw.getFabricPK());
            String descr = "Domain ID not configured or assigned on VSAN " + vid + ", switch(" + (sw1 == null ? wwn.toString() : sw1.toString()) + ") may isolate E_ports on that VSAN";
            this.logEvent(sw, LogEventType.VSAN, Severity.CRITICAL, descr);
        }
        sw.getFabric().incrementChange(false);
    }

    void onFiconPortInfoChange(SwitchImpl sw, VarBindList vbl) {
        try {
            VsanImpl vsan = sw.getVsan((short)vbl.intValue(2));
            if (vsan == null) {
                return;
            }
            List<EndPortImpl> epl = vsan.getEndPorts();
            for (EndPortImpl ep : epl) {
                if (((EndPortBase)ep.getBaseObject()).getFiconAddress() != vbl.intValue(3)) continue;
                if (!ep.isPresent()) {
                    String descr = "Ficon port unit type has changed to: " + vbl.enumValue(4) + "on VSAN: " + vsan.getId() + ", Port: " + ep.getName() + ", FICON: 0x" + Integer.toHexString(vbl.intValue(3));
                    EnclosureImpl encl = ep.getEnclosure();
                    String enclStr = encl != null ? encl.getEnclosureName() : null;
                    Set<Integer> pgIds = AppGroupUtil.getInstance().getPortGroupId(ep.getIfDbId(), sw.getDBID(), 3);
                    this.logEvent((SwitchIf<PKIf>)sw, LogEventType.FICON, Severity.INFO, descr, enclStr, pgIds, false);
                    ep.setOperStatusCause((short)2);
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void onEntityConfigChange(SwitchIf<PKIf> sw) {
        PKIf pk = sw.getSwitchPK();
        if (pk instanceof WwnKey) {
            InventoryManager.getInstance().poll((WwnKey)pk);
        } else if (pk instanceof SerialNumKey) {
            InventoryManager.getInstance().poll((SerialNumKey)pk);
        } else if (pk instanceof VdcPK) {
            InventoryManager.getInstance().poll((VdcPK)pk);
        }
    }

    void onNewPrinSwitchTrap(SwitchImpl sw, VarBindList vbl) {
        short vid = (short)vbl.intValue(2);
        VsanImpl vsan = sw.getVsan(vid);
        if (vsan != null) {
            Wwn wwn = new Wwn(vbl.byteValue(3));
            SwitchImpl prinSw = SanManager.getInstance().findSwitch(wwn, sw.getFabricPK());
            String descr = (prinSw != null ? prinSw.toString() : wwn.toString()) + " became the Principal Switch on VSAN" + vid;
            this.logEvent(sw, LogEventType.VSAN, Severity.INFO, descr);
        } else {
            sw.getFabric().incrementChange(false);
        }
    }

    void onFabricChangeTrap(SwitchImpl sw, VarBindList vbl) {
        short vid = (short)vbl.intValue(2);
        VsanImpl vsan = sw.getVsan(vid);
        if (vsan == null) {
            sw.getFabric().incrementChange(false);
        }
    }

    void onZoneMergeTrap(SwitchImpl sw, VarBindList vbl, boolean success) {
        int ifIndex = vbl.intValue(2);
        int vsanNum = vbl.intValue(3);
        StringBuffer descr = new StringBuffer(success ? "Activation succeeded" : "Activation failed");
        if (vsanNum == 0) {
            descr.append(", all VSANs ");
        } else {
            descr.append(", VSAN ").append(vsanNum);
        }
        descr.append(" on ").append(sw.ifIndexToName(ifIndex));
        this.logEvent(sw, LogEventType.ZONE, success ? Severity.INFO : Severity.ERROR, descr.toString());
    }

    void onFRUChange(SwitchIf<PKIf> sw, VarBindList vbl, int type) {
        final SwitchIf<PKIf> _sw = sw;
        final VarBindList _vbl = vbl;
        final int _type = type;
        Runnable rt = new Runnable(){

            @Override
            public void run() {
                LogEventType t;
                Severity sev;
                String descr;
                HwInventoryComponent c;
                String adddescr = "";
                int phyIndex = _vbl.getVb(2).getOid().getIndexFromEnd(0);
                adddescr = "physical index " + phyIndex;
                int slot = -99;
                SnmpPeer peer = null;
                if (_sw instanceof SwitchImpl) {
                    try {
                        peer = ((SwitchImpl)_sw).createPeer();
                    }
                    catch (SnmpException e) {
                        _Logger.warn((Object)("onFRUChange: failed to get SnmpPeer. " + e.getMessage()));
                    }
                } else if (_sw instanceof EthSwitchImpl) {
                    peer = ((EthSwitchImpl)_sw).getPeer();
                }
                if (peer == null) {
                    return;
                }
                try {
                    slot = peer.send(TrapHandler.this.buildPDU(_sw, _EntPhysicalParentRelPos, phyIndex)).getVariables().intValue(0);
                }
                catch (SnmpException e) {
                    adddescr = adddescr + " Exception reading slot : " + e.getMessage();
                }
                adddescr = adddescr + (slot == -99 ? " Could not Read Slot # from Switch " : " Read Slot from Switch " + slot);
                int n = slot = slot == -99 || slot == 0 && _type != 11 ? phyIndex - _sw.getModuleIndexOffset() : slot;
                if (_type != 11 && (c = InventoryManager.getInstance().findHardwareComponent((PKIf)_sw.getSwitchPK(), phyIndex)) != null && c.getHardwareType() == HwInventoryType.POWERSUPPLY) {
                    slot = c.getSlotId();
                }
                adddescr = adddescr + " Slot number calculated : " + slot;
                if (_type == 11) {
                    descr = "module inserted into slot " + slot;
                    sev = Severity.INFO;
                    t = LogEventType.SWITCH_HARDWARE;
                } else {
                    descr = "module removed from slot " + slot;
                    sev = Severity.CRITICAL;
                    t = LogEventType.SWITCH_HARDWARE;
                    if (SnmpSession.isTrace()) {
                        descr = descr + "[ added information : " + adddescr + " ] ";
                    }
                }
                TrapHandler.this.logEvent(_sw, t, sev, descr);
                Object pk = _sw.getSwitchPK();
                if (pk instanceof WwnKey) {
                    InventoryManager.getInstance().poll((WwnKey)pk, 1);
                } else if (pk instanceof SerialNumKey) {
                    InventoryManager.getInstance().poll((SerialNumKey)pk, 1);
                } else if (pk instanceof VdcPK) {
                    InventoryManager.getInstance().poll((VdcPK)pk, 1);
                }
            }
        };
        this._trapPool.execute(rt);
    }

    void onModuleStatusChangeTrap(SwitchIf<PKIf> sw, VarBindList vbl) {
        int phyIndex = vbl.getVb(2).getOid().getIndexFromEnd(0);
        int slot = phyIndex - sw.getModuleIndexOffset();
        int status = vbl.intValue(2);
        String statusDescr = vbl.enumValue(2);
        long timeStamp = vbl.longValue(3);
        InventoryManager.getInstance().updateCardStatus(sw.getSwitchPK(), phyIndex, status, statusDescr, timeStamp);
        Severity sev = status == 2 || status == 5 || status == 6 || status == 16 || status == 21 ? Severity.INFO : (status == 1 || status == 3 || status == 4 ? Severity.WARNING : Severity.ERROR);
        StringBuffer descr = new StringBuffer("module ");
        if (slot > 0 && slot <= 24) {
            descr.append(slot + ", ");
        }
        descr.append("status: " + statusDescr + ", lastChangeTime: " + SnmpTimeticks.formatTimeAsDate(sw.getSysUpTime() - timeStamp));
        this.logEvent(sw, LogEventType.SWITCH_HARDWARE, sev, descr.toString());
        PKIf pk = sw.getSwitchPK();
        if (pk instanceof WwnKey) {
            InventoryManager.getInstance().poll((WwnKey)pk, 1);
        } else if (pk instanceof SerialNumKey) {
            InventoryManager.getInstance().poll((SerialNumKey)pk, 1);
        } else if (pk instanceof VdcPK) {
            InventoryManager.getInstance().poll((VdcPK)pk, 1);
        }
    }

    void onPowerStatusChangeTrap(SwitchIf<PKIf> sw, VarBindList vbl) {
        final SwitchIf<PKIf> _sw = sw;
        final VarBindList _vbl = vbl;
        Runnable rt = new Runnable(){

            @Override
            public void run() {
                String adddescr = "";
                int phyIndex = _vbl.getVb(2).getOid().getIndexFromEnd(0);
                adddescr = "physical index " + phyIndex;
                int status = _vbl.intValue(2);
                int slot = -99;
                SnmpPeer peer = null;
                if (_sw instanceof SwitchImpl) {
                    try {
                        peer = ((SwitchImpl)_sw).createPeer();
                    }
                    catch (SnmpException e) {
                        _Logger.warn((Object)("onPowerStatusChangeTrap: failed to get SnmpPeer. " + e.getMessage()));
                    }
                } else if (_sw instanceof EthSwitchImpl) {
                    peer = ((EthSwitchImpl)_sw).getPeer();
                }
                if (peer == null) {
                    return;
                }
                try {
                    slot = peer.send(TrapHandler.this.buildPDU(_sw, _EntPhysicalParentRelPos, phyIndex)).getVariables().intValue(0);
                }
                catch (SnmpException e) {
                    adddescr = adddescr + " Exception reading slot : " + e.getMessage();
                }
                adddescr = adddescr + (slot == -99 ? " Could not Read Slot # from Switch " : " Read Slot from Switch " + slot);
                slot = slot == -99 || slot == 0 ? phyIndex - _sw.getModuleIndexOffset() : slot;
                HwInventoryComponent c = InventoryManager.getInstance().findHardwareComponent((PKIf)_sw.getSwitchPK(), phyIndex);
                if (c != null && c.getHardwareType() == HwInventoryType.POWERSUPPLY) {
                    slot = c.getSlotId();
                }
                adddescr = adddescr + " Slot number calculated : " + slot;
                Severity sev = status == 2 || status == 3 ? Severity.INFO : Severity.WARNING;
                String descr = "module " + slot + ", Operational power: " + _vbl.enumValue(2) + ", Administratively desired power: " + _vbl.enumValue(3);
                if (SnmpSession.isTrace()) {
                    descr = descr + "[ added information : " + adddescr + " ] ";
                }
                TrapHandler.this.logEvent(_sw, LogEventType.SWITCH_HARDWARE, sev, descr);
            }
        };
        this._trapPool.execute(rt);
    }

    void onFanStatusChangeTrap(SwitchIf<PKIf> sw, VarBindList vbl) {
        final SwitchIf<PKIf> _sw = sw;
        final VarBindList _vbl = vbl;
        Runnable rt = new Runnable(){

            @Override
            public void run() {
                int phyIndex = _vbl.getVb(2).getOid().getIndexFromEnd(0);
                int status = _vbl.intValue(2);
                String statusDescr = _vbl.enumValue(2);
                SnmpPeer peer = null;
                if (_sw instanceof SwitchImpl) {
                    try {
                        peer = ((SwitchImpl)_sw).createPeer();
                    }
                    catch (SnmpException e) {
                        _Logger.warn((Object)("onFRUChange: failed to get SnmpPeer. " + e.getMessage()));
                    }
                } else if (_sw instanceof EthSwitchImpl) {
                    peer = ((EthSwitchImpl)_sw).getPeer();
                }
                if (peer == null) {
                    return;
                }
                int slot = -99;
                try {
                    slot = peer.send(TrapHandler.this.buildPDU(_sw, _EntPhysicalParentRelPos, phyIndex)).getVariables().intValue(0);
                }
                catch (SnmpException e) {
                    // empty catch block
                }
                slot = slot == -99 ? phyIndex - (((SwitchImpl)_sw).isVersionGreaterThanEqual("3.0") ? 534 : 40) + 1 : slot;
                String descr = "Fan tray " + slot + ", status: " + statusDescr;
                TrapHandler.this.logEvent(_sw, LogEventType.SWITCH_HARDWARE, status == 2 ? Severity.INFO : (status == 3 ? Severity.CRITICAL : Severity.WARNING), descr);
            }
        };
        this._trapPool.execute(rt);
    }

    void onCFSFeatureAction(SwitchImpl sw, VarBindList vbl) {
        SnmpOID oid = vbl.getVb(2).getOid();
        SnmpOID expOid = new SnmpOID(MibNode.get("cfsFeatureOpLastAction").getOid());
        int offset = expOid.getValue().length + 1;
        int[] index = oid.getValue();
        int len = index.length;
        String name = SnmpString.toString(index, offset, len);
        String descr = "feature " + name + ", lastAction: " + vbl.enumValue(2) + ", lastActionResult: " + vbl.enumValue(5);
        this.logEvent(sw, LogEventType.OTHER, Severity.INFO, descr, true);
        if (name.contains("device-alias")) {
            FabricImpl fabric = sw.getFabric();
            FabricWorker fWorker = fabric.getWorker();
            if (fWorker.getStatus() == 1 && fWorker.getDiscoveryType() == DiscoveryType.FABRIC_POLL) {
                fWorker.setNeedRediscover(true);
            } else {
                fWorker.setDiscoveryType(DiscoveryType.FABRIC_AUTODEMAND);
                sw.getFabric().incrementChange(false);
            }
        }
    }

    void onHaRestartTrap(SwitchIf<PKIf> sw, VarBindList vbl) {
        String descr = (vbl.intValue(4) == 1 ? "stateless " : "") + "service/process " + vbl.stringValue(3) + " restarted on the active supervisor " + "[ " + sw.getIpAddress() + " ] for reason of " + vbl.enumValue(2);
        this.logEvent(sw, LogEventType.OTHER, Severity.CRITICAL, descr, true);
    }

    void onRFSwactTrap(SwitchIf<PKIf> sw, VarBindList vbl) {
        long timeStamp = vbl.longValue(3);
        String descr = "Switch of activity: module " + (vbl.intValue(2) - sw.getModuleIndexOffset()) + ", reason: " + vbl.enumValue(4) + ", at " + SnmpTimeticks.formatTimeAsDate(sw.getSysUpTime() - timeStamp);
        this.logEvent(sw, LogEventType.SWITCH_MANAGEABILITY, Severity.WARNING, descr);
    }

    void onPsmDenyTrap(SwitchImpl sw, VarBindList vbl, int type) {
        SnmpOID oid = vbl.getVb(2).getOid();
        Wwn loginWwn = new Wwn(vbl.byteValue(2));
        Wwn localWwn = type == 21 ? null : new Wwn(vbl.byteValue(3));
        long timeStamp = vbl.longValue(type == 21 ? 3 : 4);
        StringBuffer sb = new StringBuffer("Port Security: violation index: ").append(oid.getIndexFromEnd(0)).append(", ");
        if (type == 20 || type == 21) {
            sb.append("switch WWN: ").append(loginWwn);
            if (type == 20) {
                sb.append(", local device port: ").append(localWwn);
            }
        } else {
            sb.append("device ").append(type == 18 ? (char)'p' : 's').append("WWN: ");
            sb.append(loginWwn).append(", local device port: ").append(localWwn).append(" on ").append(oid.getIndexFromEnd(2) == 1 ? "VSAN" : "VLAN").append(oid.getIndexFromEnd(1));
        }
        sb.append(", ").append(SnmpTimeticks.formatTimeAsDate(sw.getSysUpTime() - timeStamp));
        this.logEvent(sw, LogEventType.SECURITY, Severity.ERROR, sb.toString(), true);
    }

    void onImageUpgradeTrap(SwitchIf<PKIf> sw, VarBindList vbl) {
        int status = vbl.intValue(3);
        if (status == 4 || status == 6) {
            return;
        }
        this.logEvent(sw, LogEventType.OTHER, Severity.INFO, "Image upgrade, operation: " + vbl.enumValue(2) + ", status: " + vbl.enumValue(3) + ", time: " + SnmpTimeticks.formatTimeAsDate(sw.getSysUpTime() - vbl.longValue(4)), true);
    }

    void onVrrpTrap(SwitchImpl sw, VarBindList vbl) {
        SnmpOID oid = vbl.getVb(2).getOid();
        this.logEvent(sw, LogEventType.OTHER, Severity.INFO, "VRRP, master router's primary IP address: " + vbl.stringValue(2) + ", " + sw.ifIndexToName(oid.getIndexFromEnd(1)) + ", VRID: " + oid.getIndexFromEnd(0), true);
    }

    void onZoneBehaviorTrap(SwitchImpl sw, VarBindList vbl) {
        int vsan = vbl.getVb(2).getOid().getIndexFromEnd(0);
        String descr = sw.getFabric().toString() + ", VSAN" + vsan + " default zone behavior changed to " + (vbl.intValue(2) == 1 ? "permit" : "deny");
        this.logEvent(sw, LogEventType.ZONE, Severity.INFO, descr);
    }

    void onFeatureControlChangeTrap(SwitchImpl sw, VarBindList vbl) {
        int featureId = vbl.getVb(2).getOid().getIndexFromEnd(0);
        boolean enabled = vbl.intValue(2) == 2;
        sw.setFeatureEnabled(featureId - 1, enabled);
    }

    void onIvrActivationTrap(SwitchImpl sw, VarBindList vbl) {
        if (sw.getFabric().getIvrSeed() != null && sw.getFabric().getIvrSeed() != sw) {
            return;
        }
        int result = vbl.intValue(3);
        if (result > 12 && result < 16) {
            return;
        }
        String zoneset = vbl.stringValue(2);
        StringBuffer descr = new StringBuffer(sw.getFabric().toString());
        descr.append(", IVR zoneset ").append(zoneset);
        if (result == 1) {
            descr.append(" activated");
            sw.getFabric().setIvrEnforcedZoneSetName(zoneset);
        } else if (result == 9) {
            descr.append(" deactivated");
            sw.getFabric().setIvrEnforcedZoneSetName(null);
        } else {
            descr.append(vbl.enumValue(3));
        }
        if (vbl.intValue(4) == 1) {
            descr.append(" partially");
        }
        this.logEvent(sw, LogEventType.IVR, Severity.INFO, descr.toString());
    }

    void onIvrDomainConflictTrap(SwitchImpl sw, VarBindList vbl) {
        if (sw.getFabric().getIvrSeed() != null && sw.getFabric().getIvrSeed() != sw) {
            return;
        }
        Wwn pwwn = new Wwn(vbl.byteValue(2));
        int mbrVid = vbl.intValue(3);
        byte[] fcid = vbl.byteValue(4);
        int conflictVid = vbl.intValue(5);
        StringBuffer descr = new StringBuffer(sw.getFabric().toString());
        descr.append(", enforced zone member ");
        EndPortImpl ep = SanManager.getInstance().findEndPortByWwn(pwwn);
        String enc = null;
        if (ep != null) {
            descr.append(ep.getPortWwn() + "(" + ep.getName() + ")");
            enc = ep.getEnclosure() != null ? ep.getEnclosure().getName() : null;
        } else {
            descr.append(pwwn.toString());
        }
        descr.append(" of VSAN").append(mbrVid).append(" has domain ID=").append(fcid[0] & 0xFF).append(" conflict in VSAN").append(conflictVid);
        Set<Integer> pgIds = AppGroupUtil.getInstance().getPortGroupId(ep.getIfDbId(), sw.getDBID(), 3);
        this.logEvent((SwitchIf<PKIf>)sw, LogEventType.IVR, Severity.INFO, descr.toString(), enc, pgIds, false);
    }

    void onIvrAfidMisConfigTrap(SwitchImpl sw, VarBindList vbl) {
        if (sw.getFabric().getIvrSeed() != null && sw.getFabric().getIvrSeed() != sw) {
            return;
        }
        if (vbl.size() < 7) {
            return;
        }
        StringBuffer descr = new StringBuffer(sw.getFabric().toString());
        descr.append(" AFID Misconfiguration, local afid=" + vbl.intValue(2) + " remote afid, swwn=" + vbl.intValue(3) + ", " + new Wwn(vbl.byteValue(5)));
        descr.append(", VSAN " + vbl.intValue(6));
        this.logEvent(sw, LogEventType.IVR, Severity.WARNING, descr.toString());
    }

    void onNsEntryTrap(SwitchIf<PKIf> sw, VarBindList vbl) {
        if (sw instanceof SwitchImpl) {
            boolean add = ((SnmpOID)vbl.getVb(1).getVar()).startsWith(_AffectModelTrapOids[30]);
            int[] oid = vbl.getVb(2).getOid().getValue();
            short vid = (short)oid[oid.length - 4];
            int fcid = (oid[oid.length - 3] << 16) + (oid[oid.length - 2] << 8) + oid[oid.length - 1];
            Wwn pwwn = new Wwn(vbl.byteValue(2));
            EndPortImpl ep = SanManager.getInstance().findEndPortByWwn(pwwn);
            int type = vbl.intValue(3);
            VsanImpl vsan = ((SwitchImpl)sw).getVsan(vid);
            int domainId = oid[oid.length - 3];
            if (vsan != null && vsan.getInterOperMode() == 4) {
                domainId -= 96;
            }
            if (ep != null) {
                if (add) {
                    if (vsan != null) {
                        SwitchImpl nbrsw;
                        short[] vids = ep.getVsanMembership();
                        if (!ep.isPresent() && vids != null) {
                            for (int i = 0; i < vids.length; ++i) {
                                VsanImpl v;
                                if (vids[i] == vid || (v = ((SwitchImpl)sw).getVsan(vids[i])) == null) continue;
                                v.removeEndPort(ep);
                            }
                        }
                        if ((nbrsw = ((SwitchImpl)sw).findNeighborSwitch(vid, domainId)) == null) {
                            if (_Logger.isDebugEnabled()) {
                                _Logger.debug((Object)("ignoring NxPort " + pwwn + "(" + ep.getName() + ")" + " attached to unknown FxPort on domain " + domainId + " in VSAN " + vid));
                            }
                        } else {
                            vsan.addEndPort(ep, fcid);
                        }
                    }
                } else {
                    ((SwitchImpl)sw).getFabric().incrementChange(false);
                }
                ep.setLoop(type == 3);
            }
            if (_Logger.isDebugEnabled()) {
                _Logger.debug((Object)((type == 3 ? "NL" : "N") + "_Port " + pwwn + " " + (add ? "up" : "down") + " in VSAN " + vid));
            }
        } else if (sw instanceof EthSwitchImpl && _Logger.isInfoEnabled()) {
            _Logger.info((Object)("onNsEntryTrap: " + vbl.toString()));
        }
    }

    private void onZoneActivateNotify(SwitchImpl sw, VarBindList vbl, boolean b) {
        String[] result = new String[]{"activation succeeded", "activation failed", "deactivation succeeded", "deactivation failed", "activation in progress", "entry just created"};
        int zoneSetActivateResult = vbl.intValue(2);
        Wwn zoneSwitchWwn = new Wwn(vbl.byteValue(3));
        int vsan = vbl.getVb(2).getOid().getIndexFromEnd(0);
        String switchdesc = zoneSwitchWwn.toString();
        SwitchImpl zoneSwitch = SanManager.getInstance().findSwitch(zoneSwitchWwn, sw.getFabricPK());
        if (zoneSwitch != null) {
            switchdesc = zoneSwitch.getName();
        }
        String descr = "Zoneset changed: " + sw.getFabric().toString() + ", VSAN" + vsan + " zone " + result[zoneSetActivateResult - 1] + " on " + switchdesc;
        this.logEvent(sw, LogEventType.ZONE, zoneSetActivateResult == 2 || zoneSetActivateResult == 4 ? Severity.WARNING : Severity.INFO, descr);
        FabricImpl fabric = sw.getFabric();
        FabricWorker fWorker = fabric.getWorker();
        if (fWorker.getStatus() == 1 && fWorker.getDiscoveryType() == DiscoveryType.FABRIC_POLL) {
            fWorker.setNeedRediscover(true);
        } else {
            fWorker.setDiscoveryType(DiscoveryType.FABRIC_ON_DEMAND_ZONE_ONLY);
            sw.getFabric().incrementChange(false);
        }
    }

    void onLicenseTrap(SwitchIf<PKIf> sw, SnmpOID trapOid, VarBindList vbl) {
        StringBuffer sb = new StringBuffer();
        sb.append(MibNode.oidToName(trapOid.getValue())).append(", ");
        int max = vbl.size();
        for (int i = 2; i < max; ++i) {
            SnmpOID oid = vbl.getVb(i).getOid();
            if (oid.startsWith(_SnmpTrapEnterprise)) continue;
            String name = MibNode.oidToName(oid.getValue());
            String mibDescriptor = "";
            if (i == 2) {
                String var = name;
                int varlen = name.indexOf(46);
                if (varlen > 0) {
                    var = name.substring(0, varlen);
                }
                SnmpOID expOid = new SnmpOID(MibNode.get(var).getOid());
                int offset = expOid.getValue().length + 1;
                int[] index = oid.getValue();
                int len = index.length;
                mibDescriptor = name.substring(0, name.indexOf("."));
                String indexName = SnmpString.toString(index, offset, len);
                mibDescriptor = mibDescriptor + "." + indexName;
            }
            sb.append(mibDescriptor);
            sb.append('=');
            int len = name.indexOf(46);
            if (len == -1) {
                len = name.length();
            }
            if (name.startsWith("clmLicenseGracePeriod")) {
                long grace = vbl.longValue(i);
                int ss = (int)(grace % 60L);
                int m = (int)(grace / 60L);
                int hh = m / 60;
                int dd = hh / 24;
                m %= 60;
                if ((hh %= 24) > 0 || dd > 0) {
                    sb.append((dd > 0 ? dd + " days " : "") + (hh > 0 ? hh + " hours " : ""));
                    break;
                }
                sb.append((m > 0 ? m + " mins " : "") + (ss > 0 ? ss + " seconds " : ""));
                break;
            }
            if (name.startsWith("clmLicenseExpiryDate")) {
                sb.append(SnmpDateAndTime.toString(vbl.byteValue(i)));
                break;
            }
            if (!name.startsWith("clmNoOfMissingUsageLicenses")) break;
            sb.append(vbl.intValue(i));
            break;
        }
        this.logEvent(sw, LogEventType.LICENSE, Severity.WARNING, sb.toString(), true);
        if (trapOid.startsWith(_LicenseMgrOids[0]) || trapOid.startsWith(_LicenseMgrOids[3])) {
            PKIf pk = sw.getSwitchPK();
            if (pk instanceof WwnKey) {
                InventoryManager.getInstance().poll((WwnKey)pk);
            } else if (pk instanceof SerialNumKey) {
                InventoryManager.getInstance().poll((SerialNumKey)pk);
            } else if (pk instanceof VdcPK) {
                InventoryManager.getInstance().poll((VdcPK)pk);
            }
        }
    }

    void onSmeInterfChange(SwitchImpl sw, VarBindList vbl, int type) {
        final SwitchImpl _sw = sw;
        final VarBindList _vbl = vbl;
        final int _type = type;
        Runnable rt = new Runnable(){

            @Override
            public void run() {
                LogEventType t;
                Severity sev;
                String descr = "";
                int ifIndex = _vbl.getVb(2).getOid().getIndexFromEnd(0);
                short status = (short)_vbl.intValue(2);
                if (_type == 36) {
                    FcPortBase port = _sw.createPort(ifIndex);
                    port.setSMEState(status);
                    descr = "SME interface " + _sw.ifIndexToName(ifIndex) + " created";
                    sev = Severity.INFO;
                    t = LogEventType.OTHER;
                } else {
                    _sw.removePort(ifIndex);
                    descr = "SME interface " + _sw.ifIndexToName(ifIndex) + " removed";
                    sev = Severity.INFO;
                    t = LogEventType.OTHER;
                }
                TrapHandler.this.logEvent(_sw, t, sev, descr);
            }
        };
        this._trapPool.execute(rt);
    }

    void onRmonTrap(SwitchImpl sw, VarBindList vbl, LogEventType type, boolean rising) {
        int alarmInterValadj;
        StringBuilder sb = new StringBuilder();
        int ifIndex = 0;
        long speed = 0L;
        long thresholdRLo = 0L;
        long thresholdRHi = 0L;
        long thresholdR = 0L;
        long thresholdFLo = 0L;
        long thresholdFHi = 0L;
        long thresholdF = 0L;
        long srcId = 0L;
        BigInteger alarmValue = BigInteger.ZERO;
        int alarmInterVal = 0;
        BigInteger brthreshold = null;
        BigInteger bfthreshold = null;
        String mstr = "";
        String bsuffix = "";
        String enclosure = "";
        boolean isAlarmValueValid = true;
        boolean isDeltaType = true;
        long switchId = 0L;
        if (sw != null) {
            switchId = sw.getDBID();
        }
        Severity sev = rising ? Severity.WARNING : Severity.INFO;
        block6: for (int i = 2; i < vbl.size(); ++i) {
            int j;
            SnmpOID oid = vbl.getVb(i).getOid();
            boolean cont = false;
            if (oid.startsWith(_SnmpTrapEnterprise)) continue;
            if (vbl.getVb(i).getVar().getType() == 6) {
                for (j = 0; j < _RmonVariableOids.length; ++j) {
                    if (!oid.startsWith(_RmonVariableOids[j])) continue;
                    ifIndex = ((SnmpOID)vbl.getVb(i).getVar()).getIndexFromEnd(0);
                    try {
                        srcId = FcPortImpl.getSwitchPort(switchId, ifIndex);
                    }
                    catch (SQLException e1) {
                        // empty catch block
                    }
                    IslImpl isl = sw.getFabric().findIsl(new SwitchIntKey(sw.getSwitchPK(), ifIndex));
                    if (isl != null) {
                        try {
                            sb.append(isl.getEventDesc(type, false));
                        }
                        catch (Exception e) {
                            if (_Logger.isDebugEnabled()) {
                                _Logger.debug((Object)e.getMessage());
                            }
                            return;
                        }
                        speed = isl.getSpeed();
                    } else {
                        String vsans;
                        FcPortBase fcport = sw.findPort(ifIndex);
                        ArrayList<EndPortImpl> list = sw.getFabric().findEndPortsBySwitchIfIndex(sw, ifIndex);
                        String switchPort = fcport == null ? "" : fcport.getDisplayName();
                        String string = vsans = fcport == null ? "" : fcport.getVsansAsString();
                        if (fcport != null && list != null && !list.isEmpty()) {
                            speed = fcport.getIfSpeed();
                            enclosure = this.printString(sb, list, switchPort, vsans);
                        } else {
                            NpvLinkImpl nplink = sw.getFabric().findNpvLink(sw, ifIndex);
                            if (nplink != null) {
                                try {
                                    sb.append(nplink.getEventDesc(type, false));
                                }
                                catch (Exception e) {
                                    if (_Logger.isDebugEnabled()) {
                                        _Logger.debug((Object)e.getMessage());
                                    }
                                    return;
                                }
                            } else if (ifIndex != 0) {
                                sb.append("Other: Port: ");
                                sb.append(sw.ifIndexToName(ifIndex));
                                sb.append(", ");
                            }
                        }
                    }
                    String str = MibNode.oidToName(((SnmpOID)vbl.getVb(i).getVar()).toString());
                    str = str.substring(0, str.indexOf(46));
                    mstr = _PMOidStrs.get(str);
                    if (mstr != null) {
                        type = LogEventType.PORT_ALARM;
                    } else {
                        mstr = str;
                        sb = new StringBuilder();
                    }
                    if (mstr.indexOf("Bytes") != -1) {
                        bsuffix = "B";
                    }
                    sb.append("Reason: ");
                    continue block6;
                }
                continue;
            }
            for (j = 0; j < _AlarmSampleTypeOids.length; ++j) {
                if (!oid.startsWith(_AlarmSampleTypeOids[j])) continue;
                if (vbl.stringValue(i).equalsIgnoreCase("absoluteValue")) {
                    isDeltaType = false;
                }
                cont = true;
                break;
            }
            if (cont) continue;
            for (j = 0; j < _AlarmValueOids.length; ++j) {
                if (!oid.startsWith(_AlarmValueOids[j])) continue;
                if (vbl.getVb(i) != null && vbl.getVb(i).getVar() != null) {
                    SnmpVar var = vbl.getVb(i).getVar();
                    alarmValue = var.getType() == 70 ? ((SnmpCounter64)var).getBigValue() : BigInteger.valueOf(vbl.longValue(i));
                }
                cont = true;
                break;
            }
            if (cont) continue;
            for (j = 0; j < _AlarmIntervals.length; ++j) {
                if (!oid.startsWith(_AlarmIntervals[j])) continue;
                alarmInterVal = vbl.intValue(i);
                cont = true;
                break;
            }
            if (cont) continue;
            for (j = 0; j < _AlarmRisingThresholdLoOids.length; ++j) {
                if (!oid.startsWith(_AlarmRisingThresholdLoOids[j])) continue;
                thresholdRLo = vbl.longValue(i);
                cont = true;
                break;
            }
            if (cont) continue;
            for (j = 0; j < _AlarmRisingThresholdHiOids.length; ++j) {
                if (!oid.startsWith(_AlarmRisingThresholdHiOids[j])) continue;
                thresholdRHi = vbl.longValue(i);
                cont = true;
                break;
            }
            if (cont) continue;
            for (j = 0; j < _AlarmValueStatusOids.length; ++j) {
                if (!oid.startsWith(_AlarmValueStatusOids[j])) continue;
                if (vbl.intValue(i) == 1) {
                    isAlarmValueValid = false;
                } else if (vbl.intValue(i) == 3) {
                    alarmValue = alarmValue.abs();
                }
                cont = true;
                break;
            }
            if (cont) continue;
            for (j = 0; j < _AlarmFallingThresholdLoOids.length; ++j) {
                if (!oid.startsWith(_AlarmFallingThresholdLoOids[j])) continue;
                thresholdFLo = vbl.longValue(i);
                cont = true;
                break;
            }
            if (cont) continue;
            for (j = 0; j < _AlarmFallingThresholdHiOids.length; ++j) {
                if (!oid.startsWith(_AlarmFallingThresholdHiOids[j])) continue;
                thresholdFHi = vbl.longValue(i);
                cont = true;
                break;
            }
            if (cont) continue;
            if (oid.startsWith(_AlarmRisingThresholdOid)) {
                thresholdR = vbl.longValue(i);
                continue;
            }
            if (!oid.startsWith(_AlarmFallingThresholdOid)) continue;
            thresholdF = vbl.longValue(i);
        }
        if (thresholdRHi == 0L) {
            thresholdR = thresholdRLo;
        } else {
            int i;
            byte[] bytes = new byte[8];
            for (i = 0; i < 4; ++i) {
                bytes[i] = (byte)(thresholdRHi >> (3 - i) * 8 & 0xFFL);
            }
            for (i = 4; i < 8; ++i) {
                bytes[i] = (byte)(thresholdRLo >> (7 - i) * 8 & 0xFFL);
            }
            brthreshold = new BigInteger(bytes);
        }
        if (thresholdFHi == 0L) {
            thresholdF = thresholdFLo;
        } else {
            int i;
            byte[] bytes = new byte[8];
            for (i = 0; i < 4; ++i) {
                bytes[i] = (byte)(thresholdFHi >>> (3 - i) * 8 & 0xFFL);
            }
            for (i = 4; i < 8; ++i) {
                bytes[i] = (byte)(thresholdFLo >>> (7 - i) * 8 & 0xFFL);
            }
            bfthreshold = new BigInteger(bytes);
        }
        sb.append(mstr);
        String sign = rising ? " >= " : " <= ";
        BigInteger bthreshold = rising ? brthreshold : bfthreshold;
        long threshold = rising ? thresholdR : thresholdF;
        int n = alarmInterValadj = alarmInterVal == 0 ? 60 : alarmInterVal;
        if (bsuffix.length() == 0 || speed == 0L) {
            sb.append(sign);
            if (bthreshold != null) {
                sb.append(DefaultSnmpNumberRenderer.formatBigInt(bthreshold) + bsuffix);
            } else {
                sb.append(DefaultSnmpNumberRenderer.formatLong(threshold, DefaultSnmpNumberRenderer.NUM_FORMAT_0_PREC) + bsuffix);
            }
        } else {
            double pvalue = 0.0;
            pvalue = bthreshold != null ? bthreshold.multiply(BigInteger.valueOf(800L)).divide(BigInteger.valueOf((long)alarmInterValadj * speed)).doubleValue() : (double)threshold * 100.0 * 8.0 / (double)((long)alarmInterValadj * speed);
            sb.append(sign);
            sb.append(new DecimalFormat("0.00000").format(pvalue)).append("%").append(isDeltaType ? "" : "(Absolute)").append(" of " + DefaultSnmpNumberRenderer.formatLong(speed)).append("bps");
            if (isAlarmValueValid) {
                sb.append(", now = ");
                double ppvalue = alarmValue.multiply(BigInteger.valueOf(800L)).divide(BigInteger.valueOf((long)alarmInterValadj * speed)).doubleValue();
                sb.append(new DecimalFormat("0.00000").format(ppvalue)).append("%");
            }
            if (alarmInterVal == 0) {
                sb.append(" [ASSUME 60s INTERVAL]");
            }
        }
        Set<Integer> pgIds = AppGroupUtil.getInstance().getPortGroupId(srcId, sw.getDBID(), 3);
        this.logEvent((SwitchIf<PKIf>)sw, type, sev, sb.toString(), enclosure, pgIds, srcId);
    }

    public String printString(StringBuilder sb, List<EndPortImpl> list, String switchPort, String vsans) {
        if (sb == null) {
            return null;
        }
        if (switchPort == null) {
            switchPort = "?";
        }
        HashMap<String, StringBuilder> encls = new HashMap<String, StringBuilder>();
        StringBuilder sbencl = new StringBuilder();
        for (EndPortImpl endPortImpl : list) {
            String name;
            EnclosureImpl encl = endPortImpl.getEnclosure();
            if (encl == null || (name = encl.getName()) == null) continue;
            sb.append(name);
            sb.append("|");
            String type = ((EnclosureBase)encl.getBaseObject()).getTypeName();
            StringBuilder names = null;
            names = (StringBuilder)encls.get(type);
            if (names == null) {
                encls.put(type, new StringBuilder(name));
                continue;
            }
            names.append(", ");
            names.append(name);
            encls.put(type, names);
        }
        for (Map.Entry entry : encls.entrySet()) {
            sb.append((String)entry.getKey());
            sb.append(": ");
            StringBuilder tmp = ((StringBuilder)entry.getValue()).append(", ");
            sb.append((CharSequence)tmp);
        }
        sb.append("Port: " + switchPort);
        sb.append(", VSAN: " + vsans + ", ");
        if (sbencl.length() != 0) {
            return sbencl.substring(0, sbencl.length() - 1).toString();
        }
        return null;
    }

    void onSFPDiagTrap(SwitchImpl sw, VarBindList vbl) {
        StringBuilder sb = new StringBuilder();
        LogEventType type = LogEventType.PORT_ALARM;
        Severity sev = Severity.INFO;
        boolean logging = false;
        String enclosure = "";
        long srcId = 0L;
        long switchId = 0L;
        if (sw != null) {
            switchId = sw.getDBID();
        }
        if (vbl.getOid(2).startsWith(MibNode.get("ifName").getOid())) {
            int ifIndex = vbl.getOid(2).getIndexFromEnd(0);
            try {
                srcId = FcPortImpl.getSwitchPort(switchId, ifIndex);
            }
            catch (SQLException e1) {
                // empty catch block
            }
            IslImpl isl = sw.getFabric().findIsl(new SwitchIntKey(sw.getSwitchPK(), ifIndex));
            if (isl != null) {
                try {
                    sb.append(isl.getEventDesc(type, false));
                }
                catch (Exception e) {
                    if (_Logger.isDebugEnabled()) {
                        _Logger.debug((Object)e.getMessage());
                    }
                    return;
                }
            } else {
                String vsans;
                ArrayList<EndPortImpl> list = sw.getFabric().findEndPortsBySwitchIfIndex(sw, ifIndex);
                FcPortBase fcport = sw.findPort(ifIndex);
                String switchPort = fcport == null ? "" : fcport.getDisplayName();
                String string = vsans = fcport == null ? "" : fcport.getVsansAsString();
                if (list != null && !list.isEmpty()) {
                    enclosure = this.printString(sb, list, switchPort, vsans);
                } else {
                    NpvLinkImpl nplink = sw.getFabric().findNpvLink(sw, ifIndex);
                    if (nplink != null) {
                        try {
                            sb.append(nplink.getEventDesc(type, false));
                        }
                        catch (Exception e) {
                            if (_Logger.isDebugEnabled()) {
                                _Logger.debug((Object)e.getMessage());
                            }
                            return;
                        }
                    } else {
                        sb.append("Other: Port: ");
                        sb.append(sw.ifIndexToName(ifIndex));
                        sb.append(", ");
                    }
                }
            }
        } else {
            sb.append(vbl.get(2).toString());
        }
        sb.append("Reason: SFP DigitalDiag, ");
        int max = vbl.size();
        for (int i = 3; i < max; ++i) {
            MibEnum[] enums;
            String st;
            int status;
            SnmpOID oid = vbl.getVb(i).getOid();
            if (oid.startsWith(_SnmpTrapEnterprise) || (status = vbl.intValue(i)) == 0 || status == 5) continue;
            String name = MibNode.oidToName(oid.getValue());
            String display = "";
            if (!name.startsWith(SFP_DIAG_PREFIX)) continue;
            display = name.substring(SFP_DIAG_PREFIX.length());
            logging = true;
            sb.append(display);
            sb.append(":");
            int len = name.indexOf(46);
            if (len == -1) {
                len = name.length();
            }
            if ((st = MibEnum.getLabel(enums = MibNode.get(name.substring(0, len)).getEnums(), status)).equalsIgnoreCase("highSet") || st.equalsIgnoreCase("lowSet")) {
                sev = Severity.WARNING;
            }
            sb.append(st);
        }
        if (logging) {
            Set<Integer> pgIds = AppGroupUtil.getInstance().getPortGroupId(srcId, sw.getDBID(), 3);
            this.logEvent((SwitchIf<PKIf>)sw, type, sev, sb.toString(), enclosure, pgIds, srcId);
        }
    }

    void onOtherTrap(SwitchIf<PKIf> sw, SnmpOID trapOid, VarBindList vbl) {
        Severity sev;
        LogEventType type = LogEventType.OTHER;
        if (_SecurityOIDSet.contains(trapOid)) {
            type = LogEventType.SECURITY;
        } else if (trapOid.startsWith(_VsanPortChangeNotif)) {
            type = LogEventType.VSAN;
        }
        StringBuilder enclosure = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        sb.append(MibNode.oidToName(trapOid.getValue())).append(", ");
        int max = vbl.size();
        for (int i = 2; i < max; ++i) {
            int code;
            SnmpOID oid = vbl.getVb(i).getOid();
            if (oid.startsWith(_SnmpTrapEnterprise)) continue;
            String name = MibNode.oidToName(oid.getValue());
            String mibDescriptor = null;
            if (sw instanceof SwitchImpl) {
                mibDescriptor = NotificationLogUtil.formatMibDescriptor(name, (SwitchBase)((SwitchImpl)sw).getBaseObject());
            } else if (sw instanceof VdcImpl) {
                VdcBase base = ((VdcImpl)sw).getBase();
                mibDescriptor = NotificationLogUtil.formatMibDescriptor(name, base);
            } else if (sw instanceof EthSwitchImpl) {
                mibDescriptor = NotificationLogUtil.formatMibDescriptor(name, (SwitchBase)((EthSwitchImpl)sw).getBaseObject());
            }
            sb.append(mibDescriptor);
            sb.append('=');
            int len = name.indexOf(46);
            if (len == -1) {
                len = name.length();
            }
            SnmpVar var = vbl.getVb(i).getVar();
            if (trapOid.startsWith(_CFSFeatureActionOid) && name.startsWith("cfsFeatureOpLastActionResult") && var.getType() == 2 && (code = ((SnmpInt)var).getValue()) != 2 && code != 3) {
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)("CFS event is dropped from the trapHanlder: " + sb));
                }
                return;
            }
            if (trapOid.startsWith(_CFSMergeFailOid) && name.startsWith("cfsMergeFailScopeVal") && vbl.intValue(i - 1) == 2) {
                sb.append("VSAN ");
                sb.append(MibVariableFormat.cfsFeatureOpScopeVal(var));
            } else if (trapOid.startsWith(_CFSFeatureActionOid) && name.startsWith("cfsFeatureOpLastAction") && mibDescriptor.indexOf("device-alias") != -1) {
                if (var.getType() == 2) {
                    MibEnum[] enums = MibNode.get(name.substring(0, len)).getEnums();
                    sb.append(MibEnum.getLabel(enums, ((SnmpInt)var).getValue()));
                }
            } else if (SnmpOID.startsWith(oid.getValue(), IFINDEX_OID)) {
                sb.append(sw.ifIndexToName(((SnmpInt)var).getValue()));
            } else if (name.charAt(0) != '.') {
                MibNode n = MibNode.getWithoutLog(name.substring(0, len));
                MibEnum[] enums = null;
                if (n != null) {
                    enums = n.getEnums();
                }
                if (n != null && enums != null) {
                    if (var.getType() == 2) {
                        sb.append(MibEnum.getLabel(enums, ((SnmpInt)var).getValue()));
                    } else if (var.getType() == 4) {
                        sb.append(SnmpString.bitsToString(((SnmpString)var).getValue(), enums));
                    }
                } else {
                    sb.append(var);
                }
            } else {
                sb.append(var);
            }
            sb.append(", ");
        }
        Severity severity = sev = type == LogEventType.OTHER ? Severity.INFO : Severity.WARNING;
        if (trapOid.startsWith(_UcsNotify)) {
            sev = Severity.WARNING;
        }
        this.logEvent(sw, type, sev, sb.length() > 2 ? sb.substring(0, sb.length() - 2) : sb.toString(), true);
    }

    void logEvent(SwitchIf<PKIf> sw, LogEventType type, Severity severity, String descr, Set<Integer> pgIds, long srcId) {
        this.logEvent(sw, type, severity, descr, pgIds, srcId, false);
    }

    void logEvent(SwitchIf<PKIf> sw, LogEventType type, Severity severity, String descr, Set<Integer> pgIds, long srcId, boolean dispatchOnly) {
        LogEvent e = null;
        e = sw instanceof SwitchImpl ? new LogEvent((Object)((SwitchImpl)sw).getFabric().getPK(), type, severity, "Trap " + sw.getName(), descr, ((SwitchImpl)sw).getFabric().getDBID(), ((SwitchImpl)sw).getDBID(), ((SwitchImpl)sw).getSwitchPK()) : new LogEvent(type, severity, "Trap " + sw.getName(), descr, System.currentTimeMillis(), sw.getInetAddress(), 1);
        e.setSrcId(srcId);
        e.set_pgGroupIds(pgIds);
        if (dispatchOnly) {
            this._logger.dispatchEvent(e);
        } else {
            this._logger.logEvent(e);
        }
        if (SnmpTrapSession.isTrace()) {
            _Logger.trace((Object)("TrapHandler : " + e));
        }
    }

    void logEvent(SwitchIf<PKIf> sw, LogEventType type, Severity severity, String descr) {
        this.logEvent(sw, type, severity, descr, false);
    }

    void logEvent(SwitchIf<PKIf> sw, LogEventType type, Severity severity, String descr, boolean dispatchOnly) {
        LogEvent e = null;
        e = sw instanceof SwitchImpl ? new LogEvent((Object)((SwitchImpl)sw).getFabric().getPK(), type, severity, "Trap " + sw.getName(), descr, ((SwitchImpl)sw).getFabric().getDBID(), ((SwitchImpl)sw).getDBID(), ((SwitchImpl)sw).getSwitchPK()) : new LogEvent(type, severity, "Trap " + sw.getName(), descr, System.currentTimeMillis(), sw.getInetAddress(), 1);
        if (dispatchOnly) {
            this._logger.dispatchEvent(e);
        } else {
            this._logger.logEvent(e);
        }
        if (SnmpTrapSession.isTrace()) {
            _Logger.trace((Object)("TrapHandler : " + e));
        }
    }

    void logEvent(SwitchIf<PKIf> sw, LogEventType type, Severity severity, String descr, String enclosure, Set<Integer> pgIds, long srcId) {
        this.logEvent(sw, type, severity, descr, enclosure, pgIds, srcId, false);
    }

    void logEvent(SwitchIf<PKIf> sw, LogEventType type, Severity severity, String descr, String enclosure, Set<Integer> pgIds, long srcId, boolean dispatchOnly) {
        LogEvent e = null;
        e = sw instanceof SwitchImpl ? new LogEvent((Object)((SwitchImpl)sw).getFabric().getPK(), type, severity, "Trap " + sw.getName(), descr, ((SwitchImpl)sw).getFabric().getDBID(), ((SwitchImpl)sw).getDBID(), ((SwitchImpl)sw).getSwitchPK()) : new LogEvent(type, severity, "Trap " + sw.getName(), descr, System.currentTimeMillis(), sw.getInetAddress(), 1);
        e.setSrcId(srcId);
        e.set_pgGroupIds(pgIds);
        if (enclosure != null && enclosure.length() != 0) {
            e.setEnclosure(enclosure);
        }
        if (dispatchOnly) {
            this._logger.dispatchEvent(e);
        } else {
            this._logger.logEvent(e);
        }
        if (SnmpTrapSession.isTrace()) {
            _Logger.trace((Object)("TrapHandler : " + e));
        }
    }

    void logEvent(SwitchIf<PKIf> sw, LogEventType type, Severity severity, String descr, String enclosure, Set<Integer> pgids, boolean dispatchOnly) {
        LogEvent e = null;
        e = sw instanceof SwitchImpl ? new LogEvent((Object)((SwitchImpl)sw).getFabric().getPK(), type, severity, "Trap " + sw.getName(), descr, ((SwitchImpl)sw).getFabric().getDBID(), ((SwitchImpl)sw).getDBID(), ((SwitchImpl)sw).getSwitchPK()) : new LogEvent(type, severity, "Trap " + sw.getName(), descr, System.currentTimeMillis(), sw.getInetAddress(), 1);
        if (enclosure != null && enclosure.length() != 0) {
            e.setEnclosure(enclosure);
        }
        e.set_pgGroupIds(pgids);
        if (dispatchOnly) {
            this._logger.dispatchEvent(e);
        } else {
            this._logger.logEvent(e);
        }
        if (SnmpTrapSession.isTrace()) {
            _Logger.trace((Object)("TrapHandler : " + e));
        }
    }

    private SnmpPDU buildPDU(SwitchIf<PKIf> _sw, int[] _entP, int index) {
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList(1));
        pdu.addVar(new SnmpOID(_entP, index));
        pdu.setAddress(_sw.getInetAddress());
        pdu.setTimeout(SnmpPeer._Timeout);
        pdu.setPort(161);
        pdu.setRetries(0);
        return pdu;
    }

    public static void enableTrapNotification(SnmpPeer peer) {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList(_EnabledNotifies.length));
        for (int i = 0; i < _EnabledNotifies.length; ++i) {
            pdu.addVar(new SnmpOID(_EnabledNotifies[i]), new SnmpInt(1));
        }
        pdu.setIgnoreSetCount(true);
        try {
            peer.send(pdu, new SnmpCallbackIf(){

                @Override
                public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        for (int i = 0; i < _PMOIDS.length; ++i) {
            _PMOidStrs.put(_PMOIDS[i][0], _PMOIDS[i][1]);
        }
        for (int j = 0; j < _SecurityOids.length; ++j) {
            _SecurityOIDSet.add(_SecurityOids[j]);
        }
    }
}

